%------------------------------------------------------------------------------
% File     : CSR115+36 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Which British company was taken over by BMW in 1994?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_007_mira_news_1223_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.25 v9.1.0, 0.20 v9.0.0, 0.19 v8.2.0, 0.13 v8.1.0, 0.14 v7.5.0, 0.24 v7.4.0, 0.19 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.21 v6.4.0, 0.14 v6.3.0, 0.23 v6.2.0, 0.27 v6.1.0, 0.44 v6.0.0, 0.50 v5.5.0, 0.54 v5.4.0, 0.48 v5.3.0, 0.61 v5.2.0, 0.36 v5.0.0, 0.40 v4.1.0, 0.44 v4.0.1, 0.42 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10846 (   0 equ)
%            Maximal formula atoms :  139 (   1 avg)
%            Number of connectives :  657 (   0   ~;  18   |; 513   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  139 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   86 (  86 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16655 (16655 usr;16654 con; 0-2 aty)
%            Number of variables   :  475 ( 405   !;  70   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_007_mira_news_1223,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6] :
      ( agt(X4,X3)
      & attr(X0,X1)
      & attr(X3,X2)
      & attr(X5,X6)
      & sub(X1,name_1_1)
      & sub(X0,firma_1_1)
      & sub(X2,name_1_1)
      & val(X1,bmw_0)
      & val(X2,bmw_0) ) ).

fof(ave07_era5_synth_qa07_007_mira_news_1223,hypothesis,
    ( assoc(autofirma_1_1,auto__1_1)
    & sub(autofirma_1_1,firma_1_1)
    & attr(c428,c429)
    & sub(c428,firma_1_1)
    & sub(c429,name_1_1)
    & val(c429,bmw_0)
    & prop(c434,britisch__1_1)
    & sub(c434,autofirma_1_1)
    & benf(c441,c452)
    & pred(c441,beid_2_1)
    & name(c452,die_vorhersehbare_zukunft_0)
    & exp(c458,c441)
    & obj(c458,c6)
    & subs(c458,ausschlie__337en_1_1)
    & agt(c6,c428)
    & obj(c6,c434)
    & subs(c6,kapitalbeteiligung_1_1)
    & assoc(kapitalbeteiligung_1_1,kapital_2_1)
    & subs(kapitalbeteiligung_1_1,beteiligung_1_1)
    & sort(autofirma_1_1,d)
    & sort(autofirma_1_1,io)
    & card(autofirma_1_1,int1)
    & etype(autofirma_1_1,int0)
    & fact(autofirma_1_1,real)
    & gener(autofirma_1_1,ge)
    & quant(autofirma_1_1,one)
    & refer(autofirma_1_1,refer_c)
    & varia(autofirma_1_1,varia_c)
    & sort(auto__1_1,d)
    & card(auto__1_1,int1)
    & etype(auto__1_1,int0)
    & fact(auto__1_1,real)
    & gener(auto__1_1,ge)
    & quant(auto__1_1,one)
    & refer(auto__1_1,refer_c)
    & varia(auto__1_1,varia_c)
    & sort(firma_1_1,d)
    & sort(firma_1_1,io)
    & card(firma_1_1,int1)
    & etype(firma_1_1,int0)
    & fact(firma_1_1,real)
    & gener(firma_1_1,ge)
    & quant(firma_1_1,one)
    & refer(firma_1_1,refer_c)
    & varia(firma_1_1,varia_c)
    & sort(c428,d)
    & sort(c428,io)
    & card(c428,int1)
    & etype(c428,int0)
    & fact(c428,real)
    & gener(c428,sp)
    & quant(c428,one)
    & refer(c428,det)
    & varia(c428,con)
    & sort(c429,na)
    & card(c429,int1)
    & etype(c429,int0)
    & fact(c429,real)
    & gener(c429,sp)
    & quant(c429,one)
    & refer(c429,indet)
    & varia(c429,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(bmw_0,fe)
    & sort(c434,d)
    & sort(c434,io)
    & card(c434,int1)
    & etype(c434,int0)
    & fact(c434,real)
    & gener(c434,sp)
    & quant(c434,one)
    & refer(c434,det)
    & varia(c434,con)
    & sort(britisch__1_1,nq)
    & sort(c441,o)
    & card(c441,int2)
    & etype(c441,int1)
    & etype(c441,int2)
    & etype(c441,int3)
    & fact(c441,real)
    & gener(c441,sp)
    & quant(c441,both)
    & refer(c441,indet)
    & varia(c441,varia_c)
    & sort(c452,o)
    & card(c452,int1)
    & etype(c452,int0)
    & fact(c452,real)
    & gener(c452,sp)
    & quant(c452,one)
    & refer(c452,refer_c)
    & varia(c452,varia_c)
    & sort(beid_2_1,o)
    & card(beid_2_1,int2)
    & etype(beid_2_1,int1)
    & fact(beid_2_1,real)
    & gener(beid_2_1,gener_c)
    & quant(beid_2_1,both)
    & refer(beid_2_1,refer_c)
    & varia(beid_2_1,varia_c)
    & sort(die_vorhersehbare_zukunft_0,fe)
    & sort(c458,dn)
    & fact(c458,real)
    & gener(c458,sp)
    & sort(c6,ad)
    & card(c6,int1)
    & etype(c6,int0)
    & fact(c6,real)
    & gener(c6,sp)
    & quant(c6,one)
    & refer(c6,indet)
    & varia(c6,varia_c)
    & sort(ausschlie__337en_1_1,dn)
    & fact(ausschlie__337en_1_1,real)
    & gener(ausschlie__337en_1_1,ge)
    & sort(kapitalbeteiligung_1_1,ad)
    & card(kapitalbeteiligung_1_1,int1)
    & etype(kapitalbeteiligung_1_1,int0)
    & fact(kapitalbeteiligung_1_1,real)
    & gener(kapitalbeteiligung_1_1,ge)
    & quant(kapitalbeteiligung_1_1,one)
    & refer(kapitalbeteiligung_1_1,refer_c)
    & varia(kapitalbeteiligung_1_1,varia_c)
    & sort(kapital_2_1,nq)
    & sort(beteiligung_1_1,ad)
    & card(beteiligung_1_1,int1)
    & etype(beteiligung_1_1,int0)
    & fact(beteiligung_1_1,real)
    & gener(beteiligung_1_1,ge)
    & quant(beteiligung_1_1,one)
    & refer(beteiligung_1_1,refer_c)
    & varia(beteiligung_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
