%------------------------------------------------------------------------------
% File     : CSR115+33 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Which British company was taken over by BMW in 1994?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_007_mira_news_1217_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.30 v9.1.0, 0.40 v9.0.0, 0.19 v8.2.0, 0.20 v8.1.0, 0.29 v7.5.0, 0.38 v7.4.0, 0.31 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.29 v6.4.0, 0.21 v6.3.0, 0.31 v6.2.0, 0.45 v6.1.0, 0.64 v6.0.0, 0.50 v5.5.0, 0.62 v5.4.0, 0.61 v5.3.0, 0.70 v5.2.0, 0.43 v5.0.0, 0.55 v4.1.0, 0.67 v4.0.1, 0.58 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10904 (   0 equ)
%            Maximal formula atoms :  199 (   1 avg)
%            Number of connectives :  715 (   0   ~;  18   |; 571   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  199 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-6 aty)
%            Number of functors    : 16654 (16654 usr;16653 con; 0-2 aty)
%            Number of variables   :  475 ( 405   !;  70   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_007_mira_news_1217,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6] :
      ( attr(X0,X1)
      & attr(X3,X2)
      & attr(X5,X6)
      & obj(X4,X0)
      & prop(X0,britisch__1_1)
      & sub(X1,name_1_1)
      & sub(X2,name_1_1) ) ).

fof(ave07_era5_synth_qa07_007_mira_news_1217,hypothesis,
    ( assoc(autobauer_1_1,automobil_1_1)
    & sub(autobauer_1_1,fabrikant_1_1)
    & attr(c7456,c7457)
    & sub(c7456,stadt__1_1)
    & sub(c7457,name_1_1)
    & val(c7457,m__374nchen_0)
    & attr(c7461,c7462)
    & sub(c7461,einrichtung_1_2)
    & sub(c7462,name_1_1)
    & val(c7462,dpa_0)
    & sub(c7464,bmw_1_1)
    & subs(c7474,ankauf__1_1)
    & attch(c7513,c7474)
    & attr(c7513,c7514)
    & prop(c7513,britisch__1_1)
    & sub(c7513,autobauer_1_1)
    & sub(c7514,name_1_1)
    & val(c7514,rover_0)
    & prop(c7518,neo_1_1)
    & sub(c7518,gr__366ssenordnung_1_1)
    & tupl_p6(c8677,c7456,c7461,c7464,c7474,c7518)
    & assoc(gr__366ssenordnung_1_1,gr__366__337e_1_1)
    & sub(gr__366ssenordnung_1_1,ordnung_1_1)
    & sort(autobauer_1_1,d)
    & sort(autobauer_1_1,io)
    & card(autobauer_1_1,int1)
    & etype(autobauer_1_1,int0)
    & fact(autobauer_1_1,real)
    & gener(autobauer_1_1,ge)
    & quant(autobauer_1_1,one)
    & refer(autobauer_1_1,refer_c)
    & varia(autobauer_1_1,varia_c)
    & sort(automobil_1_1,tq)
    & sort(fabrikant_1_1,d)
    & sort(fabrikant_1_1,io)
    & card(fabrikant_1_1,int1)
    & etype(fabrikant_1_1,int0)
    & fact(fabrikant_1_1,real)
    & gener(fabrikant_1_1,ge)
    & quant(fabrikant_1_1,one)
    & refer(fabrikant_1_1,refer_c)
    & varia(fabrikant_1_1,varia_c)
    & sort(c7456,d)
    & sort(c7456,io)
    & card(c7456,int1)
    & etype(c7456,int0)
    & fact(c7456,real)
    & gener(c7456,sp)
    & quant(c7456,one)
    & refer(c7456,det)
    & varia(c7456,con)
    & sort(c7457,na)
    & card(c7457,int1)
    & etype(c7457,int0)
    & fact(c7457,real)
    & gener(c7457,sp)
    & quant(c7457,one)
    & refer(c7457,indet)
    & varia(c7457,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(m__374nchen_0,fe)
    & sort(c7461,d)
    & sort(c7461,io)
    & card(c7461,int1)
    & etype(c7461,int1)
    & fact(c7461,real)
    & gener(c7461,sp)
    & quant(c7461,one)
    & refer(c7461,det)
    & varia(c7461,con)
    & sort(c7462,na)
    & card(c7462,int1)
    & etype(c7462,int0)
    & fact(c7462,real)
    & gener(c7462,sp)
    & quant(c7462,one)
    & refer(c7462,indet)
    & varia(c7462,varia_c)
    & sort(einrichtung_1_2,d)
    & sort(einrichtung_1_2,io)
    & card(einrichtung_1_2,card_c)
    & etype(einrichtung_1_2,int1)
    & fact(einrichtung_1_2,real)
    & gener(einrichtung_1_2,ge)
    & quant(einrichtung_1_2,quant_c)
    & refer(einrichtung_1_2,refer_c)
    & varia(einrichtung_1_2,varia_c)
    & sort(dpa_0,fe)
    & sort(c7464,d)
    & card(c7464,int1)
    & etype(c7464,int0)
    & fact(c7464,real)
    & gener(c7464,gener_c)
    & quant(c7464,one)
    & refer(c7464,refer_c)
    & varia(c7464,varia_c)
    & sort(bmw_1_1,d)
    & card(bmw_1_1,int1)
    & etype(bmw_1_1,int0)
    & fact(bmw_1_1,real)
    & gener(bmw_1_1,ge)
    & quant(bmw_1_1,one)
    & refer(bmw_1_1,refer_c)
    & varia(bmw_1_1,varia_c)
    & sort(c7474,ad)
    & card(c7474,int1)
    & etype(c7474,int0)
    & fact(c7474,real)
    & gener(c7474,sp)
    & quant(c7474,one)
    & refer(c7474,det)
    & varia(c7474,con)
    & sort(ankauf__1_1,ad)
    & card(ankauf__1_1,int1)
    & etype(ankauf__1_1,int0)
    & fact(ankauf__1_1,real)
    & gener(ankauf__1_1,ge)
    & quant(ankauf__1_1,one)
    & refer(ankauf__1_1,refer_c)
    & varia(ankauf__1_1,varia_c)
    & sort(c7513,d)
    & sort(c7513,io)
    & card(c7513,int1)
    & etype(c7513,int0)
    & fact(c7513,real)
    & gener(c7513,sp)
    & quant(c7513,one)
    & refer(c7513,det)
    & varia(c7513,con)
    & sort(c7514,na)
    & card(c7514,int1)
    & etype(c7514,int0)
    & fact(c7514,real)
    & gener(c7514,sp)
    & quant(c7514,one)
    & refer(c7514,indet)
    & varia(c7514,varia_c)
    & sort(britisch__1_1,nq)
    & sort(rover_0,fe)
    & sort(c7518,io)
    & sort(c7518,oa)
    & card(c7518,int1)
    & etype(c7518,int0)
    & fact(c7518,real)
    & gener(c7518,sp)
    & quant(c7518,one)
    & refer(c7518,indet)
    & varia(c7518,varia_c)
    & sort(neo_1_1,nq)
    & sort(gr__366ssenordnung_1_1,io)
    & sort(gr__366ssenordnung_1_1,oa)
    & card(gr__366ssenordnung_1_1,int1)
    & etype(gr__366ssenordnung_1_1,int0)
    & fact(gr__366ssenordnung_1_1,real)
    & gener(gr__366ssenordnung_1_1,ge)
    & quant(gr__366ssenordnung_1_1,one)
    & refer(gr__366ssenordnung_1_1,refer_c)
    & varia(gr__366ssenordnung_1_1,varia_c)
    & sort(c8677,ent)
    & card(c8677,card_c)
    & etype(c8677,etype_c)
    & fact(c8677,real)
    & gener(c8677,gener_c)
    & quant(c8677,quant_c)
    & refer(c8677,refer_c)
    & varia(c8677,varia_c)
    & sort(gr__366__337e_1_1,oa)
    & card(gr__366__337e_1_1,int1)
    & etype(gr__366__337e_1_1,int0)
    & fact(gr__366__337e_1_1,real)
    & gener(gr__366__337e_1_1,ge)
    & quant(gr__366__337e_1_1,one)
    & refer(gr__366__337e_1_1,refer_c)
    & varia(gr__366__337e_1_1,varia_c)
    & sort(ordnung_1_1,as)
    & sort(ordnung_1_1,io)
    & card(ordnung_1_1,int1)
    & etype(ordnung_1_1,int0)
    & fact(ordnung_1_1,real)
    & gener(ordnung_1_1,ge)
    & quant(ordnung_1_1,one)
    & refer(ordnung_1_1,refer_c)
    & varia(ordnung_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
