%------------------------------------------------------------------------------
% File     : CSR115+32 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Which British company was taken over by BMW in 1994?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_007_mira_news_1214_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.35 v9.1.0, 0.40 v9.0.0, 0.25 v8.2.0, 0.27 v8.1.0, 0.29 v7.5.0, 0.38 v7.4.0, 0.31 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.29 v6.4.0, 0.21 v6.3.0, 0.23 v6.2.0, 0.36 v6.1.0, 0.52 v6.0.0, 0.50 v5.5.0, 0.54 v5.4.0, 0.52 v5.3.0, 0.61 v5.2.0, 0.43 v5.0.0, 0.45 v4.1.0, 0.50 v4.0.1, 0.63 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10810 (   0 equ)
%            Maximal formula atoms :  103 (   1 avg)
%            Number of connectives :  621 (   0   ~;  18   |; 477   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  103 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-4 aty)
%            Number of functors    : 16647 (16647 usr;16646 con; 0-2 aty)
%            Number of variables   :  475 ( 405   !;  70   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_007_mira_news_1214,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6] :
      ( attr(X0,X1)
      & attr(X3,X2)
      & attr(X5,X6)
      & obj(X4,X0)
      & sub(X1,name_1_1)
      & sub(X0,firma_1_1)
      & sub(X2,name_1_1)
      & val(X1,bmw_0)
      & val(X2,bmw_0) ) ).

fof(ave07_era5_synth_qa07_007_mira_news_1214,hypothesis,
    ( attr(c186,c187)
    & sub(c186,verpackungsfirma_1_1)
    & sub(c187,name_1_1)
    & val(c187,bmw_0)
    & sub(c188,vogel__1_1)
    & prop(c195,franko_1_1)
    & sub(c195,gruppe_1_1)
    & tupl_p4(c344,c186,c188,c195)
    & assoc(verpackungsfirma_1_1,umh__374llung_1_1)
    & sub(verpackungsfirma_1_1,firma_1_1)
    & sort(c186,d)
    & sort(c186,io)
    & card(c186,int1)
    & etype(c186,int0)
    & fact(c186,real)
    & gener(c186,sp)
    & quant(c186,one)
    & refer(c186,det)
    & varia(c186,varia_c)
    & sort(c187,na)
    & card(c187,int1)
    & etype(c187,int0)
    & fact(c187,real)
    & gener(c187,sp)
    & quant(c187,one)
    & refer(c187,det)
    & varia(c187,varia_c)
    & sort(verpackungsfirma_1_1,d)
    & sort(verpackungsfirma_1_1,io)
    & card(verpackungsfirma_1_1,int1)
    & etype(verpackungsfirma_1_1,int0)
    & fact(verpackungsfirma_1_1,real)
    & gener(verpackungsfirma_1_1,ge)
    & quant(verpackungsfirma_1_1,one)
    & refer(verpackungsfirma_1_1,refer_c)
    & varia(verpackungsfirma_1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(bmw_0,fe)
    & sort(c188,d)
    & card(c188,int1)
    & etype(c188,int0)
    & fact(c188,real)
    & gener(c188,gener_c)
    & quant(c188,one)
    & refer(c188,refer_c)
    & varia(c188,varia_c)
    & sort(vogel__1_1,d)
    & card(vogel__1_1,int1)
    & etype(vogel__1_1,int0)
    & fact(vogel__1_1,real)
    & gener(vogel__1_1,ge)
    & quant(vogel__1_1,one)
    & refer(vogel__1_1,refer_c)
    & varia(vogel__1_1,varia_c)
    & sort(c195,d)
    & card(c195,int1)
    & etype(c195,int1)
    & fact(c195,real)
    & gener(c195,gener_c)
    & quant(c195,one)
    & refer(c195,refer_c)
    & varia(c195,varia_c)
    & sort(franko_1_1,nq)
    & sort(gruppe_1_1,d)
    & card(gruppe_1_1,card_c)
    & etype(gruppe_1_1,int1)
    & fact(gruppe_1_1,real)
    & gener(gruppe_1_1,ge)
    & quant(gruppe_1_1,quant_c)
    & refer(gruppe_1_1,refer_c)
    & varia(gruppe_1_1,varia_c)
    & sort(c344,ent)
    & card(c344,card_c)
    & etype(c344,etype_c)
    & fact(c344,real)
    & gener(c344,gener_c)
    & quant(c344,quant_c)
    & refer(c344,refer_c)
    & varia(c344,varia_c)
    & sort(umh__374llung_1_1,d)
    & card(umh__374llung_1_1,int1)
    & etype(umh__374llung_1_1,int0)
    & fact(umh__374llung_1_1,real)
    & gener(umh__374llung_1_1,ge)
    & quant(umh__374llung_1_1,one)
    & refer(umh__374llung_1_1,refer_c)
    & varia(umh__374llung_1_1,varia_c)
    & sort(firma_1_1,d)
    & sort(firma_1_1,io)
    & card(firma_1_1,int1)
    & etype(firma_1_1,int0)
    & fact(firma_1_1,real)
    & gener(firma_1_1,ge)
    & quant(firma_1_1,one)
    & refer(firma_1_1,refer_c)
    & varia(firma_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
