%------------------------------------------------------------------------------
% File     : CSR115+31 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Which British company was taken over by BMW in 1994?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_007_mira_news_1209_a462_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.40 v9.1.0, 0.53 v9.0.0, 0.25 v8.2.0, 0.27 v8.1.0, 0.36 v7.5.0, 0.48 v7.4.0, 0.25 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.36 v6.4.0, 0.29 v6.3.0, 0.23 v6.2.0, 0.36 v6.1.0, 0.52 v6.0.0, 0.50 v5.5.0, 0.58 v5.4.0, 0.57 v5.3.0, 0.61 v5.2.0, 0.36 v5.0.0, 0.50 v4.1.0, 0.56 v4.0.1, 0.68 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10966 (   0 equ)
%            Maximal formula atoms :  259 (   1 avg)
%            Number of connectives :  777 (   0   ~;  18   |; 633   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  259 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   88 (  88 usr;   0 prp; 2-8 aty)
%            Number of functors    : 16665 (16665 usr;16664 con; 0-2 aty)
%            Number of variables   :  476 ( 405   !;  71   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_007_mira_news_1209_a462,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6,X7] :
      ( attr(X0,X1)
      & attr(X3,X2)
      & attr(X5,X6)
      & has_card_leq(X7,int1994)
      & obj(X4,X0)
      & sub(X1,name_1_1)
      & sub(X2,name_1_1)
      & sub(X6,jahr__1_1)
      & val(X6,X7) ) ).

fof(ave07_era5_synth_qa07_007_mira_news_1209_a462,hypothesis,
    ( attr(c11,c12)
    & sub(c11,stadt__1_1)
    & sub(c12,name_1_1)
    & val(c12,m__374nchen_0)
    & sub(c14,feb_1_1)
    & tupl(c18,c11,c14)
    & sub(c5123,m__374nchener_2_1)
    & sub(c5130,bmw_1_1)
    & sub(c5132,ag_1_1)
    & attr(c5138,c5139)
    & sub(c5139,jahr__1_1)
    & val(c5139,c5136)
    & sub(c5142,motorradgesch__344ft_1_1)
    & prop(c5147,c5151)
    & sub(c5147,jahr__1_1)
    & supl(c5151,erfolgreich_1_1,c5152)
    & attr(c5159,c5147)
    & prop(c5159,jahrelang_1_1)
    & sub(c5159,firmengeschichte_1_1)
    & tupl_p8(c6160,c5123,c5130,c5132,c5138,c5142,c5147,c5151)
    & assoc(firmengeschichte_1_1,firmen_1_1)
    & sub(firmengeschichte_1_1,geschichte_1_1)
    & assoc(motorradgesch__344ft_1_1,kraftrad_1_1)
    & sub(motorradgesch__344ft_1_1,gesch__344ft_1_1)
    & sort(c11,d)
    & sort(c11,io)
    & card(c11,int1)
    & etype(c11,int0)
    & fact(c11,real)
    & gener(c11,sp)
    & quant(c11,one)
    & refer(c11,det)
    & varia(c11,con)
    & sort(c12,na)
    & card(c12,int1)
    & etype(c12,int0)
    & fact(c12,real)
    & gener(c12,sp)
    & quant(c12,one)
    & refer(c12,indet)
    & varia(c12,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(m__374nchen_0,fe)
    & sort(c14,o)
    & card(c14,int1)
    & etype(c14,int0)
    & fact(c14,real)
    & gener(c14,gener_c)
    & quant(c14,one)
    & refer(c14,refer_c)
    & varia(c14,varia_c)
    & sort(feb_1_1,o)
    & card(feb_1_1,int1)
    & etype(feb_1_1,int0)
    & fact(feb_1_1,real)
    & gener(feb_1_1,ge)
    & quant(feb_1_1,one)
    & refer(feb_1_1,refer_c)
    & varia(feb_1_1,varia_c)
    & sort(c18,ent)
    & card(c18,card_c)
    & etype(c18,etype_c)
    & fact(c18,real)
    & gener(c18,gener_c)
    & quant(c18,quant_c)
    & refer(c18,refer_c)
    & varia(c18,varia_c)
    & sort(c5123,d)
    & card(c5123,int1)
    & etype(c5123,int0)
    & fact(c5123,real)
    & gener(c5123,sp)
    & quant(c5123,one)
    & refer(c5123,det)
    & varia(c5123,con)
    & sort(m__374nchener_2_1,d)
    & card(m__374nchener_2_1,int1)
    & etype(m__374nchener_2_1,int0)
    & fact(m__374nchener_2_1,real)
    & gener(m__374nchener_2_1,ge)
    & quant(m__374nchener_2_1,one)
    & refer(m__374nchener_2_1,refer_c)
    & varia(m__374nchener_2_1,varia_c)
    & sort(c5130,d)
    & card(c5130,int1)
    & etype(c5130,int0)
    & fact(c5130,real)
    & gener(c5130,gener_c)
    & quant(c5130,one)
    & refer(c5130,refer_c)
    & varia(c5130,varia_c)
    & sort(bmw_1_1,d)
    & card(bmw_1_1,int1)
    & etype(bmw_1_1,int0)
    & fact(bmw_1_1,real)
    & gener(bmw_1_1,ge)
    & quant(bmw_1_1,one)
    & refer(bmw_1_1,refer_c)
    & varia(bmw_1_1,varia_c)
    & sort(c5132,io)
    & card(c5132,int1)
    & etype(c5132,int0)
    & fact(c5132,real)
    & gener(c5132,gener_c)
    & quant(c5132,one)
    & refer(c5132,refer_c)
    & varia(c5132,varia_c)
    & sort(ag_1_1,io)
    & card(ag_1_1,int1)
    & etype(ag_1_1,int0)
    & fact(ag_1_1,real)
    & gener(ag_1_1,ge)
    & quant(ag_1_1,one)
    & refer(ag_1_1,refer_c)
    & varia(ag_1_1,varia_c)
    & sort(c5138,t)
    & card(c5138,int1)
    & etype(c5138,int0)
    & fact(c5138,real)
    & gener(c5138,sp)
    & quant(c5138,one)
    & refer(c5138,det)
    & varia(c5138,con)
    & sort(c5139,me)
    & sort(c5139,oa)
    & sort(c5139,ta)
    & card(c5139,card_c)
    & etype(c5139,etype_c)
    & fact(c5139,real)
    & gener(c5139,sp)
    & quant(c5139,quant_c)
    & refer(c5139,refer_c)
    & varia(c5139,varia_c)
    & sort(jahr__1_1,me)
    & sort(jahr__1_1,oa)
    & sort(jahr__1_1,ta)
    & card(jahr__1_1,card_c)
    & etype(jahr__1_1,etype_c)
    & fact(jahr__1_1,real)
    & gener(jahr__1_1,ge)
    & quant(jahr__1_1,quant_c)
    & refer(jahr__1_1,refer_c)
    & varia(jahr__1_1,varia_c)
    & sort(c5136,nu)
    & card(c5136,int1994)
    & sort(c5142,d)
    & sort(c5142,io)
    & card(c5142,int1)
    & etype(c5142,int0)
    & fact(c5142,real)
    & gener(c5142,sp)
    & quant(c5142,one)
    & refer(c5142,det)
    & varia(c5142,con)
    & sort(motorradgesch__344ft_1_1,d)
    & sort(motorradgesch__344ft_1_1,io)
    & card(motorradgesch__344ft_1_1,int1)
    & etype(motorradgesch__344ft_1_1,int0)
    & fact(motorradgesch__344ft_1_1,real)
    & gener(motorradgesch__344ft_1_1,ge)
    & quant(motorradgesch__344ft_1_1,one)
    & refer(motorradgesch__344ft_1_1,refer_c)
    & varia(motorradgesch__344ft_1_1,varia_c)
    & sort(c5147,me)
    & sort(c5147,oa)
    & sort(c5147,ta)
    & card(c5147,card_c)
    & etype(c5147,etype_c)
    & fact(c5147,real)
    & gener(c5147,sp)
    & quant(c5147,quant_c)
    & refer(c5147,det)
    & varia(c5147,con)
    & sort(c5151,tq)
    & sort(erfolgreich_1_1,nq)
    & sort(c5152,o)
    & card(c5152,card_c)
    & etype(c5152,int1)
    & etype(c5152,int2)
    & fact(c5152,real)
    & gener(c5152,gener_c)
    & quant(c5152,quant_c)
    & refer(c5152,refer_c)
    & varia(c5152,varia_c)
    & sort(c5159,ad)
    & sort(c5159,d)
    & sort(c5159,io)
    & card(c5159,int1)
    & etype(c5159,int0)
    & fact(c5159,real)
    & gener(c5159,sp)
    & quant(c5159,one)
    & refer(c5159,det)
    & varia(c5159,con)
    & sort(jahrelang_1_1,tq)
    & sort(firmengeschichte_1_1,ad)
    & sort(firmengeschichte_1_1,d)
    & sort(firmengeschichte_1_1,io)
    & card(firmengeschichte_1_1,int1)
    & etype(firmengeschichte_1_1,int0)
    & fact(firmengeschichte_1_1,real)
    & gener(firmengeschichte_1_1,ge)
    & quant(firmengeschichte_1_1,one)
    & refer(firmengeschichte_1_1,refer_c)
    & varia(firmengeschichte_1_1,varia_c)
    & sort(c6160,ent)
    & card(c6160,card_c)
    & etype(c6160,etype_c)
    & fact(c6160,real)
    & gener(c6160,gener_c)
    & quant(c6160,quant_c)
    & refer(c6160,refer_c)
    & varia(c6160,varia_c)
    & sort(firmen_1_1,da)
    & fact(firmen_1_1,real)
    & gener(firmen_1_1,ge)
    & sort(geschichte_1_1,ad)
    & sort(geschichte_1_1,d)
    & sort(geschichte_1_1,io)
    & card(geschichte_1_1,int1)
    & etype(geschichte_1_1,int0)
    & fact(geschichte_1_1,real)
    & gener(geschichte_1_1,ge)
    & quant(geschichte_1_1,one)
    & refer(geschichte_1_1,refer_c)
    & varia(geschichte_1_1,varia_c)
    & sort(kraftrad_1_1,d)
    & card(kraftrad_1_1,int1)
    & etype(kraftrad_1_1,int0)
    & fact(kraftrad_1_1,real)
    & gener(kraftrad_1_1,ge)
    & quant(kraftrad_1_1,one)
    & refer(kraftrad_1_1,refer_c)
    & varia(kraftrad_1_1,varia_c)
    & sort(gesch__344ft_1_1,d)
    & sort(gesch__344ft_1_1,io)
    & card(gesch__344ft_1_1,int1)
    & etype(gesch__344ft_1_1,int0)
    & fact(gesch__344ft_1_1,real)
    & gener(gesch__344ft_1_1,ge)
    & quant(gesch__344ft_1_1,one)
    & refer(gesch__344ft_1_1,refer_c)
    & varia(gesch__344ft_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
