%------------------------------------------------------------------------------
% File     : CSR115+28 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Which British company was taken over by BMW in 1994?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_007_mira_news_1201_a19984_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.30 v9.1.0, 0.40 v9.0.0, 0.25 v8.2.0, 0.27 v8.1.0, 0.29 v7.5.0, 0.38 v7.4.0, 0.25 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.29 v6.4.0, 0.21 v6.3.0, 0.23 v6.2.0, 0.36 v6.1.0, 0.48 v6.0.0, 0.50 v5.5.0, 0.46 v5.4.0, 0.43 v5.3.0, 0.52 v5.2.0, 0.36 v5.0.0, 0.35 v4.1.0, 0.39 v4.0.1, 0.47 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10808 (   0 equ)
%            Maximal formula atoms :  106 (   1 avg)
%            Number of connectives :  619 (   0   ~;  18   |; 475   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  106 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   86 (  86 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16648 (16648 usr;16647 con; 0-2 aty)
%            Number of variables   :  474 ( 405   !;  69   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_007_mira_news_1201_a19984,conjecture,
    ? [X0,X1,X2,X3,X4,X5] :
      ( attr(X2,X1)
      & attr(X4,X5)
      & obj(X3,X0)
      & sub(X1,name_1_1) ) ).

fof(ave07_era5_synth_qa07_007_mira_news_1201_a19984,hypothesis,
    ( attr(c15,c16)
    & sub(c15,stadt__1_1)
    & sub(c16,name_1_1)
    & val(c16,genf_0)
    & attr(c22,c23)
    & attr(c22,c24)
    & sub(c23,tag_1_1)
    & val(c23,c20)
    & sub(c24,monat_1_1)
    & val(c24,c21)
    & tupl(c75,c15,c22)
    & sort(c15,d)
    & sort(c15,io)
    & card(c15,int1)
    & etype(c15,int0)
    & fact(c15,real)
    & gener(c15,sp)
    & quant(c15,one)
    & refer(c15,det)
    & varia(c15,con)
    & sort(c16,na)
    & card(c16,int1)
    & etype(c16,int0)
    & fact(c16,real)
    & gener(c16,sp)
    & quant(c16,one)
    & refer(c16,indet)
    & varia(c16,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(genf_0,fe)
    & sort(c22,t)
    & card(c22,int1)
    & etype(c22,int0)
    & fact(c22,real)
    & gener(c22,sp)
    & quant(c22,one)
    & refer(c22,det)
    & varia(c22,con)
    & sort(c23,me)
    & sort(c23,oa)
    & sort(c23,ta)
    & card(c23,card_c)
    & etype(c23,etype_c)
    & fact(c23,real)
    & gener(c23,sp)
    & quant(c23,quant_c)
    & refer(c23,refer_c)
    & varia(c23,varia_c)
    & sort(c24,me)
    & sort(c24,oa)
    & sort(c24,ta)
    & card(c24,card_c)
    & etype(c24,etype_c)
    & fact(c24,real)
    & gener(c24,sp)
    & quant(c24,quant_c)
    & refer(c24,refer_c)
    & varia(c24,varia_c)
    & sort(tag_1_1,me)
    & sort(tag_1_1,oa)
    & sort(tag_1_1,ta)
    & card(tag_1_1,card_c)
    & etype(tag_1_1,etype_c)
    & fact(tag_1_1,real)
    & gener(tag_1_1,ge)
    & quant(tag_1_1,quant_c)
    & refer(tag_1_1,refer_c)
    & varia(tag_1_1,varia_c)
    & sort(c20,nu)
    & card(c20,int7)
    & sort(monat_1_1,me)
    & sort(monat_1_1,oa)
    & sort(monat_1_1,ta)
    & card(monat_1_1,card_c)
    & etype(monat_1_1,etype_c)
    & fact(monat_1_1,real)
    & gener(monat_1_1,ge)
    & quant(monat_1_1,quant_c)
    & refer(monat_1_1,refer_c)
    & varia(monat_1_1,varia_c)
    & sort(c21,nu)
    & card(c21,int3)
    & sort(c75,ent)
    & card(c75,card_c)
    & etype(c75,etype_c)
    & fact(c75,real)
    & gener(c75,gener_c)
    & quant(c75,quant_c)
    & refer(c75,refer_c)
    & varia(c75,varia_c) ) ).

%------------------------------------------------------------------------------
