%------------------------------------------------------------------------------
% File     : CSR115+27 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Which British company was taken over by BMW in 1994?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_007_mira_news_1195_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.40 v9.1.0, 0.53 v9.0.0, 0.25 v8.2.0, 0.27 v8.1.0, 0.36 v7.5.0, 0.48 v7.4.0, 0.25 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.36 v6.4.0, 0.29 v6.3.0, 0.23 v6.2.0, 0.36 v6.1.0, 0.60 v6.0.0, 0.50 v5.5.0, 0.58 v5.4.0, 0.57 v5.3.0, 0.65 v5.2.0, 0.36 v5.0.0, 0.50 v4.1.0, 0.56 v4.0.1, 0.68 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10951 (   0 equ)
%            Maximal formula atoms :  244 (   1 avg)
%            Number of connectives :  762 (   0   ~;  18   |; 618   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  244 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   88 (  88 usr;   0 prp; 2-7 aty)
%            Number of functors    : 16669 (16669 usr;16668 con; 0-2 aty)
%            Number of variables   :  476 ( 405   !;  71   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_007_mira_news_1195,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6,X7] :
      ( attr(X0,X1)
      & attr(X3,X2)
      & attr(X5,X6)
      & has_card_leq(X7,int1994)
      & obj(X4,X0)
      & sub(X1,name_1_1)
      & sub(X2,name_1_1)
      & sub(X6,jahr__1_1)
      & val(X6,X7) ) ).

fof(ave07_era5_synth_qa07_007_mira_news_1195,hypothesis,
    ( attr(c11,c12)
    & sub(c11,stadt__1_1)
    & sub(c12,name_1_1)
    & val(c12,m__374nchen_0)
    & attr(c18,c19)
    & attr(c18,c20)
    & sub(c19,tag_1_1)
    & val(c19,c16)
    & sub(c20,monat_1_1)
    & val(c20,c17)
    & tupl_p7(c319,c68,c72,c79,c84,c91,c95)
    & sub(c324,mark_1_1)
    & tupl(c47,c11,c18)
    & sub(c68,bmw_1_1)
    & sub(c72,firmengruppe_1_1)
    & sub(c79,konzerngewinn_1_1)
    & attr(c84,c85)
    & sub(c85,jahr__1_1)
    & val(c85,c80)
    & quant_p3(c91,c86,hundertstel__1_1)
    & quant_p3(c95,c92,million_1_1)
    & assoc(konzerngewinn_1_1,firmengruppe_1_1)
    & sub(konzerngewinn_1_1,gewinn_1_1)
    & sort(c11,d)
    & sort(c11,io)
    & card(c11,int1)
    & etype(c11,int0)
    & fact(c11,real)
    & gener(c11,sp)
    & quant(c11,one)
    & refer(c11,det)
    & varia(c11,con)
    & sort(c12,na)
    & card(c12,int1)
    & etype(c12,int0)
    & fact(c12,real)
    & gener(c12,sp)
    & quant(c12,one)
    & refer(c12,indet)
    & varia(c12,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(m__374nchen_0,fe)
    & sort(c18,t)
    & card(c18,int1)
    & etype(c18,int0)
    & fact(c18,real)
    & gener(c18,sp)
    & quant(c18,one)
    & refer(c18,det)
    & varia(c18,con)
    & sort(c19,me)
    & sort(c19,oa)
    & sort(c19,ta)
    & card(c19,card_c)
    & etype(c19,etype_c)
    & fact(c19,real)
    & gener(c19,sp)
    & quant(c19,quant_c)
    & refer(c19,refer_c)
    & varia(c19,varia_c)
    & sort(c20,me)
    & sort(c20,oa)
    & sort(c20,ta)
    & card(c20,card_c)
    & etype(c20,etype_c)
    & fact(c20,real)
    & gener(c20,sp)
    & quant(c20,quant_c)
    & refer(c20,refer_c)
    & varia(c20,varia_c)
    & sort(tag_1_1,me)
    & sort(tag_1_1,oa)
    & sort(tag_1_1,ta)
    & card(tag_1_1,card_c)
    & etype(tag_1_1,etype_c)
    & fact(tag_1_1,real)
    & gener(tag_1_1,ge)
    & quant(tag_1_1,quant_c)
    & refer(tag_1_1,refer_c)
    & varia(tag_1_1,varia_c)
    & sort(c16,nu)
    & card(c16,int16)
    & sort(monat_1_1,me)
    & sort(monat_1_1,oa)
    & sort(monat_1_1,ta)
    & card(monat_1_1,card_c)
    & etype(monat_1_1,etype_c)
    & fact(monat_1_1,real)
    & gener(monat_1_1,ge)
    & quant(monat_1_1,quant_c)
    & refer(monat_1_1,refer_c)
    & varia(monat_1_1,varia_c)
    & sort(c17,nu)
    & card(c17,int3)
    & sort(c319,ent)
    & card(c319,card_c)
    & etype(c319,etype_c)
    & fact(c319,real)
    & gener(c319,gener_c)
    & quant(c319,quant_c)
    & refer(c319,refer_c)
    & varia(c319,varia_c)
    & sort(c68,d)
    & card(c68,int1)
    & etype(c68,int0)
    & fact(c68,real)
    & gener(c68,sp)
    & quant(c68,one)
    & refer(c68,det)
    & varia(c68,con)
    & sort(c72,d)
    & sort(c72,io)
    & card(c72,int1)
    & etype(c72,int0)
    & fact(c72,real)
    & gener(c72,gener_c)
    & quant(c72,one)
    & refer(c72,refer_c)
    & varia(c72,varia_c)
    & sort(c79,d)
    & card(c79,int1)
    & etype(c79,int0)
    & fact(c79,real)
    & gener(c79,sp)
    & quant(c79,one)
    & refer(c79,det)
    & varia(c79,con)
    & sort(c84,t)
    & card(c84,int1)
    & etype(c84,int0)
    & fact(c84,real)
    & gener(c84,sp)
    & quant(c84,one)
    & refer(c84,det)
    & varia(c84,con)
    & sort(c91,co)
    & sort(c91,m)
    & card(c91,card_c)
    & etype(c91,etype_c)
    & fact(c91,real)
    & gener(c91,gener_c)
    & quant(c91,quant_c)
    & refer(c91,refer_c)
    & varia(c91,con)
    & sort(c95,co)
    & sort(c95,m)
    & card(c95,card_c)
    & etype(c95,etype_c)
    & fact(c95,real)
    & gener(c95,gener_c)
    & quant(c95,quant_c)
    & refer(c95,refer_c)
    & varia(c95,con)
    & sort(c324,me)
    & fact(c324,real)
    & sort(mark_1_1,me)
    & gener(mark_1_1,ge)
    & sort(c47,ent)
    & card(c47,card_c)
    & etype(c47,etype_c)
    & fact(c47,real)
    & gener(c47,gener_c)
    & quant(c47,quant_c)
    & refer(c47,refer_c)
    & varia(c47,varia_c)
    & sort(bmw_1_1,d)
    & card(bmw_1_1,int1)
    & etype(bmw_1_1,int0)
    & fact(bmw_1_1,real)
    & gener(bmw_1_1,ge)
    & quant(bmw_1_1,one)
    & refer(bmw_1_1,refer_c)
    & varia(bmw_1_1,varia_c)
    & sort(firmengruppe_1_1,d)
    & sort(firmengruppe_1_1,io)
    & card(firmengruppe_1_1,int1)
    & etype(firmengruppe_1_1,int0)
    & fact(firmengruppe_1_1,real)
    & gener(firmengruppe_1_1,ge)
    & quant(firmengruppe_1_1,one)
    & refer(firmengruppe_1_1,refer_c)
    & varia(firmengruppe_1_1,varia_c)
    & sort(konzerngewinn_1_1,d)
    & card(konzerngewinn_1_1,int1)
    & etype(konzerngewinn_1_1,int0)
    & fact(konzerngewinn_1_1,real)
    & gener(konzerngewinn_1_1,ge)
    & quant(konzerngewinn_1_1,one)
    & refer(konzerngewinn_1_1,refer_c)
    & varia(konzerngewinn_1_1,varia_c)
    & sort(c85,me)
    & sort(c85,oa)
    & sort(c85,ta)
    & card(c85,card_c)
    & etype(c85,etype_c)
    & fact(c85,real)
    & gener(c85,sp)
    & quant(c85,quant_c)
    & refer(c85,refer_c)
    & varia(c85,varia_c)
    & sort(jahr__1_1,me)
    & sort(jahr__1_1,oa)
    & sort(jahr__1_1,ta)
    & card(jahr__1_1,card_c)
    & etype(jahr__1_1,etype_c)
    & fact(jahr__1_1,real)
    & gener(jahr__1_1,ge)
    & quant(jahr__1_1,quant_c)
    & refer(jahr__1_1,refer_c)
    & varia(jahr__1_1,varia_c)
    & sort(c80,nu)
    & card(c80,int1994)
    & sort(c86,nu)
    & card(c86,int35)
    & sort(hundertstel__1_1,me)
    & gener(hundertstel__1_1,ge)
    & sort(c92,nu)
    & card(c92,int697)
    & sort(million_1_1,me)
    & gener(million_1_1,ge)
    & sort(gewinn_1_1,d)
    & card(gewinn_1_1,int1)
    & etype(gewinn_1_1,int0)
    & fact(gewinn_1_1,real)
    & gener(gewinn_1_1,ge)
    & quant(gewinn_1_1,one)
    & refer(gewinn_1_1,refer_c)
    & varia(gewinn_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
