%------------------------------------------------------------------------------
% File     : CSR115+26 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Which British company was taken over by BMW in 1994?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_007_mira_news_1168_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.30 v9.1.0, 0.33 v9.0.0, 0.19 v8.2.0, 0.20 v8.1.0, 0.21 v7.5.0, 0.33 v7.4.0, 0.25 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.29 v6.4.0, 0.21 v6.3.0, 0.31 v6.2.0, 0.45 v6.1.0, 0.56 v6.0.0, 0.50 v5.4.0, 0.48 v5.3.0, 0.57 v5.2.0, 0.36 v5.0.0, 0.40 v4.1.0, 0.50 v4.0.1, 0.53 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10948 (   0 equ)
%            Maximal formula atoms :  241 (   1 avg)
%            Number of connectives :  759 (   0   ~;  18   |; 615   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  241 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-9 aty)
%            Number of functors    : 16662 (16662 usr;16661 con; 0-2 aty)
%            Number of variables   :  475 ( 405   !;  70   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_007_mira_news_1168,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6] :
      ( attr(X0,X1)
      & attr(X3,X2)
      & attr(X5,X6)
      & obj(X4,X0)
      & sub(X1,name_1_1)
      & sub(X0,firma_1_1)
      & sub(X2,name_1_1)
      & val(X1,bmw_0)
      & val(X2,bmw_0) ) ).

fof(ave07_era5_synth_qa07_007_mira_news_1168,hypothesis,
    ( assoc(aggregat_1_1,ableger_1_1)
    & sub(aggregat_1_1,werk_1_2)
    & attr(c1022,c1023)
    & attr(c1022,c1099)
    & sub(c1022,firma_1_1)
    & sub(c1023,name_1_1)
    & val(c1023,bmw_0)
    & attch(c1026,c1022)
    & attr(c1026,c1027)
    & sub(c1026,mensch_1_1)
    & sub(c1027,familiename_1_1)
    & val(c1027,roll_0)
    & attr(c1031,c1032)
    & sub(c1031,mensch_1_1)
    & sub(c1032,eigenname_1_1)
    & val(c1032,royce_0)
    & sub(c1035,joint_1_1)
    & sub(c1036,venture_1_1)
    & sub(c1099,name_1_1)
    & val(c1099,bmw_0)
    & prop(c1103,britisch__1_1)
    & sub(c1103,maschinenfabrikant_1_1)
    & pred(c1116,aggregat_1_1)
    & prop(c1123,neo_1_1)
    & sub(c1123,aggregat_1_1)
    & tupl_p9(c1511,c1022,c1031,c1035,c1036,c1022,c1103,c1116,c1123)
    & assoc(maschinenfabrikant_1_1,aggregat_1_1)
    & sub(maschinenfabrikant_1_1,fabrikant_1_1)
    & sort(aggregat_1_1,d)
    & sort(aggregat_1_1,io)
    & card(aggregat_1_1,int1)
    & etype(aggregat_1_1,int0)
    & fact(aggregat_1_1,real)
    & gener(aggregat_1_1,ge)
    & quant(aggregat_1_1,one)
    & refer(aggregat_1_1,refer_c)
    & varia(aggregat_1_1,varia_c)
    & sort(ableger_1_1,d)
    & card(ableger_1_1,int1)
    & etype(ableger_1_1,int0)
    & fact(ableger_1_1,real)
    & gener(ableger_1_1,ge)
    & quant(ableger_1_1,one)
    & refer(ableger_1_1,refer_c)
    & varia(ableger_1_1,varia_c)
    & sort(werk_1_2,d)
    & sort(werk_1_2,io)
    & card(werk_1_2,int1)
    & etype(werk_1_2,int0)
    & fact(werk_1_2,real)
    & gener(werk_1_2,ge)
    & quant(werk_1_2,one)
    & refer(werk_1_2,refer_c)
    & varia(werk_1_2,varia_c)
    & sort(c1022,d)
    & sort(c1022,io)
    & card(c1022,int1)
    & etype(c1022,int0)
    & fact(c1022,real)
    & gener(c1022,sp)
    & quant(c1022,one)
    & refer(c1022,det)
    & varia(c1022,con)
    & sort(c1023,na)
    & card(c1023,int1)
    & etype(c1023,int0)
    & fact(c1023,real)
    & gener(c1023,sp)
    & quant(c1023,one)
    & refer(c1023,indet)
    & varia(c1023,varia_c)
    & sort(c1099,na)
    & card(c1099,int1)
    & etype(c1099,int0)
    & fact(c1099,real)
    & gener(c1099,sp)
    & quant(c1099,one)
    & refer(c1099,indet)
    & varia(c1099,varia_c)
    & sort(firma_1_1,d)
    & sort(firma_1_1,io)
    & card(firma_1_1,int1)
    & etype(firma_1_1,int0)
    & fact(firma_1_1,real)
    & gener(firma_1_1,ge)
    & quant(firma_1_1,one)
    & refer(firma_1_1,refer_c)
    & varia(firma_1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(bmw_0,fe)
    & sort(c1026,d)
    & card(c1026,int1)
    & etype(c1026,int0)
    & fact(c1026,real)
    & gener(c1026,sp)
    & quant(c1026,one)
    & refer(c1026,det)
    & varia(c1026,con)
    & sort(c1027,na)
    & card(c1027,int1)
    & etype(c1027,int0)
    & fact(c1027,real)
    & gener(c1027,sp)
    & quant(c1027,one)
    & refer(c1027,indet)
    & varia(c1027,varia_c)
    & sort(mensch_1_1,d)
    & card(mensch_1_1,int1)
    & etype(mensch_1_1,int0)
    & fact(mensch_1_1,real)
    & gener(mensch_1_1,ge)
    & quant(mensch_1_1,one)
    & refer(mensch_1_1,refer_c)
    & varia(mensch_1_1,varia_c)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(roll_0,fe)
    & sort(c1031,d)
    & card(c1031,int1)
    & etype(c1031,int0)
    & fact(c1031,real)
    & gener(c1031,sp)
    & quant(c1031,one)
    & refer(c1031,det)
    & varia(c1031,con)
    & sort(c1032,na)
    & card(c1032,int1)
    & etype(c1032,int0)
    & fact(c1032,real)
    & gener(c1032,sp)
    & quant(c1032,one)
    & refer(c1032,indet)
    & varia(c1032,varia_c)
    & sort(eigenname_1_1,na)
    & card(eigenname_1_1,int1)
    & etype(eigenname_1_1,int0)
    & fact(eigenname_1_1,real)
    & gener(eigenname_1_1,ge)
    & quant(eigenname_1_1,one)
    & refer(eigenname_1_1,refer_c)
    & varia(eigenname_1_1,varia_c)
    & sort(royce_0,fe)
    & sort(c1035,o)
    & card(c1035,int1)
    & etype(c1035,int0)
    & fact(c1035,real)
    & gener(c1035,sp)
    & quant(c1035,one)
    & refer(c1035,indet)
    & varia(c1035,varia_c)
    & sort(joint_1_1,o)
    & card(joint_1_1,int1)
    & etype(joint_1_1,int0)
    & fact(joint_1_1,real)
    & gener(joint_1_1,ge)
    & quant(joint_1_1,one)
    & refer(joint_1_1,refer_c)
    & varia(joint_1_1,varia_c)
    & sort(c1036,o)
    & card(c1036,int1)
    & etype(c1036,int0)
    & fact(c1036,real)
    & gener(c1036,gener_c)
    & quant(c1036,one)
    & refer(c1036,refer_c)
    & varia(c1036,varia_c)
    & sort(venture_1_1,o)
    & card(venture_1_1,int1)
    & etype(venture_1_1,int0)
    & fact(venture_1_1,real)
    & gener(venture_1_1,ge)
    & quant(venture_1_1,one)
    & refer(venture_1_1,refer_c)
    & varia(venture_1_1,varia_c)
    & sort(c1103,d)
    & sort(c1103,io)
    & card(c1103,int1)
    & etype(c1103,int0)
    & fact(c1103,real)
    & gener(c1103,sp)
    & quant(c1103,one)
    & refer(c1103,det)
    & varia(c1103,con)
    & sort(britisch__1_1,nq)
    & sort(maschinenfabrikant_1_1,d)
    & sort(maschinenfabrikant_1_1,io)
    & card(maschinenfabrikant_1_1,int1)
    & etype(maschinenfabrikant_1_1,int0)
    & fact(maschinenfabrikant_1_1,real)
    & gener(maschinenfabrikant_1_1,ge)
    & quant(maschinenfabrikant_1_1,one)
    & refer(maschinenfabrikant_1_1,refer_c)
    & varia(maschinenfabrikant_1_1,varia_c)
    & sort(c1116,d)
    & sort(c1116,io)
    & card(c1116,cons(x_constant,cons(int1,nil)))
    & etype(c1116,int1)
    & fact(c1116,real)
    & gener(c1116,sp)
    & quant(c1116,mult)
    & refer(c1116,det)
    & varia(c1116,con)
    & sort(c1123,d)
    & card(c1123,int1)
    & etype(c1123,int0)
    & fact(c1123,real)
    & gener(c1123,sp)
    & quant(c1123,one)
    & refer(c1123,det)
    & varia(c1123,con)
    & sort(neo_1_1,nq)
    & sort(c1511,ent)
    & card(c1511,card_c)
    & etype(c1511,etype_c)
    & fact(c1511,real)
    & gener(c1511,gener_c)
    & quant(c1511,quant_c)
    & refer(c1511,refer_c)
    & varia(c1511,varia_c)
    & sort(fabrikant_1_1,d)
    & sort(fabrikant_1_1,io)
    & card(fabrikant_1_1,int1)
    & etype(fabrikant_1_1,int0)
    & fact(fabrikant_1_1,real)
    & gener(fabrikant_1_1,ge)
    & quant(fabrikant_1_1,one)
    & refer(fabrikant_1_1,refer_c)
    & varia(fabrikant_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
