%------------------------------------------------------------------------------
% File     : CSR115+25 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Which British company was taken over by BMW in 1994?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_007_mira_news_1163_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.35 v9.1.0, 0.40 v9.0.0, 0.25 v8.2.0, 0.27 v8.1.0, 0.29 v7.5.0, 0.38 v7.4.0, 0.25 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.29 v6.4.0, 0.21 v6.3.0, 0.31 v6.2.0, 0.45 v6.1.0, 0.60 v6.0.0, 0.50 v5.5.0, 0.58 v5.4.0, 0.57 v5.3.0, 0.65 v5.2.0, 0.36 v5.0.0, 0.45 v4.1.0, 0.61 v4.0.1, 0.63 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 11067 (   0 equ)
%            Maximal formula atoms :  360 (   1 avg)
%            Number of connectives :  878 (   0   ~;  18   |; 734   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  360 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-16 aty)
%            Number of functors    : 16676 (16676 usr;16675 con; 0-2 aty)
%            Number of variables   :  475 ( 405   !;  70   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_007_mira_news_1163,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6] :
      ( attr(X0,X1)
      & attr(X3,X2)
      & attr(X5,X6)
      & obj(X4,X0)
      & sub(X1,name_1_1)
      & sub(X0,firma_1_1)
      & sub(X2,name_1_1)
      & val(X1,bmw_0)
      & val(X2,bmw_0) ) ).

fof(ave07_era5_synth_qa07_007_mira_news_1163,hypothesis,
    ( assoc(betreuungsplatz_1_1,betreuung_1_1)
    & sub(betreuungsplatz_1_1,platz_1_1)
    & subs(c133316,anschaffung_1_1)
    & pred(c133326,betreuungsplatz_1_1)
    & prop(c133326,c133296)
    & pred(c133332,kind_1_1)
    & sub(c133357,know_1_1)
    & pred(c133366,eltern_1_1)
    & sub(c133371,firma_1_1)
    & pred(c133383,kosten__1_1)
    & pred(c133388,kraft_1_1)
    & prop(c133388,neo_1_1)
    & attr(c133411,c133412)
    & sub(c133411,mensch_1_1)
    & sub(c133412,eigenname_1_1)
    & val(c133412,peter_0)
    & attr(c133415,c133416)
    & sub(c133415,stadt__1_1)
    & sub(c133416,name_1_1)
    & val(c133416,hackenberg_0)
    & attr(c133463,c133464)
    & sub(c133463,firma_1_1)
    & sub(c133464,name_1_1)
    & val(c133464,bmw_0)
    & pred(c133469,grundsatzthema_1_1)
    & prop(c133469,personalpolitisch_1_1)
    & subs(c133476,engagement_1_1)
    & attch(c133480,c133476)
    & sub(c133480,firma_1_1)
    & tupl_p16(c133747,c133311,c133316,c133326,c133332,c133311,c133357,c133366,c133371,c133383,c133388,c133411,c133415,c133463,c133469,c133476)
    & chsp2(eignen_1_1,c133296)
    & assoc(grundsatzthema_1_1,grundsatz_1_1)
    & sub(grundsatzthema_1_1,motto__1_1)
    & assoc(personalpolitisch_1_1,personal__1_1)
    & impl(personalpolitisch_1_1,politisch__1_1)
    & sort(betreuungsplatz_1_1,d)
    & card(betreuungsplatz_1_1,int1)
    & etype(betreuungsplatz_1_1,int0)
    & fact(betreuungsplatz_1_1,real)
    & gener(betreuungsplatz_1_1,ge)
    & quant(betreuungsplatz_1_1,one)
    & refer(betreuungsplatz_1_1,refer_c)
    & varia(betreuungsplatz_1_1,varia_c)
    & sort(betreuung_1_1,ad)
    & card(betreuung_1_1,int1)
    & etype(betreuung_1_1,int0)
    & fact(betreuung_1_1,real)
    & gener(betreuung_1_1,ge)
    & quant(betreuung_1_1,one)
    & refer(betreuung_1_1,refer_c)
    & varia(betreuung_1_1,varia_c)
    & sort(platz_1_1,d)
    & card(platz_1_1,int1)
    & etype(platz_1_1,int0)
    & fact(platz_1_1,real)
    & gener(platz_1_1,ge)
    & quant(platz_1_1,one)
    & refer(platz_1_1,refer_c)
    & varia(platz_1_1,varia_c)
    & sort(c133316,ad)
    & card(c133316,int1)
    & etype(c133316,int0)
    & fact(c133316,real)
    & gener(c133316,sp)
    & quant(c133316,one)
    & refer(c133316,det)
    & varia(c133316,con)
    & sort(anschaffung_1_1,ad)
    & card(anschaffung_1_1,int1)
    & etype(anschaffung_1_1,int0)
    & fact(anschaffung_1_1,real)
    & gener(anschaffung_1_1,ge)
    & quant(anschaffung_1_1,one)
    & refer(anschaffung_1_1,refer_c)
    & varia(anschaffung_1_1,varia_c)
    & sort(c133326,d)
    & card(c133326,cons(x_constant,cons(int1,nil)))
    & etype(c133326,int1)
    & fact(c133326,real)
    & gener(c133326,gener_c)
    & quant(c133326,mult)
    & refer(c133326,refer_c)
    & varia(c133326,varia_c)
    & sort(c133296,tq)
    & sort(c133332,d)
    & card(c133332,cons(x_constant,cons(int1,nil)))
    & etype(c133332,int1)
    & fact(c133332,real)
    & gener(c133332,sp)
    & quant(c133332,mult)
    & refer(c133332,det)
    & varia(c133332,con)
    & sort(kind_1_1,d)
    & card(kind_1_1,int1)
    & etype(kind_1_1,int0)
    & fact(kind_1_1,real)
    & gener(kind_1_1,ge)
    & quant(kind_1_1,one)
    & refer(kind_1_1,refer_c)
    & varia(kind_1_1,varia_c)
    & sort(c133357,o)
    & card(c133357,int1)
    & etype(c133357,int0)
    & fact(c133357,real)
    & gener(c133357,sp)
    & quant(c133357,one)
    & refer(c133357,det)
    & varia(c133357,con)
    & sort(know_1_1,o)
    & card(know_1_1,int1)
    & etype(know_1_1,int0)
    & fact(know_1_1,real)
    & gener(know_1_1,ge)
    & quant(know_1_1,one)
    & refer(know_1_1,refer_c)
    & varia(know_1_1,varia_c)
    & sort(c133366,d)
    & card(c133366,cons(x_constant,cons(int1,nil)))
    & etype(c133366,int1)
    & fact(c133366,real)
    & gener(c133366,sp)
    & quant(c133366,mult)
    & refer(c133366,det)
    & varia(c133366,con)
    & sort(eltern_1_1,d)
    & card(eltern_1_1,int1)
    & etype(eltern_1_1,int0)
    & fact(eltern_1_1,real)
    & gener(eltern_1_1,ge)
    & quant(eltern_1_1,one)
    & refer(eltern_1_1,refer_c)
    & varia(eltern_1_1,varia_c)
    & sort(c133371,d)
    & sort(c133371,io)
    & card(c133371,int1)
    & etype(c133371,int0)
    & fact(c133371,real)
    & gener(c133371,sp)
    & quant(c133371,one)
    & refer(c133371,det)
    & varia(c133371,con)
    & sort(firma_1_1,d)
    & sort(firma_1_1,io)
    & card(firma_1_1,int1)
    & etype(firma_1_1,int0)
    & fact(firma_1_1,real)
    & gener(firma_1_1,ge)
    & quant(firma_1_1,one)
    & refer(firma_1_1,refer_c)
    & varia(firma_1_1,varia_c)
    & sort(c133383,io)
    & sort(c133383,oa)
    & card(c133383,int1)
    & etype(c133383,int2)
    & fact(c133383,real)
    & gener(c133383,sp)
    & quant(c133383,mult)
    & refer(c133383,det)
    & varia(c133383,con)
    & sort(kosten__1_1,io)
    & sort(kosten__1_1,oa)
    & card(kosten__1_1,int1)
    & etype(kosten__1_1,int1)
    & fact(kosten__1_1,real)
    & gener(kosten__1_1,ge)
    & quant(kosten__1_1,one)
    & refer(kosten__1_1,refer_c)
    & varia(kosten__1_1,varia_c)
    & sort(c133388,io)
    & card(c133388,cons(x_constant,cons(int1,nil)))
    & etype(c133388,int1)
    & fact(c133388,real)
    & gener(c133388,gener_c)
    & quant(c133388,mult)
    & refer(c133388,refer_c)
    & varia(c133388,varia_c)
    & sort(kraft_1_1,io)
    & card(kraft_1_1,int1)
    & etype(kraft_1_1,int0)
    & fact(kraft_1_1,real)
    & gener(kraft_1_1,ge)
    & quant(kraft_1_1,one)
    & refer(kraft_1_1,refer_c)
    & varia(kraft_1_1,varia_c)
    & sort(neo_1_1,nq)
    & sort(c133411,d)
    & card(c133411,int1)
    & etype(c133411,int0)
    & fact(c133411,real)
    & gener(c133411,sp)
    & quant(c133411,one)
    & refer(c133411,det)
    & varia(c133411,con)
    & sort(c133412,na)
    & card(c133412,int1)
    & etype(c133412,int0)
    & fact(c133412,real)
    & gener(c133412,sp)
    & quant(c133412,one)
    & refer(c133412,indet)
    & varia(c133412,varia_c)
    & sort(mensch_1_1,d)
    & card(mensch_1_1,int1)
    & etype(mensch_1_1,int0)
    & fact(mensch_1_1,real)
    & gener(mensch_1_1,ge)
    & quant(mensch_1_1,one)
    & refer(mensch_1_1,refer_c)
    & varia(mensch_1_1,varia_c)
    & sort(eigenname_1_1,na)
    & card(eigenname_1_1,int1)
    & etype(eigenname_1_1,int0)
    & fact(eigenname_1_1,real)
    & gener(eigenname_1_1,ge)
    & quant(eigenname_1_1,one)
    & refer(eigenname_1_1,refer_c)
    & varia(eigenname_1_1,varia_c)
    & sort(peter_0,fe)
    & sort(c133415,d)
    & sort(c133415,io)
    & card(c133415,int1)
    & etype(c133415,int0)
    & fact(c133415,real)
    & gener(c133415,sp)
    & quant(c133415,one)
    & refer(c133415,det)
    & varia(c133415,con)
    & sort(c133416,na)
    & card(c133416,int1)
    & etype(c133416,int0)
    & fact(c133416,real)
    & gener(c133416,sp)
    & quant(c133416,one)
    & refer(c133416,indet)
    & varia(c133416,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(hackenberg_0,fe)
    & sort(c133463,d)
    & sort(c133463,io)
    & card(c133463,int1)
    & etype(c133463,int0)
    & fact(c133463,real)
    & gener(c133463,sp)
    & quant(c133463,one)
    & refer(c133463,det)
    & varia(c133463,con)
    & sort(c133464,na)
    & card(c133464,int1)
    & etype(c133464,int0)
    & fact(c133464,real)
    & gener(c133464,sp)
    & quant(c133464,one)
    & refer(c133464,indet)
    & varia(c133464,varia_c)
    & sort(bmw_0,fe)
    & sort(c133469,io)
    & card(c133469,cons(x_constant,cons(int1,nil)))
    & etype(c133469,int1)
    & fact(c133469,real)
    & gener(c133469,gener_c)
    & quant(c133469,mult)
    & refer(c133469,refer_c)
    & varia(c133469,varia_c)
    & sort(grundsatzthema_1_1,io)
    & card(grundsatzthema_1_1,int1)
    & etype(grundsatzthema_1_1,int0)
    & fact(grundsatzthema_1_1,real)
    & gener(grundsatzthema_1_1,ge)
    & quant(grundsatzthema_1_1,one)
    & refer(grundsatzthema_1_1,refer_c)
    & varia(grundsatzthema_1_1,varia_c)
    & sort(personalpolitisch_1_1,tq)
    & sort(c133476,ad)
    & card(c133476,int1)
    & etype(c133476,int0)
    & fact(c133476,real)
    & gener(c133476,sp)
    & quant(c133476,one)
    & refer(c133476,det)
    & varia(c133476,con)
    & sort(engagement_1_1,ad)
    & card(engagement_1_1,int1)
    & etype(engagement_1_1,int0)
    & fact(engagement_1_1,real)
    & gener(engagement_1_1,ge)
    & quant(engagement_1_1,one)
    & refer(engagement_1_1,refer_c)
    & varia(engagement_1_1,varia_c)
    & sort(c133480,d)
    & sort(c133480,io)
    & card(c133480,int1)
    & etype(c133480,int0)
    & fact(c133480,real)
    & gener(c133480,sp)
    & quant(c133480,one)
    & refer(c133480,det)
    & varia(c133480,con)
    & sort(c133747,ent)
    & card(c133747,card_c)
    & etype(c133747,etype_c)
    & fact(c133747,real)
    & gener(c133747,gener_c)
    & quant(c133747,quant_c)
    & refer(c133747,refer_c)
    & varia(c133747,varia_c)
    & sort(c133311,d)
    & card(c133311,card_c)
    & etype(c133311,int1)
    & etype(c133311,int2)
    & etype(c133311,int3)
    & fact(c133311,real)
    & gener(c133311,sp)
    & quant(c133311,quant_c)
    & refer(c133311,det)
    & varia(c133311,varia_c)
    & sort(eignen_1_1,st)
    & fact(eignen_1_1,real)
    & gener(eignen_1_1,ge)
    & sort(grundsatz_1_1,io)
    & card(grundsatz_1_1,int1)
    & etype(grundsatz_1_1,int0)
    & fact(grundsatz_1_1,real)
    & gener(grundsatz_1_1,ge)
    & quant(grundsatz_1_1,one)
    & refer(grundsatz_1_1,refer_c)
    & varia(grundsatz_1_1,varia_c)
    & sort(motto__1_1,io)
    & card(motto__1_1,int1)
    & etype(motto__1_1,int0)
    & fact(motto__1_1,real)
    & gener(motto__1_1,ge)
    & quant(motto__1_1,one)
    & refer(motto__1_1,refer_c)
    & varia(motto__1_1,varia_c)
    & sort(personal__1_1,d)
    & sort(personal__1_1,io)
    & card(personal__1_1,card_c)
    & etype(personal__1_1,int1)
    & fact(personal__1_1,real)
    & gener(personal__1_1,ge)
    & quant(personal__1_1,quant_c)
    & refer(personal__1_1,refer_c)
    & varia(personal__1_1,varia_c)
    & sort(politisch__1_1,tq) ) ).

%------------------------------------------------------------------------------
