%------------------------------------------------------------------------------
% File     : CSR115+22 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Which British company was taken over by BMW in 1994?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_007_mira_news_1147_a462_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.35 v9.1.0, 0.40 v9.0.0, 0.25 v8.2.0, 0.27 v8.1.0, 0.29 v7.5.0, 0.38 v7.4.0, 0.31 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.29 v6.4.0, 0.21 v6.3.0, 0.31 v6.2.0, 0.45 v6.1.0, 0.52 v6.0.0, 0.50 v5.5.0, 0.58 v5.4.0, 0.57 v5.3.0, 0.65 v5.2.0, 0.43 v5.0.0, 0.55 v4.1.0, 0.61 v4.0.1, 0.63 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10919 (   0 equ)
%            Maximal formula atoms :  212 (   1 avg)
%            Number of connectives :  730 (   0   ~;  18   |; 586   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  212 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   88 (  88 usr;   0 prp; 2-10 aty)
%            Number of functors    : 16664 (16664 usr;16663 con; 0-2 aty)
%            Number of variables   :  475 ( 405   !;  70   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_007_mira_news_1147_a462,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6] :
      ( attr(X0,X1)
      & attr(X3,X2)
      & attr(X5,X6)
      & obj(X4,X0)
      & sub(X1,name_1_1)
      & sub(X0,firma_1_1)
      & sub(X2,name_1_1)
      & val(X1,bmw_0)
      & val(X2,bmw_0) ) ).

fof(ave07_era5_synth_qa07_007_mira_news_1147_a462,hypothesis,
    ( assoc(branchenblatt_1_1,branche_1_1)
    & sub(branchenblatt_1_1,blatt_1_1)
    & attr(c346,c354)
    & pred(c346,reisende_1_1)
    & sub(c354,name_1_1)
    & val(c354,einer_hessischen_0)
    & attr(c361,c362)
    & sub(c361,fluss_1_1)
    & sub(c362,name_1_1)
    & val(c362,headwear_0)
    & sub(c373,firma_1_1)
    & sub(c390,branchenblatt_1_1)
    & poss(c394,c390)
    & subs(c396,boykott_1_1)
    & attr(c436,c437)
    & sub(c436,firma_1_1)
    & sub(c437,name_1_1)
    & val(c437,rover_0)
    & attr(c817,c818)
    & sub(c817,firma_1_1)
    & sub(c818,name_1_1)
    & val(c818,bmw_0)
    & name(c827,an_bester_stelle_0)
    & tupl_p10(c898,c346,c361,c373,c390,c396,c436,c817,c827,c827)
    & sort(branchenblatt_1_1,d)
    & sort(branchenblatt_1_1,io)
    & card(branchenblatt_1_1,int1)
    & etype(branchenblatt_1_1,int0)
    & fact(branchenblatt_1_1,real)
    & gener(branchenblatt_1_1,ge)
    & quant(branchenblatt_1_1,one)
    & refer(branchenblatt_1_1,refer_c)
    & varia(branchenblatt_1_1,varia_c)
    & sort(branche_1_1,io)
    & card(branche_1_1,card_c)
    & etype(branche_1_1,int1)
    & fact(branche_1_1,real)
    & gener(branche_1_1,ge)
    & quant(branche_1_1,quant_c)
    & refer(branche_1_1,refer_c)
    & varia(branche_1_1,varia_c)
    & sort(blatt_1_1,d)
    & sort(blatt_1_1,io)
    & card(blatt_1_1,int1)
    & etype(blatt_1_1,int0)
    & fact(blatt_1_1,real)
    & gener(blatt_1_1,ge)
    & quant(blatt_1_1,one)
    & refer(blatt_1_1,refer_c)
    & varia(blatt_1_1,varia_c)
    & sort(c346,d)
    & card(c346,int4)
    & etype(c346,int1)
    & fact(c346,real)
    & gener(c346,sp)
    & quant(c346,nfquant)
    & refer(c346,det)
    & varia(c346,varia_c)
    & sort(c354,na)
    & card(c354,int1)
    & etype(c354,int0)
    & fact(c354,real)
    & gener(c354,sp)
    & quant(c354,one)
    & refer(c354,det)
    & varia(c354,varia_c)
    & sort(reisende_1_1,d)
    & card(reisende_1_1,int1)
    & etype(reisende_1_1,int0)
    & fact(reisende_1_1,real)
    & gener(reisende_1_1,ge)
    & quant(reisende_1_1,one)
    & refer(reisende_1_1,refer_c)
    & varia(reisende_1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(einer_hessischen_0,fe)
    & sort(c361,d)
    & card(c361,int1)
    & etype(c361,int0)
    & fact(c361,real)
    & gener(c361,sp)
    & quant(c361,one)
    & refer(c361,det)
    & varia(c361,con)
    & sort(c362,na)
    & card(c362,int1)
    & etype(c362,int0)
    & fact(c362,real)
    & gener(c362,sp)
    & quant(c362,one)
    & refer(c362,indet)
    & varia(c362,varia_c)
    & sort(fluss_1_1,d)
    & card(fluss_1_1,int1)
    & etype(fluss_1_1,int0)
    & fact(fluss_1_1,real)
    & gener(fluss_1_1,ge)
    & quant(fluss_1_1,one)
    & refer(fluss_1_1,refer_c)
    & varia(fluss_1_1,varia_c)
    & sort(headwear_0,fe)
    & sort(c373,d)
    & sort(c373,io)
    & card(c373,int1)
    & etype(c373,int0)
    & fact(c373,real)
    & gener(c373,gener_c)
    & quant(c373,one)
    & refer(c373,refer_c)
    & varia(c373,varia_c)
    & sort(firma_1_1,d)
    & sort(firma_1_1,io)
    & card(firma_1_1,int1)
    & etype(firma_1_1,int0)
    & fact(firma_1_1,real)
    & gener(firma_1_1,ge)
    & quant(firma_1_1,one)
    & refer(firma_1_1,refer_c)
    & varia(firma_1_1,varia_c)
    & sort(c390,d)
    & sort(c390,io)
    & card(c390,int1)
    & etype(c390,int0)
    & fact(c390,real)
    & gener(c390,sp)
    & quant(c390,one)
    & refer(c390,det)
    & varia(c390,varia_c)
    & sort(c394,o)
    & card(c394,int1)
    & etype(c394,int0)
    & fact(c394,real)
    & gener(c394,sp)
    & quant(c394,one)
    & refer(c394,det)
    & varia(c394,varia_c)
    & sort(c396,ad)
    & card(c396,int1)
    & etype(c396,int0)
    & fact(c396,real)
    & gener(c396,sp)
    & quant(c396,one)
    & refer(c396,det)
    & varia(c396,con)
    & sort(boykott_1_1,ad)
    & card(boykott_1_1,int1)
    & etype(boykott_1_1,int0)
    & fact(boykott_1_1,real)
    & gener(boykott_1_1,ge)
    & quant(boykott_1_1,one)
    & refer(boykott_1_1,refer_c)
    & varia(boykott_1_1,varia_c)
    & sort(c436,d)
    & sort(c436,io)
    & card(c436,int1)
    & etype(c436,int0)
    & fact(c436,real)
    & gener(c436,sp)
    & quant(c436,one)
    & refer(c436,det)
    & varia(c436,con)
    & sort(c437,na)
    & card(c437,int1)
    & etype(c437,int0)
    & fact(c437,real)
    & gener(c437,sp)
    & quant(c437,one)
    & refer(c437,indet)
    & varia(c437,varia_c)
    & sort(rover_0,fe)
    & sort(c817,d)
    & sort(c817,io)
    & card(c817,int1)
    & etype(c817,int0)
    & fact(c817,real)
    & gener(c817,sp)
    & quant(c817,one)
    & refer(c817,det)
    & varia(c817,con)
    & sort(c818,na)
    & card(c818,int1)
    & etype(c818,int0)
    & fact(c818,real)
    & gener(c818,sp)
    & quant(c818,one)
    & refer(c818,indet)
    & varia(c818,varia_c)
    & sort(bmw_0,fe)
    & sort(c827,o)
    & card(c827,int1)
    & etype(c827,int0)
    & fact(c827,real)
    & gener(c827,gener_c)
    & quant(c827,one)
    & refer(c827,refer_c)
    & varia(c827,varia_c)
    & sort(an_bester_stelle_0,fe)
    & sort(c898,ent)
    & card(c898,card_c)
    & etype(c898,etype_c)
    & fact(c898,real)
    & gener(c898,gener_c)
    & quant(c898,quant_c)
    & refer(c898,refer_c)
    & varia(c898,varia_c) ) ).

%------------------------------------------------------------------------------
