%------------------------------------------------------------------------------
% File     : CSR115+21 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Which British company was taken over by BMW in 1994?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_007_mira_news_1144_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.20 v9.0.0, 0.19 v8.2.0, 0.13 v8.1.0, 0.14 v7.5.0, 0.19 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.14 v6.3.0, 0.23 v6.2.0, 0.27 v6.1.0, 0.32 v6.0.0, 0.50 v5.5.0, 0.42 v5.4.0, 0.39 v5.3.0, 0.43 v5.2.0, 0.36 v5.0.0, 0.35 v4.1.0, 0.39 v4.0.1, 0.37 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10841 (   0 equ)
%            Maximal formula atoms :  135 (   1 avg)
%            Number of connectives :  652 (   0   ~;  18   |; 508   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  135 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   90 (  90 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16654 (16654 usr;16653 con; 0-2 aty)
%            Number of variables   :  475 ( 405   !;  70   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_007_mira_news_1144,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6] :
      ( agt(X4,X3)
      & attr(X0,X1)
      & attr(X3,X2)
      & attr(X5,X6)
      & sub(X1,name_1_1)
      & sub(X2,name_1_1)
      & val(X1,bmw_0)
      & val(X2,bmw_0) ) ).

fof(ave07_era5_synth_qa07_007_mira_news_1144,hypothesis,
    ( attr(c5,c802)
    & sub(c5,papier_1_1)
    & aff(c537,c5)
    & init(c537,c822)
    & mannr(c537,enorm_1_1)
    & rslt(c537,c821)
    & subs(c537,gewinnen_1_2)
    & attch(c717,c5)
    & attr(c717,c718)
    & sub(c717,k__344ufer_1_1)
    & sub(c718,name_1_1)
    & val(c718,bmw_0)
    & sub(c802,wert_1_1)
    & sub(c814,firma_1_1)
    & agt(c816,c717)
    & modl(c816,just_1_1)
    & obj(c816,c814)
    & reas(c816,c537)
    & subs(c816,zulegen_1_1)
    & arg1(c821,c802)
    & subr(c821,val_0)
    & arg1(c822,c802)
    & subr(c822,val_0)
    & sort(c5,s)
    & card(c5,int1)
    & etype(c5,int0)
    & fact(c5,real)
    & gener(c5,sp)
    & quant(c5,one)
    & refer(c5,det)
    & varia(c5,con)
    & sort(c802,io)
    & sort(c802,oa)
    & card(c802,int1)
    & etype(c802,int0)
    & fact(c802,real)
    & gener(c802,gener_c)
    & quant(c802,one)
    & refer(c802,refer_c)
    & varia(c802,varia_c)
    & sort(papier_1_1,s)
    & card(papier_1_1,int1)
    & etype(papier_1_1,int0)
    & fact(papier_1_1,real)
    & gener(papier_1_1,ge)
    & quant(papier_1_1,one)
    & refer(papier_1_1,refer_c)
    & varia(papier_1_1,varia_c)
    & sort(c537,dn)
    & fact(c537,real)
    & gener(c537,sp)
    & sort(c822,st)
    & fact(c822,real)
    & gener(c822,sp)
    & sort(enorm_1_1,nq)
    & sort(c821,st)
    & fact(c821,real)
    & gener(c821,sp)
    & sort(gewinnen_1_2,dn)
    & fact(gewinnen_1_2,real)
    & gener(gewinnen_1_2,ge)
    & sort(c717,d)
    & sort(c717,io)
    & card(c717,int1)
    & etype(c717,int0)
    & fact(c717,real)
    & gener(c717,sp)
    & quant(c717,one)
    & refer(c717,det)
    & varia(c717,con)
    & sort(c718,na)
    & card(c718,int1)
    & etype(c718,int0)
    & fact(c718,real)
    & gener(c718,sp)
    & quant(c718,one)
    & refer(c718,indet)
    & varia(c718,varia_c)
    & sort(k__344ufer_1_1,d)
    & sort(k__344ufer_1_1,io)
    & card(k__344ufer_1_1,int1)
    & etype(k__344ufer_1_1,int0)
    & fact(k__344ufer_1_1,real)
    & gener(k__344ufer_1_1,ge)
    & quant(k__344ufer_1_1,one)
    & refer(k__344ufer_1_1,refer_c)
    & varia(k__344ufer_1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(bmw_0,fe)
    & sort(wert_1_1,io)
    & sort(wert_1_1,oa)
    & card(wert_1_1,int1)
    & etype(wert_1_1,int0)
    & fact(wert_1_1,real)
    & gener(wert_1_1,ge)
    & quant(wert_1_1,one)
    & refer(wert_1_1,refer_c)
    & varia(wert_1_1,varia_c)
    & sort(c814,d)
    & sort(c814,io)
    & card(c814,int1)
    & etype(c814,int0)
    & fact(c814,real)
    & gener(c814,sp)
    & quant(c814,one)
    & refer(c814,det)
    & varia(c814,varia_c)
    & sort(firma_1_1,d)
    & sort(firma_1_1,io)
    & card(firma_1_1,int1)
    & etype(firma_1_1,int0)
    & fact(firma_1_1,real)
    & gener(firma_1_1,ge)
    & quant(firma_1_1,one)
    & refer(firma_1_1,refer_c)
    & varia(firma_1_1,varia_c)
    & sort(c816,da)
    & fact(c816,real)
    & gener(c816,sp)
    & sort(just_1_1,md)
    & fact(just_1_1,real)
    & gener(just_1_1,gener_c)
    & sort(zulegen_1_1,da)
    & fact(zulegen_1_1,real)
    & gener(zulegen_1_1,ge)
    & sort(val_0,st)
    & fact(val_0,real)
    & gener(val_0,gener_c) ) ).

%------------------------------------------------------------------------------
