%------------------------------------------------------------------------------
% File     : CSR115+20 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Which British company was taken over by BMW in 1994?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_007_mira_news_1142_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.35 v9.1.0, 0.40 v9.0.0, 0.19 v8.2.0, 0.20 v8.1.0, 0.29 v7.5.0, 0.43 v7.4.0, 0.25 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.29 v6.4.0, 0.21 v6.3.0, 0.23 v6.2.0, 0.36 v6.1.0, 0.52 v6.0.0, 0.50 v5.5.0, 0.58 v5.4.0, 0.61 v5.3.0, 0.65 v5.2.0, 0.36 v5.0.0, 0.50 v4.1.0, 0.56 v4.0.1, 0.63 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 11083 (   0 equ)
%            Maximal formula atoms :  375 (   1 avg)
%            Number of connectives :  894 (   0   ~;  18   |; 750   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  375 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-14 aty)
%            Number of functors    : 16682 (16682 usr;16681 con; 0-2 aty)
%            Number of variables   :  475 ( 405   !;  70   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_007_mira_news_1142,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6] :
      ( attr(X0,X1)
      & attr(X3,X2)
      & attr(X5,X6)
      & obj(X4,X0)
      & sub(X1,name_1_1)
      & sub(X0,firma_1_1)
      & sub(X2,name_1_1)
      & sub(X6,jahr__1_1)
      & val(X1,bmw_0)
      & val(X2,bmw_0) ) ).

fof(ave07_era5_synth_qa07_007_mira_news_1142,hypothesis,
    ( assoc(aggregat_1_1,ableger_1_1)
    & sub(aggregat_1_1,werk_1_2)
    & attr(c1158,c1159)
    & sub(c1158,firma_1_1)
    & sub(c1159,name_1_1)
    & val(c1159,bmw_0)
    & attr(c1162,c1163)
    & sub(c1162,mensch_1_1)
    & sub(c1163,familiename_1_1)
    & val(c1163,roll_0)
    & attr(c1167,c1168)
    & sub(c1167,mensch_1_1)
    & sub(c1168,familiename_1_1)
    & val(c1168,royce_0)
    & attr(c1170,c1171)
    & sub(c1171,jahr__1_1)
    & val(c1171,c1165)
    & attr(c1174,c1175)
    & sub(c1175,jahr__1_1)
    & val(c1175,c1172)
    & pred(c1177,kontrakt_1_1)
    & attr(c1186,c1187)
    & sub(c1186,land_1_1)
    & sub(c1187,name_1_1)
    & val(c1187,usa_0)
    & attr(c1188,c1213)
    & prop(c1188,kandadischen_1_1)
    & sub(c1188,fabrikant_1_1)
    & sub(c1188,firma_1_1)
    & pred(c1189,gulfstream_1_1)
    & sub(c1213,name_1_1)
    & val(c1213,bombardier_0)
    & tupl_p14(c1251,c162,c170,c180,c1158,c1162,c1167,c1170,c1174,c1177,c1186,c1188,c1189,c1188)
    & prop(c162,klein_1_1)
    & sub(c162,aggregat_1_1)
    & attch(c167,c170)
    & attr(c167,c168)
    & sub(c167,einrichtung_1_2)
    & sub(c168,name_1_1)
    & val(c168,br_0)
    & attr(c170,c171)
    & sub(c171,jahr__1_1)
    & val(c171,c165)
    & pred(c180,fr__374htyp_1_1)
    & sort(aggregat_1_1,d)
    & sort(aggregat_1_1,io)
    & card(aggregat_1_1,int1)
    & etype(aggregat_1_1,int0)
    & fact(aggregat_1_1,real)
    & gener(aggregat_1_1,ge)
    & quant(aggregat_1_1,one)
    & refer(aggregat_1_1,refer_c)
    & varia(aggregat_1_1,varia_c)
    & sort(ableger_1_1,d)
    & card(ableger_1_1,int1)
    & etype(ableger_1_1,int0)
    & fact(ableger_1_1,real)
    & gener(ableger_1_1,ge)
    & quant(ableger_1_1,one)
    & refer(ableger_1_1,refer_c)
    & varia(ableger_1_1,varia_c)
    & sort(werk_1_2,d)
    & sort(werk_1_2,io)
    & card(werk_1_2,int1)
    & etype(werk_1_2,int0)
    & fact(werk_1_2,real)
    & gener(werk_1_2,ge)
    & quant(werk_1_2,one)
    & refer(werk_1_2,refer_c)
    & varia(werk_1_2,varia_c)
    & sort(c1158,d)
    & sort(c1158,io)
    & card(c1158,int1)
    & etype(c1158,int0)
    & fact(c1158,real)
    & gener(c1158,sp)
    & quant(c1158,one)
    & refer(c1158,det)
    & varia(c1158,con)
    & sort(c1159,na)
    & card(c1159,int1)
    & etype(c1159,int0)
    & fact(c1159,real)
    & gener(c1159,sp)
    & quant(c1159,one)
    & refer(c1159,indet)
    & varia(c1159,varia_c)
    & sort(firma_1_1,d)
    & sort(firma_1_1,io)
    & card(firma_1_1,int1)
    & etype(firma_1_1,int0)
    & fact(firma_1_1,real)
    & gener(firma_1_1,ge)
    & quant(firma_1_1,one)
    & refer(firma_1_1,refer_c)
    & varia(firma_1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(bmw_0,fe)
    & sort(c1162,d)
    & card(c1162,int1)
    & etype(c1162,int0)
    & fact(c1162,real)
    & gener(c1162,sp)
    & quant(c1162,one)
    & refer(c1162,det)
    & varia(c1162,con)
    & sort(c1163,na)
    & card(c1163,int1)
    & etype(c1163,int0)
    & fact(c1163,real)
    & gener(c1163,sp)
    & quant(c1163,one)
    & refer(c1163,indet)
    & varia(c1163,varia_c)
    & sort(mensch_1_1,d)
    & card(mensch_1_1,int1)
    & etype(mensch_1_1,int0)
    & fact(mensch_1_1,real)
    & gener(mensch_1_1,ge)
    & quant(mensch_1_1,one)
    & refer(mensch_1_1,refer_c)
    & varia(mensch_1_1,varia_c)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(roll_0,fe)
    & sort(c1167,d)
    & card(c1167,int1)
    & etype(c1167,int0)
    & fact(c1167,real)
    & gener(c1167,sp)
    & quant(c1167,one)
    & refer(c1167,det)
    & varia(c1167,con)
    & sort(c1168,na)
    & card(c1168,int1)
    & etype(c1168,int0)
    & fact(c1168,real)
    & gener(c1168,sp)
    & quant(c1168,one)
    & refer(c1168,indet)
    & varia(c1168,varia_c)
    & sort(royce_0,fe)
    & sort(c1170,t)
    & card(c1170,int1)
    & etype(c1170,int0)
    & fact(c1170,real)
    & gener(c1170,sp)
    & quant(c1170,one)
    & refer(c1170,det)
    & varia(c1170,con)
    & sort(c1171,me)
    & sort(c1171,oa)
    & sort(c1171,ta)
    & card(c1171,card_c)
    & etype(c1171,etype_c)
    & fact(c1171,real)
    & gener(c1171,sp)
    & quant(c1171,quant_c)
    & refer(c1171,refer_c)
    & varia(c1171,varia_c)
    & sort(jahr__1_1,me)
    & sort(jahr__1_1,oa)
    & sort(jahr__1_1,ta)
    & card(jahr__1_1,card_c)
    & etype(jahr__1_1,etype_c)
    & fact(jahr__1_1,real)
    & gener(jahr__1_1,ge)
    & quant(jahr__1_1,quant_c)
    & refer(jahr__1_1,refer_c)
    & varia(jahr__1_1,varia_c)
    & sort(c1165,nu)
    & card(c1165,int1992)
    & sort(c1174,t)
    & card(c1174,int1)
    & etype(c1174,int0)
    & fact(c1174,real)
    & gener(c1174,sp)
    & quant(c1174,one)
    & refer(c1174,det)
    & varia(c1174,con)
    & sort(c1175,me)
    & sort(c1175,oa)
    & sort(c1175,ta)
    & card(c1175,card_c)
    & etype(c1175,etype_c)
    & fact(c1175,real)
    & gener(c1175,sp)
    & quant(c1175,quant_c)
    & refer(c1175,refer_c)
    & varia(c1175,varia_c)
    & sort(c1172,nu)
    & card(c1172,int1993)
    & sort(c1177,d)
    & sort(c1177,io)
    & card(c1177,cons(x_constant,cons(int1,nil)))
    & etype(c1177,int1)
    & fact(c1177,real)
    & gener(c1177,gener_c)
    & quant(c1177,mult)
    & refer(c1177,indet)
    & varia(c1177,varia_c)
    & sort(kontrakt_1_1,d)
    & sort(kontrakt_1_1,io)
    & card(kontrakt_1_1,int1)
    & etype(kontrakt_1_1,int0)
    & fact(kontrakt_1_1,real)
    & gener(kontrakt_1_1,ge)
    & quant(kontrakt_1_1,one)
    & refer(kontrakt_1_1,refer_c)
    & varia(kontrakt_1_1,varia_c)
    & sort(c1186,d)
    & sort(c1186,io)
    & card(c1186,int1)
    & etype(c1186,int0)
    & fact(c1186,real)
    & gener(c1186,sp)
    & quant(c1186,one)
    & refer(c1186,det)
    & varia(c1186,con)
    & sort(c1187,na)
    & card(c1187,int1)
    & etype(c1187,int0)
    & fact(c1187,real)
    & gener(c1187,sp)
    & quant(c1187,one)
    & refer(c1187,indet)
    & varia(c1187,varia_c)
    & sort(land_1_1,d)
    & sort(land_1_1,io)
    & card(land_1_1,int1)
    & etype(land_1_1,int0)
    & fact(land_1_1,real)
    & gener(land_1_1,ge)
    & quant(land_1_1,one)
    & refer(land_1_1,refer_c)
    & varia(land_1_1,varia_c)
    & sort(usa_0,fe)
    & sort(c1188,d)
    & sort(c1188,io)
    & card(c1188,int1)
    & etype(c1188,int0)
    & fact(c1188,real)
    & gener(c1188,gener_c)
    & quant(c1188,one)
    & refer(c1188,refer_c)
    & varia(c1188,varia_c)
    & sort(c1213,na)
    & card(c1213,int1)
    & etype(c1213,int0)
    & fact(c1213,real)
    & gener(c1213,sp)
    & quant(c1213,one)
    & refer(c1213,indet)
    & varia(c1213,varia_c)
    & sort(kandadischen_1_1,gq)
    & sort(fabrikant_1_1,d)
    & sort(fabrikant_1_1,io)
    & card(fabrikant_1_1,int1)
    & etype(fabrikant_1_1,int0)
    & fact(fabrikant_1_1,real)
    & gener(fabrikant_1_1,ge)
    & quant(fabrikant_1_1,one)
    & refer(fabrikant_1_1,refer_c)
    & varia(fabrikant_1_1,varia_c)
    & sort(c1189,o)
    & card(c1189,cons(x_constant,cons(int1,nil)))
    & etype(c1189,int1)
    & fact(c1189,real)
    & gener(c1189,gener_c)
    & quant(c1189,mult)
    & refer(c1189,indet)
    & varia(c1189,varia_c)
    & sort(gulfstream_1_1,o)
    & card(gulfstream_1_1,int1)
    & etype(gulfstream_1_1,int0)
    & fact(gulfstream_1_1,real)
    & gener(gulfstream_1_1,ge)
    & quant(gulfstream_1_1,one)
    & refer(gulfstream_1_1,refer_c)
    & varia(gulfstream_1_1,varia_c)
    & sort(bombardier_0,fe)
    & sort(c1251,ent)
    & card(c1251,card_c)
    & etype(c1251,etype_c)
    & fact(c1251,real)
    & gener(c1251,gener_c)
    & quant(c1251,quant_c)
    & refer(c1251,refer_c)
    & varia(c1251,varia_c)
    & sort(c162,d)
    & sort(c162,io)
    & card(c162,int1)
    & etype(c162,int0)
    & fact(c162,real)
    & gener(c162,sp)
    & quant(c162,one)
    & refer(c162,det)
    & varia(c162,con)
    & sort(c170,t)
    & card(c170,int1)
    & etype(c170,int0)
    & fact(c170,real)
    & gener(c170,sp)
    & quant(c170,one)
    & refer(c170,det)
    & varia(c170,con)
    & sort(c180,d)
    & card(c180,cons(x_constant,cons(int1,nil)))
    & etype(c180,int1)
    & fact(c180,real)
    & gener(c180,gener_c)
    & quant(c180,mult)
    & refer(c180,indet)
    & varia(c180,varia_c)
    & sort(klein_1_1,mq)
    & sort(c167,d)
    & sort(c167,io)
    & card(c167,int1)
    & etype(c167,int1)
    & fact(c167,real)
    & gener(c167,sp)
    & quant(c167,one)
    & refer(c167,det)
    & varia(c167,con)
    & sort(c168,na)
    & card(c168,int1)
    & etype(c168,int0)
    & fact(c168,real)
    & gener(c168,sp)
    & quant(c168,one)
    & refer(c168,indet)
    & varia(c168,varia_c)
    & sort(einrichtung_1_2,d)
    & sort(einrichtung_1_2,io)
    & card(einrichtung_1_2,card_c)
    & etype(einrichtung_1_2,int1)
    & fact(einrichtung_1_2,real)
    & gener(einrichtung_1_2,ge)
    & quant(einrichtung_1_2,quant_c)
    & refer(einrichtung_1_2,refer_c)
    & varia(einrichtung_1_2,varia_c)
    & sort(br_0,fe)
    & sort(c171,me)
    & sort(c171,oa)
    & sort(c171,ta)
    & card(c171,card_c)
    & etype(c171,etype_c)
    & fact(c171,real)
    & gener(c171,sp)
    & quant(c171,quant_c)
    & refer(c171,refer_c)
    & varia(c171,varia_c)
    & sort(c165,nu)
    & card(c165,int710)
    & sort(fr__374htyp_1_1,d)
    & card(fr__374htyp_1_1,int1)
    & etype(fr__374htyp_1_1,int0)
    & fact(fr__374htyp_1_1,real)
    & gener(fr__374htyp_1_1,ge)
    & quant(fr__374htyp_1_1,one)
    & refer(fr__374htyp_1_1,refer_c)
    & varia(fr__374htyp_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
