%------------------------------------------------------------------------------
% File     : CSR115+2 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Which British company was taken over by BMW in 1994?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_007_insicht_3_a19984_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.40 v9.0.0, 0.25 v8.2.0, 0.27 v8.1.0, 0.29 v7.5.0, 0.43 v7.4.0, 0.31 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.36 v6.4.0, 0.21 v6.3.0, 0.23 v6.2.0, 0.36 v6.1.0, 0.60 v6.0.0, 0.50 v5.5.0, 0.58 v5.4.0, 0.57 v5.3.0, 0.65 v5.2.0, 0.43 v5.0.0, 0.45 v4.1.0, 0.56 v4.0.1, 0.58 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10967 (   0 equ)
%            Maximal formula atoms :  263 (   1 avg)
%            Number of connectives :  778 (   0   ~;  18   |; 634   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  263 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16669 (16669 usr;16668 con; 0-2 aty)
%            Number of variables   :  474 ( 405   !;  69   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_007_insicht_3_a19984,conjecture,
    ? [X0,X1,X2,X3,X4,X5] :
      ( attr(X2,X1)
      & attr(X4,X5)
      & obj(X3,X0)
      & sub(X0,firma_1_1)
      & sub(X1,name_1_1)
      & val(X1,bmw_0) ) ).

fof(ave07_era5_synth_qa07_007_insicht_3_a19984,hypothesis,
    ( assoc(autofirma_1_1,auto__1_1)
    & sub(autofirma_1_1,firma_1_1)
    & attr(c1166,c1167)
    & sub(c1166,firma_1_1)
    & sub(c1167,name_1_1)
    & val(c1167,bmw_0)
    & prop(c1173,pass__351_1_1)
    & sub(c1173,sommer__1_1)
    & attr(c1201,c1202)
    & sub(c1201,autofirma_1_1)
    & sub(c1202,name_1_1)
    & val(c1202,rover_0)
    & prop(c1210,britisch__1_1)
    & prop(c1210,unabh__344ngig_1_1)
    & sub(c1210,c1212)
    & pmod(c1212,letzt_1_1,massenhersteller_1_1)
    & agt(c1215,c1210)
    & subs(c1215,herstellen_1_1)
    & agt(c61,c73)
    & modl(c61,dar__374berhinaus_1_1)
    & obj(c61,c76)
    & ornt(c61,c84)
    & subs(c61,liefern_1_1)
    & attr(c73,c74)
    & sub(c73,firma_1_1)
    & sub(c74,name_1_1)
    & val(c74,rover_0)
    & pred(c76,rohkarosse_1_1)
    & agt(c792,c1201)
    & benf(c792,c1166)
    & obj(c792,c1210)
    & subs(c792,nehmen_1_7)
    & temp(c792,c1173)
    & prop(c84,britisch__1_1)
    & sub(c84,nobelwagenbauer_1_1)
    & assoc(massenhersteller_1_1,masse_1_1)
    & sub(massenhersteller_1_1,fabrikant_1_1)
    & assoc(nobelwagenbauer_1_1,gro__337m__374tig_1_1)
    & sub(nobelwagenbauer_1_1,wagenbauer_1_1)
    & assoc(rohkarosse_1_1,roh_1_1)
    & sub(rohkarosse_1_1,karosse_1_1)
    & sort(autofirma_1_1,d)
    & sort(autofirma_1_1,io)
    & card(autofirma_1_1,int1)
    & etype(autofirma_1_1,int0)
    & fact(autofirma_1_1,real)
    & gener(autofirma_1_1,ge)
    & quant(autofirma_1_1,one)
    & refer(autofirma_1_1,refer_c)
    & varia(autofirma_1_1,varia_c)
    & sort(auto__1_1,d)
    & card(auto__1_1,int1)
    & etype(auto__1_1,int0)
    & fact(auto__1_1,real)
    & gener(auto__1_1,ge)
    & quant(auto__1_1,one)
    & refer(auto__1_1,refer_c)
    & varia(auto__1_1,varia_c)
    & sort(firma_1_1,d)
    & sort(firma_1_1,io)
    & card(firma_1_1,int1)
    & etype(firma_1_1,int0)
    & fact(firma_1_1,real)
    & gener(firma_1_1,ge)
    & quant(firma_1_1,one)
    & refer(firma_1_1,refer_c)
    & varia(firma_1_1,varia_c)
    & sort(c1166,d)
    & sort(c1166,io)
    & card(c1166,int1)
    & etype(c1166,int0)
    & fact(c1166,real)
    & gener(c1166,sp)
    & quant(c1166,one)
    & refer(c1166,det)
    & varia(c1166,con)
    & sort(c1167,na)
    & card(c1167,int1)
    & etype(c1167,int0)
    & fact(c1167,real)
    & gener(c1167,sp)
    & quant(c1167,one)
    & refer(c1167,indet)
    & varia(c1167,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(bmw_0,fe)
    & sort(c1173,ta)
    & card(c1173,int1)
    & etype(c1173,int0)
    & fact(c1173,real)
    & gener(c1173,sp)
    & quant(c1173,one)
    & refer(c1173,det)
    & varia(c1173,con)
    & sort(pass__351_1_1,tq)
    & sort(sommer__1_1,ta)
    & card(sommer__1_1,int1)
    & etype(sommer__1_1,int0)
    & fact(sommer__1_1,real)
    & gener(sommer__1_1,ge)
    & quant(sommer__1_1,one)
    & refer(sommer__1_1,refer_c)
    & varia(sommer__1_1,varia_c)
    & sort(c1201,d)
    & sort(c1201,io)
    & card(c1201,int1)
    & etype(c1201,int0)
    & fact(c1201,real)
    & gener(c1201,sp)
    & quant(c1201,one)
    & refer(c1201,det)
    & varia(c1201,con)
    & sort(c1202,na)
    & card(c1202,int1)
    & etype(c1202,int0)
    & fact(c1202,real)
    & gener(c1202,sp)
    & quant(c1202,one)
    & refer(c1202,indet)
    & varia(c1202,varia_c)
    & sort(rover_0,fe)
    & sort(c1210,io)
    & card(c1210,int1)
    & etype(c1210,int0)
    & fact(c1210,real)
    & gener(c1210,sp)
    & quant(c1210,one)
    & refer(c1210,det)
    & varia(c1210,con)
    & sort(britisch__1_1,nq)
    & sort(unabh__344ngig_1_1,nq)
    & sort(c1212,d)
    & sort(c1212,io)
    & card(c1212,int1)
    & etype(c1212,int0)
    & fact(c1212,real)
    & gener(c1212,ge)
    & quant(c1212,one)
    & refer(c1212,refer_c)
    & varia(c1212,varia_c)
    & sort(letzt_1_1,oq)
    & card(letzt_1_1,card_c)
    & sort(massenhersteller_1_1,d)
    & sort(massenhersteller_1_1,io)
    & card(massenhersteller_1_1,int1)
    & etype(massenhersteller_1_1,int0)
    & fact(massenhersteller_1_1,real)
    & gener(massenhersteller_1_1,ge)
    & quant(massenhersteller_1_1,one)
    & refer(massenhersteller_1_1,refer_c)
    & varia(massenhersteller_1_1,varia_c)
    & sort(c1215,da)
    & fact(c1215,real)
    & gener(c1215,sp)
    & sort(herstellen_1_1,da)
    & fact(herstellen_1_1,real)
    & gener(herstellen_1_1,ge)
    & sort(c61,da)
    & fact(c61,real)
    & gener(c61,sp)
    & sort(c73,d)
    & sort(c73,io)
    & card(c73,int1)
    & etype(c73,int0)
    & fact(c73,real)
    & gener(c73,sp)
    & quant(c73,one)
    & refer(c73,det)
    & varia(c73,con)
    & sort(dar__374berhinaus_1_1,md)
    & fact(dar__374berhinaus_1_1,real)
    & gener(dar__374berhinaus_1_1,gener_c)
    & sort(c76,co)
    & card(c76,card_c)
    & etype(c76,etype_c)
    & fact(c76,real)
    & gener(c76,sp)
    & quant(c76,quant_c)
    & refer(c76,indet)
    & varia(c76,varia_c)
    & sort(c84,d)
    & card(c84,int1)
    & etype(c84,int0)
    & fact(c84,real)
    & gener(c84,sp)
    & quant(c84,one)
    & refer(c84,det)
    & varia(c84,con)
    & sort(liefern_1_1,da)
    & fact(liefern_1_1,real)
    & gener(liefern_1_1,ge)
    & sort(c74,na)
    & card(c74,int1)
    & etype(c74,int0)
    & fact(c74,real)
    & gener(c74,sp)
    & quant(c74,one)
    & refer(c74,indet)
    & varia(c74,varia_c)
    & sort(rohkarosse_1_1,o)
    & card(rohkarosse_1_1,int1)
    & etype(rohkarosse_1_1,int0)
    & fact(rohkarosse_1_1,real)
    & gener(rohkarosse_1_1,ge)
    & quant(rohkarosse_1_1,one)
    & refer(rohkarosse_1_1,refer_c)
    & varia(rohkarosse_1_1,varia_c)
    & sort(c792,da)
    & fact(c792,real)
    & gener(c792,sp)
    & sort(nehmen_1_7,da)
    & fact(nehmen_1_7,real)
    & gener(nehmen_1_7,ge)
    & sort(nobelwagenbauer_1_1,d)
    & card(nobelwagenbauer_1_1,int1)
    & etype(nobelwagenbauer_1_1,int0)
    & fact(nobelwagenbauer_1_1,real)
    & gener(nobelwagenbauer_1_1,ge)
    & quant(nobelwagenbauer_1_1,one)
    & refer(nobelwagenbauer_1_1,refer_c)
    & varia(nobelwagenbauer_1_1,varia_c)
    & sort(masse_1_1,io)
    & card(masse_1_1,card_c)
    & etype(masse_1_1,int1)
    & fact(masse_1_1,real)
    & gener(masse_1_1,ge)
    & quant(masse_1_1,quant_c)
    & refer(masse_1_1,refer_c)
    & varia(masse_1_1,varia_c)
    & sort(fabrikant_1_1,d)
    & sort(fabrikant_1_1,io)
    & card(fabrikant_1_1,int1)
    & etype(fabrikant_1_1,int0)
    & fact(fabrikant_1_1,real)
    & gener(fabrikant_1_1,ge)
    & quant(fabrikant_1_1,one)
    & refer(fabrikant_1_1,refer_c)
    & varia(fabrikant_1_1,varia_c)
    & sort(gro__337m__374tig_1_1,nq)
    & sort(wagenbauer_1_1,d)
    & card(wagenbauer_1_1,int1)
    & etype(wagenbauer_1_1,int0)
    & fact(wagenbauer_1_1,real)
    & gener(wagenbauer_1_1,ge)
    & quant(wagenbauer_1_1,one)
    & refer(wagenbauer_1_1,refer_c)
    & varia(wagenbauer_1_1,varia_c)
    & sort(roh_1_1,nq)
    & sort(karosse_1_1,o)
    & card(karosse_1_1,int1)
    & etype(karosse_1_1,int0)
    & fact(karosse_1_1,real)
    & gener(karosse_1_1,ge)
    & quant(karosse_1_1,one)
    & refer(karosse_1_1,refer_c)
    & varia(karosse_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
