%------------------------------------------------------------------------------
% File     : CSR115+19 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Which British company was taken over by BMW in 1994?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_007_mira_news_1131_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.30 v9.1.0, 0.33 v9.0.0, 0.19 v8.2.0, 0.20 v8.1.0, 0.21 v7.5.0, 0.33 v7.4.0, 0.25 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.29 v6.4.0, 0.21 v6.3.0, 0.31 v6.2.0, 0.45 v6.1.0, 0.60 v6.0.0, 0.50 v5.5.0, 0.58 v5.4.0, 0.57 v5.3.0, 0.65 v5.2.0, 0.36 v5.0.0, 0.50 v4.1.0, 0.61 v4.0.1, 0.58 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10983 (   0 equ)
%            Maximal formula atoms :  278 (   1 avg)
%            Number of connectives :  794 (   0   ~;  18   |; 650   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  278 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-6 aty)
%            Number of functors    : 16663 (16663 usr;16662 con; 0-2 aty)
%            Number of variables   :  475 ( 405   !;  70   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_007_mira_news_1131,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6] :
      ( attr(X0,X1)
      & attr(X3,X2)
      & attr(X5,X6)
      & obj(X4,X0)
      & prop(X0,britisch__1_1)
      & sub(X1,name_1_1)
      & sub(X2,name_1_1) ) ).

fof(ave07_era5_synth_qa07_007_mira_news_1131,hypothesis,
    ( assoc(autobauer_1_1,auto__1_1)
    & sub(autobauer_1_1,fabrikant_1_1)
    & attr(c11,c12)
    & sub(c11,stadt__1_1)
    & sub(c12,name_1_1)
    & val(c12,m__374nchen_0)
    & attr(c131,c132)
    & prop(c131,britisch__1_1)
    & sub(c131,autobauer_1_1)
    & sub(c132,name_1_1)
    & val(c132,rover_0)
    & prop(c137,neo_1_1)
    & sub(c137,gr__366ssenordnung_1_1)
    & attr(c17,c18)
    & attr(c17,c19)
    & sub(c18,tag_1_1)
    & val(c18,c15)
    & sub(c19,monat_1_1)
    & val(c19,c16)
    & tupl(c20,c11,c17)
    & tupl_p6(c262,c70,c74,c83,c131,c137)
    & prop(c70,bundesdeutsch_1_1)
    & sub(c70,bmw_1_1)
    & sub(c74,firmengruppe_1_1)
    & attr(c83,c84)
    & sub(c84,jahr__1_1)
    & val(c84,c81)
    & assoc(gr__366ssenordnung_1_1,gr__366__337e_1_1)
    & sub(gr__366ssenordnung_1_1,ordnung_1_1)
    & sort(autobauer_1_1,d)
    & sort(autobauer_1_1,io)
    & card(autobauer_1_1,int1)
    & etype(autobauer_1_1,int0)
    & fact(autobauer_1_1,real)
    & gener(autobauer_1_1,ge)
    & quant(autobauer_1_1,one)
    & refer(autobauer_1_1,refer_c)
    & varia(autobauer_1_1,varia_c)
    & sort(auto__1_1,d)
    & card(auto__1_1,int1)
    & etype(auto__1_1,int0)
    & fact(auto__1_1,real)
    & gener(auto__1_1,ge)
    & quant(auto__1_1,one)
    & refer(auto__1_1,refer_c)
    & varia(auto__1_1,varia_c)
    & sort(fabrikant_1_1,d)
    & sort(fabrikant_1_1,io)
    & card(fabrikant_1_1,int1)
    & etype(fabrikant_1_1,int0)
    & fact(fabrikant_1_1,real)
    & gener(fabrikant_1_1,ge)
    & quant(fabrikant_1_1,one)
    & refer(fabrikant_1_1,refer_c)
    & varia(fabrikant_1_1,varia_c)
    & sort(c11,d)
    & sort(c11,io)
    & card(c11,int1)
    & etype(c11,int0)
    & fact(c11,real)
    & gener(c11,sp)
    & quant(c11,one)
    & refer(c11,det)
    & varia(c11,con)
    & sort(c12,na)
    & card(c12,int1)
    & etype(c12,int0)
    & fact(c12,real)
    & gener(c12,sp)
    & quant(c12,one)
    & refer(c12,indet)
    & varia(c12,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(m__374nchen_0,fe)
    & sort(c131,d)
    & sort(c131,io)
    & card(c131,int1)
    & etype(c131,int0)
    & fact(c131,real)
    & gener(c131,sp)
    & quant(c131,one)
    & refer(c131,det)
    & varia(c131,con)
    & sort(c132,na)
    & card(c132,int1)
    & etype(c132,int0)
    & fact(c132,real)
    & gener(c132,sp)
    & quant(c132,one)
    & refer(c132,indet)
    & varia(c132,varia_c)
    & sort(britisch__1_1,nq)
    & sort(rover_0,fe)
    & sort(c137,io)
    & sort(c137,oa)
    & card(c137,int1)
    & etype(c137,int0)
    & fact(c137,real)
    & gener(c137,sp)
    & quant(c137,one)
    & refer(c137,indet)
    & varia(c137,varia_c)
    & sort(neo_1_1,nq)
    & sort(gr__366ssenordnung_1_1,io)
    & sort(gr__366ssenordnung_1_1,oa)
    & card(gr__366ssenordnung_1_1,int1)
    & etype(gr__366ssenordnung_1_1,int0)
    & fact(gr__366ssenordnung_1_1,real)
    & gener(gr__366ssenordnung_1_1,ge)
    & quant(gr__366ssenordnung_1_1,one)
    & refer(gr__366ssenordnung_1_1,refer_c)
    & varia(gr__366ssenordnung_1_1,varia_c)
    & sort(c17,t)
    & card(c17,int1)
    & etype(c17,int0)
    & fact(c17,real)
    & gener(c17,sp)
    & quant(c17,one)
    & refer(c17,det)
    & varia(c17,con)
    & sort(c18,me)
    & sort(c18,oa)
    & sort(c18,ta)
    & card(c18,card_c)
    & etype(c18,etype_c)
    & fact(c18,real)
    & gener(c18,sp)
    & quant(c18,quant_c)
    & refer(c18,refer_c)
    & varia(c18,varia_c)
    & sort(c19,me)
    & sort(c19,oa)
    & sort(c19,ta)
    & card(c19,card_c)
    & etype(c19,etype_c)
    & fact(c19,real)
    & gener(c19,sp)
    & quant(c19,quant_c)
    & refer(c19,refer_c)
    & varia(c19,varia_c)
    & sort(tag_1_1,me)
    & sort(tag_1_1,oa)
    & sort(tag_1_1,ta)
    & card(tag_1_1,card_c)
    & etype(tag_1_1,etype_c)
    & fact(tag_1_1,real)
    & gener(tag_1_1,ge)
    & quant(tag_1_1,quant_c)
    & refer(tag_1_1,refer_c)
    & varia(tag_1_1,varia_c)
    & sort(c15,nu)
    & card(c15,int31)
    & sort(monat_1_1,me)
    & sort(monat_1_1,oa)
    & sort(monat_1_1,ta)
    & card(monat_1_1,card_c)
    & etype(monat_1_1,etype_c)
    & fact(monat_1_1,real)
    & gener(monat_1_1,ge)
    & quant(monat_1_1,quant_c)
    & refer(monat_1_1,refer_c)
    & varia(monat_1_1,varia_c)
    & sort(c16,nu)
    & card(c16,int1)
    & sort(c20,ent)
    & card(c20,card_c)
    & etype(c20,etype_c)
    & fact(c20,real)
    & gener(c20,gener_c)
    & quant(c20,quant_c)
    & refer(c20,refer_c)
    & varia(c20,varia_c)
    & sort(c262,ent)
    & card(c262,card_c)
    & etype(c262,etype_c)
    & fact(c262,real)
    & gener(c262,gener_c)
    & quant(c262,quant_c)
    & refer(c262,refer_c)
    & varia(c262,varia_c)
    & sort(c70,d)
    & card(c70,int1)
    & etype(c70,int0)
    & fact(c70,real)
    & gener(c70,sp)
    & quant(c70,one)
    & refer(c70,det)
    & varia(c70,con)
    & sort(c74,d)
    & sort(c74,io)
    & card(c74,int1)
    & etype(c74,int0)
    & fact(c74,real)
    & gener(c74,gener_c)
    & quant(c74,one)
    & refer(c74,refer_c)
    & varia(c74,varia_c)
    & sort(c83,t)
    & card(c83,int1)
    & etype(c83,int0)
    & fact(c83,real)
    & gener(c83,sp)
    & quant(c83,one)
    & refer(c83,det)
    & varia(c83,con)
    & sort(bundesdeutsch_1_1,tq)
    & sort(bmw_1_1,d)
    & card(bmw_1_1,int1)
    & etype(bmw_1_1,int0)
    & fact(bmw_1_1,real)
    & gener(bmw_1_1,ge)
    & quant(bmw_1_1,one)
    & refer(bmw_1_1,refer_c)
    & varia(bmw_1_1,varia_c)
    & sort(firmengruppe_1_1,d)
    & sort(firmengruppe_1_1,io)
    & card(firmengruppe_1_1,int1)
    & etype(firmengruppe_1_1,int0)
    & fact(firmengruppe_1_1,real)
    & gener(firmengruppe_1_1,ge)
    & quant(firmengruppe_1_1,one)
    & refer(firmengruppe_1_1,refer_c)
    & varia(firmengruppe_1_1,varia_c)
    & sort(c84,me)
    & sort(c84,oa)
    & sort(c84,ta)
    & card(c84,card_c)
    & etype(c84,etype_c)
    & fact(c84,real)
    & gener(c84,sp)
    & quant(c84,quant_c)
    & refer(c84,refer_c)
    & varia(c84,varia_c)
    & sort(jahr__1_1,me)
    & sort(jahr__1_1,oa)
    & sort(jahr__1_1,ta)
    & card(jahr__1_1,card_c)
    & etype(jahr__1_1,etype_c)
    & fact(jahr__1_1,real)
    & gener(jahr__1_1,ge)
    & quant(jahr__1_1,quant_c)
    & refer(jahr__1_1,refer_c)
    & varia(jahr__1_1,varia_c)
    & sort(c81,nu)
    & card(c81,int1994)
    & sort(gr__366__337e_1_1,oa)
    & card(gr__366__337e_1_1,int1)
    & etype(gr__366__337e_1_1,int0)
    & fact(gr__366__337e_1_1,real)
    & gener(gr__366__337e_1_1,ge)
    & quant(gr__366__337e_1_1,one)
    & refer(gr__366__337e_1_1,refer_c)
    & varia(gr__366__337e_1_1,varia_c)
    & sort(ordnung_1_1,as)
    & sort(ordnung_1_1,io)
    & card(ordnung_1_1,int1)
    & etype(ordnung_1_1,int0)
    & fact(ordnung_1_1,real)
    & gener(ordnung_1_1,ge)
    & quant(ordnung_1_1,one)
    & refer(ordnung_1_1,refer_c)
    & varia(ordnung_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
