%------------------------------------------------------------------------------
% File     : CSR115+17 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Which British company was taken over by BMW in 1994?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_007_mira_news_1127_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.30 v9.1.0, 0.33 v9.0.0, 0.25 v8.2.0, 0.20 v8.1.0, 0.21 v7.5.0, 0.29 v7.4.0, 0.25 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.29 v6.4.0, 0.21 v6.3.0, 0.31 v6.2.0, 0.45 v6.1.0, 0.52 v6.0.0, 0.50 v5.4.0, 0.48 v5.3.0, 0.61 v5.2.0, 0.43 v5.0.0, 0.40 v4.1.0, 0.50 v4.0.1, 0.47 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10939 (   0 equ)
%            Maximal formula atoms :  236 (   1 avg)
%            Number of connectives :  750 (   0   ~;  18   |; 606   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  236 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   88 (  88 usr;   0 prp; 2-6 aty)
%            Number of functors    : 16664 (16664 usr;16663 con; 0-2 aty)
%            Number of variables   :  474 ( 405   !;  69   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_007_mira_news_1127,conjecture,
    ? [X0,X1,X2,X3,X4,X5] :
      ( attr(X0,X1)
      & attr(X3,X2)
      & attr(X4,X5)
      & sub(X1,name_1_1)
      & sub(X2,name_1_1) ) ).

fof(ave07_era5_synth_qa07_007_mira_news_1127,hypothesis,
    ( sub(c142,bmw_1_1)
    & sub(c147,kurs_1_1)
    & subs(c159,einstieg_1_1)
    & tupl_p6(c1612,c142,c147,c159,c175,c185)
    & attr(c175,c176)
    & prop(c175,britisch__1_1)
    & sub(c175,gruppe_1_1)
    & sub(c176,familiename_1_1)
    & val(c176,rover_0)
    & attr(c185,c186)
    & attr(c185,c187)
    & sub(c186,monat_1_1)
    & val(c186,c184)
    & sub(c187,jahr__1_1)
    & val(c187,c183)
    & prop(c4,aktuell_1_1)
    & sub(c4,kurswert_1_1)
    & assoc(c42,c7)
    & exp(c42,c4)
    & obj(c42,c47)
    & subs(c42,beiliegen_1_1)
    & quant_p3(c47,c43,mark_1_1)
    & sub(c7,aktie_1_1)
    & assoc(kurswert_1_1,kurs_1_1)
    & sub(kurswert_1_1,wert_1_1)
    & sort(c142,d)
    & card(c142,int1)
    & etype(c142,int0)
    & fact(c142,real)
    & gener(c142,sp)
    & quant(c142,one)
    & refer(c142,det)
    & varia(c142,con)
    & sort(bmw_1_1,d)
    & card(bmw_1_1,int1)
    & etype(bmw_1_1,int0)
    & fact(bmw_1_1,real)
    & gener(bmw_1_1,ge)
    & quant(bmw_1_1,one)
    & refer(bmw_1_1,refer_c)
    & varia(bmw_1_1,varia_c)
    & sort(c147,ad)
    & sort(c147,d)
    & sort(c147,io)
    & card(c147,int1)
    & etype(c147,int0)
    & fact(c147,real)
    & gener(c147,gener_c)
    & quant(c147,one)
    & refer(c147,refer_c)
    & varia(c147,varia_c)
    & sort(kurs_1_1,ad)
    & sort(kurs_1_1,d)
    & sort(kurs_1_1,io)
    & card(kurs_1_1,int1)
    & etype(kurs_1_1,int0)
    & fact(kurs_1_1,real)
    & gener(kurs_1_1,ge)
    & quant(kurs_1_1,one)
    & refer(kurs_1_1,refer_c)
    & varia(kurs_1_1,varia_c)
    & sort(c159,ad)
    & card(c159,int1)
    & etype(c159,int0)
    & fact(c159,real)
    & gener(c159,sp)
    & quant(c159,one)
    & refer(c159,det)
    & varia(c159,con)
    & sort(einstieg_1_1,ad)
    & card(einstieg_1_1,int1)
    & etype(einstieg_1_1,int0)
    & fact(einstieg_1_1,real)
    & gener(einstieg_1_1,ge)
    & quant(einstieg_1_1,one)
    & refer(einstieg_1_1,refer_c)
    & varia(einstieg_1_1,varia_c)
    & sort(c1612,ent)
    & card(c1612,card_c)
    & etype(c1612,etype_c)
    & fact(c1612,real)
    & gener(c1612,gener_c)
    & quant(c1612,quant_c)
    & refer(c1612,refer_c)
    & varia(c1612,varia_c)
    & sort(c175,d)
    & card(c175,int1)
    & etype(c175,int1)
    & fact(c175,real)
    & gener(c175,sp)
    & quant(c175,one)
    & refer(c175,det)
    & varia(c175,varia_c)
    & sort(c185,t)
    & card(c185,int1)
    & etype(c185,int0)
    & fact(c185,real)
    & gener(c185,sp)
    & quant(c185,one)
    & refer(c185,det)
    & varia(c185,con)
    & sort(c176,na)
    & card(c176,int1)
    & etype(c176,int0)
    & fact(c176,real)
    & gener(c176,sp)
    & quant(c176,one)
    & refer(c176,det)
    & varia(c176,varia_c)
    & sort(britisch__1_1,nq)
    & sort(gruppe_1_1,d)
    & card(gruppe_1_1,card_c)
    & etype(gruppe_1_1,int1)
    & fact(gruppe_1_1,real)
    & gener(gruppe_1_1,ge)
    & quant(gruppe_1_1,quant_c)
    & refer(gruppe_1_1,refer_c)
    & varia(gruppe_1_1,varia_c)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(rover_0,fe)
    & sort(c186,me)
    & sort(c186,oa)
    & sort(c186,ta)
    & card(c186,card_c)
    & etype(c186,etype_c)
    & fact(c186,real)
    & gener(c186,sp)
    & quant(c186,quant_c)
    & refer(c186,refer_c)
    & varia(c186,varia_c)
    & sort(c187,me)
    & sort(c187,oa)
    & sort(c187,ta)
    & card(c187,card_c)
    & etype(c187,etype_c)
    & fact(c187,real)
    & gener(c187,sp)
    & quant(c187,quant_c)
    & refer(c187,refer_c)
    & varia(c187,varia_c)
    & sort(monat_1_1,me)
    & sort(monat_1_1,oa)
    & sort(monat_1_1,ta)
    & card(monat_1_1,card_c)
    & etype(monat_1_1,etype_c)
    & fact(monat_1_1,real)
    & gener(monat_1_1,ge)
    & quant(monat_1_1,quant_c)
    & refer(monat_1_1,refer_c)
    & varia(monat_1_1,varia_c)
    & sort(c184,nu)
    & card(c184,int1)
    & sort(jahr__1_1,me)
    & sort(jahr__1_1,oa)
    & sort(jahr__1_1,ta)
    & card(jahr__1_1,card_c)
    & etype(jahr__1_1,etype_c)
    & fact(jahr__1_1,real)
    & gener(jahr__1_1,ge)
    & quant(jahr__1_1,quant_c)
    & refer(jahr__1_1,refer_c)
    & varia(jahr__1_1,varia_c)
    & sort(c183,nu)
    & card(c183,int1994)
    & sort(c4,io)
    & sort(c4,oa)
    & card(c4,int1)
    & etype(c4,int0)
    & fact(c4,real)
    & gener(c4,sp)
    & quant(c4,one)
    & refer(c4,det)
    & varia(c4,con)
    & sort(aktuell_1_1,nq)
    & sort(kurswert_1_1,io)
    & sort(kurswert_1_1,oa)
    & card(kurswert_1_1,int1)
    & etype(kurswert_1_1,int0)
    & fact(kurswert_1_1,real)
    & gener(kurswert_1_1,ge)
    & quant(kurswert_1_1,one)
    & refer(kurswert_1_1,refer_c)
    & varia(kurswert_1_1,varia_c)
    & sort(c42,dn)
    & fact(c42,real)
    & gener(c42,sp)
    & sort(c7,d)
    & sort(c7,io)
    & card(c7,int1)
    & etype(c7,int0)
    & fact(c7,real)
    & gener(c7,gener_c)
    & quant(c7,one)
    & refer(c7,refer_c)
    & varia(c7,varia_c)
    & sort(c47,co)
    & sort(c47,m)
    & card(c47,card_c)
    & etype(c47,etype_c)
    & fact(c47,real)
    & gener(c47,sp)
    & quant(c47,quant_c)
    & refer(c47,refer_c)
    & varia(c47,con)
    & sort(beiliegen_1_1,dn)
    & fact(beiliegen_1_1,real)
    & gener(beiliegen_1_1,ge)
    & sort(c43,nu)
    & card(c43,int768)
    & sort(mark_1_1,me)
    & gener(mark_1_1,ge)
    & sort(aktie_1_1,d)
    & sort(aktie_1_1,io)
    & card(aktie_1_1,int1)
    & etype(aktie_1_1,int0)
    & fact(aktie_1_1,real)
    & gener(aktie_1_1,ge)
    & quant(aktie_1_1,one)
    & refer(aktie_1_1,refer_c)
    & varia(aktie_1_1,varia_c)
    & sort(wert_1_1,io)
    & sort(wert_1_1,oa)
    & card(wert_1_1,int1)
    & etype(wert_1_1,int0)
    & fact(wert_1_1,real)
    & gener(wert_1_1,ge)
    & quant(wert_1_1,one)
    & refer(wert_1_1,refer_c)
    & varia(wert_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
