%------------------------------------------------------------------------------
% File     : CSR115+15 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Which British company was taken over by BMW in 1994?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_007_mira_news_1122_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.35 v9.1.0, 0.40 v9.0.0, 0.25 v8.2.0, 0.27 v8.1.0, 0.29 v7.5.0, 0.38 v7.4.0, 0.31 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.29 v6.4.0, 0.21 v6.3.0, 0.23 v6.2.0, 0.36 v6.1.0, 0.52 v6.0.0, 0.50 v5.5.0, 0.58 v5.4.0, 0.57 v5.3.0, 0.65 v5.2.0, 0.43 v5.0.0, 0.55 v4.1.0, 0.56 v4.0.1, 0.63 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10834 (   0 equ)
%            Maximal formula atoms :  127 (   1 avg)
%            Number of connectives :  645 (   0   ~;  18   |; 501   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  127 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-5 aty)
%            Number of functors    : 16650 (16650 usr;16649 con; 0-2 aty)
%            Number of variables   :  475 ( 405   !;  70   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_007_mira_news_1122,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6] :
      ( attr(X0,X1)
      & attr(X3,X2)
      & attr(X5,X6)
      & obj(X4,X0)
      & sub(X1,name_1_1)
      & sub(X0,firma_1_1)
      & sub(X2,name_1_1)
      & val(X1,bmw_0)
      & val(X2,bmw_0) ) ).

fof(ave07_era5_synth_qa07_007_mira_news_1122,hypothesis,
    ( sub(c1089,infobahn_1_1)
    & attr(c1119,c1120)
    & prop(c1119,klein_1_1)
    & sub(c1119,land_1_1)
    & sub(c1120,name_1_1)
    & val(c1120,usa_0)
    & sub(c1121,firma_1_1)
    & attr(c1132,c1133)
    & sub(c1132,firma_1_1)
    & sub(c1133,name_1_1)
    & val(c1133,bmw_0)
    & tupl_p5(c1439,c1089,c1119,c1121,c1132)
    & assoc(infobahn_1_1,info_2_1)
    & sub(infobahn_1_1,bahn_1_1)
    & sort(c1089,io)
    & card(c1089,int1)
    & etype(c1089,int0)
    & fact(c1089,real)
    & gener(c1089,sp)
    & quant(c1089,one)
    & refer(c1089,det)
    & varia(c1089,con)
    & sort(infobahn_1_1,io)
    & card(infobahn_1_1,int1)
    & etype(infobahn_1_1,int0)
    & fact(infobahn_1_1,real)
    & gener(infobahn_1_1,ge)
    & quant(infobahn_1_1,one)
    & refer(infobahn_1_1,refer_c)
    & varia(infobahn_1_1,varia_c)
    & sort(c1119,d)
    & sort(c1119,io)
    & card(c1119,int1)
    & etype(c1119,int0)
    & fact(c1119,real)
    & gener(c1119,sp)
    & quant(c1119,one)
    & refer(c1119,indet)
    & varia(c1119,con)
    & sort(c1120,na)
    & card(c1120,int1)
    & etype(c1120,int0)
    & fact(c1120,real)
    & gener(c1120,sp)
    & quant(c1120,one)
    & refer(c1120,indet)
    & varia(c1120,varia_c)
    & sort(klein_1_1,mq)
    & sort(land_1_1,d)
    & sort(land_1_1,io)
    & card(land_1_1,int1)
    & etype(land_1_1,int0)
    & fact(land_1_1,real)
    & gener(land_1_1,ge)
    & quant(land_1_1,one)
    & refer(land_1_1,refer_c)
    & varia(land_1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(usa_0,fe)
    & sort(c1121,d)
    & sort(c1121,io)
    & card(c1121,int1)
    & etype(c1121,int0)
    & fact(c1121,real)
    & gener(c1121,gener_c)
    & quant(c1121,one)
    & refer(c1121,refer_c)
    & varia(c1121,varia_c)
    & sort(firma_1_1,d)
    & sort(firma_1_1,io)
    & card(firma_1_1,int1)
    & etype(firma_1_1,int0)
    & fact(firma_1_1,real)
    & gener(firma_1_1,ge)
    & quant(firma_1_1,one)
    & refer(firma_1_1,refer_c)
    & varia(firma_1_1,varia_c)
    & sort(c1132,d)
    & sort(c1132,io)
    & card(c1132,int1)
    & etype(c1132,int0)
    & fact(c1132,real)
    & gener(c1132,sp)
    & quant(c1132,one)
    & refer(c1132,det)
    & varia(c1132,con)
    & sort(c1133,na)
    & card(c1133,int1)
    & etype(c1133,int0)
    & fact(c1133,real)
    & gener(c1133,sp)
    & quant(c1133,one)
    & refer(c1133,indet)
    & varia(c1133,varia_c)
    & sort(bmw_0,fe)
    & sort(c1439,ent)
    & card(c1439,card_c)
    & etype(c1439,etype_c)
    & fact(c1439,real)
    & gener(c1439,gener_c)
    & quant(c1439,quant_c)
    & refer(c1439,refer_c)
    & varia(c1439,varia_c)
    & sort(info_2_1,d)
    & sort(info_2_1,io)
    & card(info_2_1,int1)
    & etype(info_2_1,int0)
    & fact(info_2_1,real)
    & gener(info_2_1,ge)
    & quant(info_2_1,one)
    & refer(info_2_1,refer_c)
    & varia(info_2_1,varia_c)
    & sort(bahn_1_1,io)
    & card(bahn_1_1,int1)
    & etype(bahn_1_1,int0)
    & fact(bahn_1_1,real)
    & gener(bahn_1_1,ge)
    & quant(bahn_1_1,one)
    & refer(bahn_1_1,refer_c)
    & varia(bahn_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
