%------------------------------------------------------------------------------
% File     : CSR115+14 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Which British company was taken over by BMW in 1994?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_007_mira_news_1120_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.35 v9.1.0, 0.40 v9.0.0, 0.25 v8.2.0, 0.27 v8.1.0, 0.29 v7.5.0, 0.38 v7.4.0, 0.31 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.29 v6.4.0, 0.21 v6.3.0, 0.31 v6.2.0, 0.45 v6.1.0, 0.52 v6.0.0, 0.50 v5.4.0, 0.48 v5.3.0, 0.57 v5.2.0, 0.43 v5.0.0, 0.45 v4.1.0, 0.50 v4.0.1, 0.53 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10933 (   0 equ)
%            Maximal formula atoms :  226 (   1 avg)
%            Number of connectives :  744 (   0   ~;  18   |; 600   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  226 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-10 aty)
%            Number of functors    : 16661 (16661 usr;16660 con; 0-2 aty)
%            Number of variables   :  475 ( 405   !;  70   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_007_mira_news_1120,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6] :
      ( attr(X0,X1)
      & attr(X3,X2)
      & attr(X5,X6)
      & obj(X4,X0)
      & sub(X1,name_1_1)
      & sub(X0,firma_1_1)
      & sub(X2,name_1_1)
      & val(X1,bmw_0)
      & val(X2,bmw_0) ) ).

fof(ave07_era5_synth_qa07_007_mira_news_1120,hypothesis,
    ( sub(c53498,bmw_1_1)
    & attr(c53524,c54239)
    & sub(c53524,firma_1_1)
    & name(c53531,kinderb__374ro_0)
    & sub(c54239,name_1_1)
    & val(c54239,bmw_0)
    & pred(c54240,mitarbeiter__1_1)
    & subs(c54246,sorge_1_1)
    & obj(c54251,c54257)
    & subs(c54251,betreuung_1_1)
    & pred(c54257,kind_1_1)
    & attch(c54264,c54257)
    & pred(c54268,kindergartenplatz_1_1)
    & pred(c54282,kinderfrau_1_1)
    & tupl_p10(c55260,c53498,c53524,c53531,c53524,c54240,c54246,c54251,c54268,c54282)
    & assoc(kinderfrau_1_1,tag_1_1)
    & sub(kinderfrau_1_1,mutter_1_1)
    & assoc(kindergartenplatz_1_1,kindergarten__1_1)
    & sub(kindergartenplatz_1_1,platz_1_1)
    & sort(c53498,d)
    & card(c53498,int1)
    & etype(c53498,int0)
    & fact(c53498,real)
    & gener(c53498,gener_c)
    & quant(c53498,one)
    & refer(c53498,refer_c)
    & varia(c53498,varia_c)
    & sort(bmw_1_1,d)
    & card(bmw_1_1,int1)
    & etype(bmw_1_1,int0)
    & fact(bmw_1_1,real)
    & gener(bmw_1_1,ge)
    & quant(bmw_1_1,one)
    & refer(bmw_1_1,refer_c)
    & varia(bmw_1_1,varia_c)
    & sort(c53524,d)
    & sort(c53524,io)
    & card(c53524,int1)
    & etype(c53524,int0)
    & fact(c53524,real)
    & gener(c53524,sp)
    & quant(c53524,one)
    & refer(c53524,indet)
    & varia(c53524,varia_c)
    & sort(c54239,na)
    & card(c54239,int1)
    & etype(c54239,int0)
    & fact(c54239,real)
    & gener(c54239,sp)
    & quant(c54239,one)
    & refer(c54239,indet)
    & varia(c54239,varia_c)
    & sort(firma_1_1,d)
    & sort(firma_1_1,io)
    & card(firma_1_1,int1)
    & etype(firma_1_1,int0)
    & fact(firma_1_1,real)
    & gener(firma_1_1,ge)
    & quant(firma_1_1,one)
    & refer(firma_1_1,refer_c)
    & varia(firma_1_1,varia_c)
    & sort(c53531,o)
    & card(c53531,int1)
    & etype(c53531,int0)
    & fact(c53531,real)
    & gener(c53531,gener_c)
    & quant(c53531,one)
    & refer(c53531,refer_c)
    & varia(c53531,varia_c)
    & sort(kinderb__374ro_0,fe)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(bmw_0,fe)
    & sort(c54240,d)
    & card(c54240,cons(x_constant,cons(int1,nil)))
    & etype(c54240,int1)
    & fact(c54240,real)
    & gener(c54240,gener_c)
    & quant(c54240,mult)
    & refer(c54240,indet)
    & varia(c54240,varia_c)
    & sort(mitarbeiter__1_1,d)
    & card(mitarbeiter__1_1,int1)
    & etype(mitarbeiter__1_1,int0)
    & fact(mitarbeiter__1_1,real)
    & gener(mitarbeiter__1_1,ge)
    & quant(mitarbeiter__1_1,one)
    & refer(mitarbeiter__1_1,refer_c)
    & varia(mitarbeiter__1_1,varia_c)
    & sort(c54246,ad)
    & card(c54246,int1)
    & etype(c54246,int0)
    & fact(c54246,real)
    & gener(c54246,sp)
    & quant(c54246,one)
    & refer(c54246,det)
    & varia(c54246,con)
    & sort(sorge_1_1,ad)
    & card(sorge_1_1,int1)
    & etype(sorge_1_1,int0)
    & fact(sorge_1_1,real)
    & gener(sorge_1_1,ge)
    & quant(sorge_1_1,one)
    & refer(sorge_1_1,refer_c)
    & varia(sorge_1_1,varia_c)
    & sort(c54251,ad)
    & card(c54251,int1)
    & etype(c54251,int0)
    & fact(c54251,real)
    & gener(c54251,sp)
    & quant(c54251,one)
    & refer(c54251,det)
    & varia(c54251,con)
    & sort(c54257,d)
    & card(c54257,cons(x_constant,cons(int1,nil)))
    & etype(c54257,int1)
    & fact(c54257,real)
    & gener(c54257,sp)
    & quant(c54257,mult)
    & refer(c54257,det)
    & varia(c54257,varia_c)
    & sort(betreuung_1_1,ad)
    & card(betreuung_1_1,int1)
    & etype(betreuung_1_1,int0)
    & fact(betreuung_1_1,real)
    & gener(betreuung_1_1,ge)
    & quant(betreuung_1_1,one)
    & refer(betreuung_1_1,refer_c)
    & varia(betreuung_1_1,varia_c)
    & sort(kind_1_1,d)
    & card(kind_1_1,int1)
    & etype(kind_1_1,int0)
    & fact(kind_1_1,real)
    & gener(kind_1_1,ge)
    & quant(kind_1_1,one)
    & refer(kind_1_1,refer_c)
    & varia(kind_1_1,varia_c)
    & sort(c54264,o)
    & card(c54264,int1)
    & etype(c54264,int0)
    & fact(c54264,real)
    & gener(c54264,sp)
    & quant(c54264,one)
    & refer(c54264,det)
    & varia(c54264,varia_c)
    & sort(c54268,d)
    & card(c54268,cons(x_constant,cons(int1,nil)))
    & etype(c54268,int1)
    & fact(c54268,real)
    & gener(c54268,gener_c)
    & quant(c54268,mult)
    & refer(c54268,indet)
    & varia(c54268,varia_c)
    & sort(kindergartenplatz_1_1,d)
    & card(kindergartenplatz_1_1,int1)
    & etype(kindergartenplatz_1_1,int0)
    & fact(kindergartenplatz_1_1,real)
    & gener(kindergartenplatz_1_1,ge)
    & quant(kindergartenplatz_1_1,one)
    & refer(kindergartenplatz_1_1,refer_c)
    & varia(kindergartenplatz_1_1,varia_c)
    & sort(c54282,d)
    & card(c54282,cons(x_constant,cons(int1,nil)))
    & etype(c54282,int1)
    & fact(c54282,real)
    & gener(c54282,gener_c)
    & quant(c54282,mult)
    & refer(c54282,indet)
    & varia(c54282,varia_c)
    & sort(kinderfrau_1_1,d)
    & card(kinderfrau_1_1,int1)
    & etype(kinderfrau_1_1,int0)
    & fact(kinderfrau_1_1,real)
    & gener(kinderfrau_1_1,ge)
    & quant(kinderfrau_1_1,one)
    & refer(kinderfrau_1_1,refer_c)
    & varia(kinderfrau_1_1,varia_c)
    & sort(c55260,ent)
    & card(c55260,card_c)
    & etype(c55260,etype_c)
    & fact(c55260,real)
    & gener(c55260,gener_c)
    & quant(c55260,quant_c)
    & refer(c55260,refer_c)
    & varia(c55260,varia_c)
    & sort(tag_1_1,me)
    & sort(tag_1_1,oa)
    & sort(tag_1_1,ta)
    & card(tag_1_1,card_c)
    & etype(tag_1_1,etype_c)
    & fact(tag_1_1,real)
    & gener(tag_1_1,ge)
    & quant(tag_1_1,quant_c)
    & refer(tag_1_1,refer_c)
    & varia(tag_1_1,varia_c)
    & sort(mutter_1_1,d)
    & card(mutter_1_1,int1)
    & etype(mutter_1_1,int0)
    & fact(mutter_1_1,real)
    & gener(mutter_1_1,ge)
    & quant(mutter_1_1,one)
    & refer(mutter_1_1,refer_c)
    & varia(mutter_1_1,varia_c)
    & sort(kindergarten__1_1,d)
    & sort(kindergarten__1_1,io)
    & card(kindergarten__1_1,int1)
    & etype(kindergarten__1_1,int0)
    & fact(kindergarten__1_1,real)
    & gener(kindergarten__1_1,ge)
    & quant(kindergarten__1_1,one)
    & refer(kindergarten__1_1,refer_c)
    & varia(kindergarten__1_1,varia_c)
    & sort(platz_1_1,d)
    & card(platz_1_1,int1)
    & etype(platz_1_1,int0)
    & fact(platz_1_1,real)
    & gener(platz_1_1,ge)
    & quant(platz_1_1,one)
    & refer(platz_1_1,refer_c)
    & varia(platz_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
