%------------------------------------------------------------------------------
% File     : CSR115+12 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Which British company was taken over by BMW in 1994?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_007_mira_news_1112_a19984_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.40 v9.1.0, 0.47 v9.0.0, 0.19 v8.2.0, 0.20 v8.1.0, 0.29 v7.5.0, 0.43 v7.4.0, 0.31 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.29 v6.4.0, 0.21 v6.3.0, 0.23 v6.2.0, 0.36 v6.1.0, 0.60 v6.0.0, 0.50 v5.5.0, 0.62 v5.4.0, 0.61 v5.3.0, 0.70 v5.2.0, 0.43 v5.0.0, 0.55 v4.1.0, 0.61 v4.0.1, 0.63 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10983 (   0 equ)
%            Maximal formula atoms :  277 (   1 avg)
%            Number of connectives :  794 (   0   ~;  18   |; 650   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  277 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   88 (  88 usr;   0 prp; 2-9 aty)
%            Number of functors    : 16665 (16665 usr;16664 con; 0-2 aty)
%            Number of variables   :  475 ( 405   !;  70   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_007_mira_news_1112_a19984,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6] :
      ( attr(X2,X1)
      & attr(X4,X5)
      & has_card_leq(X6,int1994)
      & obj(X3,X0)
      & prop(X0,britisch__1_1)
      & sub(X1,name_1_1)
      & sub(X5,jahr__1_1)
      & val(X5,X6) ) ).

fof(ave07_era5_synth_qa07_007_mira_news_1112_a19984,hypothesis,
    ( assoc(autobauer_1_1,auto__1_1)
    & sub(autobauer_1_1,fabrikant_1_1)
    & sub(c14109,abschlu__337_1_1)
    & assoc(c14115,c14109)
    & attr(c14115,c14116)
    & sub(c14116,jahr__1_1)
    & val(c14116,c14110)
    & sub(c14120,bmw_1_1)
    & sub(c14124,firmengruppe_1_1)
    & attr(c14368,c14369)
    & prop(c14368,britisch__1_1)
    & sub(c14368,autobauer_1_1)
    & sub(c14369,name_1_1)
    & val(c14369,rover_0)
    & pmod(c14381,erst_1_1,land_1_1)
    & attr(c14382,c14383)
    & sub(c14382,c14381)
    & sub(c14383,name_1_1)
    & val(c14383,usa_0)
    & poss(c14386,c14382)
    & sub(c14391,artefakt_1_1)
    & attr(c14397,c14398)
    & sub(c14397,stadt__1_1)
    & sub(c14398,name_1_1)
    & val(c14398,spartanburg_0)
    & subs(c14404,betrieb_1_1)
    & tupl_p9(c14579,c14115,c14120,c14124,c14368,c14382,c14391,c14397,c14404)
    & sort(autobauer_1_1,d)
    & sort(autobauer_1_1,io)
    & card(autobauer_1_1,int1)
    & etype(autobauer_1_1,int0)
    & fact(autobauer_1_1,real)
    & gener(autobauer_1_1,ge)
    & quant(autobauer_1_1,one)
    & refer(autobauer_1_1,refer_c)
    & varia(autobauer_1_1,varia_c)
    & sort(auto__1_1,d)
    & card(auto__1_1,int1)
    & etype(auto__1_1,int0)
    & fact(auto__1_1,real)
    & gener(auto__1_1,ge)
    & quant(auto__1_1,one)
    & refer(auto__1_1,refer_c)
    & varia(auto__1_1,varia_c)
    & sort(fabrikant_1_1,d)
    & sort(fabrikant_1_1,io)
    & card(fabrikant_1_1,int1)
    & etype(fabrikant_1_1,int0)
    & fact(fabrikant_1_1,real)
    & gener(fabrikant_1_1,ge)
    & quant(fabrikant_1_1,one)
    & refer(fabrikant_1_1,refer_c)
    & varia(fabrikant_1_1,varia_c)
    & sort(c14109,ad)
    & sort(c14109,io)
    & card(c14109,int1)
    & etype(c14109,int0)
    & fact(c14109,real)
    & gener(c14109,gener_c)
    & quant(c14109,one)
    & refer(c14109,refer_c)
    & varia(c14109,varia_c)
    & sort(abschlu__337_1_1,ad)
    & sort(abschlu__337_1_1,io)
    & card(abschlu__337_1_1,int1)
    & etype(abschlu__337_1_1,int0)
    & fact(abschlu__337_1_1,real)
    & gener(abschlu__337_1_1,ge)
    & quant(abschlu__337_1_1,one)
    & refer(abschlu__337_1_1,refer_c)
    & varia(abschlu__337_1_1,varia_c)
    & sort(c14115,t)
    & card(c14115,int1)
    & etype(c14115,int0)
    & fact(c14115,real)
    & gener(c14115,sp)
    & quant(c14115,one)
    & refer(c14115,det)
    & varia(c14115,con)
    & sort(c14116,me)
    & sort(c14116,oa)
    & sort(c14116,ta)
    & card(c14116,card_c)
    & etype(c14116,etype_c)
    & fact(c14116,real)
    & gener(c14116,sp)
    & quant(c14116,quant_c)
    & refer(c14116,refer_c)
    & varia(c14116,varia_c)
    & sort(jahr__1_1,me)
    & sort(jahr__1_1,oa)
    & sort(jahr__1_1,ta)
    & card(jahr__1_1,card_c)
    & etype(jahr__1_1,etype_c)
    & fact(jahr__1_1,real)
    & gener(jahr__1_1,ge)
    & quant(jahr__1_1,quant_c)
    & refer(jahr__1_1,refer_c)
    & varia(jahr__1_1,varia_c)
    & sort(c14110,nu)
    & card(c14110,int1994)
    & sort(c14120,d)
    & card(c14120,int1)
    & etype(c14120,int0)
    & fact(c14120,real)
    & gener(c14120,sp)
    & quant(c14120,one)
    & refer(c14120,det)
    & varia(c14120,con)
    & sort(bmw_1_1,d)
    & card(bmw_1_1,int1)
    & etype(bmw_1_1,int0)
    & fact(bmw_1_1,real)
    & gener(bmw_1_1,ge)
    & quant(bmw_1_1,one)
    & refer(bmw_1_1,refer_c)
    & varia(bmw_1_1,varia_c)
    & sort(c14124,d)
    & sort(c14124,io)
    & card(c14124,int1)
    & etype(c14124,int0)
    & fact(c14124,real)
    & gener(c14124,gener_c)
    & quant(c14124,one)
    & refer(c14124,refer_c)
    & varia(c14124,varia_c)
    & sort(firmengruppe_1_1,d)
    & sort(firmengruppe_1_1,io)
    & card(firmengruppe_1_1,int1)
    & etype(firmengruppe_1_1,int0)
    & fact(firmengruppe_1_1,real)
    & gener(firmengruppe_1_1,ge)
    & quant(firmengruppe_1_1,one)
    & refer(firmengruppe_1_1,refer_c)
    & varia(firmengruppe_1_1,varia_c)
    & sort(c14368,d)
    & sort(c14368,io)
    & card(c14368,int1)
    & etype(c14368,int0)
    & fact(c14368,real)
    & gener(c14368,sp)
    & quant(c14368,one)
    & refer(c14368,det)
    & varia(c14368,con)
    & sort(c14369,na)
    & card(c14369,int1)
    & etype(c14369,int0)
    & fact(c14369,real)
    & gener(c14369,sp)
    & quant(c14369,one)
    & refer(c14369,indet)
    & varia(c14369,varia_c)
    & sort(britisch__1_1,nq)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(rover_0,fe)
    & sort(c14381,d)
    & sort(c14381,io)
    & card(c14381,int1)
    & etype(c14381,int0)
    & fact(c14381,real)
    & gener(c14381,ge)
    & quant(c14381,one)
    & refer(c14381,refer_c)
    & varia(c14381,varia_c)
    & sort(erst_1_1,oq)
    & card(erst_1_1,int1)
    & sort(land_1_1,d)
    & sort(land_1_1,io)
    & card(land_1_1,int1)
    & etype(land_1_1,int0)
    & fact(land_1_1,real)
    & gener(land_1_1,ge)
    & quant(land_1_1,one)
    & refer(land_1_1,refer_c)
    & varia(land_1_1,varia_c)
    & sort(c14382,d)
    & sort(c14382,io)
    & card(c14382,int1)
    & etype(c14382,int0)
    & fact(c14382,real)
    & gener(c14382,sp)
    & quant(c14382,one)
    & refer(c14382,det)
    & varia(c14382,con)
    & sort(c14383,na)
    & card(c14383,int1)
    & etype(c14383,int0)
    & fact(c14383,real)
    & gener(c14383,sp)
    & quant(c14383,one)
    & refer(c14383,indet)
    & varia(c14383,varia_c)
    & sort(usa_0,fe)
    & sort(c14386,o)
    & card(c14386,int1)
    & etype(c14386,int0)
    & fact(c14386,real)
    & gener(c14386,sp)
    & quant(c14386,one)
    & refer(c14386,det)
    & varia(c14386,varia_c)
    & sort(c14391,d)
    & sort(c14391,io)
    & card(c14391,int1)
    & etype(c14391,int0)
    & fact(c14391,real)
    & gener(c14391,gener_c)
    & quant(c14391,one)
    & refer(c14391,refer_c)
    & varia(c14391,varia_c)
    & sort(artefakt_1_1,d)
    & sort(artefakt_1_1,io)
    & card(artefakt_1_1,int1)
    & etype(artefakt_1_1,int0)
    & fact(artefakt_1_1,real)
    & gener(artefakt_1_1,ge)
    & quant(artefakt_1_1,one)
    & refer(artefakt_1_1,refer_c)
    & varia(artefakt_1_1,varia_c)
    & sort(c14397,d)
    & sort(c14397,io)
    & card(c14397,int1)
    & etype(c14397,int0)
    & fact(c14397,real)
    & gener(c14397,sp)
    & quant(c14397,one)
    & refer(c14397,det)
    & varia(c14397,con)
    & sort(c14398,na)
    & card(c14398,int1)
    & etype(c14398,int0)
    & fact(c14398,real)
    & gener(c14398,sp)
    & quant(c14398,one)
    & refer(c14398,indet)
    & varia(c14398,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(spartanburg_0,fe)
    & sort(c14404,ad)
    & card(c14404,int1)
    & etype(c14404,int0)
    & fact(c14404,real)
    & gener(c14404,gener_c)
    & quant(c14404,one)
    & refer(c14404,refer_c)
    & varia(c14404,varia_c)
    & sort(betrieb_1_1,ad)
    & card(betrieb_1_1,int1)
    & etype(betrieb_1_1,int0)
    & fact(betrieb_1_1,real)
    & gener(betrieb_1_1,ge)
    & quant(betrieb_1_1,one)
    & refer(betrieb_1_1,refer_c)
    & varia(betrieb_1_1,varia_c)
    & sort(c14579,ent)
    & card(c14579,card_c)
    & etype(c14579,etype_c)
    & fact(c14579,real)
    & gener(c14579,gener_c)
    & quant(c14579,quant_c)
    & refer(c14579,refer_c)
    & varia(c14579,varia_c) ) ).

%------------------------------------------------------------------------------
