%------------------------------------------------------------------------------
% File     : CSR115+11 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Which British company was taken over by BMW in 1994?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_007_mira_news_1109_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.40 v9.1.0, 0.47 v9.0.0, 0.19 v8.2.0, 0.20 v8.1.0, 0.29 v7.5.0, 0.43 v7.4.0, 0.25 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.29 v6.4.0, 0.21 v6.3.0, 0.23 v6.2.0, 0.36 v6.1.0, 0.56 v6.0.0, 0.50 v5.5.0, 0.58 v5.4.0, 0.57 v5.3.0, 0.65 v5.2.0, 0.36 v5.0.0, 0.50 v4.1.0, 0.56 v4.0.1, 0.58 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10985 (   0 equ)
%            Maximal formula atoms :  275 (   1 avg)
%            Number of connectives :  796 (   0   ~;  18   |; 652   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  275 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   88 (  88 usr;   0 prp; 2-7 aty)
%            Number of functors    : 16665 (16665 usr;16664 con; 0-2 aty)
%            Number of variables   :  476 ( 405   !;  71   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_007_mira_news_1109,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6,X7] :
      ( attr(X0,X1)
      & attr(X3,X2)
      & attr(X5,X6)
      & has_card_leq(X7,int1994)
      & obj(X4,X0)
      & sub(X1,name_1_1)
      & sub(X0,firma_1_1)
      & sub(X2,name_1_1)
      & sub(X6,jahr__1_1)
      & val(X1,bmw_0)
      & val(X2,bmw_0)
      & val(X6,X7) ) ).

fof(ave07_era5_synth_qa07_007_mira_news_1109,hypothesis,
    ( sub(c20305,abschlu__337_1_1)
    & assoc(c20312,c20305)
    & attr(c20312,c20313)
    & sub(c20313,jahr__1_1)
    & val(c20313,c20306)
    & attr(c20610,c20611)
    & sub(c20610,firma_1_1)
    & sub(c20611,name_1_1)
    & val(c20611,bmw_0)
    & attr(c20623,c20624)
    & sub(c20623,mensch_1_1)
    & sub(c20624,familiename_1_1)
    & val(c20624,roll_0)
    & attr(c20628,c20629)
    & cmpl1(c20628,c20623)
    & prop(c20628,britisch__1_1)
    & sub(c20628,luxuswagenhersteller_1_1)
    & sub(c20629,eigenname_1_1)
    & val(c20629,royce_0)
    & sub(c20630,abkommen_1_1)
    & subs(c20640,anlieferung_1_1)
    & rslt(c20644,c20649)
    & subs(c20644,entwicklung_1_1)
    & pred(c20649,motor__1_1)
    & prop(c20649,neo_1_1)
    & tupl_p7(c20686,c20312,c20610,c20628,c20630,c20640,c20644)
    & assoc(luxuswagenhersteller_1_1,luxus__1_1)
    & assoc(luxuswagenhersteller_1_1,wagen_2_1)
    & sub(luxuswagenhersteller_1_1,fabrikant_1_1)
    & sort(c20305,ad)
    & sort(c20305,io)
    & card(c20305,int1)
    & etype(c20305,int0)
    & fact(c20305,real)
    & gener(c20305,gener_c)
    & quant(c20305,one)
    & refer(c20305,refer_c)
    & varia(c20305,varia_c)
    & sort(abschlu__337_1_1,ad)
    & sort(abschlu__337_1_1,io)
    & card(abschlu__337_1_1,int1)
    & etype(abschlu__337_1_1,int0)
    & fact(abschlu__337_1_1,real)
    & gener(abschlu__337_1_1,ge)
    & quant(abschlu__337_1_1,one)
    & refer(abschlu__337_1_1,refer_c)
    & varia(abschlu__337_1_1,varia_c)
    & sort(c20312,t)
    & card(c20312,int1)
    & etype(c20312,int0)
    & fact(c20312,real)
    & gener(c20312,sp)
    & quant(c20312,one)
    & refer(c20312,det)
    & varia(c20312,con)
    & sort(c20313,me)
    & sort(c20313,oa)
    & sort(c20313,ta)
    & card(c20313,card_c)
    & etype(c20313,etype_c)
    & fact(c20313,real)
    & gener(c20313,sp)
    & quant(c20313,quant_c)
    & refer(c20313,refer_c)
    & varia(c20313,varia_c)
    & sort(jahr__1_1,me)
    & sort(jahr__1_1,oa)
    & sort(jahr__1_1,ta)
    & card(jahr__1_1,card_c)
    & etype(jahr__1_1,etype_c)
    & fact(jahr__1_1,real)
    & gener(jahr__1_1,ge)
    & quant(jahr__1_1,quant_c)
    & refer(jahr__1_1,refer_c)
    & varia(jahr__1_1,varia_c)
    & sort(c20306,nu)
    & card(c20306,int1994)
    & sort(c20610,d)
    & sort(c20610,io)
    & card(c20610,int1)
    & etype(c20610,int0)
    & fact(c20610,real)
    & gener(c20610,sp)
    & quant(c20610,one)
    & refer(c20610,det)
    & varia(c20610,con)
    & sort(c20611,na)
    & card(c20611,int1)
    & etype(c20611,int0)
    & fact(c20611,real)
    & gener(c20611,sp)
    & quant(c20611,one)
    & refer(c20611,indet)
    & varia(c20611,varia_c)
    & sort(firma_1_1,d)
    & sort(firma_1_1,io)
    & card(firma_1_1,int1)
    & etype(firma_1_1,int0)
    & fact(firma_1_1,real)
    & gener(firma_1_1,ge)
    & quant(firma_1_1,one)
    & refer(firma_1_1,refer_c)
    & varia(firma_1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(bmw_0,fe)
    & sort(c20623,d)
    & card(c20623,int1)
    & etype(c20623,int0)
    & fact(c20623,real)
    & gener(c20623,sp)
    & quant(c20623,one)
    & refer(c20623,det)
    & varia(c20623,con)
    & sort(c20624,na)
    & card(c20624,int1)
    & etype(c20624,int0)
    & fact(c20624,real)
    & gener(c20624,sp)
    & quant(c20624,one)
    & refer(c20624,indet)
    & varia(c20624,varia_c)
    & sort(mensch_1_1,d)
    & card(mensch_1_1,int1)
    & etype(mensch_1_1,int0)
    & fact(mensch_1_1,real)
    & gener(mensch_1_1,ge)
    & quant(mensch_1_1,one)
    & refer(mensch_1_1,refer_c)
    & varia(mensch_1_1,varia_c)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(roll_0,fe)
    & sort(c20628,d)
    & card(c20628,int1)
    & etype(c20628,int0)
    & fact(c20628,real)
    & gener(c20628,sp)
    & quant(c20628,one)
    & refer(c20628,det)
    & varia(c20628,con)
    & sort(c20629,na)
    & card(c20629,int1)
    & etype(c20629,int0)
    & fact(c20629,real)
    & gener(c20629,sp)
    & quant(c20629,one)
    & refer(c20629,indet)
    & varia(c20629,varia_c)
    & sort(britisch__1_1,nq)
    & sort(luxuswagenhersteller_1_1,d)
    & sort(luxuswagenhersteller_1_1,io)
    & card(luxuswagenhersteller_1_1,int1)
    & etype(luxuswagenhersteller_1_1,int0)
    & fact(luxuswagenhersteller_1_1,real)
    & gener(luxuswagenhersteller_1_1,ge)
    & quant(luxuswagenhersteller_1_1,one)
    & refer(luxuswagenhersteller_1_1,refer_c)
    & varia(luxuswagenhersteller_1_1,varia_c)
    & sort(eigenname_1_1,na)
    & card(eigenname_1_1,int1)
    & etype(eigenname_1_1,int0)
    & fact(eigenname_1_1,real)
    & gener(eigenname_1_1,ge)
    & quant(eigenname_1_1,one)
    & refer(eigenname_1_1,refer_c)
    & varia(eigenname_1_1,varia_c)
    & sort(royce_0,fe)
    & sort(c20630,d)
    & sort(c20630,io)
    & card(c20630,int1)
    & etype(c20630,int0)
    & fact(c20630,real)
    & gener(c20630,sp)
    & quant(c20630,one)
    & refer(c20630,indet)
    & varia(c20630,varia_c)
    & sort(abkommen_1_1,d)
    & sort(abkommen_1_1,io)
    & card(abkommen_1_1,int1)
    & etype(abkommen_1_1,int0)
    & fact(abkommen_1_1,real)
    & gener(abkommen_1_1,ge)
    & quant(abkommen_1_1,one)
    & refer(abkommen_1_1,refer_c)
    & varia(abkommen_1_1,varia_c)
    & sort(c20640,ad)
    & card(c20640,int1)
    & etype(c20640,int0)
    & fact(c20640,real)
    & gener(c20640,sp)
    & quant(c20640,one)
    & refer(c20640,det)
    & varia(c20640,con)
    & sort(anlieferung_1_1,ad)
    & card(anlieferung_1_1,int1)
    & etype(anlieferung_1_1,int0)
    & fact(anlieferung_1_1,real)
    & gener(anlieferung_1_1,ge)
    & quant(anlieferung_1_1,one)
    & refer(anlieferung_1_1,refer_c)
    & varia(anlieferung_1_1,varia_c)
    & sort(c20644,ad)
    & card(c20644,int1)
    & etype(c20644,int0)
    & fact(c20644,real)
    & gener(c20644,sp)
    & quant(c20644,one)
    & refer(c20644,det)
    & varia(c20644,varia_c)
    & sort(c20649,d)
    & card(c20649,cons(x_constant,cons(int1,nil)))
    & etype(c20649,int1)
    & fact(c20649,real)
    & gener(c20649,sp)
    & quant(c20649,mult)
    & refer(c20649,indet)
    & varia(c20649,varia_c)
    & sort(entwicklung_1_1,ad)
    & card(entwicklung_1_1,int1)
    & etype(entwicklung_1_1,int0)
    & fact(entwicklung_1_1,real)
    & gener(entwicklung_1_1,ge)
    & quant(entwicklung_1_1,one)
    & refer(entwicklung_1_1,refer_c)
    & varia(entwicklung_1_1,varia_c)
    & sort(motor__1_1,d)
    & card(motor__1_1,int1)
    & etype(motor__1_1,int0)
    & fact(motor__1_1,real)
    & gener(motor__1_1,ge)
    & quant(motor__1_1,one)
    & refer(motor__1_1,refer_c)
    & varia(motor__1_1,varia_c)
    & sort(neo_1_1,nq)
    & sort(c20686,ent)
    & card(c20686,card_c)
    & etype(c20686,etype_c)
    & fact(c20686,real)
    & gener(c20686,gener_c)
    & quant(c20686,quant_c)
    & refer(c20686,refer_c)
    & varia(c20686,varia_c)
    & sort(luxus__1_1,io)
    & card(luxus__1_1,int1)
    & etype(luxus__1_1,int0)
    & fact(luxus__1_1,real)
    & gener(luxus__1_1,ge)
    & quant(luxus__1_1,one)
    & refer(luxus__1_1,refer_c)
    & varia(luxus__1_1,varia_c)
    & sort(wagen_2_1,da)
    & fact(wagen_2_1,real)
    & gener(wagen_2_1,ge)
    & sort(fabrikant_1_1,d)
    & sort(fabrikant_1_1,io)
    & card(fabrikant_1_1,int1)
    & etype(fabrikant_1_1,int0)
    & fact(fabrikant_1_1,real)
    & gener(fabrikant_1_1,ge)
    & quant(fabrikant_1_1,one)
    & refer(fabrikant_1_1,refer_c)
    & varia(fabrikant_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
