%------------------------------------------------------------------------------
% File     : CSR115+10 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Which British company was taken over by BMW in 1994?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_007_mira_news_1108_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.40 v9.0.0, 0.25 v8.2.0, 0.27 v8.1.0, 0.29 v7.5.0, 0.38 v7.4.0, 0.31 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.29 v6.4.0, 0.21 v6.3.0, 0.31 v6.2.0, 0.45 v6.1.0, 0.56 v6.0.0, 0.50 v5.5.0, 0.54 v5.4.0, 0.52 v5.3.0, 0.61 v5.2.0, 0.43 v5.0.0, 0.45 v4.1.0, 0.50 v4.0.1, 0.58 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10953 (   0 equ)
%            Maximal formula atoms :  246 (   1 avg)
%            Number of connectives :  764 (   0   ~;  18   |; 620   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  246 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-12 aty)
%            Number of functors    : 16666 (16666 usr;16665 con; 0-2 aty)
%            Number of variables   :  475 ( 405   !;  70   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_007_mira_news_1108,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6] :
      ( attr(X0,X1)
      & attr(X3,X2)
      & attr(X5,X6)
      & obj(X4,X0)
      & sub(X1,name_1_1)
      & sub(X0,firma_1_1)
      & sub(X2,name_1_1)
      & val(X1,bmw_0)
      & val(X2,bmw_0) ) ).

fof(ave07_era5_synth_qa07_007_mira_news_1108,hypothesis,
    ( subs(c57187,einigung_1_1)
    & attr(c57201,c57202)
    & sub(c57201,firma_1_1)
    & sub(c57202,name_1_1)
    & val(c57202,bmw_0)
    & attr(c57288,c57289)
    & attr(c57288,c59030)
    & sub(c57288,firma_1_1)
    & sub(c57289,name_1_1)
    & val(c57289,honda_0)
    & pred(c57295,rover_1_1)
    & preds(c57299,bem__374hen_3_1)
    & prop(c57299,langfristig_1_1)
    & sub(c57309,vorzeitigkeit_1_1)
    & attr(c58967,c58968)
    & sub(c58967,firma_1_1)
    & sub(c58968,name_1_1)
    & val(c58968,rover_0)
    & prop(c58970,britisch__1_1)
    & sub(c58970,firma_1_1)
    & prop(c58978,eigen_1_1)
    & sub(c58978,markenidentit__344t_1_1)
    & sub(c59030,name_1_1)
    & val(c59030,honda_0)
    & attr(c59035,c59036)
    & sub(c59035,stadt__1_1)
    & sub(c59036,name_1_1)
    & val(c59036,london_0)
    & tupl_p12(c59878,c57187,c57201,c57288,c57295,c57299,c57309,c58967,c58970,c58978,c57288,c59035)
    & assoc(markenidentit__344t_1_1,marken_0)
    & sub(markenidentit__344t_1_1,analogie__1_1)
    & sort(c57187,ad)
    & card(c57187,int1)
    & etype(c57187,int0)
    & fact(c57187,real)
    & gener(c57187,sp)
    & quant(c57187,one)
    & refer(c57187,det)
    & varia(c57187,con)
    & sort(einigung_1_1,ad)
    & card(einigung_1_1,int1)
    & etype(einigung_1_1,int0)
    & fact(einigung_1_1,real)
    & gener(einigung_1_1,ge)
    & quant(einigung_1_1,one)
    & refer(einigung_1_1,refer_c)
    & varia(einigung_1_1,varia_c)
    & sort(c57201,d)
    & sort(c57201,io)
    & card(c57201,int1)
    & etype(c57201,int0)
    & fact(c57201,real)
    & gener(c57201,sp)
    & quant(c57201,one)
    & refer(c57201,det)
    & varia(c57201,con)
    & sort(c57202,na)
    & card(c57202,int1)
    & etype(c57202,int0)
    & fact(c57202,real)
    & gener(c57202,sp)
    & quant(c57202,one)
    & refer(c57202,indet)
    & varia(c57202,varia_c)
    & sort(firma_1_1,d)
    & sort(firma_1_1,io)
    & card(firma_1_1,int1)
    & etype(firma_1_1,int0)
    & fact(firma_1_1,real)
    & gener(firma_1_1,ge)
    & quant(firma_1_1,one)
    & refer(firma_1_1,refer_c)
    & varia(firma_1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(bmw_0,fe)
    & sort(c57288,d)
    & sort(c57288,io)
    & card(c57288,int1)
    & etype(c57288,int0)
    & fact(c57288,real)
    & gener(c57288,sp)
    & quant(c57288,one)
    & refer(c57288,det)
    & varia(c57288,con)
    & sort(c57289,na)
    & card(c57289,int1)
    & etype(c57289,int0)
    & fact(c57289,real)
    & gener(c57289,sp)
    & quant(c57289,one)
    & refer(c57289,indet)
    & varia(c57289,varia_c)
    & sort(c59030,na)
    & card(c59030,int1)
    & etype(c59030,int0)
    & fact(c59030,real)
    & gener(c59030,sp)
    & quant(c59030,one)
    & refer(c59030,indet)
    & varia(c59030,varia_c)
    & sort(honda_0,fe)
    & sort(c57295,d)
    & card(c57295,cons(x_constant,cons(int1,nil)))
    & etype(c57295,int1)
    & fact(c57295,real)
    & gener(c57295,gener_c)
    & quant(c57295,mult)
    & refer(c57295,indet)
    & varia(c57295,varia_c)
    & sort(rover_1_1,d)
    & card(rover_1_1,int1)
    & etype(rover_1_1,int0)
    & fact(rover_1_1,real)
    & gener(rover_1_1,ge)
    & quant(rover_1_1,one)
    & refer(rover_1_1,refer_c)
    & varia(rover_1_1,varia_c)
    & sort(c57299,ad)
    & card(c57299,cons(x_constant,cons(int1,nil)))
    & etype(c57299,int1)
    & fact(c57299,real)
    & gener(c57299,gener_c)
    & quant(c57299,mult)
    & refer(c57299,refer_c)
    & varia(c57299,varia_c)
    & sort(bem__374hen_3_1,ad)
    & card(bem__374hen_3_1,int1)
    & etype(bem__374hen_3_1,int0)
    & fact(bem__374hen_3_1,real)
    & gener(bem__374hen_3_1,ge)
    & quant(bem__374hen_3_1,one)
    & refer(bem__374hen_3_1,refer_c)
    & varia(bem__374hen_3_1,varia_c)
    & sort(langfristig_1_1,tq)
    & sort(c57309,ta)
    & card(c57309,int1)
    & etype(c57309,int0)
    & fact(c57309,real)
    & gener(c57309,gener_c)
    & quant(c57309,one)
    & refer(c57309,refer_c)
    & varia(c57309,varia_c)
    & sort(vorzeitigkeit_1_1,ta)
    & card(vorzeitigkeit_1_1,int1)
    & etype(vorzeitigkeit_1_1,int0)
    & fact(vorzeitigkeit_1_1,real)
    & gener(vorzeitigkeit_1_1,ge)
    & quant(vorzeitigkeit_1_1,one)
    & refer(vorzeitigkeit_1_1,refer_c)
    & varia(vorzeitigkeit_1_1,varia_c)
    & sort(c58967,d)
    & sort(c58967,io)
    & card(c58967,int1)
    & etype(c58967,int0)
    & fact(c58967,real)
    & gener(c58967,sp)
    & quant(c58967,one)
    & refer(c58967,det)
    & varia(c58967,con)
    & sort(c58968,na)
    & card(c58968,int1)
    & etype(c58968,int0)
    & fact(c58968,real)
    & gener(c58968,sp)
    & quant(c58968,one)
    & refer(c58968,indet)
    & varia(c58968,varia_c)
    & sort(rover_0,fe)
    & sort(c58970,d)
    & sort(c58970,io)
    & card(c58970,int1)
    & etype(c58970,int0)
    & fact(c58970,real)
    & gener(c58970,gener_c)
    & quant(c58970,one)
    & refer(c58970,refer_c)
    & varia(c58970,varia_c)
    & sort(britisch__1_1,nq)
    & sort(c58978,io)
    & card(c58978,int1)
    & etype(c58978,int0)
    & fact(c58978,real)
    & gener(c58978,gener_c)
    & quant(c58978,one)
    & refer(c58978,refer_c)
    & varia(c58978,varia_c)
    & sort(eigen_1_1,nq)
    & sort(markenidentit__344t_1_1,io)
    & card(markenidentit__344t_1_1,int1)
    & etype(markenidentit__344t_1_1,int0)
    & fact(markenidentit__344t_1_1,real)
    & gener(markenidentit__344t_1_1,ge)
    & quant(markenidentit__344t_1_1,one)
    & refer(markenidentit__344t_1_1,refer_c)
    & varia(markenidentit__344t_1_1,varia_c)
    & sort(c59035,d)
    & sort(c59035,io)
    & card(c59035,int1)
    & etype(c59035,int0)
    & fact(c59035,real)
    & gener(c59035,sp)
    & quant(c59035,one)
    & refer(c59035,det)
    & varia(c59035,con)
    & sort(c59036,na)
    & card(c59036,int1)
    & etype(c59036,int0)
    & fact(c59036,real)
    & gener(c59036,sp)
    & quant(c59036,one)
    & refer(c59036,indet)
    & varia(c59036,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(london_0,fe)
    & sort(c59878,ent)
    & card(c59878,card_c)
    & etype(c59878,etype_c)
    & fact(c59878,real)
    & gener(c59878,gener_c)
    & quant(c59878,quant_c)
    & refer(c59878,refer_c)
    & varia(c59878,varia_c)
    & sort(marken_0,fe)
    & sort(analogie__1_1,io)
    & card(analogie__1_1,int1)
    & etype(analogie__1_1,int0)
    & fact(analogie__1_1,real)
    & gener(analogie__1_1,ge)
    & quant(analogie__1_1,one)
    & refer(analogie__1_1,refer_c)
    & varia(analogie__1_1,varia_c) ) ).

%------------------------------------------------------------------------------
