%------------------------------------------------------------------------------
% File     : CSR114+9 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : In which Italian city can you find the Colosseum?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_004_mira_news_552_a281_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.40 v9.0.0, 0.31 v8.2.0, 0.20 v8.1.0, 0.29 v7.5.0, 0.43 v7.4.0, 0.31 v7.3.0, 0.43 v7.2.0, 0.33 v7.1.0, 0.25 v7.0.0, 0.36 v6.4.0, 0.29 v6.3.0, 0.31 v6.2.0, 0.45 v6.1.0, 0.56 v6.0.0, 0.50 v5.5.0, 0.58 v5.4.0, 0.57 v5.3.0, 0.74 v5.2.0, 0.57 v5.0.0, 0.60 v4.1.0, 0.67 v4.0.1, 0.74 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10951 (   0 equ)
%            Maximal formula atoms :  247 (   1 avg)
%            Number of connectives :  762 (   0   ~;  18   |; 618   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  247 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   88 (  88 usr;   0 prp; 2-10 aty)
%            Number of functors    : 16665 (16665 usr;16664 con; 0-2 aty)
%            Number of variables   :  473 ( 405   !;  68   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_004_mira_news_552_a281,conjecture,
    ? [X0,X1,X2,X3,X4] :
      ( in(X2,X0)
      & attr(X0,X1)
      & loc(X4,X2)
      & scar(X4,X3)
      & sub(X1,name_1_1)
      & subs(X4,stehen_1_1) ) ).

fof(ave07_era5_synth_qa07_004_mira_news_552_a281,hypothesis,
    ( attr(c35597,c35598)
    & sub(c35597,mensch_1_1)
    & sub(c35598,eigenname_1_1)
    & val(c35598,rutelli_0)
    & pred(c35599,kathpress_1_1)
    & prop(c35605,althergebracht_1_1)
    & sub(c35605,papstaudienz_1_1)
    & sub(c35611,buergermeister_1_1)
    & sub(c35616,stadtrat_1_1)
    & attch(c35631,c35616)
    & prop(c35631,italienisch__1_1)
    & sub(c35631,hauptsstadt_1_1)
    & sub(c35676,kirchenf__374rst_1_1)
    & prop(c35683,unbeirrt_1_1)
    & sub(c35683,einsatz_1_1)
    & poss(c35688,c35683)
    & sub(c35694,friede_1_1)
    & name(c35704,edelste_aufgabe_roms_0)
    & tupl_p10(c35765,c35597,c35599,c35605,c35611,c35616,c35676,c35683,c35694,c35704)
    & sub(hauptsstadt_1_1,stadt__1_1)
    & assoc(papstaudienz_1_1,kirchenf__374rst_1_1)
    & sub(papstaudienz_1_1,audienz__1_1)
    & assoc(stadtrat_1_1,stadt__1_1)
    & sub(stadtrat_1_1,rat_2_1)
    & sort(c35597,d)
    & card(c35597,int1)
    & etype(c35597,int0)
    & fact(c35597,real)
    & gener(c35597,sp)
    & quant(c35597,one)
    & refer(c35597,det)
    & varia(c35597,con)
    & sort(c35598,na)
    & card(c35598,int1)
    & etype(c35598,int0)
    & fact(c35598,real)
    & gener(c35598,sp)
    & quant(c35598,one)
    & refer(c35598,indet)
    & varia(c35598,varia_c)
    & sort(mensch_1_1,d)
    & card(mensch_1_1,int1)
    & etype(mensch_1_1,int0)
    & fact(mensch_1_1,real)
    & gener(mensch_1_1,ge)
    & quant(mensch_1_1,one)
    & refer(mensch_1_1,refer_c)
    & varia(mensch_1_1,varia_c)
    & sort(eigenname_1_1,na)
    & card(eigenname_1_1,int1)
    & etype(eigenname_1_1,int0)
    & fact(eigenname_1_1,real)
    & gener(eigenname_1_1,ge)
    & quant(eigenname_1_1,one)
    & refer(eigenname_1_1,refer_c)
    & varia(eigenname_1_1,varia_c)
    & sort(rutelli_0,fe)
    & sort(c35599,o)
    & card(c35599,cons(x_constant,cons(int1,nil)))
    & etype(c35599,int1)
    & fact(c35599,real)
    & gener(c35599,gener_c)
    & quant(c35599,mult)
    & refer(c35599,indet)
    & varia(c35599,varia_c)
    & sort(kathpress_1_1,o)
    & card(kathpress_1_1,int1)
    & etype(kathpress_1_1,int0)
    & fact(kathpress_1_1,real)
    & gener(kathpress_1_1,ge)
    & quant(kathpress_1_1,one)
    & refer(kathpress_1_1,refer_c)
    & varia(kathpress_1_1,varia_c)
    & sort(c35605,o)
    & card(c35605,int1)
    & etype(c35605,int0)
    & fact(c35605,real)
    & gener(c35605,sp)
    & quant(c35605,one)
    & refer(c35605,det)
    & varia(c35605,con)
    & sort(althergebracht_1_1,nq)
    & sort(papstaudienz_1_1,o)
    & card(papstaudienz_1_1,int1)
    & etype(papstaudienz_1_1,int0)
    & fact(papstaudienz_1_1,real)
    & gener(papstaudienz_1_1,ge)
    & quant(papstaudienz_1_1,one)
    & refer(papstaudienz_1_1,refer_c)
    & varia(papstaudienz_1_1,varia_c)
    & sort(c35611,d)
    & card(c35611,int1)
    & etype(c35611,int0)
    & fact(c35611,real)
    & gener(c35611,sp)
    & quant(c35611,one)
    & refer(c35611,det)
    & varia(c35611,con)
    & sort(buergermeister_1_1,d)
    & card(buergermeister_1_1,int1)
    & etype(buergermeister_1_1,int0)
    & fact(buergermeister_1_1,real)
    & gener(buergermeister_1_1,ge)
    & quant(buergermeister_1_1,one)
    & refer(buergermeister_1_1,refer_c)
    & varia(buergermeister_1_1,varia_c)
    & sort(c35616,d)
    & sort(c35616,io)
    & card(c35616,int1)
    & etype(c35616,int1)
    & fact(c35616,real)
    & gener(c35616,sp)
    & quant(c35616,one)
    & refer(c35616,det)
    & varia(c35616,con)
    & sort(stadtrat_1_1,d)
    & sort(stadtrat_1_1,io)
    & card(stadtrat_1_1,card_c)
    & etype(stadtrat_1_1,int1)
    & fact(stadtrat_1_1,real)
    & gener(stadtrat_1_1,ge)
    & quant(stadtrat_1_1,quant_c)
    & refer(stadtrat_1_1,refer_c)
    & varia(stadtrat_1_1,varia_c)
    & sort(c35631,d)
    & sort(c35631,io)
    & card(c35631,int1)
    & etype(c35631,int0)
    & fact(c35631,real)
    & gener(c35631,sp)
    & quant(c35631,one)
    & refer(c35631,det)
    & varia(c35631,con)
    & sort(italienisch__1_1,nq)
    & sort(hauptsstadt_1_1,d)
    & sort(hauptsstadt_1_1,io)
    & card(hauptsstadt_1_1,int1)
    & etype(hauptsstadt_1_1,int0)
    & fact(hauptsstadt_1_1,real)
    & gener(hauptsstadt_1_1,ge)
    & quant(hauptsstadt_1_1,one)
    & refer(hauptsstadt_1_1,refer_c)
    & varia(hauptsstadt_1_1,varia_c)
    & sort(c35676,d)
    & card(c35676,int1)
    & etype(c35676,int0)
    & fact(c35676,real)
    & gener(c35676,sp)
    & quant(c35676,one)
    & refer(c35676,det)
    & varia(c35676,con)
    & sort(kirchenf__374rst_1_1,d)
    & card(kirchenf__374rst_1_1,int1)
    & etype(kirchenf__374rst_1_1,int0)
    & fact(kirchenf__374rst_1_1,real)
    & gener(kirchenf__374rst_1_1,ge)
    & quant(kirchenf__374rst_1_1,one)
    & refer(kirchenf__374rst_1_1,refer_c)
    & varia(kirchenf__374rst_1_1,varia_c)
    & sort(c35683,ad)
    & sort(c35683,io)
    & card(c35683,int1)
    & etype(c35683,int0)
    & fact(c35683,real)
    & gener(c35683,sp)
    & quant(c35683,one)
    & refer(c35683,det)
    & varia(c35683,varia_c)
    & sort(unbeirrt_1_1,nq)
    & sort(einsatz_1_1,ad)
    & sort(einsatz_1_1,io)
    & card(einsatz_1_1,int1)
    & etype(einsatz_1_1,int0)
    & fact(einsatz_1_1,real)
    & gener(einsatz_1_1,ge)
    & quant(einsatz_1_1,one)
    & refer(einsatz_1_1,refer_c)
    & varia(einsatz_1_1,varia_c)
    & sort(c35688,o)
    & card(c35688,int1)
    & etype(c35688,int0)
    & fact(c35688,real)
    & gener(c35688,sp)
    & quant(c35688,one)
    & refer(c35688,det)
    & varia(c35688,varia_c)
    & sort(c35694,as)
    & sort(c35694,io)
    & card(c35694,int1)
    & etype(c35694,int0)
    & fact(c35694,real)
    & gener(c35694,sp)
    & quant(c35694,one)
    & refer(c35694,det)
    & varia(c35694,con)
    & sort(friede_1_1,as)
    & sort(friede_1_1,io)
    & card(friede_1_1,int1)
    & etype(friede_1_1,int0)
    & fact(friede_1_1,real)
    & gener(friede_1_1,ge)
    & quant(friede_1_1,one)
    & refer(friede_1_1,refer_c)
    & varia(friede_1_1,varia_c)
    & sort(c35704,o)
    & card(c35704,int1)
    & etype(c35704,int0)
    & fact(c35704,real)
    & gener(c35704,gener_c)
    & quant(c35704,one)
    & refer(c35704,refer_c)
    & varia(c35704,varia_c)
    & sort(edelste_aufgabe_roms_0,fe)
    & sort(c35765,ent)
    & card(c35765,card_c)
    & etype(c35765,etype_c)
    & fact(c35765,real)
    & gener(c35765,gener_c)
    & quant(c35765,quant_c)
    & refer(c35765,refer_c)
    & varia(c35765,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(audienz__1_1,o)
    & card(audienz__1_1,int1)
    & etype(audienz__1_1,int0)
    & fact(audienz__1_1,real)
    & gener(audienz__1_1,ge)
    & quant(audienz__1_1,one)
    & refer(audienz__1_1,refer_c)
    & varia(audienz__1_1,varia_c)
    & sort(rat_2_1,d)
    & sort(rat_2_1,io)
    & card(rat_2_1,card_c)
    & etype(rat_2_1,int1)
    & fact(rat_2_1,real)
    & gener(rat_2_1,ge)
    & quant(rat_2_1,quant_c)
    & refer(rat_2_1,refer_c)
    & varia(rat_2_1,varia_c) ) ).

%------------------------------------------------------------------------------
