%------------------------------------------------------------------------------
% File     : CSR114+7 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : In which Italian city can you find the Colosseum?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_004_mira_news_547_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.40 v9.1.0, 0.33 v9.0.0, 0.25 v8.2.0, 0.20 v8.1.0, 0.21 v7.5.0, 0.38 v7.4.0, 0.25 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.36 v6.4.0, 0.29 v6.3.0, 0.31 v6.2.0, 0.45 v6.1.0, 0.60 v6.0.0, 0.50 v5.5.0, 0.58 v5.4.0, 0.57 v5.3.0, 0.70 v5.2.0, 0.57 v5.0.0, 0.55 v4.1.0, 0.67 v4.0.1, 0.63 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10987 (   0 equ)
%            Maximal formula atoms :  282 (   1 avg)
%            Number of connectives :  798 (   0   ~;  18   |; 654   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  282 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-11 aty)
%            Number of functors    : 16667 (16667 usr;16666 con; 0-2 aty)
%            Number of variables   :  473 ( 405   !;  68   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_004_mira_news_547,conjecture,
    ? [X0,X1,X2,X3,X4] :
      ( attr(X0,X1)
      & loc(X4,X2)
      & scar(X4,X3)
      & sub(X1,name_1_1)
      & sub(X0,stadt__1_1)
      & subs(X4,stehen_1_1)
      & val(X1,rom_0) ) ).

fof(ave07_era5_synth_qa07_004_mira_news_547,hypothesis,
    ( tupl_p11(c2641,c744,c774,c776,c781,c785,c790,c800,c807,c810,c822)
    & attr(c774,c775)
    & sub(c774,mensch_1_1)
    & sub(c775,familiename_1_1)
    & val(c775,goethe_0)
    & sub(c776,institut__1_1)
    & attr(c781,c782)
    & sub(c781,stadt__1_1)
    & sub(c782,name_1_1)
    & val(c782,rom_0)
    & sub(c785,kultur_1_1)
    & sub(c790,stadtrat_1_1)
    & attch(c795,c790)
    & prop(c795,italienisch__1_1)
    & sub(c795,hauptsstadt_1_1)
    & sub(c800,retrospektive_1_1)
    & subs(c807,fotoausstellung_1_1)
    & preds(c822,arbeit_1_1)
    & attch(c845,c822)
    & attr(c845,c846)
    & sub(c845,mensch_1_1)
    & sub(c846,familiename_1_1)
    & val(c846,wender_0)
    & assoc(fotoausstellung_1_1,aufnahme_1_1)
    & subs(fotoausstellung_1_1,aus_stellung_1_1)
    & sub(hauptsstadt_1_1,stadt__1_1)
    & assoc(stadtrat_1_1,stadt__1_1)
    & sub(stadtrat_1_1,rat_2_1)
    & sort(c2641,ent)
    & card(c2641,card_c)
    & etype(c2641,etype_c)
    & fact(c2641,real)
    & gener(c2641,gener_c)
    & quant(c2641,quant_c)
    & refer(c2641,refer_c)
    & varia(c2641,varia_c)
    & sort(c744,o)
    & card(c744,int1)
    & etype(c744,int0)
    & fact(c744,real)
    & gener(c744,sp)
    & quant(c744,one)
    & refer(c744,det)
    & varia(c744,varia_c)
    & sort(c774,d)
    & card(c774,int1)
    & etype(c774,int0)
    & fact(c774,real)
    & gener(c774,sp)
    & quant(c774,one)
    & refer(c774,det)
    & varia(c774,con)
    & sort(c776,d)
    & sort(c776,io)
    & card(c776,int1)
    & etype(c776,int0)
    & fact(c776,real)
    & gener(c776,gener_c)
    & quant(c776,one)
    & refer(c776,refer_c)
    & varia(c776,varia_c)
    & sort(c781,d)
    & sort(c781,io)
    & card(c781,int1)
    & etype(c781,int0)
    & fact(c781,real)
    & gener(c781,sp)
    & quant(c781,one)
    & refer(c781,det)
    & varia(c781,con)
    & sort(c785,io)
    & card(c785,int1)
    & etype(c785,int0)
    & fact(c785,real)
    & gener(c785,gener_c)
    & quant(c785,one)
    & refer(c785,refer_c)
    & varia(c785,varia_c)
    & sort(c790,d)
    & sort(c790,io)
    & card(c790,int1)
    & etype(c790,int1)
    & fact(c790,real)
    & gener(c790,sp)
    & quant(c790,one)
    & refer(c790,det)
    & varia(c790,varia_c)
    & sort(c800,o)
    & card(c800,int1)
    & etype(c800,int0)
    & fact(c800,real)
    & gener(c800,gener_c)
    & quant(c800,one)
    & refer(c800,refer_c)
    & varia(c800,varia_c)
    & sort(c807,ad)
    & card(c807,int1)
    & etype(c807,int0)
    & fact(c807,real)
    & gener(c807,sp)
    & quant(c807,one)
    & refer(c807,indet)
    & varia(c807,varia_c)
    & sort(c810,o)
    & card(c810,int1)
    & etype(c810,int0)
    & fact(c810,real)
    & gener(c810,sp)
    & quant(c810,one)
    & refer(c810,det)
    & varia(c810,varia_c)
    & sort(c822,ad)
    & card(c822,cons(x_constant,cons(int1,nil)))
    & etype(c822,int1)
    & fact(c822,real)
    & gener(c822,sp)
    & quant(c822,mult)
    & refer(c822,det)
    & varia(c822,con)
    & sort(c775,na)
    & card(c775,int1)
    & etype(c775,int0)
    & fact(c775,real)
    & gener(c775,sp)
    & quant(c775,one)
    & refer(c775,indet)
    & varia(c775,varia_c)
    & sort(mensch_1_1,d)
    & card(mensch_1_1,int1)
    & etype(mensch_1_1,int0)
    & fact(mensch_1_1,real)
    & gener(mensch_1_1,ge)
    & quant(mensch_1_1,one)
    & refer(mensch_1_1,refer_c)
    & varia(mensch_1_1,varia_c)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(goethe_0,fe)
    & sort(institut__1_1,d)
    & sort(institut__1_1,io)
    & card(institut__1_1,int1)
    & etype(institut__1_1,int0)
    & fact(institut__1_1,real)
    & gener(institut__1_1,ge)
    & quant(institut__1_1,one)
    & refer(institut__1_1,refer_c)
    & varia(institut__1_1,varia_c)
    & sort(c782,na)
    & card(c782,int1)
    & etype(c782,int0)
    & fact(c782,real)
    & gener(c782,sp)
    & quant(c782,one)
    & refer(c782,indet)
    & varia(c782,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(rom_0,fe)
    & sort(kultur_1_1,io)
    & card(kultur_1_1,int1)
    & etype(kultur_1_1,int0)
    & fact(kultur_1_1,real)
    & gener(kultur_1_1,ge)
    & quant(kultur_1_1,one)
    & refer(kultur_1_1,refer_c)
    & varia(kultur_1_1,varia_c)
    & sort(stadtrat_1_1,d)
    & sort(stadtrat_1_1,io)
    & card(stadtrat_1_1,card_c)
    & etype(stadtrat_1_1,int1)
    & fact(stadtrat_1_1,real)
    & gener(stadtrat_1_1,ge)
    & quant(stadtrat_1_1,quant_c)
    & refer(stadtrat_1_1,refer_c)
    & varia(stadtrat_1_1,varia_c)
    & sort(c795,d)
    & sort(c795,io)
    & card(c795,int1)
    & etype(c795,int0)
    & fact(c795,real)
    & gener(c795,sp)
    & quant(c795,one)
    & refer(c795,det)
    & varia(c795,con)
    & sort(italienisch__1_1,nq)
    & sort(hauptsstadt_1_1,d)
    & sort(hauptsstadt_1_1,io)
    & card(hauptsstadt_1_1,int1)
    & etype(hauptsstadt_1_1,int0)
    & fact(hauptsstadt_1_1,real)
    & gener(hauptsstadt_1_1,ge)
    & quant(hauptsstadt_1_1,one)
    & refer(hauptsstadt_1_1,refer_c)
    & varia(hauptsstadt_1_1,varia_c)
    & sort(retrospektive_1_1,o)
    & card(retrospektive_1_1,int1)
    & etype(retrospektive_1_1,int0)
    & fact(retrospektive_1_1,real)
    & gener(retrospektive_1_1,ge)
    & quant(retrospektive_1_1,one)
    & refer(retrospektive_1_1,refer_c)
    & varia(retrospektive_1_1,varia_c)
    & sort(fotoausstellung_1_1,ad)
    & card(fotoausstellung_1_1,int1)
    & etype(fotoausstellung_1_1,int0)
    & fact(fotoausstellung_1_1,real)
    & gener(fotoausstellung_1_1,ge)
    & quant(fotoausstellung_1_1,one)
    & refer(fotoausstellung_1_1,refer_c)
    & varia(fotoausstellung_1_1,varia_c)
    & sort(arbeit_1_1,ad)
    & card(arbeit_1_1,int1)
    & etype(arbeit_1_1,int0)
    & fact(arbeit_1_1,real)
    & gener(arbeit_1_1,ge)
    & quant(arbeit_1_1,one)
    & refer(arbeit_1_1,refer_c)
    & varia(arbeit_1_1,varia_c)
    & sort(c845,d)
    & card(c845,int1)
    & etype(c845,int0)
    & fact(c845,real)
    & gener(c845,sp)
    & quant(c845,one)
    & refer(c845,det)
    & varia(c845,con)
    & sort(c846,na)
    & card(c846,int1)
    & etype(c846,int0)
    & fact(c846,real)
    & gener(c846,sp)
    & quant(c846,one)
    & refer(c846,indet)
    & varia(c846,varia_c)
    & sort(wender_0,fe)
    & sort(aufnahme_1_1,d)
    & sort(aufnahme_1_1,io)
    & card(aufnahme_1_1,int1)
    & etype(aufnahme_1_1,int0)
    & fact(aufnahme_1_1,real)
    & gener(aufnahme_1_1,ge)
    & quant(aufnahme_1_1,one)
    & refer(aufnahme_1_1,refer_c)
    & varia(aufnahme_1_1,varia_c)
    & sort(aus_stellung_1_1,ad)
    & card(aus_stellung_1_1,int1)
    & etype(aus_stellung_1_1,int0)
    & fact(aus_stellung_1_1,real)
    & gener(aus_stellung_1_1,ge)
    & quant(aus_stellung_1_1,one)
    & refer(aus_stellung_1_1,refer_c)
    & varia(aus_stellung_1_1,varia_c)
    & sort(rat_2_1,d)
    & sort(rat_2_1,io)
    & card(rat_2_1,card_c)
    & etype(rat_2_1,int1)
    & fact(rat_2_1,real)
    & gener(rat_2_1,ge)
    & quant(rat_2_1,quant_c)
    & refer(rat_2_1,refer_c)
    & varia(rat_2_1,varia_c) ) ).

%------------------------------------------------------------------------------
