%------------------------------------------------------------------------------
% File     : CSR114+5 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : In which Italian city can you find the Colosseum?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_004_insicht_5_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.30 v9.1.0, 0.33 v9.0.0, 0.19 v8.2.0, 0.20 v8.1.0, 0.21 v7.5.0, 0.29 v7.4.0, 0.25 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.29 v6.4.0, 0.21 v6.3.0, 0.23 v6.2.0, 0.36 v6.1.0, 0.52 v6.0.0, 0.50 v5.4.0, 0.48 v5.3.0, 0.57 v5.2.0, 0.36 v5.0.0, 0.40 v4.1.0, 0.50 v4.0.1, 0.53 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10900 (   0 equ)
%            Maximal formula atoms :  193 (   1 avg)
%            Number of connectives :  711 (   0   ~;  18   |; 567   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  193 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   86 (  86 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16658 (16658 usr;16657 con; 0-2 aty)
%            Number of variables   :  473 ( 405   !;  68   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_004_insicht_5,conjecture,
    ? [X0,X1,X2,X3,X4] :
      ( in(X2,X0)
      & attr(X0,X1)
      & loc(X4,X2)
      & scar(X4,X3)
      & sub(X1,name_1_1)
      & sub(X0,stadt__1_1)
      & sub(X3,kolosseum_1_1)
      & subs(X4,stehen_1_1)
      & val(X1,rom_0) ) ).

fof(ave07_era5_synth_qa07_004_insicht_5,hypothesis,
    ( sub(c12,m__344rtyrer_1_1)
    & attr(c21,c26)
    & prop(c21,heilig_1_1)
    & sub(c26,jahr__1_1)
    & val(c26,c22)
    & loc(c30,c80)
    & prop(c30,n366kumenisch_1_1)
    & subs(c30,zeremonie_1_1)
    & attch(c34,c44)
    & loc(c34,c79)
    & sub(c34,kolosseum_1_1)
    & attr(c42,c43)
    & sub(c42,stadt__1_1)
    & sub(c43,name_1_1)
    & val(c43,rom_0)
    & sub(c44,vorsitz_1_1)
    & attch(c47,c44)
    & sub(c47,kirchenf__374rst_1_1)
    & ctxt(c57,c30)
    & mcont(c57,c12)
    & subs(c57,denken_2_2)
    & temp(c57,c21)
    & in(c79,c42)
    & in(c80,c34)
    & sort(c12,d)
    & card(c12,int1)
    & etype(c12,int0)
    & fact(c12,hypo)
    & gener(c12,sp)
    & quant(c12,one)
    & refer(c12,det)
    & varia(c12,con)
    & sort(m__344rtyrer_1_1,d)
    & card(m__344rtyrer_1_1,int1)
    & etype(m__344rtyrer_1_1,int0)
    & fact(m__344rtyrer_1_1,real)
    & gener(m__344rtyrer_1_1,ge)
    & quant(m__344rtyrer_1_1,one)
    & refer(m__344rtyrer_1_1,refer_c)
    & varia(m__344rtyrer_1_1,varia_c)
    & sort(c21,t)
    & card(c21,int1)
    & etype(c21,int0)
    & fact(c21,real)
    & gener(c21,sp)
    & quant(c21,one)
    & refer(c21,det)
    & varia(c21,con)
    & sort(c26,me)
    & sort(c26,oa)
    & sort(c26,ta)
    & card(c26,card_c)
    & etype(c26,etype_c)
    & fact(c26,real)
    & gener(c26,sp)
    & quant(c26,quant_c)
    & refer(c26,refer_c)
    & varia(c26,varia_c)
    & sort(heilig_1_1,nq)
    & sort(jahr__1_1,me)
    & sort(jahr__1_1,oa)
    & sort(jahr__1_1,ta)
    & card(jahr__1_1,card_c)
    & etype(jahr__1_1,etype_c)
    & fact(jahr__1_1,real)
    & gener(jahr__1_1,ge)
    & quant(jahr__1_1,quant_c)
    & refer(jahr__1_1,refer_c)
    & varia(jahr__1_1,varia_c)
    & sort(c22,nu)
    & card(c22,int2000)
    & sort(c30,ad)
    & card(c30,int1)
    & etype(c30,int0)
    & fact(c30,real)
    & gener(c30,sp)
    & quant(c30,one)
    & refer(c30,indet)
    & varia(c30,varia_c)
    & sort(c80,l)
    & card(c80,int1)
    & etype(c80,int0)
    & fact(c80,real)
    & gener(c80,sp)
    & quant(c80,one)
    & refer(c80,det)
    & varia(c80,con)
    & sort(n366kumenisch_1_1,tq)
    & sort(zeremonie_1_1,ad)
    & card(zeremonie_1_1,int1)
    & etype(zeremonie_1_1,int0)
    & fact(zeremonie_1_1,real)
    & gener(zeremonie_1_1,ge)
    & quant(zeremonie_1_1,one)
    & refer(zeremonie_1_1,refer_c)
    & varia(zeremonie_1_1,varia_c)
    & sort(c34,d)
    & card(c34,int1)
    & etype(c34,int0)
    & fact(c34,real)
    & gener(c34,sp)
    & quant(c34,one)
    & refer(c34,det)
    & varia(c34,con)
    & sort(c44,io)
    & card(c44,int1)
    & etype(c44,int0)
    & fact(c44,real)
    & gener(c44,sp)
    & quant(c44,one)
    & refer(c44,det)
    & varia(c44,varia_c)
    & sort(c79,l)
    & card(c79,int1)
    & etype(c79,int0)
    & fact(c79,real)
    & gener(c79,sp)
    & quant(c79,one)
    & refer(c79,det)
    & varia(c79,con)
    & sort(kolosseum_1_1,d)
    & card(kolosseum_1_1,int1)
    & etype(kolosseum_1_1,int0)
    & fact(kolosseum_1_1,real)
    & gener(kolosseum_1_1,sp)
    & quant(kolosseum_1_1,one)
    & refer(kolosseum_1_1,det)
    & varia(kolosseum_1_1,con)
    & sort(c42,d)
    & sort(c42,io)
    & card(c42,int1)
    & etype(c42,int0)
    & fact(c42,real)
    & gener(c42,sp)
    & quant(c42,one)
    & refer(c42,det)
    & varia(c42,con)
    & sort(c43,na)
    & card(c43,int1)
    & etype(c43,int0)
    & fact(c43,real)
    & gener(c43,sp)
    & quant(c43,one)
    & refer(c43,indet)
    & varia(c43,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(rom_0,fe)
    & sort(vorsitz_1_1,io)
    & card(vorsitz_1_1,int1)
    & etype(vorsitz_1_1,int0)
    & fact(vorsitz_1_1,real)
    & gener(vorsitz_1_1,ge)
    & quant(vorsitz_1_1,one)
    & refer(vorsitz_1_1,refer_c)
    & varia(vorsitz_1_1,varia_c)
    & sort(c47,d)
    & card(c47,int1)
    & etype(c47,int0)
    & fact(c47,real)
    & gener(c47,sp)
    & quant(c47,one)
    & refer(c47,det)
    & varia(c47,con)
    & sort(kirchenf__374rst_1_1,d)
    & card(kirchenf__374rst_1_1,int1)
    & etype(kirchenf__374rst_1_1,int0)
    & fact(kirchenf__374rst_1_1,real)
    & gener(kirchenf__374rst_1_1,ge)
    & quant(kirchenf__374rst_1_1,one)
    & refer(kirchenf__374rst_1_1,refer_c)
    & varia(kirchenf__374rst_1_1,varia_c)
    & sort(c57,st)
    & fact(c57,real)
    & gener(c57,sp)
    & sort(denken_2_2,st)
    & fact(denken_2_2,real)
    & gener(denken_2_2,ge) ) ).

%------------------------------------------------------------------------------
