%------------------------------------------------------------------------------
% File     : CSR114+30 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : In which Italian city can you find the Colosseum?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_004_qw2_104_a281_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.35 v9.1.0, 0.47 v9.0.0, 0.31 v8.2.0, 0.33 v8.1.0, 0.36 v7.5.0, 0.38 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.43 v6.4.0, 0.50 v6.3.0, 0.54 v6.2.0, 0.73 v6.1.0, 0.72 v6.0.0, 0.50 v5.5.0, 0.75 v5.4.0, 0.74 v5.3.0, 0.78 v5.2.0, 0.57 v5.0.0, 0.65 v4.1.0, 0.61 v4.0.1, 0.68 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10812 (   0 equ)
%            Maximal formula atoms :  109 (   1 avg)
%            Number of connectives :  623 (   0   ~;  18   |; 479   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  109 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   88 (  88 usr;   0 prp; 2-5 aty)
%            Number of functors    : 16651 (16651 usr;16650 con; 0-2 aty)
%            Number of variables   :  472 ( 405   !;  67   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_004_qw2_104_a281,conjecture,
    ? [X0,X1,X2,X3] :
      ( attr(X0,X1)
      & scar(X3,X2)
      & sub(X1,name_1_1)
      & sub(X0,stadt__1_1)
      & val(X1,rom_0) ) ).

fof(ave07_era5_synth_qa07_004_qw2_104_a281,hypothesis,
    ( assoc(bau_1_1,aufbau_1_1)
    & quant_p3(c32,c27,cent_1_1)
    & sub(c35,kolosseum_1_1)
    & attr(c41,c42)
    & sub(c41,stadt__1_1)
    & sub(c42,name_1_1)
    & val(c42,rom_0)
    & prop(c46,altert__374mlich_1_1)
    & prop(c46,ber__374hmt_1_1)
    & sub(c46,bau_1_1)
    & tupl_p5(c51,c32,c35,c41,c46)
    & sort(bau_1_1,d)
    & card(bau_1_1,int1)
    & etype(bau_1_1,int0)
    & fact(bau_1_1,real)
    & gener(bau_1_1,ge)
    & quant(bau_1_1,one)
    & refer(bau_1_1,refer_c)
    & varia(bau_1_1,varia_c)
    & sort(aufbau_1_1,ad)
    & card(aufbau_1_1,int1)
    & etype(aufbau_1_1,int0)
    & fact(aufbau_1_1,real)
    & gener(aufbau_1_1,ge)
    & quant(aufbau_1_1,one)
    & refer(aufbau_1_1,refer_c)
    & varia(aufbau_1_1,varia_c)
    & sort(c32,co)
    & sort(c32,m)
    & card(c32,card_c)
    & etype(c32,etype_c)
    & fact(c32,real)
    & gener(c32,gener_c)
    & quant(c32,quant_c)
    & refer(c32,refer_c)
    & varia(c32,con)
    & sort(c27,nu)
    & card(c27,int5)
    & sort(cent_1_1,me)
    & gener(cent_1_1,ge)
    & sort(c35,d)
    & card(c35,int1)
    & etype(c35,int0)
    & fact(c35,real)
    & gener(c35,sp)
    & quant(c35,one)
    & refer(c35,det)
    & varia(c35,con)
    & sort(kolosseum_1_1,d)
    & card(kolosseum_1_1,int1)
    & etype(kolosseum_1_1,int0)
    & fact(kolosseum_1_1,real)
    & gener(kolosseum_1_1,sp)
    & quant(kolosseum_1_1,one)
    & refer(kolosseum_1_1,det)
    & varia(kolosseum_1_1,con)
    & sort(c41,d)
    & sort(c41,io)
    & card(c41,int1)
    & etype(c41,int0)
    & fact(c41,real)
    & gener(c41,sp)
    & quant(c41,one)
    & refer(c41,det)
    & varia(c41,con)
    & sort(c42,na)
    & card(c42,int1)
    & etype(c42,int0)
    & fact(c42,real)
    & gener(c42,sp)
    & quant(c42,one)
    & refer(c42,indet)
    & varia(c42,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(rom_0,fe)
    & sort(c46,d)
    & card(c46,int1)
    & etype(c46,int0)
    & fact(c46,real)
    & gener(c46,sp)
    & quant(c46,one)
    & refer(c46,indet)
    & varia(c46,varia_c)
    & sort(altert__374mlich_1_1,nq)
    & sort(ber__374hmt_1_1,nq)
    & sort(c51,ent)
    & card(c51,card_c)
    & etype(c51,etype_c)
    & fact(c51,real)
    & gener(c51,gener_c)
    & quant(c51,quant_c)
    & refer(c51,refer_c)
    & varia(c51,varia_c) ) ).

%------------------------------------------------------------------------------
