%------------------------------------------------------------------------------
% File     : CSR114+28 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : In which Italian city can you find the Colosseum?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_004_qapw_93_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.35 v9.1.0, 0.47 v9.0.0, 0.31 v8.2.0, 0.33 v8.1.0, 0.36 v7.5.0, 0.38 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.50 v6.3.0, 0.54 v6.2.0, 0.73 v6.1.0, 0.72 v6.0.0, 0.50 v5.5.0, 0.75 v5.4.0, 0.74 v5.2.0, 0.57 v5.0.0, 0.65 v4.1.0, 0.61 v4.0.1, 0.68 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10837 (   0 equ)
%            Maximal formula atoms :  134 (   1 avg)
%            Number of connectives :  648 (   0   ~;  18   |; 504   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  134 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-6 aty)
%            Number of functors    : 16651 (16651 usr;16650 con; 0-2 aty)
%            Number of variables   :  472 ( 405   !;  67   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_004_qapw_93,conjecture,
    ? [X0,X1,X2,X3] :
      ( attr(X0,X1)
      & scar(X3,X2)
      & sub(X1,name_1_1)
      & sub(X0,stadt__1_1)
      & val(X1,rom_0) ) ).

fof(ave07_era5_synth_qa07_004_qapw_93,hypothesis,
    ( assoc(au__337enfassade_1_1,au__337en_1_1)
    & sub(au__337enfassade_1_1,fassade_1_1)
    & sub(c573,architektur_1_1)
    & sub(c582,au__337enfassade_1_1)
    & sub(c609,sich_1_1)
    & sub(c614,kolosseum_1_1)
    & attr(c620,c621)
    & sub(c620,stadt__1_1)
    & sub(c621,name_1_1)
    & val(c621,rom_0)
    & tupl_p6(c895,c573,c582,c609,c614,c620)
    & sort(au__337enfassade_1_1,d)
    & card(au__337enfassade_1_1,int1)
    & etype(au__337enfassade_1_1,int0)
    & fact(au__337enfassade_1_1,real)
    & gener(au__337enfassade_1_1,ge)
    & quant(au__337enfassade_1_1,one)
    & refer(au__337enfassade_1_1,refer_c)
    & varia(au__337enfassade_1_1,varia_c)
    & sort(au__337en_1_1,l)
    & card(au__337en_1_1,int1)
    & etype(au__337en_1_1,int0)
    & fact(au__337en_1_1,real)
    & gener(au__337en_1_1,gener_c)
    & quant(au__337en_1_1,one)
    & refer(au__337en_1_1,refer_c)
    & varia(au__337en_1_1,varia_c)
    & sort(fassade_1_1,d)
    & card(fassade_1_1,int1)
    & etype(fassade_1_1,int0)
    & fact(fassade_1_1,real)
    & gener(fassade_1_1,ge)
    & quant(fassade_1_1,one)
    & refer(fassade_1_1,refer_c)
    & varia(fassade_1_1,varia_c)
    & sort(c573,io)
    & card(c573,int1)
    & etype(c573,int0)
    & fact(c573,real)
    & gener(c573,sp)
    & quant(c573,one)
    & refer(c573,det)
    & varia(c573,con)
    & sort(architektur_1_1,io)
    & card(architektur_1_1,int1)
    & etype(architektur_1_1,int0)
    & fact(architektur_1_1,real)
    & gener(architektur_1_1,ge)
    & quant(architektur_1_1,one)
    & refer(architektur_1_1,refer_c)
    & varia(architektur_1_1,varia_c)
    & sort(c582,d)
    & card(c582,int1)
    & etype(c582,int0)
    & fact(c582,real)
    & gener(c582,sp)
    & quant(c582,one)
    & refer(c582,det)
    & varia(c582,con)
    & sort(c609,o)
    & card(c609,int1)
    & etype(c609,int0)
    & fact(c609,real)
    & gener(c609,gener_c)
    & quant(c609,one)
    & refer(c609,refer_c)
    & varia(c609,varia_c)
    & sort(sich_1_1,o)
    & card(sich_1_1,int1)
    & etype(sich_1_1,int0)
    & fact(sich_1_1,real)
    & gener(sich_1_1,gener_c)
    & quant(sich_1_1,one)
    & refer(sich_1_1,refer_c)
    & varia(sich_1_1,varia_c)
    & sort(c614,d)
    & card(c614,int1)
    & etype(c614,int0)
    & fact(c614,real)
    & gener(c614,sp)
    & quant(c614,one)
    & refer(c614,det)
    & varia(c614,con)
    & sort(kolosseum_1_1,d)
    & card(kolosseum_1_1,int1)
    & etype(kolosseum_1_1,int0)
    & fact(kolosseum_1_1,real)
    & gener(kolosseum_1_1,sp)
    & quant(kolosseum_1_1,one)
    & refer(kolosseum_1_1,det)
    & varia(kolosseum_1_1,con)
    & sort(c620,d)
    & sort(c620,io)
    & card(c620,int1)
    & etype(c620,int0)
    & fact(c620,real)
    & gener(c620,sp)
    & quant(c620,one)
    & refer(c620,det)
    & varia(c620,con)
    & sort(c621,na)
    & card(c621,int1)
    & etype(c621,int0)
    & fact(c621,real)
    & gener(c621,sp)
    & quant(c621,one)
    & refer(c621,indet)
    & varia(c621,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(rom_0,fe)
    & sort(c895,ent)
    & card(c895,card_c)
    & etype(c895,etype_c)
    & fact(c895,real)
    & gener(c895,gener_c)
    & quant(c895,quant_c)
    & refer(c895,refer_c)
    & varia(c895,varia_c) ) ).

%------------------------------------------------------------------------------
