%------------------------------------------------------------------------------
% File     : CSR114+26 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : In which Italian city can you find the Colosseum?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_004_qapw_82_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.30 v9.1.0, 0.33 v9.0.0, 0.19 v8.2.0, 0.20 v8.1.0, 0.21 v7.5.0, 0.29 v7.4.0, 0.25 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.29 v6.4.0, 0.21 v6.3.0, 0.23 v6.2.0, 0.36 v6.1.0, 0.56 v6.0.0, 0.50 v5.5.0, 0.54 v5.4.0, 0.52 v5.3.0, 0.61 v5.2.0, 0.36 v5.0.0, 0.45 v4.1.0, 0.56 v4.0.1, 0.47 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10938 (   0 equ)
%            Maximal formula atoms :  231 (   1 avg)
%            Number of connectives :  749 (   0   ~;  18   |; 605   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  231 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   88 (  88 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16668 (16668 usr;16667 con; 0-2 aty)
%            Number of variables   :  473 ( 405   !;  68   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_004_qapw_82,conjecture,
    ? [X0,X1,X2,X3,X4] :
      ( in(X2,X0)
      & attr(X0,X1)
      & loc(X4,X2)
      & scar(X4,X3)
      & sub(X1,name_1_1)
      & sub(X0,stadt__1_1)
      & sub(X3,kolosseum_1_1)
      & subs(X4,stehen_1_1)
      & val(X1,rom_0) ) ).

fof(ave07_era5_synth_qa07_004_qapw_82,hypothesis,
    ( pred(c10,amphi_theater_1_1)
    & pred(c32,kampfspiel_1_2)
    & prop(c4,gro__337_1_1)
    & sub(c4,bedeutung_1_1)
    & assoc(c5,c82)
    & ctxt(c5,c76)
    & modl(c5,weitaus_1_1)
    & obj(c5,c4)
    & scar(c5,c10)
    & subs(c5,haben_1_1)
    & pred(c66,tierhatz_1_1)
    & exp(c67,c74)
    & loc(c67,c73)
    & subs(c67,eintreffen_1_2)
    & in(c73,c10)
    & itms(c74,c32,c66)
    & prop(c76,c80)
    & sub(c76,beispiel_1_1)
    & supl(c80,bekannt_1_1,c81)
    & loc(c82,c91)
    & sub(c82,kolosseum_1_1)
    & attr(c88,c89)
    & sub(c88,stadt__1_1)
    & sub(c89,name_1_1)
    & val(c89,rom_0)
    & in(c91,c88)
    & assoc(kampfspiel_1_2,gefecht_1_1)
    & subs(kampfspiel_1_2,spiel_1_2)
    & sort(c10,abs)
    & sort(c10,co)
    & sort(c10,io)
    & sort(c10,mo)
    & sort(c10,ta)
    & sort(c10,re)
    & card(c10,card_c)
    & etype(c10,etype_c)
    & fact(c10,real)
    & gener(c10,sp)
    & quant(c10,quant_c)
    & refer(c10,det)
    & varia(c10,con)
    & sort(amphi_theater_1_1,o)
    & card(amphi_theater_1_1,int1)
    & etype(amphi_theater_1_1,int0)
    & fact(amphi_theater_1_1,real)
    & gener(amphi_theater_1_1,ge)
    & quant(amphi_theater_1_1,one)
    & refer(amphi_theater_1_1,refer_c)
    & varia(amphi_theater_1_1,varia_c)
    & sort(c32,ab)
    & card(c32,cons(x_constant,cons(int1,nil)))
    & etype(c32,int1)
    & fact(c32,real)
    & gener(c32,sp)
    & quant(c32,mult)
    & refer(c32,indet)
    & varia(c32,varia_c)
    & sort(kampfspiel_1_2,ad)
    & card(kampfspiel_1_2,int1)
    & etype(kampfspiel_1_2,int0)
    & fact(kampfspiel_1_2,real)
    & gener(kampfspiel_1_2,ge)
    & quant(kampfspiel_1_2,one)
    & refer(kampfspiel_1_2,refer_c)
    & varia(kampfspiel_1_2,varia_c)
    & sort(c4,io)
    & card(c4,int1)
    & etype(c4,int0)
    & fact(c4,real)
    & gener(c4,sp)
    & quant(c4,one)
    & refer(c4,refer_c)
    & varia(c4,varia_c)
    & sort(gro__337_1_1,mq)
    & sort(bedeutung_1_1,io)
    & card(bedeutung_1_1,int1)
    & etype(bedeutung_1_1,int0)
    & fact(bedeutung_1_1,real)
    & gener(bedeutung_1_1,ge)
    & quant(bedeutung_1_1,one)
    & refer(bedeutung_1_1,refer_c)
    & varia(bedeutung_1_1,varia_c)
    & sort(c5,st)
    & fact(c5,real)
    & gener(c5,sp)
    & sort(c82,d)
    & card(c82,int1)
    & etype(c82,int0)
    & fact(c82,real)
    & gener(c82,sp)
    & quant(c82,one)
    & refer(c82,det)
    & varia(c82,con)
    & sort(c76,io)
    & card(c76,int1)
    & etype(c76,int0)
    & fact(c76,real)
    & gener(c76,gener_c)
    & quant(c76,one)
    & refer(c76,refer_c)
    & varia(c76,varia_c)
    & sort(weitaus_1_1,md)
    & fact(weitaus_1_1,real)
    & gener(weitaus_1_1,gener_c)
    & sort(haben_1_1,st)
    & fact(haben_1_1,real)
    & gener(haben_1_1,ge)
    & sort(c66,o)
    & card(c66,cons(x_constant,cons(int1,nil)))
    & etype(c66,int1)
    & fact(c66,real)
    & gener(c66,sp)
    & quant(c66,mult)
    & refer(c66,indet)
    & varia(c66,varia_c)
    & sort(tierhatz_1_1,o)
    & card(tierhatz_1_1,int1)
    & etype(tierhatz_1_1,int0)
    & fact(tierhatz_1_1,real)
    & gener(tierhatz_1_1,ge)
    & quant(tierhatz_1_1,one)
    & refer(tierhatz_1_1,refer_c)
    & varia(tierhatz_1_1,varia_c)
    & sort(c67,dn)
    & fact(c67,real)
    & gener(c67,sp)
    & sort(c74,o)
    & card(c74,int2)
    & etype(c74,int2)
    & fact(c74,real)
    & gener(c74,sp)
    & quant(c74,nfquant)
    & refer(c74,indet)
    & varia(c74,varia_c)
    & sort(c73,l)
    & card(c73,cons(x_constant,cons(int1,nil)))
    & etype(c73,int1)
    & fact(c73,real)
    & gener(c73,sp)
    & quant(c73,mult)
    & refer(c73,det)
    & varia(c73,con)
    & sort(eintreffen_1_2,dn)
    & fact(eintreffen_1_2,real)
    & gener(eintreffen_1_2,ge)
    & sort(c80,tq)
    & sort(beispiel_1_1,io)
    & card(beispiel_1_1,int1)
    & etype(beispiel_1_1,int0)
    & fact(beispiel_1_1,real)
    & gener(beispiel_1_1,ge)
    & quant(beispiel_1_1,one)
    & refer(beispiel_1_1,refer_c)
    & varia(beispiel_1_1,varia_c)
    & sort(bekannt_1_1,nq)
    & sort(c81,o)
    & card(c81,card_c)
    & etype(c81,int1)
    & etype(c81,int2)
    & fact(c81,real)
    & gener(c81,gener_c)
    & quant(c81,quant_c)
    & refer(c81,refer_c)
    & varia(c81,varia_c)
    & sort(c91,l)
    & card(c91,int1)
    & etype(c91,int0)
    & fact(c91,real)
    & gener(c91,sp)
    & quant(c91,one)
    & refer(c91,det)
    & varia(c91,con)
    & sort(kolosseum_1_1,d)
    & card(kolosseum_1_1,int1)
    & etype(kolosseum_1_1,int0)
    & fact(kolosseum_1_1,real)
    & gener(kolosseum_1_1,sp)
    & quant(kolosseum_1_1,one)
    & refer(kolosseum_1_1,det)
    & varia(kolosseum_1_1,con)
    & sort(c88,d)
    & sort(c88,io)
    & card(c88,int1)
    & etype(c88,int0)
    & fact(c88,real)
    & gener(c88,sp)
    & quant(c88,one)
    & refer(c88,det)
    & varia(c88,con)
    & sort(c89,na)
    & card(c89,int1)
    & etype(c89,int0)
    & fact(c89,real)
    & gener(c89,sp)
    & quant(c89,one)
    & refer(c89,indet)
    & varia(c89,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(rom_0,fe)
    & sort(gefecht_1_1,ad)
    & card(gefecht_1_1,int1)
    & etype(gefecht_1_1,int0)
    & fact(gefecht_1_1,real)
    & gener(gefecht_1_1,ge)
    & quant(gefecht_1_1,one)
    & refer(gefecht_1_1,refer_c)
    & varia(gefecht_1_1,varia_c)
    & sort(spiel_1_2,ad)
    & card(spiel_1_2,int1)
    & etype(spiel_1_2,int0)
    & fact(spiel_1_2,real)
    & gener(spiel_1_2,ge)
    & quant(spiel_1_2,one)
    & refer(spiel_1_2,refer_c)
    & varia(spiel_1_2,varia_c) ) ).

%------------------------------------------------------------------------------
