%------------------------------------------------------------------------------
% File     : CSR114+25 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : In which Italian city can you find the Colosseum?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_004_qapw_81_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.30 v9.1.0, 0.33 v9.0.0, 0.19 v8.2.0, 0.20 v8.1.0, 0.21 v7.5.0, 0.29 v7.4.0, 0.25 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.29 v6.4.0, 0.21 v6.3.0, 0.23 v6.2.0, 0.36 v6.1.0, 0.52 v6.0.0, 0.75 v5.5.0, 0.50 v5.4.0, 0.48 v5.3.0, 0.57 v5.2.0, 0.36 v5.0.0, 0.40 v4.1.0, 0.50 v4.0.1, 0.47 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10922 (   0 equ)
%            Maximal formula atoms :  215 (   1 avg)
%            Number of connectives :  733 (   0   ~;  18   |; 589   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  215 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   89 (  89 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16666 (16666 usr;16665 con; 0-2 aty)
%            Number of variables   :  473 ( 405   !;  68   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_004_qapw_81,conjecture,
    ? [X0,X1,X2,X3,X4] :
      ( in(X2,X0)
      & attr(X0,X1)
      & loc(X4,X2)
      & scar(X4,X3)
      & sub(X1,name_1_1)
      & sub(X0,stadt__1_1)
      & sub(X3,kolosseum_1_1)
      & subs(X4,stehen_1_1)
      & val(X1,rom_0) ) ).

fof(ave07_era5_synth_qa07_004_qapw_81,hypothesis,
    ( chsp2(auskl__374geln_1_1,c0)
    & pred(c11,er_fahrung_1_1)
    & loc(c13125,c13134)
    & sub(c13125,kolosseum_1_1)
    & attr(c13131,c13132)
    & sub(c13131,stadt__1_1)
    & sub(c13132,name_1_1)
    & val(c13132,rom_0)
    & in(c13134,c13131)
    & pred(c20,bau_1_1)
    & assoc(c21,c20)
    & obj(c21,c11)
    & reas(c21,c24)
    & scar(c21,c4)
    & subs(c21,haben_1_1)
    & agt(c24,c9825)
    & benf(c24,c13125)
    & circ(c24,c9847)
    & mannr(c24,wie_1_1)
    & modl(c24,nicht_1_1)
    & obj(c24,c9837)
    & subs(c24,geben_1_4)
    & sub(c4,man_1_1)
    & prop(c9837,c0)
    & sub(c9837,technik__1_1)
    & preds(c9847,anlage_1_1)
    & prop(c9847,spaet_1_1)
    & attch(c9853,c9847)
    & subs(c9853,art_1_1)
    & sort(auskl__374geln_1_1,dn)
    & fact(auskl__374geln_1_1,real)
    & gener(auskl__374geln_1_1,ge)
    & sort(c0,tq)
    & sort(c11,as)
    & sort(c11,io)
    & card(c11,cons(x_constant,cons(int1,nil)))
    & etype(c11,int1)
    & fact(c11,nonreal)
    & gener(c11,sp)
    & quant(c11,mult)
    & refer(c11,indet)
    & varia(c11,varia_c)
    & sort(er_fahrung_1_1,as)
    & sort(er_fahrung_1_1,io)
    & card(er_fahrung_1_1,int1)
    & etype(er_fahrung_1_1,int0)
    & fact(er_fahrung_1_1,real)
    & gener(er_fahrung_1_1,ge)
    & quant(er_fahrung_1_1,one)
    & refer(er_fahrung_1_1,refer_c)
    & varia(er_fahrung_1_1,varia_c)
    & sort(c13125,d)
    & card(c13125,int1)
    & etype(c13125,int0)
    & fact(c13125,real)
    & gener(c13125,sp)
    & quant(c13125,one)
    & refer(c13125,det)
    & varia(c13125,con)
    & sort(c13134,l)
    & card(c13134,int1)
    & etype(c13134,int0)
    & fact(c13134,real)
    & gener(c13134,sp)
    & quant(c13134,one)
    & refer(c13134,det)
    & varia(c13134,con)
    & sort(kolosseum_1_1,d)
    & card(kolosseum_1_1,int1)
    & etype(kolosseum_1_1,int0)
    & fact(kolosseum_1_1,real)
    & gener(kolosseum_1_1,sp)
    & quant(kolosseum_1_1,one)
    & refer(kolosseum_1_1,det)
    & varia(kolosseum_1_1,con)
    & sort(c13131,d)
    & sort(c13131,io)
    & card(c13131,int1)
    & etype(c13131,int0)
    & fact(c13131,real)
    & gener(c13131,sp)
    & quant(c13131,one)
    & refer(c13131,det)
    & varia(c13131,con)
    & sort(c13132,na)
    & card(c13132,int1)
    & etype(c13132,int0)
    & fact(c13132,real)
    & gener(c13132,sp)
    & quant(c13132,one)
    & refer(c13132,indet)
    & varia(c13132,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(rom_0,fe)
    & sort(c20,d)
    & card(c20,cons(x_constant,cons(int1,nil)))
    & etype(c20,int1)
    & fact(c20,real)
    & gener(c20,sp)
    & quant(c20,mult)
    & refer(c20,det)
    & varia(c20,varia_c)
    & sort(bau_1_1,d)
    & card(bau_1_1,int1)
    & etype(bau_1_1,int0)
    & fact(bau_1_1,real)
    & gener(bau_1_1,ge)
    & quant(bau_1_1,one)
    & refer(bau_1_1,refer_c)
    & varia(bau_1_1,varia_c)
    & sort(c21,st)
    & fact(c21,real)
    & gener(c21,sp)
    & sort(c24,da)
    & fact(c24,real)
    & gener(c24,sp)
    & sort(c4,d)
    & card(c4,int1)
    & etype(c4,int0)
    & fact(c4,real)
    & gener(c4,ge)
    & quant(c4,one)
    & refer(c4,refer_c)
    & varia(c4,varia_c)
    & sort(haben_1_1,st)
    & fact(haben_1_1,real)
    & gener(haben_1_1,ge)
    & sort(c9825,o)
    & card(c9825,int1)
    & etype(c9825,int0)
    & fact(c9825,real)
    & gener(c9825,sp)
    & quant(c9825,one)
    & refer(c9825,det)
    & varia(c9825,varia_c)
    & sort(c9847,as)
    & card(c9847,cons(x_constant,cons(int1,nil)))
    & etype(c9847,int1)
    & fact(c9847,real)
    & gener(c9847,sp)
    & quant(c9847,mult)
    & refer(c9847,det)
    & varia(c9847,varia_c)
    & sort(wie_1_1,mq)
    & sort(nicht_1_1,md)
    & fact(nicht_1_1,real)
    & gener(nicht_1_1,gener_c)
    & sort(c9837,io)
    & card(c9837,int1)
    & etype(c9837,int0)
    & fact(c9837,real)
    & gener(c9837,sp)
    & quant(c9837,one)
    & refer(c9837,det)
    & varia(c9837,con)
    & sort(geben_1_4,da)
    & fact(geben_1_4,real)
    & gener(geben_1_4,ge)
    & sort(man_1_1,d)
    & card(man_1_1,int1)
    & etype(man_1_1,int0)
    & fact(man_1_1,real)
    & gener(man_1_1,ge)
    & quant(man_1_1,one)
    & refer(man_1_1,refer_c)
    & varia(man_1_1,varia_c)
    & sort(technik__1_1,io)
    & card(technik__1_1,int1)
    & etype(technik__1_1,int0)
    & fact(technik__1_1,real)
    & gener(technik__1_1,ge)
    & quant(technik__1_1,one)
    & refer(technik__1_1,refer_c)
    & varia(technik__1_1,varia_c)
    & sort(anlage_1_1,as)
    & card(anlage_1_1,int1)
    & etype(anlage_1_1,int0)
    & fact(anlage_1_1,real)
    & gener(anlage_1_1,ge)
    & quant(anlage_1_1,one)
    & refer(anlage_1_1,refer_c)
    & varia(anlage_1_1,varia_c)
    & sort(spaet_1_1,mq)
    & sort(c9853,ad)
    & card(c9853,int1)
    & etype(c9853,int1)
    & fact(c9853,real)
    & gener(c9853,sp)
    & quant(c9853,one)
    & refer(c9853,det)
    & varia(c9853,varia_c)
    & sort(art_1_1,ad)
    & card(art_1_1,card_c)
    & etype(art_1_1,int1)
    & fact(art_1_1,real)
    & gener(art_1_1,ge)
    & quant(art_1_1,quant_c)
    & refer(art_1_1,refer_c)
    & varia(art_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
