%------------------------------------------------------------------------------
% File     : CSR114+24 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : In which Italian city can you find the Colosseum?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_004_qapw_68_a281_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.40 v9.1.0, 0.47 v9.0.0, 0.31 v8.2.0, 0.33 v8.1.0, 0.36 v7.5.0, 0.43 v7.4.0, 0.44 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.43 v6.4.0, 0.50 v6.3.0, 0.54 v6.2.0, 0.73 v6.1.0, 0.76 v6.0.0, 0.50 v5.5.0, 0.75 v5.4.0, 0.74 v5.3.0, 0.78 v5.2.0, 0.57 v5.0.0, 0.65 v4.1.0, 0.61 v4.0.1, 0.68 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10979 (   0 equ)
%            Maximal formula atoms :  276 (   1 avg)
%            Number of connectives :  790 (   0   ~;  18   |; 646   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  276 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   88 (  88 usr;   0 prp; 2-13 aty)
%            Number of functors    : 16672 (16672 usr;16671 con; 0-2 aty)
%            Number of variables   :  472 ( 405   !;  67   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_004_qapw_68_a281,conjecture,
    ? [X0,X1,X2,X3] :
      ( attr(X0,X1)
      & scar(X3,X2)
      & sub(X1,name_1_1)
      & sub(X0,stadt__1_1)
      & val(X1,rom_0) ) ).

fof(ave07_era5_synth_qa07_004_qapw_68_a281,hypothesis,
    ( pred(c49899,sportort_1_1)
    & prop(c49899,c49902)
    & supl(c49902,bekannt_1_1,c49903)
    & attch(c49905,c49899)
    & prop(c49905,r__366misch__1_1)
    & sub(c49905,reich_1_1)
    & sub(c49915,circus_1_1)
    & sub(c49918,maximus_1_1)
    & attr(c49925,c49926)
    & sub(c49925,stadt__1_1)
    & sub(c49926,name_1_1)
    & val(c49926,rom_0)
    & pred(c49930,wagenrennen_1_1)
    & preds(c49933,gladiatorenkampf_1_1)
    & sub(c49948,kolosseum_1_1)
    & attr(c49954,c49955)
    & sub(c49954,stadt__1_1)
    & sub(c49955,name_1_1)
    & val(c49955,rom_0)
    & pred(c49974,gladiator_1_1)
    & sub(c49977,einander_1_1)
    & tupl_p13(c50158,c49899,c49902,c49915,c49918,c49925,c49930,c49933,c49948,c49954,c49957,c49974,c49977)
    & assoc(gladiatorenkampf_1_1,gladiator_1_1)
    & subs(gladiatorenkampf_1_1,gefecht_1_1)
    & assoc(sportort_1_1,sport__1_1)
    & sub(sportort_1_1,staette_1_1)
    & sort(c49899,d)
    & card(c49899,cons(x_constant,cons(int1,nil)))
    & etype(c49899,int1)
    & fact(c49899,real)
    & gener(c49899,sp)
    & quant(c49899,mult)
    & refer(c49899,det)
    & varia(c49899,con)
    & sort(sportort_1_1,d)
    & card(sportort_1_1,int1)
    & etype(sportort_1_1,int0)
    & fact(sportort_1_1,real)
    & gener(sportort_1_1,ge)
    & quant(sportort_1_1,one)
    & refer(sportort_1_1,refer_c)
    & varia(sportort_1_1,varia_c)
    & sort(c49902,tq)
    & sort(bekannt_1_1,nq)
    & sort(c49903,o)
    & card(c49903,card_c)
    & etype(c49903,int1)
    & etype(c49903,int2)
    & fact(c49903,real)
    & gener(c49903,gener_c)
    & quant(c49903,quant_c)
    & refer(c49903,refer_c)
    & varia(c49903,varia_c)
    & sort(c49905,d)
    & sort(c49905,io)
    & card(c49905,int1)
    & etype(c49905,int0)
    & fact(c49905,real)
    & gener(c49905,sp)
    & quant(c49905,one)
    & refer(c49905,det)
    & varia(c49905,con)
    & sort(r__366misch__1_1,tq)
    & sort(reich_1_1,d)
    & sort(reich_1_1,io)
    & card(reich_1_1,int1)
    & etype(reich_1_1,int0)
    & fact(reich_1_1,real)
    & gener(reich_1_1,ge)
    & quant(reich_1_1,one)
    & refer(reich_1_1,refer_c)
    & varia(reich_1_1,varia_c)
    & sort(c49915,o)
    & card(c49915,int1)
    & etype(c49915,int0)
    & fact(c49915,real)
    & gener(c49915,sp)
    & quant(c49915,one)
    & refer(c49915,det)
    & varia(c49915,con)
    & sort(circus_1_1,o)
    & card(circus_1_1,int1)
    & etype(circus_1_1,int0)
    & fact(circus_1_1,real)
    & gener(circus_1_1,ge)
    & quant(circus_1_1,one)
    & refer(circus_1_1,refer_c)
    & varia(circus_1_1,varia_c)
    & sort(c49918,o)
    & card(c49918,int1)
    & etype(c49918,int0)
    & fact(c49918,real)
    & gener(c49918,gener_c)
    & quant(c49918,one)
    & refer(c49918,refer_c)
    & varia(c49918,varia_c)
    & sort(maximus_1_1,o)
    & card(maximus_1_1,int1)
    & etype(maximus_1_1,int0)
    & fact(maximus_1_1,real)
    & gener(maximus_1_1,ge)
    & quant(maximus_1_1,one)
    & refer(maximus_1_1,refer_c)
    & varia(maximus_1_1,varia_c)
    & sort(c49925,d)
    & sort(c49925,io)
    & card(c49925,int1)
    & etype(c49925,int0)
    & fact(c49925,real)
    & gener(c49925,sp)
    & quant(c49925,one)
    & refer(c49925,det)
    & varia(c49925,con)
    & sort(c49926,na)
    & card(c49926,int1)
    & etype(c49926,int0)
    & fact(c49926,real)
    & gener(c49926,sp)
    & quant(c49926,one)
    & refer(c49926,indet)
    & varia(c49926,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(rom_0,fe)
    & sort(c49930,o)
    & card(c49930,cons(x_constant,cons(int1,nil)))
    & etype(c49930,int1)
    & fact(c49930,real)
    & gener(c49930,gener_c)
    & quant(c49930,mult)
    & refer(c49930,indet)
    & varia(c49930,varia_c)
    & sort(wagenrennen_1_1,o)
    & card(wagenrennen_1_1,int1)
    & etype(wagenrennen_1_1,int0)
    & fact(wagenrennen_1_1,real)
    & gener(wagenrennen_1_1,ge)
    & quant(wagenrennen_1_1,one)
    & refer(wagenrennen_1_1,refer_c)
    & varia(wagenrennen_1_1,varia_c)
    & sort(c49933,ad)
    & card(c49933,cons(x_constant,cons(int1,nil)))
    & etype(c49933,int1)
    & fact(c49933,real)
    & gener(c49933,gener_c)
    & quant(c49933,mult)
    & refer(c49933,indet)
    & varia(c49933,varia_c)
    & sort(gladiatorenkampf_1_1,ad)
    & card(gladiatorenkampf_1_1,int1)
    & etype(gladiatorenkampf_1_1,int0)
    & fact(gladiatorenkampf_1_1,real)
    & gener(gladiatorenkampf_1_1,ge)
    & quant(gladiatorenkampf_1_1,one)
    & refer(gladiatorenkampf_1_1,refer_c)
    & varia(gladiatorenkampf_1_1,varia_c)
    & sort(c49948,d)
    & card(c49948,int1)
    & etype(c49948,int0)
    & fact(c49948,real)
    & gener(c49948,sp)
    & quant(c49948,one)
    & refer(c49948,det)
    & varia(c49948,con)
    & sort(kolosseum_1_1,d)
    & card(kolosseum_1_1,int1)
    & etype(kolosseum_1_1,int0)
    & fact(kolosseum_1_1,real)
    & gener(kolosseum_1_1,sp)
    & quant(kolosseum_1_1,one)
    & refer(kolosseum_1_1,det)
    & varia(kolosseum_1_1,con)
    & sort(c49954,d)
    & sort(c49954,io)
    & card(c49954,int1)
    & etype(c49954,int0)
    & fact(c49954,real)
    & gener(c49954,sp)
    & quant(c49954,one)
    & refer(c49954,det)
    & varia(c49954,con)
    & sort(c49955,na)
    & card(c49955,int1)
    & etype(c49955,int0)
    & fact(c49955,real)
    & gener(c49955,sp)
    & quant(c49955,one)
    & refer(c49955,indet)
    & varia(c49955,varia_c)
    & sort(c49974,d)
    & card(c49974,cons(x_constant,cons(int1,nil)))
    & etype(c49974,int1)
    & fact(c49974,real)
    & gener(c49974,gener_c)
    & quant(c49974,mult)
    & refer(c49974,indet)
    & varia(c49974,varia_c)
    & sort(gladiator_1_1,d)
    & card(gladiator_1_1,int1)
    & etype(gladiator_1_1,int0)
    & fact(gladiator_1_1,real)
    & gener(gladiator_1_1,ge)
    & quant(gladiator_1_1,one)
    & refer(gladiator_1_1,refer_c)
    & varia(gladiator_1_1,varia_c)
    & sort(c49977,o)
    & card(c49977,cons(x_constant,cons(int1,nil)))
    & etype(c49977,int1)
    & fact(c49977,real)
    & gener(c49977,gener_c)
    & quant(c49977,mult)
    & refer(c49977,refer_c)
    & varia(c49977,varia_c)
    & sort(einander_1_1,o)
    & card(einander_1_1,cons(x_constant,cons(int1,nil)))
    & etype(einander_1_1,int1)
    & fact(einander_1_1,real)
    & gener(einander_1_1,gener_c)
    & quant(einander_1_1,mult)
    & refer(einander_1_1,refer_c)
    & varia(einander_1_1,varia_c)
    & sort(c50158,ent)
    & card(c50158,card_c)
    & etype(c50158,etype_c)
    & fact(c50158,real)
    & gener(c50158,gener_c)
    & quant(c50158,quant_c)
    & refer(c50158,refer_c)
    & varia(c50158,varia_c)
    & sort(c49957,o)
    & card(c49957,int1)
    & etype(c49957,int0)
    & fact(c49957,real)
    & gener(c49957,sp)
    & quant(c49957,one)
    & refer(c49957,det)
    & varia(c49957,varia_c)
    & sort(gefecht_1_1,ad)
    & card(gefecht_1_1,int1)
    & etype(gefecht_1_1,int0)
    & fact(gefecht_1_1,real)
    & gener(gefecht_1_1,ge)
    & quant(gefecht_1_1,one)
    & refer(gefecht_1_1,refer_c)
    & varia(gefecht_1_1,varia_c)
    & sort(sport__1_1,ad)
    & card(sport__1_1,int1)
    & etype(sport__1_1,int0)
    & fact(sport__1_1,real)
    & gener(sport__1_1,ge)
    & quant(sport__1_1,one)
    & refer(sport__1_1,refer_c)
    & varia(sport__1_1,varia_c)
    & sort(staette_1_1,d)
    & card(staette_1_1,int1)
    & etype(staette_1_1,int0)
    & fact(staette_1_1,real)
    & gener(staette_1_1,ge)
    & quant(staette_1_1,one)
    & refer(staette_1_1,refer_c)
    & varia(staette_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
