%------------------------------------------------------------------------------
% File     : CSR114+23 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : In which Italian city can you find the Colosseum?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_004_qapw_67_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.35 v9.1.0, 0.33 v9.0.0, 0.19 v8.2.0, 0.20 v8.1.0, 0.21 v7.5.0, 0.29 v7.4.0, 0.25 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.29 v6.4.0, 0.21 v6.3.0, 0.23 v6.2.0, 0.36 v6.1.0, 0.52 v6.0.0, 0.50 v5.4.0, 0.48 v5.3.0, 0.57 v5.2.0, 0.36 v5.0.0, 0.40 v4.1.0, 0.50 v4.0.1, 0.53 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 11075 (   0 equ)
%            Maximal formula atoms :  368 (   1 avg)
%            Number of connectives :  886 (   0   ~;  18   |; 742   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  368 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16680 (16680 usr;16679 con; 0-2 aty)
%            Number of variables   :  473 ( 405   !;  68   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_004_qapw_67,conjecture,
    ? [X0,X1,X2,X3,X4] :
      ( in(X2,X0)
      & attr(X0,X1)
      & loc(X4,X2)
      & scar(X4,X3)
      & sub(X1,name_1_1)
      & sub(X0,stadt__1_1)
      & sub(X3,kolosseum_1_1)
      & subs(X4,stehen_1_1)
      & val(X1,rom_0) ) ).

fof(ave07_era5_synth_qa07_004_qapw_67,hypothesis,
    ( agt(c11,c209)
    & ctxt(c11,c4)
    & loc(c11,c208)
    & subs(c11,spielen_1_2)
    & temp(c11,c178)
    & attr(c167,c168)
    & attr(c167,c169)
    & sub(c167,mensch_1_1)
    & sub(c168,eigenname_1_1)
    & val(c168,bryan_0)
    & sub(c169,familiename_1_1)
    & val(c169,adams_0)
    & attr(c178,c179)
    & attr(c178,c180)
    & attr(c178,c181)
    & sub(c179,tag_1_1)
    & val(c179,c175)
    & sub(c180,monat_1_1)
    & val(c180,c176)
    & sub(c181,jahr__1_1)
    & val(c181,c177)
    & loc(c185,c207)
    & pred(c185,zuschauer__1_1)
    & loc(c190,c206)
    & sub(c190,gratiskonzert_1_1)
    & loc(c196,c205)
    & sub(c196,kolosseum_1_1)
    & attr(c202,c203)
    & sub(c202,stadt__1_1)
    & sub(c203,name_1_1)
    & val(c203,rom_0)
    & in(c205,c202)
    & vor(c206,c196)
    & bei(c207,c190)
    & vor(c208,c185)
    & itms(c209,c13,c167)
    & agt(c210,c185)
    & subs(c210,zugucken_1_1)
    & subs(c4,abschlu__337_1_1)
    & attch(c8,c4)
    & subs(c8,europatour_1_1)
    & assoc(europatour_1_1,europa_0)
    & subs(europatour_1_1,tour_1_1)
    & assoc(gratiskonzert_1_1,gratis_1_1)
    & sub(gratiskonzert_1_1,konzert__1_1)
    & sort(c11,da)
    & fact(c11,real)
    & gener(c11,sp)
    & sort(c209,o)
    & card(c209,int2)
    & etype(c209,int1)
    & fact(c209,real)
    & gener(c209,sp)
    & quant(c209,nfquant)
    & refer(c209,det)
    & varia(c209,varia_c)
    & sort(c4,ad)
    & card(c4,int1)
    & etype(c4,int0)
    & fact(c4,real)
    & gener(c4,sp)
    & quant(c4,one)
    & refer(c4,det)
    & varia(c4,varia_c)
    & sort(c208,l)
    & card(c208,int500000)
    & etype(c208,int1)
    & fact(c208,real)
    & gener(c208,sp)
    & quant(c208,nfquant)
    & refer(c208,refer_c)
    & varia(c208,varia_c)
    & sort(spielen_1_2,da)
    & fact(spielen_1_2,real)
    & gener(spielen_1_2,ge)
    & sort(c178,t)
    & card(c178,int1)
    & etype(c178,int0)
    & fact(c178,real)
    & gener(c178,sp)
    & quant(c178,one)
    & refer(c178,det)
    & varia(c178,con)
    & sort(c167,d)
    & card(c167,int1)
    & etype(c167,int0)
    & fact(c167,real)
    & gener(c167,sp)
    & quant(c167,one)
    & refer(c167,det)
    & varia(c167,con)
    & sort(c168,na)
    & card(c168,int1)
    & etype(c168,int0)
    & fact(c168,real)
    & gener(c168,sp)
    & quant(c168,one)
    & refer(c168,indet)
    & varia(c168,varia_c)
    & sort(c169,na)
    & card(c169,int1)
    & etype(c169,int0)
    & fact(c169,real)
    & gener(c169,sp)
    & quant(c169,one)
    & refer(c169,indet)
    & varia(c169,varia_c)
    & sort(mensch_1_1,d)
    & card(mensch_1_1,int1)
    & etype(mensch_1_1,int0)
    & fact(mensch_1_1,real)
    & gener(mensch_1_1,ge)
    & quant(mensch_1_1,one)
    & refer(mensch_1_1,refer_c)
    & varia(mensch_1_1,varia_c)
    & sort(eigenname_1_1,na)
    & card(eigenname_1_1,int1)
    & etype(eigenname_1_1,int0)
    & fact(eigenname_1_1,real)
    & gener(eigenname_1_1,ge)
    & quant(eigenname_1_1,one)
    & refer(eigenname_1_1,refer_c)
    & varia(eigenname_1_1,varia_c)
    & sort(bryan_0,fe)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(adams_0,fe)
    & sort(c179,me)
    & sort(c179,oa)
    & sort(c179,ta)
    & card(c179,card_c)
    & etype(c179,etype_c)
    & fact(c179,real)
    & gener(c179,sp)
    & quant(c179,quant_c)
    & refer(c179,det)
    & varia(c179,varia_c)
    & sort(c180,me)
    & sort(c180,oa)
    & sort(c180,ta)
    & card(c180,card_c)
    & etype(c180,etype_c)
    & fact(c180,real)
    & gener(c180,sp)
    & quant(c180,quant_c)
    & refer(c180,det)
    & varia(c180,varia_c)
    & sort(c181,me)
    & sort(c181,oa)
    & sort(c181,ta)
    & card(c181,card_c)
    & etype(c181,etype_c)
    & fact(c181,real)
    & gener(c181,sp)
    & quant(c181,quant_c)
    & refer(c181,refer_c)
    & varia(c181,varia_c)
    & sort(tag_1_1,me)
    & sort(tag_1_1,oa)
    & sort(tag_1_1,ta)
    & card(tag_1_1,card_c)
    & etype(tag_1_1,etype_c)
    & fact(tag_1_1,real)
    & gener(tag_1_1,ge)
    & quant(tag_1_1,quant_c)
    & refer(tag_1_1,refer_c)
    & varia(tag_1_1,varia_c)
    & sort(c175,nu)
    & card(c175,int31)
    & sort(monat_1_1,me)
    & sort(monat_1_1,oa)
    & sort(monat_1_1,ta)
    & card(monat_1_1,card_c)
    & etype(monat_1_1,etype_c)
    & fact(monat_1_1,real)
    & gener(monat_1_1,ge)
    & quant(monat_1_1,quant_c)
    & refer(monat_1_1,refer_c)
    & varia(monat_1_1,varia_c)
    & sort(c176,nu)
    & card(c176,int7)
    & sort(jahr__1_1,me)
    & sort(jahr__1_1,oa)
    & sort(jahr__1_1,ta)
    & card(jahr__1_1,card_c)
    & etype(jahr__1_1,etype_c)
    & fact(jahr__1_1,real)
    & gener(jahr__1_1,ge)
    & quant(jahr__1_1,quant_c)
    & refer(jahr__1_1,refer_c)
    & varia(jahr__1_1,varia_c)
    & sort(c177,nu)
    & card(c177,int2006)
    & sort(c185,d)
    & card(c185,int500000)
    & etype(c185,int1)
    & fact(c185,real)
    & gener(c185,sp)
    & quant(c185,nfquant)
    & refer(c185,indet)
    & varia(c185,varia_c)
    & sort(c207,l)
    & card(c207,int1)
    & etype(c207,int0)
    & fact(c207,real)
    & gener(c207,sp)
    & quant(c207,one)
    & refer(c207,indet)
    & varia(c207,varia_c)
    & sort(zuschauer__1_1,d)
    & card(zuschauer__1_1,int1)
    & etype(zuschauer__1_1,int0)
    & fact(zuschauer__1_1,real)
    & gener(zuschauer__1_1,ge)
    & quant(zuschauer__1_1,one)
    & refer(zuschauer__1_1,refer_c)
    & varia(zuschauer__1_1,varia_c)
    & sort(c190,ad)
    & sort(c190,d)
    & sort(c190,io)
    & card(c190,int1)
    & etype(c190,int0)
    & fact(c190,real)
    & gener(c190,sp)
    & quant(c190,one)
    & refer(c190,indet)
    & varia(c190,varia_c)
    & sort(c206,l)
    & card(c206,int1)
    & etype(c206,int0)
    & fact(c206,real)
    & gener(c206,sp)
    & quant(c206,one)
    & refer(c206,det)
    & varia(c206,con)
    & sort(gratiskonzert_1_1,ad)
    & sort(gratiskonzert_1_1,d)
    & sort(gratiskonzert_1_1,io)
    & card(gratiskonzert_1_1,int1)
    & etype(gratiskonzert_1_1,int0)
    & fact(gratiskonzert_1_1,real)
    & gener(gratiskonzert_1_1,ge)
    & quant(gratiskonzert_1_1,one)
    & refer(gratiskonzert_1_1,refer_c)
    & varia(gratiskonzert_1_1,varia_c)
    & sort(c196,d)
    & card(c196,int1)
    & etype(c196,int0)
    & fact(c196,real)
    & gener(c196,sp)
    & quant(c196,one)
    & refer(c196,det)
    & varia(c196,con)
    & sort(c205,l)
    & card(c205,int1)
    & etype(c205,int0)
    & fact(c205,real)
    & gener(c205,sp)
    & quant(c205,one)
    & refer(c205,det)
    & varia(c205,con)
    & sort(kolosseum_1_1,d)
    & card(kolosseum_1_1,int1)
    & etype(kolosseum_1_1,int0)
    & fact(kolosseum_1_1,real)
    & gener(kolosseum_1_1,sp)
    & quant(kolosseum_1_1,one)
    & refer(kolosseum_1_1,det)
    & varia(kolosseum_1_1,con)
    & sort(c202,d)
    & sort(c202,io)
    & card(c202,int1)
    & etype(c202,int0)
    & fact(c202,real)
    & gener(c202,sp)
    & quant(c202,one)
    & refer(c202,det)
    & varia(c202,con)
    & sort(c203,na)
    & card(c203,int1)
    & etype(c203,int0)
    & fact(c203,real)
    & gener(c203,sp)
    & quant(c203,one)
    & refer(c203,indet)
    & varia(c203,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(rom_0,fe)
    & sort(c13,o)
    & card(c13,int1)
    & etype(c13,int0)
    & fact(c13,real)
    & gener(c13,sp)
    & quant(c13,one)
    & refer(c13,det)
    & varia(c13,varia_c)
    & sort(c210,da)
    & fact(c210,real)
    & gener(c210,sp)
    & sort(zugucken_1_1,da)
    & fact(zugucken_1_1,real)
    & gener(zugucken_1_1,ge)
    & sort(abschlu__337_1_1,ad)
    & card(abschlu__337_1_1,int1)
    & etype(abschlu__337_1_1,int0)
    & fact(abschlu__337_1_1,real)
    & gener(abschlu__337_1_1,ge)
    & quant(abschlu__337_1_1,one)
    & refer(abschlu__337_1_1,refer_c)
    & varia(abschlu__337_1_1,varia_c)
    & sort(c8,ad)
    & card(c8,int1)
    & etype(c8,int0)
    & fact(c8,real)
    & gener(c8,sp)
    & quant(c8,one)
    & refer(c8,det)
    & varia(c8,con)
    & sort(europatour_1_1,ad)
    & card(europatour_1_1,int1)
    & etype(europatour_1_1,int0)
    & fact(europatour_1_1,real)
    & gener(europatour_1_1,ge)
    & quant(europatour_1_1,one)
    & refer(europatour_1_1,refer_c)
    & varia(europatour_1_1,varia_c)
    & sort(europa_0,fe)
    & sort(tour_1_1,ad)
    & card(tour_1_1,int1)
    & etype(tour_1_1,int0)
    & fact(tour_1_1,real)
    & gener(tour_1_1,ge)
    & quant(tour_1_1,one)
    & refer(tour_1_1,refer_c)
    & varia(tour_1_1,varia_c)
    & sort(gratis_1_1,gq)
    & sort(konzert__1_1,ad)
    & sort(konzert__1_1,d)
    & sort(konzert__1_1,io)
    & card(konzert__1_1,int1)
    & etype(konzert__1_1,int0)
    & fact(konzert__1_1,real)
    & gener(konzert__1_1,ge)
    & quant(konzert__1_1,one)
    & refer(konzert__1_1,refer_c)
    & varia(konzert__1_1,varia_c) ) ).

%------------------------------------------------------------------------------
