%------------------------------------------------------------------------------
% File     : CSR114+22 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : In which Italian city can you find the Colosseum?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_004_qapw_61_a281_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.35 v9.1.0, 0.33 v9.0.0, 0.25 v8.2.0, 0.20 v8.1.0, 0.21 v7.5.0, 0.33 v7.4.0, 0.25 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.36 v6.4.0, 0.29 v6.3.0, 0.31 v6.2.0, 0.45 v6.1.0, 0.60 v6.0.0, 0.50 v5.4.0, 0.48 v5.3.0, 0.61 v5.2.0, 0.57 v5.0.0, 0.45 v4.1.0, 0.56 v4.0.1, 0.53 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10890 (   0 equ)
%            Maximal formula atoms :  185 (   1 avg)
%            Number of connectives :  701 (   0   ~;  18   |; 557   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  185 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   88 (  88 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16655 (16655 usr;16654 con; 0-2 aty)
%            Number of variables   :  473 ( 405   !;  68   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_004_qapw_61_a281,conjecture,
    ? [X0,X1,X2,X3,X4] :
      ( attr(X0,X1)
      & loc(X4,X2)
      & scar(X4,X3)
      & sub(X1,name_1_1)
      & sub(X0,stadt__1_1)
      & subs(X4,stehen_1_1)
      & val(X1,rom_0) ) ).

fof(ave07_era5_synth_qa07_004_qapw_61_a281,hypothesis,
    ( attr(c102,c103)
    & sub(c102,stadt__1_1)
    & sub(c103,name_1_1)
    & val(c103,rom_0)
    & sub(c108,abschlu__337_1_1)
    & attch(c4,c108)
    & pars(c4,c97)
    & preds(c4,unabh__344ngigkeitkrieg_1_1)
    & prop(c4,italienisch__1_1)
    & arg1(c5,c4)
    & arg2(c5,c97)
    & subs(c5,enden_1_3)
    & temp(c5,c90)
    & attr(c90,c91)
    & attr(c90,c92)
    & sub(c91,monat_1_1)
    & val(c91,c89)
    & sub(c92,jahr__1_1)
    & val(c92,c88)
    & equ(c97,c108)
    & obj(c97,c102)
    & subs(c97,eroberung_1_1)
    & assoc(unabh__344ngigkeitkrieg_1_1,autonomie__1_1)
    & subs(unabh__344ngigkeitkrieg_1_1,krieg__1_1)
    & sort(c102,d)
    & sort(c102,io)
    & card(c102,int1)
    & etype(c102,int0)
    & fact(c102,real)
    & gener(c102,sp)
    & quant(c102,one)
    & refer(c102,det)
    & varia(c102,con)
    & sort(c103,na)
    & card(c103,int1)
    & etype(c103,int0)
    & fact(c103,real)
    & gener(c103,sp)
    & quant(c103,one)
    & refer(c103,indet)
    & varia(c103,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(rom_0,fe)
    & sort(c108,ad)
    & sort(c108,io)
    & card(c108,int1)
    & etype(c108,int0)
    & fact(c108,real)
    & gener(c108,sp)
    & quant(c108,one)
    & refer(c108,det)
    & varia(c108,varia_c)
    & sort(abschlu__337_1_1,ad)
    & sort(abschlu__337_1_1,io)
    & card(abschlu__337_1_1,int1)
    & etype(abschlu__337_1_1,int0)
    & fact(abschlu__337_1_1,real)
    & gener(abschlu__337_1_1,ge)
    & quant(abschlu__337_1_1,one)
    & refer(abschlu__337_1_1,refer_c)
    & varia(abschlu__337_1_1,varia_c)
    & sort(c4,ad)
    & card(c4,cons(x_constant,cons(int1,nil)))
    & etype(c4,int1)
    & fact(c4,real)
    & gener(c4,sp)
    & quant(c4,mult)
    & refer(c4,det)
    & varia(c4,con)
    & sort(c97,ad)
    & card(c97,int1)
    & etype(c97,int0)
    & fact(c97,real)
    & gener(c97,sp)
    & quant(c97,one)
    & refer(c97,det)
    & varia(c97,con)
    & sort(unabh__344ngigkeitkrieg_1_1,ad)
    & card(unabh__344ngigkeitkrieg_1_1,int1)
    & etype(unabh__344ngigkeitkrieg_1_1,int0)
    & fact(unabh__344ngigkeitkrieg_1_1,real)
    & gener(unabh__344ngigkeitkrieg_1_1,ge)
    & quant(unabh__344ngigkeitkrieg_1_1,one)
    & refer(unabh__344ngigkeitkrieg_1_1,refer_c)
    & varia(unabh__344ngigkeitkrieg_1_1,varia_c)
    & sort(italienisch__1_1,nq)
    & sort(c5,st)
    & fact(c5,real)
    & gener(c5,sp)
    & sort(enden_1_3,st)
    & fact(enden_1_3,real)
    & gener(enden_1_3,ge)
    & sort(c90,t)
    & card(c90,int1)
    & etype(c90,int0)
    & fact(c90,real)
    & gener(c90,sp)
    & quant(c90,one)
    & refer(c90,det)
    & varia(c90,con)
    & sort(c91,me)
    & sort(c91,oa)
    & sort(c91,ta)
    & card(c91,card_c)
    & etype(c91,etype_c)
    & fact(c91,real)
    & gener(c91,sp)
    & quant(c91,quant_c)
    & refer(c91,det)
    & varia(c91,varia_c)
    & sort(c92,me)
    & sort(c92,oa)
    & sort(c92,ta)
    & card(c92,card_c)
    & etype(c92,etype_c)
    & fact(c92,real)
    & gener(c92,sp)
    & quant(c92,quant_c)
    & refer(c92,refer_c)
    & varia(c92,varia_c)
    & sort(monat_1_1,me)
    & sort(monat_1_1,oa)
    & sort(monat_1_1,ta)
    & card(monat_1_1,card_c)
    & etype(monat_1_1,etype_c)
    & fact(monat_1_1,real)
    & gener(monat_1_1,ge)
    & quant(monat_1_1,quant_c)
    & refer(monat_1_1,refer_c)
    & varia(monat_1_1,varia_c)
    & sort(c89,nu)
    & card(c89,int9)
    & sort(jahr__1_1,me)
    & sort(jahr__1_1,oa)
    & sort(jahr__1_1,ta)
    & card(jahr__1_1,card_c)
    & etype(jahr__1_1,etype_c)
    & fact(jahr__1_1,real)
    & gener(jahr__1_1,ge)
    & quant(jahr__1_1,quant_c)
    & refer(jahr__1_1,refer_c)
    & varia(jahr__1_1,varia_c)
    & sort(c88,nu)
    & card(c88,int1870)
    & sort(eroberung_1_1,ad)
    & card(eroberung_1_1,int1)
    & etype(eroberung_1_1,int0)
    & fact(eroberung_1_1,real)
    & gener(eroberung_1_1,ge)
    & quant(eroberung_1_1,one)
    & refer(eroberung_1_1,refer_c)
    & varia(eroberung_1_1,varia_c)
    & sort(autonomie__1_1,as)
    & sort(autonomie__1_1,io)
    & card(autonomie__1_1,int1)
    & etype(autonomie__1_1,int0)
    & fact(autonomie__1_1,real)
    & gener(autonomie__1_1,ge)
    & quant(autonomie__1_1,one)
    & refer(autonomie__1_1,refer_c)
    & varia(autonomie__1_1,varia_c)
    & sort(krieg__1_1,ad)
    & card(krieg__1_1,int1)
    & etype(krieg__1_1,int0)
    & fact(krieg__1_1,real)
    & gener(krieg__1_1,ge)
    & quant(krieg__1_1,one)
    & refer(krieg__1_1,refer_c)
    & varia(krieg__1_1,varia_c) ) ).

%------------------------------------------------------------------------------
