%------------------------------------------------------------------------------
% File     : CSR114+20 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : In which Italian city can you find the Colosseum?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_004_qapn_67_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.30 v9.1.0, 0.33 v9.0.0, 0.19 v8.2.0, 0.20 v8.1.0, 0.21 v7.5.0, 0.29 v7.4.0, 0.25 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.29 v6.4.0, 0.21 v6.3.0, 0.23 v6.2.0, 0.36 v6.1.0, 0.52 v6.0.0, 0.50 v5.4.0, 0.48 v5.3.0, 0.57 v5.2.0, 0.36 v5.0.0, 0.40 v4.1.0, 0.50 v4.0.1, 0.47 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10900 (   0 equ)
%            Maximal formula atoms :  193 (   1 avg)
%            Number of connectives :  711 (   0   ~;  18   |; 567   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  193 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16658 (16658 usr;16657 con; 0-2 aty)
%            Number of variables   :  473 ( 405   !;  68   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_004_qapn_67,conjecture,
    ? [X0,X1,X2,X3,X4] :
      ( in(X2,X0)
      & attr(X0,X1)
      & loc(X4,X2)
      & scar(X4,X3)
      & sub(X1,name_1_1)
      & sub(X0,stadt__1_1)
      & sub(X3,kolosseum_1_1)
      & subs(X4,stehen_1_1)
      & val(X1,rom_0) ) ).

fof(ave07_era5_synth_qa07_004_qapn_67,hypothesis,
    ( attch(c11,c4)
    & sub(c11,republik__1_1)
    & agt(c15,c378)
    & cstr(c15,c388)
    & obj(c15,c4)
    & subs(c15,verlangen_2_1)
    & attr(c378,c379)
    & sub(c378,mensch_1_1)
    & sub(c379,familiename_1_1)
    & val(c379,niebuhr_0)
    & prop(c388,gro__337_1_1)
    & sub(c4,palais_1_1)
    & loc(c486,c505)
    & sub(c486,kolosseum_1_1)
    & attr(c494,c495)
    & sub(c494,stadt__1_1)
    & sub(c495,name_1_1)
    & val(c495,rom_0)
    & prop(c497,c0)
    & sub(c497,klotz__1_1)
    & benf(c501,c486)
    & obj(c501,c497)
    & semrel(c501,c15)
    & subs(c501,ersetzen_1_1)
    & in(c505,c494)
    & chsp2(nachempfinden_1_1,c0)
    & sort(c11,d)
    & sort(c11,io)
    & card(c11,int1)
    & etype(c11,int0)
    & fact(c11,real)
    & gener(c11,sp)
    & quant(c11,one)
    & refer(c11,det)
    & varia(c11,con)
    & sort(c4,d)
    & card(c4,int1)
    & etype(c4,int0)
    & fact(c4,real)
    & gener(c4,sp)
    & quant(c4,one)
    & refer(c4,det)
    & varia(c4,con)
    & sort(republik__1_1,d)
    & sort(republik__1_1,io)
    & card(republik__1_1,int1)
    & etype(republik__1_1,int0)
    & fact(republik__1_1,real)
    & gener(republik__1_1,ge)
    & quant(republik__1_1,one)
    & refer(republik__1_1,refer_c)
    & varia(republik__1_1,varia_c)
    & sort(c15,da)
    & fact(c15,real)
    & gener(c15,sp)
    & sort(c378,d)
    & card(c378,int1)
    & etype(c378,int0)
    & fact(c378,real)
    & gener(c378,sp)
    & quant(c378,one)
    & refer(c378,det)
    & varia(c378,con)
    & sort(c388,o)
    & card(c388,int1)
    & etype(c388,int0)
    & fact(c388,real)
    & gener(c388,sp)
    & quant(c388,one)
    & refer(c388,indet)
    & varia(c388,varia_c)
    & sort(verlangen_2_1,da)
    & fact(verlangen_2_1,real)
    & gener(verlangen_2_1,ge)
    & sort(c379,na)
    & card(c379,int1)
    & etype(c379,int0)
    & fact(c379,real)
    & gener(c379,sp)
    & quant(c379,one)
    & refer(c379,indet)
    & varia(c379,varia_c)
    & sort(mensch_1_1,d)
    & card(mensch_1_1,int1)
    & etype(mensch_1_1,int0)
    & fact(mensch_1_1,real)
    & gener(mensch_1_1,ge)
    & quant(mensch_1_1,one)
    & refer(mensch_1_1,refer_c)
    & varia(mensch_1_1,varia_c)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(niebuhr_0,fe)
    & sort(gro__337_1_1,mq)
    & sort(palais_1_1,d)
    & card(palais_1_1,int1)
    & etype(palais_1_1,int0)
    & fact(palais_1_1,real)
    & gener(palais_1_1,ge)
    & quant(palais_1_1,one)
    & refer(palais_1_1,refer_c)
    & varia(palais_1_1,varia_c)
    & sort(c486,d)
    & card(c486,int1)
    & etype(c486,int0)
    & fact(c486,real)
    & gener(c486,sp)
    & quant(c486,one)
    & refer(c486,det)
    & varia(c486,con)
    & sort(c505,l)
    & card(c505,int1)
    & etype(c505,int0)
    & fact(c505,real)
    & gener(c505,sp)
    & quant(c505,one)
    & refer(c505,det)
    & varia(c505,con)
    & sort(kolosseum_1_1,d)
    & card(kolosseum_1_1,int1)
    & etype(kolosseum_1_1,int0)
    & fact(kolosseum_1_1,real)
    & gener(kolosseum_1_1,sp)
    & quant(kolosseum_1_1,one)
    & refer(kolosseum_1_1,det)
    & varia(kolosseum_1_1,con)
    & sort(c494,d)
    & sort(c494,io)
    & card(c494,int1)
    & etype(c494,int0)
    & fact(c494,real)
    & gener(c494,sp)
    & quant(c494,one)
    & refer(c494,det)
    & varia(c494,con)
    & sort(c495,na)
    & card(c495,int1)
    & etype(c495,int0)
    & fact(c495,real)
    & gener(c495,sp)
    & quant(c495,one)
    & refer(c495,indet)
    & varia(c495,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(rom_0,fe)
    & sort(c497,d)
    & card(c497,int1)
    & etype(c497,int0)
    & fact(c497,real)
    & gener(c497,sp)
    & quant(c497,one)
    & refer(c497,refer_c)
    & varia(c497,varia_c)
    & sort(c0,tq)
    & sort(klotz__1_1,d)
    & card(klotz__1_1,int1)
    & etype(klotz__1_1,int0)
    & fact(klotz__1_1,real)
    & gener(klotz__1_1,ge)
    & quant(klotz__1_1,one)
    & refer(klotz__1_1,refer_c)
    & varia(klotz__1_1,varia_c)
    & sort(c501,da)
    & fact(c501,real)
    & gener(c501,sp)
    & sort(ersetzen_1_1,da)
    & fact(ersetzen_1_1,real)
    & gener(ersetzen_1_1,ge)
    & sort(nachempfinden_1_1,da)
    & fact(nachempfinden_1_1,real)
    & gener(nachempfinden_1_1,ge) ) ).

%------------------------------------------------------------------------------
