%------------------------------------------------------------------------------
% File     : CSR114+2 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : In which Italian city can you find the Colosseum?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_004_insicht_1_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.30 v9.1.0, 0.33 v9.0.0, 0.19 v8.2.0, 0.20 v8.1.0, 0.21 v7.5.0, 0.29 v7.4.0, 0.25 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.36 v6.4.0, 0.21 v6.3.0, 0.23 v6.2.0, 0.36 v6.1.0, 0.48 v6.0.0, 0.50 v5.5.0, 0.58 v5.4.0, 0.57 v5.3.0, 0.65 v5.2.0, 0.36 v5.0.0, 0.50 v4.1.0, 0.61 v4.0.1, 0.63 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 11148 (   0 equ)
%            Maximal formula atoms :  441 (   1 avg)
%            Number of connectives :  959 (   0   ~;  18   |; 815   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  441 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   90 (  90 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16691 (16691 usr;16690 con; 0-2 aty)
%            Number of variables   :  473 ( 405   !;  68   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_004_insicht_1,conjecture,
    ? [X0,X1,X2,X3,X4] :
      ( in(X2,X0)
      & attr(X0,X1)
      & loc(X4,X2)
      & scar(X4,X3)
      & sub(X1,name_1_1)
      & sub(X0,stadt__1_1)
      & sub(X3,kolosseum_1_1)
      & subs(X4,stehen_1_1)
      & val(X1,rom_0) ) ).

fof(ave07_era5_synth_qa07_004_insicht_1,hypothesis,
    ( chsp2(auskl__374geln_1_1,c43719)
    & sub(c43113,tempel_1_1)
    & temp(c43113,c43120)
    & pred(c43120,jahr__1_1)
    & prop(c43120,n1760er_1_1)
    & elmt(c43124,c43132)
    & pred(c43132,c43135)
    & pmod(c43135,erst_1_1,bau_1_1)
    & ctxt(c43142,c43124)
    & obj(c43142,c43113)
    & subs(c43142,ausgraben_1_1)
    & attch(c43144,c43132)
    & attr(c43144,c43145)
    & sub(c43144,stadt__1_1)
    & sub(c43145,name_1_1)
    & val(c43145,pompeji_0)
    & sub(c43159,n366ffentlichkeit_1_1)
    & obj(c43164,c43159)
    & subs(c43164,n374berraschen_1_2)
    & temp(c43164,c43142)
    & sub(c43285,fund_1_1)
    & attch(c43290,c43285)
    & loc(c43290,c43299)
    & prop(c43290,morgenl__344ndisch_1_1)
    & subs(c43290,kult_1_1)
    & attr(c43296,c43297)
    & sub(c43296,land_1_1)
    & sub(c43297,name_1_1)
    & val(c43297,italien_0)
    & in(c43299,c43296)
    & caus(c43300,c43164)
    & mexp(c43300,c43301)
    & obj(c43300,c43285)
    & subs(c43300,perzipieren_1_1)
    & sub(c43723,man_1_1)
    & pred(c43730,er_fahrung_1_1)
    & pred(c43739,bau_1_1)
    & assoc(c43740,c43739)
    & obj(c43740,c43730)
    & reas(c43740,c43743)
    & scar(c43740,c43723)
    & subs(c43740,haben_1_1)
    & agt(c43743,c53544)
    & benf(c43743,c56844)
    & circ(c43743,c53566)
    & mannr(c43743,wie_1_1)
    & modl(c43743,nicht_1_1)
    & obj(c43743,c53556)
    & subs(c43743,geben_1_4)
    & prop(c53556,c43719)
    & sub(c53556,technik__1_1)
    & preds(c53566,anlage_1_1)
    & prop(c53566,spaet_1_1)
    & attch(c53572,c53566)
    & subs(c53572,art_1_1)
    & loc(c56844,c56853)
    & sub(c56844,kolosseum_1_1)
    & attr(c56850,c56851)
    & sub(c56850,stadt__1_1)
    & sub(c56851,name_1_1)
    & val(c56851,rom_0)
    & in(c56853,c56850)
    & sort(auskl__374geln_1_1,dn)
    & fact(auskl__374geln_1_1,real)
    & gener(auskl__374geln_1_1,ge)
    & sort(c43719,tq)
    & sort(c43113,d)
    & card(c43113,int1)
    & etype(c43113,int0)
    & fact(c43113,real)
    & gener(c43113,sp)
    & quant(c43113,one)
    & refer(c43113,det)
    & varia(c43113,con)
    & sort(tempel_1_1,d)
    & card(tempel_1_1,int1)
    & etype(tempel_1_1,int0)
    & fact(tempel_1_1,real)
    & gener(tempel_1_1,ge)
    & quant(tempel_1_1,one)
    & refer(tempel_1_1,refer_c)
    & varia(tempel_1_1,varia_c)
    & sort(c43120,me)
    & sort(c43120,oa)
    & sort(c43120,ta)
    & card(c43120,card_c)
    & etype(c43120,etype_c)
    & fact(c43120,real)
    & gener(c43120,sp)
    & quant(c43120,quant_c)
    & refer(c43120,det)
    & varia(c43120,con)
    & sort(jahr__1_1,me)
    & sort(jahr__1_1,oa)
    & sort(jahr__1_1,ta)
    & card(jahr__1_1,card_c)
    & etype(jahr__1_1,etype_c)
    & fact(jahr__1_1,real)
    & gener(jahr__1_1,ge)
    & quant(jahr__1_1,quant_c)
    & refer(jahr__1_1,refer_c)
    & varia(jahr__1_1,varia_c)
    & sort(n1760er_1_1,gq)
    & sort(c43124,d)
    & card(c43124,int1)
    & etype(c43124,int0)
    & fact(c43124,real)
    & gener(c43124,sp)
    & quant(c43124,one)
    & refer(c43124,indet)
    & varia(c43124,varia_c)
    & sort(c43132,d)
    & card(c43132,cons(x_constant,cons(int1,nil)))
    & etype(c43132,int1)
    & fact(c43132,real)
    & gener(c43132,sp)
    & quant(c43132,mult)
    & refer(c43132,det)
    & varia(c43132,con)
    & sort(c43135,d)
    & card(c43135,int1)
    & etype(c43135,int0)
    & fact(c43135,real)
    & gener(c43135,ge)
    & quant(c43135,one)
    & refer(c43135,refer_c)
    & varia(c43135,varia_c)
    & sort(erst_1_1,oq)
    & card(erst_1_1,int1)
    & sort(bau_1_1,d)
    & card(bau_1_1,int1)
    & etype(bau_1_1,int0)
    & fact(bau_1_1,real)
    & gener(bau_1_1,ge)
    & quant(bau_1_1,one)
    & refer(bau_1_1,refer_c)
    & varia(bau_1_1,varia_c)
    & sort(c43142,da)
    & fact(c43142,real)
    & gener(c43142,sp)
    & sort(ausgraben_1_1,da)
    & fact(ausgraben_1_1,real)
    & gener(ausgraben_1_1,ge)
    & sort(c43144,d)
    & sort(c43144,io)
    & card(c43144,int1)
    & etype(c43144,int0)
    & fact(c43144,real)
    & gener(c43144,sp)
    & quant(c43144,one)
    & refer(c43144,det)
    & varia(c43144,con)
    & sort(c43145,na)
    & card(c43145,int1)
    & etype(c43145,int0)
    & fact(c43145,real)
    & gener(c43145,sp)
    & quant(c43145,one)
    & refer(c43145,indet)
    & varia(c43145,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(pompeji_0,fe)
    & sort(c43159,d)
    & sort(c43159,io)
    & card(c43159,int1)
    & etype(c43159,int1)
    & fact(c43159,real)
    & gener(c43159,sp)
    & quant(c43159,one)
    & refer(c43159,det)
    & varia(c43159,con)
    & sort(n366ffentlichkeit_1_1,d)
    & sort(n366ffentlichkeit_1_1,io)
    & card(n366ffentlichkeit_1_1,card_c)
    & etype(n366ffentlichkeit_1_1,int1)
    & fact(n366ffentlichkeit_1_1,real)
    & gener(n366ffentlichkeit_1_1,ge)
    & quant(n366ffentlichkeit_1_1,quant_c)
    & refer(n366ffentlichkeit_1_1,refer_c)
    & varia(n366ffentlichkeit_1_1,varia_c)
    & sort(c43164,da)
    & fact(c43164,real)
    & gener(c43164,sp)
    & sort(n374berraschen_1_2,da)
    & fact(n374berraschen_1_2,real)
    & gener(n374berraschen_1_2,ge)
    & sort(c43285,co)
    & card(c43285,card_c)
    & etype(c43285,etype_c)
    & fact(c43285,real)
    & gener(c43285,sp)
    & quant(c43285,quant_c)
    & refer(c43285,det)
    & varia(c43285,con)
    & sort(fund_1_1,co)
    & card(fund_1_1,card_c)
    & etype(fund_1_1,etype_c)
    & fact(fund_1_1,real)
    & gener(fund_1_1,ge)
    & quant(fund_1_1,quant_c)
    & refer(fund_1_1,refer_c)
    & varia(fund_1_1,varia_c)
    & sort(c43290,ad)
    & card(c43290,int1)
    & etype(c43290,int0)
    & fact(c43290,real)
    & gener(c43290,sp)
    & quant(c43290,one)
    & refer(c43290,indet)
    & varia(c43290,varia_c)
    & sort(c43299,l)
    & card(c43299,int1)
    & etype(c43299,int0)
    & fact(c43299,real)
    & gener(c43299,sp)
    & quant(c43299,one)
    & refer(c43299,det)
    & varia(c43299,con)
    & sort(morgenl__344ndisch_1_1,nq)
    & sort(kult_1_1,ad)
    & card(kult_1_1,int1)
    & etype(kult_1_1,int0)
    & fact(kult_1_1,real)
    & gener(kult_1_1,ge)
    & quant(kult_1_1,one)
    & refer(kult_1_1,refer_c)
    & varia(kult_1_1,varia_c)
    & sort(c43296,d)
    & sort(c43296,io)
    & card(c43296,int1)
    & etype(c43296,int0)
    & fact(c43296,real)
    & gener(c43296,sp)
    & quant(c43296,one)
    & refer(c43296,det)
    & varia(c43296,con)
    & sort(c43297,na)
    & card(c43297,int1)
    & etype(c43297,int0)
    & fact(c43297,real)
    & gener(c43297,sp)
    & quant(c43297,one)
    & refer(c43297,indet)
    & varia(c43297,varia_c)
    & sort(land_1_1,d)
    & sort(land_1_1,io)
    & card(land_1_1,int1)
    & etype(land_1_1,int0)
    & fact(land_1_1,real)
    & gener(land_1_1,ge)
    & quant(land_1_1,one)
    & refer(land_1_1,refer_c)
    & varia(land_1_1,varia_c)
    & sort(italien_0,fe)
    & sort(c43300,st)
    & fact(c43300,real)
    & gener(c43300,gener_c)
    & sort(c43301,d)
    & card(c43301,int1)
    & etype(c43301,int0)
    & fact(c43301,real)
    & gener(c43301,gener_c)
    & quant(c43301,one)
    & refer(c43301,refer_c)
    & varia(c43301,varia_c)
    & sort(perzipieren_1_1,da)
    & fact(perzipieren_1_1,real)
    & gener(perzipieren_1_1,ge)
    & sort(c43723,d)
    & card(c43723,int1)
    & etype(c43723,int0)
    & fact(c43723,real)
    & gener(c43723,ge)
    & quant(c43723,one)
    & refer(c43723,refer_c)
    & varia(c43723,varia_c)
    & sort(man_1_1,d)
    & card(man_1_1,int1)
    & etype(man_1_1,int0)
    & fact(man_1_1,real)
    & gener(man_1_1,ge)
    & quant(man_1_1,one)
    & refer(man_1_1,refer_c)
    & varia(man_1_1,varia_c)
    & sort(c43730,as)
    & sort(c43730,io)
    & card(c43730,cons(x_constant,cons(int1,nil)))
    & etype(c43730,int1)
    & fact(c43730,nonreal)
    & gener(c43730,sp)
    & quant(c43730,mult)
    & refer(c43730,indet)
    & varia(c43730,varia_c)
    & sort(er_fahrung_1_1,as)
    & sort(er_fahrung_1_1,io)
    & card(er_fahrung_1_1,int1)
    & etype(er_fahrung_1_1,int0)
    & fact(er_fahrung_1_1,real)
    & gener(er_fahrung_1_1,ge)
    & quant(er_fahrung_1_1,one)
    & refer(er_fahrung_1_1,refer_c)
    & varia(er_fahrung_1_1,varia_c)
    & sort(c43739,d)
    & card(c43739,cons(x_constant,cons(int1,nil)))
    & etype(c43739,int1)
    & fact(c43739,real)
    & gener(c43739,sp)
    & quant(c43739,mult)
    & refer(c43739,det)
    & varia(c43739,varia_c)
    & sort(c43740,st)
    & fact(c43740,real)
    & gener(c43740,sp)
    & sort(c43743,da)
    & fact(c43743,real)
    & gener(c43743,sp)
    & sort(haben_1_1,st)
    & fact(haben_1_1,real)
    & gener(haben_1_1,ge)
    & sort(c53544,o)
    & card(c53544,int1)
    & etype(c53544,int0)
    & fact(c53544,real)
    & gener(c53544,sp)
    & quant(c53544,one)
    & refer(c53544,det)
    & varia(c53544,varia_c)
    & sort(c56844,d)
    & card(c56844,int1)
    & etype(c56844,int0)
    & fact(c56844,real)
    & gener(c56844,sp)
    & quant(c56844,one)
    & refer(c56844,det)
    & varia(c56844,con)
    & sort(c53566,as)
    & card(c53566,cons(x_constant,cons(int1,nil)))
    & etype(c53566,int1)
    & fact(c53566,real)
    & gener(c53566,sp)
    & quant(c53566,mult)
    & refer(c53566,det)
    & varia(c53566,varia_c)
    & sort(wie_1_1,mq)
    & sort(nicht_1_1,md)
    & fact(nicht_1_1,real)
    & gener(nicht_1_1,gener_c)
    & sort(c53556,io)
    & card(c53556,int1)
    & etype(c53556,int0)
    & fact(c53556,real)
    & gener(c53556,sp)
    & quant(c53556,one)
    & refer(c53556,det)
    & varia(c53556,con)
    & sort(geben_1_4,da)
    & fact(geben_1_4,real)
    & gener(geben_1_4,ge)
    & sort(technik__1_1,io)
    & card(technik__1_1,int1)
    & etype(technik__1_1,int0)
    & fact(technik__1_1,real)
    & gener(technik__1_1,ge)
    & quant(technik__1_1,one)
    & refer(technik__1_1,refer_c)
    & varia(technik__1_1,varia_c)
    & sort(anlage_1_1,as)
    & card(anlage_1_1,int1)
    & etype(anlage_1_1,int0)
    & fact(anlage_1_1,real)
    & gener(anlage_1_1,ge)
    & quant(anlage_1_1,one)
    & refer(anlage_1_1,refer_c)
    & varia(anlage_1_1,varia_c)
    & sort(spaet_1_1,mq)
    & sort(c53572,ad)
    & card(c53572,int1)
    & etype(c53572,int1)
    & fact(c53572,real)
    & gener(c53572,sp)
    & quant(c53572,one)
    & refer(c53572,det)
    & varia(c53572,varia_c)
    & sort(art_1_1,ad)
    & card(art_1_1,card_c)
    & etype(art_1_1,int1)
    & fact(art_1_1,real)
    & gener(art_1_1,ge)
    & quant(art_1_1,quant_c)
    & refer(art_1_1,refer_c)
    & varia(art_1_1,varia_c)
    & sort(c56853,l)
    & card(c56853,int1)
    & etype(c56853,int0)
    & fact(c56853,real)
    & gener(c56853,sp)
    & quant(c56853,one)
    & refer(c56853,det)
    & varia(c56853,con)
    & sort(kolosseum_1_1,d)
    & card(kolosseum_1_1,int1)
    & etype(kolosseum_1_1,int0)
    & fact(kolosseum_1_1,real)
    & gener(kolosseum_1_1,sp)
    & quant(kolosseum_1_1,one)
    & refer(kolosseum_1_1,det)
    & varia(kolosseum_1_1,con)
    & sort(c56850,d)
    & sort(c56850,io)
    & card(c56850,int1)
    & etype(c56850,int0)
    & fact(c56850,real)
    & gener(c56850,sp)
    & quant(c56850,one)
    & refer(c56850,det)
    & varia(c56850,con)
    & sort(c56851,na)
    & card(c56851,int1)
    & etype(c56851,int0)
    & fact(c56851,real)
    & gener(c56851,sp)
    & quant(c56851,one)
    & refer(c56851,indet)
    & varia(c56851,varia_c)
    & sort(rom_0,fe) ) ).

%------------------------------------------------------------------------------
