%------------------------------------------------------------------------------
% File     : CSR114+18 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : In which Italian city can you find the Colosseum?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_004_qapn_64_a281_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.30 v9.1.0, 0.33 v9.0.0, 0.19 v8.2.0, 0.20 v8.1.0, 0.21 v7.5.0, 0.33 v7.4.0, 0.25 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.29 v6.4.0, 0.21 v6.3.0, 0.23 v6.2.0, 0.36 v6.1.0, 0.56 v6.0.0, 0.50 v5.5.0, 0.54 v5.4.0, 0.52 v5.3.0, 0.61 v5.2.0, 0.36 v5.0.0, 0.45 v4.1.0, 0.56 v4.0.1, 0.53 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10915 (   0 equ)
%            Maximal formula atoms :  209 (   1 avg)
%            Number of connectives :  726 (   0   ~;  18   |; 582   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  209 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   89 (  89 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16658 (16658 usr;16657 con; 0-2 aty)
%            Number of variables   :  473 ( 405   !;  68   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_004_qapn_64_a281,conjecture,
    ? [X0,X1,X2,X3,X4] :
      ( in(X2,X0)
      & attr(X0,X1)
      & loc(X4,X2)
      & scar(X4,X3)
      & sub(X1,name_1_1)
      & sub(X0,stadt__1_1)
      & subs(X4,stehen_1_1)
      & val(X1,rom_0) ) ).

fof(ave07_era5_synth_qa07_004_qapn_64_a281,hypothesis,
    ( prop(c10,arglistig_1_1)
    & subs(c10,n374berraschung_1_1)
    & sub(c15,dienstag__1_1)
    & poss(c184,c204)
    & sub(c190,kolosseum_1_1)
    & attr(c196,c197)
    & sub(c196,stadt__1_1)
    & sub(c197,name_1_1)
    & val(c197,rom_0)
    & sub(c204,auto__1_1)
    & agt(c205,c184)
    & dircl(c205,c243)
    & loc(c205,c244)
    & loc(c205,c245)
    & modl(c205,wollen_0)
    & subs(c205,steigen_1_2)
    & in(c243,c204)
    & in(c244,c196)
    & vor(c245,c190)
    & prop(c25,n344gyptisch_1_1)
    & sub(c25,ehepaar_3_1)
    & exp(c31,c25)
    & obj(c31,c10)
    & subs(c31,erleben_1_1)
    & temp(c31,c15)
    & temp(c31,c205)
    & assoc(ehepaar_3_1,ehe_2_1)
    & sub(ehepaar_3_1,paar_3_1)
    & sort(c10,ad)
    & card(c10,int1)
    & etype(c10,int0)
    & fact(c10,real)
    & gener(c10,sp)
    & quant(c10,one)
    & refer(c10,indet)
    & varia(c10,varia_c)
    & sort(arglistig_1_1,nq)
    & sort(n374berraschung_1_1,ad)
    & card(n374berraschung_1_1,int1)
    & etype(n374berraschung_1_1,int0)
    & fact(n374berraschung_1_1,real)
    & gener(n374berraschung_1_1,ge)
    & quant(n374berraschung_1_1,one)
    & refer(n374berraschung_1_1,refer_c)
    & varia(n374berraschung_1_1,varia_c)
    & sort(c15,ta)
    & card(c15,int1)
    & etype(c15,int0)
    & fact(c15,real)
    & gener(c15,sp)
    & quant(c15,one)
    & refer(c15,det)
    & varia(c15,con)
    & sort(dienstag__1_1,ta)
    & card(dienstag__1_1,int1)
    & etype(dienstag__1_1,int0)
    & fact(dienstag__1_1,real)
    & gener(dienstag__1_1,ge)
    & quant(dienstag__1_1,one)
    & refer(dienstag__1_1,refer_c)
    & varia(dienstag__1_1,varia_c)
    & sort(c184,o)
    & card(c184,int1)
    & etype(c184,int0)
    & fact(c184,real)
    & gener(c184,sp)
    & quant(c184,one)
    & refer(c184,det)
    & varia(c184,varia_c)
    & sort(c204,d)
    & card(c204,int1)
    & etype(c204,int0)
    & fact(c204,real)
    & gener(c204,sp)
    & quant(c204,one)
    & refer(c204,det)
    & varia(c204,varia_c)
    & sort(c190,d)
    & card(c190,int1)
    & etype(c190,int0)
    & fact(c190,real)
    & gener(c190,sp)
    & quant(c190,one)
    & refer(c190,det)
    & varia(c190,con)
    & sort(kolosseum_1_1,d)
    & card(kolosseum_1_1,int1)
    & etype(kolosseum_1_1,int0)
    & fact(kolosseum_1_1,real)
    & gener(kolosseum_1_1,sp)
    & quant(kolosseum_1_1,one)
    & refer(kolosseum_1_1,det)
    & varia(kolosseum_1_1,con)
    & sort(c196,d)
    & sort(c196,io)
    & card(c196,int1)
    & etype(c196,int0)
    & fact(c196,real)
    & gener(c196,sp)
    & quant(c196,one)
    & refer(c196,det)
    & varia(c196,con)
    & sort(c197,na)
    & card(c197,int1)
    & etype(c197,int0)
    & fact(c197,real)
    & gener(c197,sp)
    & quant(c197,one)
    & refer(c197,indet)
    & varia(c197,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(rom_0,fe)
    & sort(auto__1_1,d)
    & card(auto__1_1,int1)
    & etype(auto__1_1,int0)
    & fact(auto__1_1,real)
    & gener(auto__1_1,ge)
    & quant(auto__1_1,one)
    & refer(auto__1_1,refer_c)
    & varia(auto__1_1,varia_c)
    & sort(c205,da)
    & fact(c205,real)
    & gener(c205,sp)
    & sort(c243,l)
    & card(c243,int1)
    & etype(c243,int0)
    & fact(c243,real)
    & gener(c243,sp)
    & quant(c243,one)
    & refer(c243,det)
    & varia(c243,varia_c)
    & sort(c244,l)
    & card(c244,int1)
    & etype(c244,int0)
    & fact(c244,real)
    & gener(c244,sp)
    & quant(c244,one)
    & refer(c244,det)
    & varia(c244,con)
    & sort(c245,l)
    & card(c245,int1)
    & etype(c245,int0)
    & fact(c245,real)
    & gener(c245,sp)
    & quant(c245,one)
    & refer(c245,det)
    & varia(c245,con)
    & sort(wollen_0,md)
    & fact(wollen_0,real)
    & gener(wollen_0,gener_c)
    & sort(steigen_1_2,da)
    & fact(steigen_1_2,real)
    & gener(steigen_1_2,ge)
    & sort(c25,d)
    & card(c25,int1)
    & etype(c25,int1)
    & fact(c25,real)
    & gener(c25,sp)
    & quant(c25,one)
    & refer(c25,indet)
    & varia(c25,varia_c)
    & sort(n344gyptisch_1_1,nq)
    & sort(ehepaar_3_1,d)
    & card(ehepaar_3_1,card_c)
    & etype(ehepaar_3_1,int1)
    & fact(ehepaar_3_1,real)
    & gener(ehepaar_3_1,ge)
    & quant(ehepaar_3_1,quant_c)
    & refer(ehepaar_3_1,refer_c)
    & varia(ehepaar_3_1,varia_c)
    & sort(c31,dn)
    & fact(c31,real)
    & gener(c31,sp)
    & sort(erleben_1_1,dn)
    & fact(erleben_1_1,real)
    & gener(erleben_1_1,ge)
    & sort(ehe_2_1,as)
    & sort(ehe_2_1,re)
    & card(ehe_2_1,int1)
    & etype(ehe_2_1,int0)
    & fact(ehe_2_1,real)
    & gener(ehe_2_1,ge)
    & quant(ehe_2_1,one)
    & refer(ehe_2_1,refer_c)
    & varia(ehe_2_1,varia_c)
    & sort(paar_3_1,d)
    & card(paar_3_1,card_c)
    & etype(paar_3_1,int1)
    & fact(paar_3_1,real)
    & gener(paar_3_1,ge)
    & quant(paar_3_1,quant_c)
    & refer(paar_3_1,refer_c)
    & varia(paar_3_1,varia_c) ) ).

%------------------------------------------------------------------------------
