%------------------------------------------------------------------------------
% File     : CSR114+17 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : In which Italian city can you find the Colosseum?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_004_mw3_166_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.30 v9.1.0, 0.33 v9.0.0, 0.19 v8.2.0, 0.20 v8.1.0, 0.21 v7.5.0, 0.38 v7.4.0, 0.25 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.36 v6.4.0, 0.29 v6.3.0, 0.31 v6.2.0, 0.45 v6.1.0, 0.52 v6.0.0, 0.50 v5.4.0, 0.48 v5.3.0, 0.61 v5.2.0, 0.43 v5.0.0, 0.45 v4.1.0, 0.50 v4.0.1, 0.53 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10872 (   0 equ)
%            Maximal formula atoms :  166 (   1 avg)
%            Number of connectives :  683 (   0   ~;  18   |; 539   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  166 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   88 (  88 usr;   0 prp; 2-8 aty)
%            Number of functors    : 16657 (16657 usr;16656 con; 0-2 aty)
%            Number of variables   :  473 ( 405   !;  68   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_004_mw3_166,conjecture,
    ? [X0,X1,X2,X3,X4] :
      ( attr(X0,X1)
      & loc(X4,X2)
      & prop(X0,italienisch__1_1)
      & scar(X4,X3)
      & sub(X1,name_1_1)
      & sub(X0,stadt__1_1)
      & subs(X4,stehen_1_1)
      & val(X1,rom_0) ) ).

fof(ave07_era5_synth_qa07_004_mw3_166,hypothesis,
    ( tupl_p8(c246,c61,c67,c71,c67,c81,c85,c93)
    & sub(c61,palazzo_1_1)
    & attr(c67,c78)
    & prop(c67,italienisch__1_1)
    & sub(c67,stadt__1_1)
    & sub(c71,phantasieansicht_1_1)
    & sub(c78,name_1_1)
    & val(c78,rom_0)
    & attr(c81,c82)
    & sub(c82,jahr__1_1)
    & val(c82,c79)
    & sub(c85,leinwand_1_1)
    & quant_p3(c93,c89,cm_1_1)
    & assoc(phantasieansicht_1_1,phantasie_1_1)
    & sub(phantasieansicht_1_1,anschauung_1_1)
    & sort(c246,ent)
    & card(c246,card_c)
    & etype(c246,etype_c)
    & fact(c246,real)
    & gener(c246,gener_c)
    & quant(c246,quant_c)
    & refer(c246,refer_c)
    & varia(c246,varia_c)
    & sort(c61,d)
    & card(c61,int1)
    & etype(c61,int0)
    & fact(c61,real)
    & gener(c61,gener_c)
    & quant(c61,one)
    & refer(c61,refer_c)
    & varia(c61,varia_c)
    & sort(c67,d)
    & sort(c67,io)
    & card(c67,int1)
    & etype(c67,int0)
    & fact(c67,real)
    & gener(c67,sp)
    & quant(c67,one)
    & refer(c67,indet)
    & varia(c67,varia_c)
    & sort(c71,io)
    & card(c71,int1)
    & etype(c71,int0)
    & fact(c71,real)
    & gener(c71,gener_c)
    & quant(c71,one)
    & refer(c71,refer_c)
    & varia(c71,varia_c)
    & sort(c81,t)
    & card(c81,int1)
    & etype(c81,int0)
    & fact(c81,real)
    & gener(c81,sp)
    & quant(c81,one)
    & refer(c81,det)
    & varia(c81,con)
    & sort(c85,d)
    & card(c85,int1)
    & etype(c85,int0)
    & fact(c85,real)
    & gener(c85,gener_c)
    & quant(c85,one)
    & refer(c85,refer_c)
    & varia(c85,varia_c)
    & sort(c93,co)
    & sort(c93,m)
    & card(c93,card_c)
    & etype(c93,etype_c)
    & fact(c93,real)
    & gener(c93,gener_c)
    & quant(c93,quant_c)
    & refer(c93,refer_c)
    & varia(c93,con)
    & sort(palazzo_1_1,d)
    & card(palazzo_1_1,int1)
    & etype(palazzo_1_1,int0)
    & fact(palazzo_1_1,real)
    & gener(palazzo_1_1,ge)
    & quant(palazzo_1_1,one)
    & refer(palazzo_1_1,refer_c)
    & varia(palazzo_1_1,varia_c)
    & sort(c78,na)
    & card(c78,int1)
    & etype(c78,int0)
    & fact(c78,real)
    & gener(c78,sp)
    & quant(c78,one)
    & refer(c78,indet)
    & varia(c78,varia_c)
    & sort(italienisch__1_1,nq)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(phantasieansicht_1_1,io)
    & card(phantasieansicht_1_1,int1)
    & etype(phantasieansicht_1_1,int0)
    & fact(phantasieansicht_1_1,real)
    & gener(phantasieansicht_1_1,ge)
    & quant(phantasieansicht_1_1,one)
    & refer(phantasieansicht_1_1,refer_c)
    & varia(phantasieansicht_1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(rom_0,fe)
    & sort(c82,me)
    & sort(c82,oa)
    & sort(c82,ta)
    & card(c82,card_c)
    & etype(c82,etype_c)
    & fact(c82,real)
    & gener(c82,sp)
    & quant(c82,quant_c)
    & refer(c82,refer_c)
    & varia(c82,varia_c)
    & sort(jahr__1_1,me)
    & sort(jahr__1_1,oa)
    & sort(jahr__1_1,ta)
    & card(jahr__1_1,card_c)
    & etype(jahr__1_1,etype_c)
    & fact(jahr__1_1,real)
    & gener(jahr__1_1,ge)
    & quant(jahr__1_1,quant_c)
    & refer(jahr__1_1,refer_c)
    & varia(jahr__1_1,varia_c)
    & sort(c79,nu)
    & card(c79,int1664)
    & sort(leinwand_1_1,d)
    & card(leinwand_1_1,int1)
    & etype(leinwand_1_1,int0)
    & fact(leinwand_1_1,real)
    & gener(leinwand_1_1,ge)
    & quant(leinwand_1_1,one)
    & refer(leinwand_1_1,refer_c)
    & varia(leinwand_1_1,varia_c)
    & sort(c89,nu)
    & card(c89,int4489)
    & sort(cm_1_1,me)
    & gener(cm_1_1,ge)
    & sort(phantasie_1_1,io)
    & card(phantasie_1_1,int1)
    & etype(phantasie_1_1,int0)
    & fact(phantasie_1_1,real)
    & gener(phantasie_1_1,ge)
    & quant(phantasie_1_1,one)
    & refer(phantasie_1_1,refer_c)
    & varia(phantasie_1_1,varia_c)
    & sort(anschauung_1_1,io)
    & card(anschauung_1_1,int1)
    & etype(anschauung_1_1,int0)
    & fact(anschauung_1_1,real)
    & gener(anschauung_1_1,ge)
    & quant(anschauung_1_1,one)
    & refer(anschauung_1_1,refer_c)
    & varia(anschauung_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
