%------------------------------------------------------------------------------
% File     : CSR114+16 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : In which Italian city can you find the Colosseum?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_004_mw3_158_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.25 v9.1.0, 0.20 v9.0.0, 0.19 v8.2.0, 0.13 v8.1.0, 0.14 v7.5.0, 0.24 v7.4.0, 0.19 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.21 v6.4.0, 0.14 v6.3.0, 0.23 v6.2.0, 0.27 v6.1.0, 0.48 v6.0.0, 0.25 v5.5.0, 0.42 v5.4.0, 0.39 v5.3.0, 0.48 v5.2.0, 0.36 v5.0.0, 0.40 v4.1.0, 0.44 v4.0.1, 0.42 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10811 (   0 equ)
%            Maximal formula atoms :  108 (   1 avg)
%            Number of connectives :  622 (   0   ~;  18   |; 478   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  108 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16650 (16650 usr;16649 con; 0-2 aty)
%            Number of variables   :  472 ( 405   !;  67   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_004_mw3_158,conjecture,
    ? [X0,X1,X2,X3] :
      ( attr(X0,X1)
      & scar(X3,X2)
      & sub(X1,name_1_1)
      & sub(X0,stadt__1_1)
      & val(X1,rom_0) ) ).

fof(ave07_era5_synth_qa07_004_mw3_158,hypothesis,
    ( obj(c657,c660)
    & scar(c657,c43)
    & subs(c657,haben_1_1)
    & pred(c660,bewohner__1_1)
    & assoc(c672,c814)
    & scar(c672,c43)
    & semrel(c672,c657)
    & sspe(c672,c819)
    & subs(c672,geh__366ren_1_1)
    & sub(c814,provinz_1_1)
    & attr(c819,c820)
    & sub(c819,stadt__1_1)
    & sub(c820,name_1_1)
    & val(c820,rom_0)
    & sort(c657,st)
    & fact(c657,real)
    & gener(c657,sp)
    & sort(c660,d)
    & card(c660,int35895)
    & etype(c660,int1)
    & fact(c660,real)
    & gener(c660,sp)
    & quant(c660,nfquant)
    & refer(c660,indet)
    & varia(c660,varia_c)
    & sort(c43,abs)
    & sort(c43,co)
    & sort(c43,io)
    & sort(c43,mo)
    & sort(c43,ta)
    & sort(c43,re)
    & card(c43,card_c)
    & etype(c43,etype_c)
    & fact(c43,real)
    & gener(c43,sp)
    & quant(c43,quant_c)
    & refer(c43,det)
    & varia(c43,varia_c)
    & sort(haben_1_1,st)
    & fact(haben_1_1,real)
    & gener(haben_1_1,ge)
    & sort(bewohner__1_1,d)
    & card(bewohner__1_1,int1)
    & etype(bewohner__1_1,int0)
    & fact(bewohner__1_1,real)
    & gener(bewohner__1_1,ge)
    & quant(bewohner__1_1,one)
    & refer(bewohner__1_1,refer_c)
    & varia(bewohner__1_1,varia_c)
    & sort(c672,st)
    & fact(c672,real)
    & gener(c672,sp)
    & sort(c814,d)
    & sort(c814,io)
    & card(c814,int1)
    & etype(c814,int0)
    & fact(c814,real)
    & gener(c814,sp)
    & quant(c814,one)
    & refer(c814,det)
    & varia(c814,con)
    & sort(c819,d)
    & sort(c819,io)
    & card(c819,int1)
    & etype(c819,int0)
    & fact(c819,real)
    & gener(c819,sp)
    & quant(c819,one)
    & refer(c819,det)
    & varia(c819,con)
    & sort(geh__366ren_1_1,st)
    & fact(geh__366ren_1_1,real)
    & gener(geh__366ren_1_1,ge)
    & sort(provinz_1_1,d)
    & sort(provinz_1_1,io)
    & card(provinz_1_1,int1)
    & etype(provinz_1_1,int0)
    & fact(provinz_1_1,real)
    & gener(provinz_1_1,ge)
    & quant(provinz_1_1,one)
    & refer(provinz_1_1,refer_c)
    & varia(provinz_1_1,varia_c)
    & sort(c820,na)
    & card(c820,int1)
    & etype(c820,int0)
    & fact(c820,real)
    & gener(c820,sp)
    & quant(c820,one)
    & refer(c820,indet)
    & varia(c820,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(rom_0,fe) ) ).

%------------------------------------------------------------------------------
