%------------------------------------------------------------------------------
% File     : CSR114+14 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : In which Italian city can you find the Colosseum?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_004_mira_wp_320_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.35 v9.1.0, 0.33 v9.0.0, 0.25 v8.2.0, 0.20 v8.1.0, 0.21 v7.5.0, 0.33 v7.4.0, 0.25 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.36 v6.4.0, 0.29 v6.3.0, 0.31 v6.2.0, 0.45 v6.1.0, 0.48 v6.0.0, 0.50 v5.4.0, 0.48 v5.3.0, 0.65 v5.2.0, 0.57 v5.0.0, 0.45 v4.1.0, 0.56 v4.0.1, 0.53 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10842 (   0 equ)
%            Maximal formula atoms :  137 (   1 avg)
%            Number of connectives :  653 (   0   ~;  18   |; 509   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  137 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-5 aty)
%            Number of functors    : 16651 (16651 usr;16650 con; 0-2 aty)
%            Number of variables   :  473 ( 405   !;  68   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_004_mira_wp_320,conjecture,
    ? [X0,X1,X2,X3,X4] :
      ( attr(X0,X1)
      & loc(X4,X2)
      & scar(X4,X3)
      & sub(X1,name_1_1)
      & sub(X0,stadt__1_1)
      & subs(X4,stehen_1_1)
      & val(X1,rom_0) ) ).

fof(ave07_era5_synth_qa07_004_mira_wp_320,hypothesis,
    ( sub(c611,logo_1_1)
    & sub(c629,zeich_nung_1_1)
    & attch(c632,c629)
    & sub(c632,kolosseum_1_1)
    & attr(c638,c639)
    & sub(c638,stadt__1_1)
    & sub(c639,name_1_1)
    & val(c639,rom_0)
    & pred(c643,nationalfarbe_1_1)
    & prop(c643,italienisch__1_1)
    & tupl_p5(c685,c611,c629,c638,c643)
    & assoc(nationalfarbe_1_1,national__1_1)
    & sub(nationalfarbe_1_1,farbe_1_1)
    & sort(c611,d)
    & sort(c611,io)
    & card(c611,int1)
    & etype(c611,int0)
    & fact(c611,real)
    & gener(c611,sp)
    & quant(c611,one)
    & refer(c611,det)
    & varia(c611,con)
    & sort(logo_1_1,d)
    & sort(logo_1_1,io)
    & card(logo_1_1,int1)
    & etype(logo_1_1,int0)
    & fact(logo_1_1,real)
    & gener(logo_1_1,ge)
    & quant(logo_1_1,one)
    & refer(logo_1_1,refer_c)
    & varia(logo_1_1,varia_c)
    & sort(c629,d)
    & sort(c629,io)
    & card(c629,int1)
    & etype(c629,int0)
    & fact(c629,real)
    & gener(c629,sp)
    & quant(c629,one)
    & refer(c629,indet)
    & varia(c629,varia_c)
    & sort(zeich_nung_1_1,d)
    & sort(zeich_nung_1_1,io)
    & card(zeich_nung_1_1,int1)
    & etype(zeich_nung_1_1,int0)
    & fact(zeich_nung_1_1,real)
    & gener(zeich_nung_1_1,ge)
    & quant(zeich_nung_1_1,one)
    & refer(zeich_nung_1_1,refer_c)
    & varia(zeich_nung_1_1,varia_c)
    & sort(c632,d)
    & card(c632,int1)
    & etype(c632,int0)
    & fact(c632,real)
    & gener(c632,sp)
    & quant(c632,one)
    & refer(c632,det)
    & varia(c632,con)
    & sort(kolosseum_1_1,d)
    & card(kolosseum_1_1,int1)
    & etype(kolosseum_1_1,int0)
    & fact(kolosseum_1_1,real)
    & gener(kolosseum_1_1,sp)
    & quant(kolosseum_1_1,one)
    & refer(kolosseum_1_1,det)
    & varia(kolosseum_1_1,con)
    & sort(c638,d)
    & sort(c638,io)
    & card(c638,int1)
    & etype(c638,int0)
    & fact(c638,real)
    & gener(c638,sp)
    & quant(c638,one)
    & refer(c638,det)
    & varia(c638,con)
    & sort(c639,na)
    & card(c639,int1)
    & etype(c639,int0)
    & fact(c639,real)
    & gener(c639,sp)
    & quant(c639,one)
    & refer(c639,indet)
    & varia(c639,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(rom_0,fe)
    & sort(c643,na)
    & sort(c643,s)
    & card(c643,cons(x_constant,cons(int1,nil)))
    & etype(c643,int1)
    & fact(c643,real)
    & gener(c643,sp)
    & quant(c643,mult)
    & refer(c643,det)
    & varia(c643,con)
    & sort(nationalfarbe_1_1,na)
    & sort(nationalfarbe_1_1,s)
    & card(nationalfarbe_1_1,int1)
    & etype(nationalfarbe_1_1,int0)
    & fact(nationalfarbe_1_1,real)
    & gener(nationalfarbe_1_1,ge)
    & quant(nationalfarbe_1_1,one)
    & refer(nationalfarbe_1_1,refer_c)
    & varia(nationalfarbe_1_1,varia_c)
    & sort(italienisch__1_1,nq)
    & sort(c685,ent)
    & card(c685,card_c)
    & etype(c685,etype_c)
    & fact(c685,real)
    & gener(c685,gener_c)
    & quant(c685,quant_c)
    & refer(c685,refer_c)
    & varia(c685,varia_c)
    & sort(national__1_1,nq)
    & sort(farbe_1_1,na)
    & sort(farbe_1_1,s)
    & card(farbe_1_1,int1)
    & etype(farbe_1_1,int0)
    & fact(farbe_1_1,real)
    & gener(farbe_1_1,ge)
    & quant(farbe_1_1,one)
    & refer(farbe_1_1,refer_c)
    & varia(farbe_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
