%------------------------------------------------------------------------------
% File     : CSR114+12 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : In which Italian city can you find the Colosseum?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_004_mira_wp_261_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.30 v9.1.0, 0.33 v9.0.0, 0.19 v8.2.0, 0.20 v8.1.0, 0.21 v7.5.0, 0.29 v7.4.0, 0.25 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.29 v6.4.0, 0.21 v6.3.0, 0.23 v6.2.0, 0.36 v6.1.0, 0.48 v6.0.0, 0.50 v5.4.0, 0.48 v5.3.0, 0.57 v5.2.0, 0.36 v5.0.0, 0.40 v4.1.0, 0.50 v4.0.1, 0.53 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10843 (   0 equ)
%            Maximal formula atoms :  136 (   1 avg)
%            Number of connectives :  654 (   0   ~;  18   |; 510   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  136 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   88 (  88 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16654 (16654 usr;16653 con; 0-2 aty)
%            Number of variables   :  473 ( 405   !;  68   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_004_mira_wp_261,conjecture,
    ? [X0,X1,X2,X3,X4] :
      ( in(X2,X0)
      & attr(X0,X1)
      & loc(X4,X2)
      & scar(X4,X3)
      & sub(X1,name_1_1)
      & sub(X0,stadt__1_1)
      & sub(X3,kolosseum_1_1)
      & subs(X4,stehen_1_1)
      & val(X1,rom_0) ) ).

fof(ave07_era5_synth_qa07_004_mira_wp_261,hypothesis,
    ( agt(c4,c72)
    & caus(c4,c99)
    & obj(c4,c80)
    & subs(c4,machen_1_6)
    & sub(c72,stadt__1_1)
    & loc(c80,c98)
    & prop(c80,c84)
    & sub(c80,amphi_theater_1_1)
    & supl(c84,zweitgro__337_1_1,c85)
    & loc(c88,c97)
    & sub(c88,kolosseum_1_1)
    & attr(c94,c95)
    & sub(c94,stadt__1_1)
    & sub(c95,name_1_1)
    & val(c95,rom_0)
    & in(c97,c94)
    & hinter(c98,c88)
    & arg1(c99,c80)
    & arg2(c99,erw__344hnenswert_1_1)
    & subr(c99,prop_0)
    & sort(c4,da)
    & fact(c4,real)
    & gener(c4,sp)
    & sort(c72,d)
    & sort(c72,io)
    & card(c72,int1)
    & etype(c72,int0)
    & fact(c72,real)
    & gener(c72,sp)
    & quant(c72,one)
    & refer(c72,det)
    & varia(c72,con)
    & sort(c99,st)
    & fact(c99,real)
    & gener(c99,sp)
    & sort(c80,o)
    & card(c80,int1)
    & etype(c80,int0)
    & fact(c80,real)
    & gener(c80,sp)
    & quant(c80,one)
    & refer(c80,det)
    & varia(c80,con)
    & sort(machen_1_6,da)
    & fact(machen_1_6,real)
    & gener(machen_1_6,ge)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(c98,l)
    & card(c98,int1)
    & etype(c98,int0)
    & fact(c98,real)
    & gener(c98,sp)
    & quant(c98,one)
    & refer(c98,det)
    & varia(c98,con)
    & sort(c84,tq)
    & sort(amphi_theater_1_1,o)
    & card(amphi_theater_1_1,int1)
    & etype(amphi_theater_1_1,int0)
    & fact(amphi_theater_1_1,real)
    & gener(amphi_theater_1_1,ge)
    & quant(amphi_theater_1_1,one)
    & refer(amphi_theater_1_1,refer_c)
    & varia(amphi_theater_1_1,varia_c)
    & sort(zweitgro__337_1_1,mq)
    & sort(c85,o)
    & card(c85,card_c)
    & etype(c85,int1)
    & etype(c85,int2)
    & fact(c85,real)
    & gener(c85,gener_c)
    & quant(c85,quant_c)
    & refer(c85,refer_c)
    & varia(c85,varia_c)
    & sort(c88,d)
    & card(c88,int1)
    & etype(c88,int0)
    & fact(c88,real)
    & gener(c88,sp)
    & quant(c88,one)
    & refer(c88,det)
    & varia(c88,con)
    & sort(c97,l)
    & card(c97,int1)
    & etype(c97,int0)
    & fact(c97,real)
    & gener(c97,sp)
    & quant(c97,one)
    & refer(c97,det)
    & varia(c97,con)
    & sort(kolosseum_1_1,d)
    & card(kolosseum_1_1,int1)
    & etype(kolosseum_1_1,int0)
    & fact(kolosseum_1_1,real)
    & gener(kolosseum_1_1,sp)
    & quant(kolosseum_1_1,one)
    & refer(kolosseum_1_1,det)
    & varia(kolosseum_1_1,con)
    & sort(c94,d)
    & sort(c94,io)
    & card(c94,int1)
    & etype(c94,int0)
    & fact(c94,real)
    & gener(c94,sp)
    & quant(c94,one)
    & refer(c94,det)
    & varia(c94,con)
    & sort(c95,na)
    & card(c95,int1)
    & etype(c95,int0)
    & fact(c95,real)
    & gener(c95,sp)
    & quant(c95,one)
    & refer(c95,indet)
    & varia(c95,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(rom_0,fe)
    & sort(erw__344hnenswert_1_1,ql)
    & sort(prop_0,st)
    & fact(prop_0,real)
    & gener(prop_0,gener_c) ) ).

%------------------------------------------------------------------------------
