%------------------------------------------------------------------------------
% File     : CSR114+11 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : In which Italian city can you find the Colosseum?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_004_mira_news_631_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.40 v9.1.0, 0.33 v9.0.0, 0.31 v8.2.0, 0.20 v8.1.0, 0.21 v7.5.0, 0.38 v7.4.0, 0.31 v7.3.0, 0.43 v7.2.0, 0.33 v7.1.0, 0.25 v7.0.0, 0.43 v6.4.0, 0.29 v6.3.0, 0.31 v6.2.0, 0.45 v6.1.0, 0.60 v6.0.0, 0.50 v5.5.0, 0.58 v5.4.0, 0.57 v5.3.0, 0.74 v5.2.0, 0.57 v5.0.0, 0.60 v4.1.0, 0.72 v4.0.1, 0.74 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 11038 (   0 equ)
%            Maximal formula atoms :  334 (   1 avg)
%            Number of connectives :  849 (   0   ~;  18   |; 705   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  334 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   88 (  88 usr;   0 prp; 2-11 aty)
%            Number of functors    : 16675 (16675 usr;16674 con; 0-2 aty)
%            Number of variables   :  473 ( 405   !;  68   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_004_mira_news_631,conjecture,
    ? [X0,X1,X2,X3,X4] :
      ( in(X2,X0)
      & attr(X0,X1)
      & loc(X4,X2)
      & scar(X4,X3)
      & sub(X1,name_1_1)
      & subs(X4,stehen_1_1) ) ).

fof(ave07_era5_synth_qa07_004_mira_news_631,hypothesis,
    ( tupl(c220,c36,c48)
    & attr(c36,c37)
    & attr(c36,c405)
    & prop(c36,sizilianisch_1_1)
    & sub(c36,stadt__1_1)
    & sub(c37,name_1_1)
    & val(c37,messina_0)
    & subs(c374,arretierung_1_1)
    & attr(c381,c382)
    & sub(c381,mensch_1_1)
    & sub(c382,eigenname_1_1)
    & val(c382,sebastiano_0)
    & attr(c385,c386)
    & sub(c385,stadt__1_1)
    & sub(c386,name_1_1)
    & val(c386,ferrara_0)
    & sub(c387,nummer_1_1)
    & subm(c388,c392)
    & sub(c392,gangstersyndikat_1_1)
    & sub(c405,name_1_1)
    & val(c405,messina_0)
    & prop(c417,italienisch__1_1)
    & sub(c417,polizei__1_1)
    & sub(c421,montag__1_1)
    & prop(c441,weit_1_1)
    & subs(c441,schlag_1_1)
    & prop(c448,organisiert_1_1)
    & sub(c448,kriminalitaet_1_1)
    & attr(c48,c49)
    & attr(c48,c50)
    & sub(c49,tag_1_1)
    & val(c49,c46)
    & sub(c50,monat_1_1)
    & val(c50,c47)
    & tupl_p11(c580,c374,c381,c385,c387,c388,c36,c417,c421,c441,c448)
    & chsp2(organisieren_1_1,organisiert_1_1)
    & sort(c220,ent)
    & card(c220,card_c)
    & etype(c220,etype_c)
    & fact(c220,real)
    & gener(c220,gener_c)
    & quant(c220,quant_c)
    & refer(c220,refer_c)
    & varia(c220,varia_c)
    & sort(c36,d)
    & sort(c36,io)
    & card(c36,int1)
    & etype(c36,int0)
    & fact(c36,real)
    & gener(c36,sp)
    & quant(c36,one)
    & refer(c36,det)
    & varia(c36,con)
    & sort(c48,t)
    & card(c48,int1)
    & etype(c48,int0)
    & fact(c48,real)
    & gener(c48,sp)
    & quant(c48,one)
    & refer(c48,det)
    & varia(c48,con)
    & sort(c37,na)
    & card(c37,int1)
    & etype(c37,int0)
    & fact(c37,real)
    & gener(c37,sp)
    & quant(c37,one)
    & refer(c37,indet)
    & varia(c37,varia_c)
    & sort(c405,na)
    & card(c405,int1)
    & etype(c405,int0)
    & fact(c405,real)
    & gener(c405,sp)
    & quant(c405,one)
    & refer(c405,indet)
    & varia(c405,varia_c)
    & sort(sizilianisch_1_1,ql)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(messina_0,fe)
    & sort(c374,ad)
    & card(c374,int1)
    & etype(c374,int0)
    & fact(c374,real)
    & gener(c374,sp)
    & quant(c374,one)
    & refer(c374,det)
    & varia(c374,con)
    & sort(arretierung_1_1,ad)
    & card(arretierung_1_1,int1)
    & etype(arretierung_1_1,int0)
    & fact(arretierung_1_1,real)
    & gener(arretierung_1_1,ge)
    & quant(arretierung_1_1,one)
    & refer(arretierung_1_1,refer_c)
    & varia(arretierung_1_1,varia_c)
    & sort(c381,d)
    & card(c381,int1)
    & etype(c381,int0)
    & fact(c381,real)
    & gener(c381,sp)
    & quant(c381,one)
    & refer(c381,det)
    & varia(c381,con)
    & sort(c382,na)
    & card(c382,int1)
    & etype(c382,int0)
    & fact(c382,real)
    & gener(c382,sp)
    & quant(c382,one)
    & refer(c382,indet)
    & varia(c382,varia_c)
    & sort(mensch_1_1,d)
    & card(mensch_1_1,int1)
    & etype(mensch_1_1,int0)
    & fact(mensch_1_1,real)
    & gener(mensch_1_1,ge)
    & quant(mensch_1_1,one)
    & refer(mensch_1_1,refer_c)
    & varia(mensch_1_1,varia_c)
    & sort(eigenname_1_1,na)
    & card(eigenname_1_1,int1)
    & etype(eigenname_1_1,int0)
    & fact(eigenname_1_1,real)
    & gener(eigenname_1_1,ge)
    & quant(eigenname_1_1,one)
    & refer(eigenname_1_1,refer_c)
    & varia(eigenname_1_1,varia_c)
    & sort(sebastiano_0,fe)
    & sort(c385,d)
    & sort(c385,io)
    & card(c385,int1)
    & etype(c385,int0)
    & fact(c385,real)
    & gener(c385,sp)
    & quant(c385,one)
    & refer(c385,det)
    & varia(c385,con)
    & sort(c386,na)
    & card(c386,int1)
    & etype(c386,int0)
    & fact(c386,real)
    & gener(c386,sp)
    & quant(c386,one)
    & refer(c386,indet)
    & varia(c386,varia_c)
    & sort(ferrara_0,fe)
    & sort(c387,d)
    & sort(c387,io)
    & card(c387,int1)
    & etype(c387,int0)
    & fact(c387,real)
    & gener(c387,gener_c)
    & quant(c387,one)
    & refer(c387,refer_c)
    & varia(c387,varia_c)
    & sort(nummer_1_1,d)
    & sort(nummer_1_1,io)
    & card(nummer_1_1,int1)
    & etype(nummer_1_1,int0)
    & fact(nummer_1_1,real)
    & gener(nummer_1_1,ge)
    & quant(nummer_1_1,one)
    & refer(nummer_1_1,refer_c)
    & varia(nummer_1_1,varia_c)
    & sort(c388,d)
    & sort(c388,io)
    & card(c388,int2)
    & etype(c388,int1)
    & fact(c388,real)
    & gener(c388,sp)
    & quant(c388,nfquant)
    & refer(c388,det)
    & varia(c388,varia_c)
    & sort(c392,d)
    & sort(c392,io)
    & card(c392,int1)
    & etype(c392,int1)
    & fact(c392,real)
    & gener(c392,sp)
    & quant(c392,one)
    & refer(c392,det)
    & varia(c392,con)
    & sort(gangstersyndikat_1_1,d)
    & sort(gangstersyndikat_1_1,io)
    & card(gangstersyndikat_1_1,card_c)
    & etype(gangstersyndikat_1_1,int1)
    & fact(gangstersyndikat_1_1,real)
    & gener(gangstersyndikat_1_1,ge)
    & quant(gangstersyndikat_1_1,quant_c)
    & refer(gangstersyndikat_1_1,refer_c)
    & varia(gangstersyndikat_1_1,varia_c)
    & sort(c417,d)
    & sort(c417,io)
    & card(c417,int1)
    & etype(c417,int0)
    & fact(c417,real)
    & gener(c417,sp)
    & quant(c417,one)
    & refer(c417,det)
    & varia(c417,con)
    & sort(italienisch__1_1,nq)
    & sort(polizei__1_1,d)
    & sort(polizei__1_1,io)
    & card(polizei__1_1,int1)
    & etype(polizei__1_1,int0)
    & fact(polizei__1_1,real)
    & gener(polizei__1_1,ge)
    & quant(polizei__1_1,one)
    & refer(polizei__1_1,refer_c)
    & varia(polizei__1_1,varia_c)
    & sort(c421,ta)
    & card(c421,int1)
    & etype(c421,int0)
    & fact(c421,real)
    & gener(c421,sp)
    & quant(c421,one)
    & refer(c421,det)
    & varia(c421,con)
    & sort(montag__1_1,ta)
    & card(montag__1_1,int1)
    & etype(montag__1_1,int0)
    & fact(montag__1_1,real)
    & gener(montag__1_1,ge)
    & quant(montag__1_1,one)
    & refer(montag__1_1,refer_c)
    & varia(montag__1_1,varia_c)
    & sort(c441,ad)
    & card(c441,int1)
    & etype(c441,int0)
    & fact(c441,real)
    & gener(c441,sp)
    & quant(c441,one)
    & refer(c441,indet)
    & varia(c441,varia_c)
    & sort(weit_1_1,mq)
    & sort(schlag_1_1,ad)
    & card(schlag_1_1,int1)
    & etype(schlag_1_1,int0)
    & fact(schlag_1_1,real)
    & gener(schlag_1_1,ge)
    & quant(schlag_1_1,one)
    & refer(schlag_1_1,refer_c)
    & varia(schlag_1_1,varia_c)
    & sort(c448,io)
    & sort(c448,na)
    & card(c448,int1)
    & etype(c448,int0)
    & fact(c448,real)
    & gener(c448,sp)
    & quant(c448,one)
    & refer(c448,det)
    & varia(c448,con)
    & sort(organisiert_1_1,nq)
    & sort(kriminalitaet_1_1,io)
    & sort(kriminalitaet_1_1,na)
    & card(kriminalitaet_1_1,int1)
    & etype(kriminalitaet_1_1,int0)
    & fact(kriminalitaet_1_1,real)
    & gener(kriminalitaet_1_1,ge)
    & quant(kriminalitaet_1_1,one)
    & refer(kriminalitaet_1_1,refer_c)
    & varia(kriminalitaet_1_1,varia_c)
    & sort(c49,me)
    & sort(c49,oa)
    & sort(c49,ta)
    & card(c49,card_c)
    & etype(c49,etype_c)
    & fact(c49,real)
    & gener(c49,sp)
    & quant(c49,quant_c)
    & refer(c49,refer_c)
    & varia(c49,varia_c)
    & sort(c50,me)
    & sort(c50,oa)
    & sort(c50,ta)
    & card(c50,card_c)
    & etype(c50,etype_c)
    & fact(c50,real)
    & gener(c50,sp)
    & quant(c50,quant_c)
    & refer(c50,refer_c)
    & varia(c50,varia_c)
    & sort(tag_1_1,me)
    & sort(tag_1_1,oa)
    & sort(tag_1_1,ta)
    & card(tag_1_1,card_c)
    & etype(tag_1_1,etype_c)
    & fact(tag_1_1,real)
    & gener(tag_1_1,ge)
    & quant(tag_1_1,quant_c)
    & refer(tag_1_1,refer_c)
    & varia(tag_1_1,varia_c)
    & sort(c46,nu)
    & card(c46,int28)
    & sort(monat_1_1,me)
    & sort(monat_1_1,oa)
    & sort(monat_1_1,ta)
    & card(monat_1_1,card_c)
    & etype(monat_1_1,etype_c)
    & fact(monat_1_1,real)
    & gener(monat_1_1,ge)
    & quant(monat_1_1,quant_c)
    & refer(monat_1_1,refer_c)
    & varia(monat_1_1,varia_c)
    & sort(c47,nu)
    & card(c47,int3)
    & sort(c580,ent)
    & card(c580,card_c)
    & etype(c580,etype_c)
    & fact(c580,real)
    & gener(c580,gener_c)
    & quant(c580,quant_c)
    & refer(c580,refer_c)
    & varia(c580,varia_c)
    & sort(organisieren_1_1,da)
    & fact(organisieren_1_1,real)
    & gener(organisieren_1_1,ge) ) ).

%------------------------------------------------------------------------------
