%------------------------------------------------------------------------------
% File     : CSR113+9 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Where can you find the Statue of Liberty?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_003_mira_wp_176_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.35 v9.1.0, 0.47 v9.0.0, 0.31 v8.2.0, 0.33 v8.1.0, 0.36 v7.5.0, 0.43 v7.4.0, 0.38 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.50 v6.3.0, 0.54 v6.2.0, 0.73 v6.1.0, 0.72 v6.0.0, 0.50 v5.5.0, 0.75 v5.4.0, 0.70 v5.3.0, 0.78 v5.2.0, 0.57 v5.0.0, 0.65 v4.1.0, 0.61 v4.0.1, 0.68 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10960 (   0 equ)
%            Maximal formula atoms :  258 (   1 avg)
%            Number of connectives :  771 (   0   ~;  18   |; 627   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  258 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-12 aty)
%            Number of functors    : 16663 (16663 usr;16662 con; 0-2 aty)
%            Number of variables   :  472 ( 405   !;  67   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_003_mira_wp_176,conjecture,
    ? [X0,X1,X2,X3] :
      ( attr(X1,X0)
      & scar(X2,X3)
      & sub(X0,name_1_1)
      & val(X0,usa_0) ) ).

fof(ave07_era5_synth_qa07_003_mira_wp_176,hypothesis,
    ( sub(c17877,freiheitsstatue_1_1)
    & attr(c17884,c17885)
    & sub(c17884,stadt__1_1)
    & sub(c17885,name_1_1)
    & val(c17885,new_york_0)
    & sub(c17888,fackel_1_1)
    & sub(c17893,buch__1_1)
    & sub(c17899,zeichen_1_1)
    & attr(c17910,c17911)
    & sub(c17910,land_1_1)
    & sub(c17911,name_1_1)
    & val(c17911,usa_0)
    & pred(c17913,b__374rger__1_1)
    & sub(c17919,zugang_1_1)
    & subs(c17925,bildung_1_1)
    & subs(c17930,erreichen_2_1)
    & attr(c17940,c17941)
    & sub(c17940,stadt__1_1)
    & sub(c17941,name_1_1)
    & val(c17941,wissen_0)
    & tupl_p12(c18018,c17877,c17884,c17888,c17893,c17899,c17910,c17913,c17919,c17925,c17930,c17940)
    & assoc(freiheitsstatue_1_1,freiheit_1_1)
    & sub(freiheitsstatue_1_1,statue_1_1)
    & sort(c17877,d)
    & card(c17877,int1)
    & etype(c17877,int0)
    & fact(c17877,real)
    & gener(c17877,sp)
    & quant(c17877,one)
    & refer(c17877,det)
    & varia(c17877,con)
    & sort(freiheitsstatue_1_1,d)
    & card(freiheitsstatue_1_1,int1)
    & etype(freiheitsstatue_1_1,int0)
    & fact(freiheitsstatue_1_1,real)
    & gener(freiheitsstatue_1_1,ge)
    & quant(freiheitsstatue_1_1,one)
    & refer(freiheitsstatue_1_1,refer_c)
    & varia(freiheitsstatue_1_1,varia_c)
    & sort(c17884,d)
    & sort(c17884,io)
    & card(c17884,int1)
    & etype(c17884,int0)
    & fact(c17884,real)
    & gener(c17884,sp)
    & quant(c17884,one)
    & refer(c17884,det)
    & varia(c17884,con)
    & sort(c17885,na)
    & card(c17885,int1)
    & etype(c17885,int0)
    & fact(c17885,real)
    & gener(c17885,sp)
    & quant(c17885,one)
    & refer(c17885,indet)
    & varia(c17885,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(new_york_0,fe)
    & sort(c17888,d)
    & card(c17888,int1)
    & etype(c17888,int0)
    & fact(c17888,real)
    & gener(c17888,sp)
    & quant(c17888,one)
    & refer(c17888,indet)
    & varia(c17888,varia_c)
    & sort(fackel_1_1,d)
    & card(fackel_1_1,int1)
    & etype(fackel_1_1,int0)
    & fact(fackel_1_1,real)
    & gener(fackel_1_1,ge)
    & quant(fackel_1_1,one)
    & refer(fackel_1_1,refer_c)
    & varia(fackel_1_1,varia_c)
    & sort(c17893,d)
    & sort(c17893,io)
    & card(c17893,int1)
    & etype(c17893,int0)
    & fact(c17893,real)
    & gener(c17893,sp)
    & quant(c17893,one)
    & refer(c17893,indet)
    & varia(c17893,varia_c)
    & sort(buch__1_1,d)
    & sort(buch__1_1,io)
    & card(buch__1_1,int1)
    & etype(buch__1_1,int0)
    & fact(buch__1_1,real)
    & gener(buch__1_1,ge)
    & quant(buch__1_1,one)
    & refer(buch__1_1,refer_c)
    & varia(buch__1_1,varia_c)
    & sort(c17899,io)
    & card(c17899,int1)
    & etype(c17899,int0)
    & fact(c17899,real)
    & gener(c17899,sp)
    & quant(c17899,one)
    & refer(c17899,det)
    & varia(c17899,con)
    & sort(zeichen_1_1,io)
    & card(zeichen_1_1,int1)
    & etype(zeichen_1_1,int0)
    & fact(zeichen_1_1,real)
    & gener(zeichen_1_1,ge)
    & quant(zeichen_1_1,one)
    & refer(zeichen_1_1,refer_c)
    & varia(zeichen_1_1,varia_c)
    & sort(c17910,d)
    & sort(c17910,io)
    & card(c17910,int1)
    & etype(c17910,int0)
    & fact(c17910,real)
    & gener(c17910,sp)
    & quant(c17910,one)
    & refer(c17910,det)
    & varia(c17910,con)
    & sort(c17911,na)
    & card(c17911,int1)
    & etype(c17911,int0)
    & fact(c17911,real)
    & gener(c17911,sp)
    & quant(c17911,one)
    & refer(c17911,indet)
    & varia(c17911,varia_c)
    & sort(land_1_1,d)
    & sort(land_1_1,io)
    & card(land_1_1,int1)
    & etype(land_1_1,int0)
    & fact(land_1_1,real)
    & gener(land_1_1,ge)
    & quant(land_1_1,one)
    & refer(land_1_1,refer_c)
    & varia(land_1_1,varia_c)
    & sort(usa_0,fe)
    & sort(c17913,d)
    & card(c17913,cons(x_constant,cons(int1,nil)))
    & etype(c17913,int1)
    & fact(c17913,real)
    & gener(c17913,gener_c)
    & quant(c17913,all)
    & refer(c17913,det)
    & varia(c17913,con)
    & sort(b__374rger__1_1,d)
    & card(b__374rger__1_1,int1)
    & etype(b__374rger__1_1,int0)
    & fact(b__374rger__1_1,real)
    & gener(b__374rger__1_1,ge)
    & quant(b__374rger__1_1,one)
    & refer(b__374rger__1_1,refer_c)
    & varia(b__374rger__1_1,varia_c)
    & sort(c17919,d)
    & card(c17919,int1)
    & etype(c17919,int0)
    & fact(c17919,real)
    & gener(c17919,gener_c)
    & quant(c17919,one)
    & refer(c17919,refer_c)
    & varia(c17919,varia_c)
    & sort(zugang_1_1,d)
    & card(zugang_1_1,int1)
    & etype(zugang_1_1,int0)
    & fact(zugang_1_1,real)
    & gener(zugang_1_1,ge)
    & quant(zugang_1_1,one)
    & refer(zugang_1_1,refer_c)
    & varia(zugang_1_1,varia_c)
    & sort(c17925,ad)
    & card(c17925,int1)
    & etype(c17925,int0)
    & fact(c17925,real)
    & gener(c17925,sp)
    & quant(c17925,one)
    & refer(c17925,det)
    & varia(c17925,con)
    & sort(bildung_1_1,ad)
    & card(bildung_1_1,int1)
    & etype(bildung_1_1,int0)
    & fact(bildung_1_1,real)
    & gener(bildung_1_1,ge)
    & quant(bildung_1_1,one)
    & refer(bildung_1_1,refer_c)
    & varia(bildung_1_1,varia_c)
    & sort(c17930,ad)
    & card(c17930,int1)
    & etype(c17930,int0)
    & fact(c17930,real)
    & gener(c17930,sp)
    & quant(c17930,one)
    & refer(c17930,det)
    & varia(c17930,con)
    & sort(erreichen_2_1,ad)
    & card(erreichen_2_1,int1)
    & etype(erreichen_2_1,int0)
    & fact(erreichen_2_1,real)
    & gener(erreichen_2_1,ge)
    & quant(erreichen_2_1,one)
    & refer(erreichen_2_1,refer_c)
    & varia(erreichen_2_1,varia_c)
    & sort(c17940,d)
    & sort(c17940,io)
    & card(c17940,int1)
    & etype(c17940,int0)
    & fact(c17940,real)
    & gener(c17940,sp)
    & quant(c17940,one)
    & refer(c17940,det)
    & varia(c17940,con)
    & sort(c17941,na)
    & card(c17941,int1)
    & etype(c17941,int0)
    & fact(c17941,real)
    & gener(c17941,sp)
    & quant(c17941,one)
    & refer(c17941,indet)
    & varia(c17941,varia_c)
    & sort(wissen_0,fe)
    & sort(c18018,ent)
    & card(c18018,card_c)
    & etype(c18018,etype_c)
    & fact(c18018,real)
    & gener(c18018,gener_c)
    & quant(c18018,quant_c)
    & refer(c18018,refer_c)
    & varia(c18018,varia_c)
    & sort(freiheit_1_1,as)
    & sort(freiheit_1_1,io)
    & card(freiheit_1_1,int1)
    & etype(freiheit_1_1,int0)
    & fact(freiheit_1_1,real)
    & gener(freiheit_1_1,ge)
    & quant(freiheit_1_1,one)
    & refer(freiheit_1_1,refer_c)
    & varia(freiheit_1_1,varia_c)
    & sort(statue_1_1,d)
    & card(statue_1_1,int1)
    & etype(statue_1_1,int0)
    & fact(statue_1_1,real)
    & gener(statue_1_1,ge)
    & quant(statue_1_1,one)
    & refer(statue_1_1,refer_c)
    & varia(statue_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
