%------------------------------------------------------------------------------
% File     : CSR113+7 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Where can you find the Statue of Liberty?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_003_mira_news_518_a19713_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.30 v9.1.0, 0.33 v9.0.0, 0.25 v8.2.0, 0.20 v8.1.0, 0.21 v7.5.0, 0.29 v7.4.0, 0.31 v7.3.0, 0.43 v7.2.0, 0.33 v7.1.0, 0.25 v7.0.0, 0.36 v6.4.0, 0.29 v6.3.0, 0.23 v6.2.0, 0.45 v6.1.0, 0.56 v6.0.0, 0.50 v5.5.0, 0.54 v5.4.0, 0.48 v5.3.0, 0.57 v5.2.0, 0.36 v5.0.0, 0.45 v4.1.0, 0.56 v4.0.1, 0.53 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 11185 (   0 equ)
%            Maximal formula atoms :  479 (   1 avg)
%            Number of connectives :  996 (   0   ~;  18   |; 852   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  479 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   89 (  89 usr;   0 prp; 2-7 aty)
%            Number of functors    : 16685 (16685 usr;16684 con; 0-2 aty)
%            Number of variables   :  473 ( 405   !;  68   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_003_mira_news_518_a19713,conjecture,
    ? [X0,X1,X2,X3,X4] :
      ( flp(X0,X2)
      & attr(X2,X1)
      & loc(X3,X0)
      & scar(X3,X4)
      & sub(X1,name_1_1)
      & sub(X4,freiheitsstatue_1_1)
      & subs(X3,stehen_1_1)
      & val(X1,new_york_0) ) ).

fof(ave07_era5_synth_qa07_003_mira_news_518_a19713,hypothesis,
    ( pmod(c1,ehemalig_1_1,stadtvater_1_1)
    & sub(c7029,finanzierungsmodell_1_3)
    & attr(c7037,c7038)
    & sub(c7037,mensch_1_1)
    & sub(c7038,familiename_1_1)
    & val(c7038,rund_0)
    & pred(c7043,franke_1_1)
    & subs(c7053,gruendung_1_1)
    & quant_p3(c7062,c7057,jahr__1_1)
    & attr(c7066,c7075)
    & sub(c7066,spendenkonto_1_1)
    & sub(c7075,name_1_1)
    & val(c7075,rettet_den_stephansdom_0)
    & tupl_p7(c7127,c7029,c7037,c7043,c7053,c7062,c7066)
    & attch(c7136,c7143)
    & attr(c7136,c7137)
    & sub(c7136,stadt__1_1)
    & sub(c7137,name_1_1)
    & val(c7137,vienna_0)
    & attr(c7143,c7144)
    & attr(c7143,c7145)
    & sub(c7143,c1)
    & sub(c7144,eigenname_1_1)
    & val(c7144,helmut_0)
    & sub(c7145,familiename_1_1)
    & val(c7145,zilk_0)
    & dircl(c7149,c7203)
    & subs(c7149,aktion_1_1)
    & sub(c7155,idol_1_1)
    & attch(c7160,c7155)
    & benf(c7160,c7166)
    & propr(c7160,para_1_1)
    & sub(c7160,hilfeprojekt_1_1)
    & loc(c7166,c7202)
    & sub(c7166,freiheitsstatue_1_1)
    & attr(c7172,c7173)
    & sub(c7172,stadt__1_1)
    & sub(c7173,name_1_1)
    & val(c7173,new_york_0)
    & subs(c7175,leben_1_1)
    & agt(c7183,c7143)
    & assoc(c7183,c7175)
    & mcont(c7183,c7149)
    & subs(c7183,rufen_1_2)
    & in(c7202,c7172)
    & flp(c7203,c7155)
    & assoc(finanzierungsmodell_1_3,finanzierung_1_1)
    & sub(finanzierungsmodell_1_3,plan_1_1)
    & assoc(freiheitsstatue_1_1,freiheit_1_1)
    & sub(freiheitsstatue_1_1,statue_1_1)
    & assoc(hilfeprojekt_1_1,hilfe_1_1)
    & sub(hilfeprojekt_1_1,ansinnen_1_1)
    & assoc(spendenkonto_1_1,spenden_1_1)
    & sub(spendenkonto_1_1,bankkonto_1_1)
    & assoc(stadtvater_1_1,stadt__1_1)
    & sub(stadtvater_1_1,vater_1_1)
    & sort(c1,ent)
    & card(c1,card_c)
    & etype(c1,etype_c)
    & fact(c1,fact_c)
    & gener(c1,gener_c)
    & quant(c1,quant_c)
    & refer(c1,refer_c)
    & varia(c1,varia_c)
    & sort(ehemalig_1_1,tq)
    & sort(stadtvater_1_1,d)
    & card(stadtvater_1_1,int1)
    & etype(stadtvater_1_1,int0)
    & fact(stadtvater_1_1,real)
    & gener(stadtvater_1_1,ge)
    & quant(stadtvater_1_1,one)
    & refer(stadtvater_1_1,refer_c)
    & varia(stadtvater_1_1,varia_c)
    & sort(c7029,ad)
    & sort(c7029,d)
    & sort(c7029,io)
    & card(c7029,int1)
    & etype(c7029,int0)
    & fact(c7029,real)
    & gener(c7029,gener_c)
    & quant(c7029,one)
    & refer(c7029,refer_c)
    & varia(c7029,varia_c)
    & sort(finanzierungsmodell_1_3,ad)
    & sort(finanzierungsmodell_1_3,d)
    & sort(finanzierungsmodell_1_3,io)
    & card(finanzierungsmodell_1_3,int1)
    & etype(finanzierungsmodell_1_3,int0)
    & fact(finanzierungsmodell_1_3,real)
    & gener(finanzierungsmodell_1_3,ge)
    & quant(finanzierungsmodell_1_3,one)
    & refer(finanzierungsmodell_1_3,refer_c)
    & varia(finanzierungsmodell_1_3,varia_c)
    & sort(c7037,d)
    & card(c7037,int1)
    & etype(c7037,int0)
    & fact(c7037,real)
    & gener(c7037,sp)
    & quant(c7037,one)
    & refer(c7037,det)
    & varia(c7037,con)
    & sort(c7038,na)
    & card(c7038,int1)
    & etype(c7038,int0)
    & fact(c7038,real)
    & gener(c7038,sp)
    & quant(c7038,one)
    & refer(c7038,indet)
    & varia(c7038,varia_c)
    & sort(mensch_1_1,d)
    & card(mensch_1_1,int1)
    & etype(mensch_1_1,int0)
    & fact(mensch_1_1,real)
    & gener(mensch_1_1,ge)
    & quant(mensch_1_1,one)
    & refer(mensch_1_1,refer_c)
    & varia(mensch_1_1,varia_c)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(rund_0,fe)
    & sort(c7043,d)
    & card(c7043,float8400000_)
    & etype(c7043,int1)
    & fact(c7043,real)
    & gener(c7043,gener_c)
    & quant(c7043,nfquant)
    & refer(c7043,refer_c)
    & varia(c7043,varia_c)
    & sort(franke_1_1,d)
    & card(franke_1_1,int1)
    & etype(franke_1_1,int0)
    & fact(franke_1_1,real)
    & gener(franke_1_1,ge)
    & quant(franke_1_1,one)
    & refer(franke_1_1,refer_c)
    & varia(franke_1_1,varia_c)
    & sort(c7053,ad)
    & card(c7053,int1)
    & etype(c7053,int0)
    & fact(c7053,real)
    & gener(c7053,sp)
    & quant(c7053,one)
    & refer(c7053,det)
    & varia(c7053,con)
    & sort(gruendung_1_1,ad)
    & card(gruendung_1_1,int1)
    & etype(gruendung_1_1,int0)
    & fact(gruendung_1_1,real)
    & gener(gruendung_1_1,ge)
    & quant(gruendung_1_1,one)
    & refer(gruendung_1_1,refer_c)
    & varia(gruendung_1_1,varia_c)
    & sort(c7062,m)
    & sort(c7062,ta)
    & card(c7062,card_c)
    & etype(c7062,etype_c)
    & fact(c7062,real)
    & gener(c7062,gener_c)
    & quant(c7062,quant_c)
    & refer(c7062,refer_c)
    & varia(c7062,varia_c)
    & sort(c7057,nu)
    & card(c7057,int8)
    & sort(jahr__1_1,me)
    & sort(jahr__1_1,oa)
    & sort(jahr__1_1,ta)
    & card(jahr__1_1,card_c)
    & etype(jahr__1_1,etype_c)
    & fact(jahr__1_1,real)
    & gener(jahr__1_1,ge)
    & quant(jahr__1_1,quant_c)
    & refer(jahr__1_1,refer_c)
    & varia(jahr__1_1,varia_c)
    & sort(c7066,d)
    & sort(c7066,io)
    & card(c7066,int1)
    & etype(c7066,int0)
    & fact(c7066,real)
    & gener(c7066,sp)
    & quant(c7066,one)
    & refer(c7066,det)
    & varia(c7066,con)
    & sort(c7075,na)
    & card(c7075,int1)
    & etype(c7075,int0)
    & fact(c7075,real)
    & gener(c7075,sp)
    & quant(c7075,one)
    & refer(c7075,indet)
    & varia(c7075,varia_c)
    & sort(spendenkonto_1_1,d)
    & sort(spendenkonto_1_1,io)
    & card(spendenkonto_1_1,int1)
    & etype(spendenkonto_1_1,int0)
    & fact(spendenkonto_1_1,real)
    & gener(spendenkonto_1_1,ge)
    & quant(spendenkonto_1_1,one)
    & refer(spendenkonto_1_1,refer_c)
    & varia(spendenkonto_1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(rettet_den_stephansdom_0,fe)
    & sort(c7127,ent)
    & card(c7127,card_c)
    & etype(c7127,etype_c)
    & fact(c7127,real)
    & gener(c7127,gener_c)
    & quant(c7127,quant_c)
    & refer(c7127,refer_c)
    & varia(c7127,varia_c)
    & sort(c7136,d)
    & sort(c7136,io)
    & card(c7136,int1)
    & etype(c7136,int0)
    & fact(c7136,real)
    & gener(c7136,sp)
    & quant(c7136,one)
    & refer(c7136,det)
    & varia(c7136,con)
    & sort(c7143,d)
    & card(c7143,int1)
    & etype(c7143,int0)
    & fact(c7143,real)
    & gener(c7143,sp)
    & quant(c7143,one)
    & refer(c7143,det)
    & varia(c7143,varia_c)
    & sort(c7137,na)
    & card(c7137,int1)
    & etype(c7137,int0)
    & fact(c7137,real)
    & gener(c7137,sp)
    & quant(c7137,one)
    & refer(c7137,indet)
    & varia(c7137,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(vienna_0,fe)
    & sort(c7144,na)
    & card(c7144,int1)
    & etype(c7144,int0)
    & fact(c7144,real)
    & gener(c7144,sp)
    & quant(c7144,one)
    & refer(c7144,indet)
    & varia(c7144,varia_c)
    & sort(c7145,na)
    & card(c7145,int1)
    & etype(c7145,int0)
    & fact(c7145,real)
    & gener(c7145,sp)
    & quant(c7145,one)
    & refer(c7145,indet)
    & varia(c7145,varia_c)
    & sort(eigenname_1_1,na)
    & card(eigenname_1_1,int1)
    & etype(eigenname_1_1,int0)
    & fact(eigenname_1_1,real)
    & gener(eigenname_1_1,ge)
    & quant(eigenname_1_1,one)
    & refer(eigenname_1_1,refer_c)
    & varia(eigenname_1_1,varia_c)
    & sort(helmut_0,fe)
    & sort(zilk_0,fe)
    & sort(c7149,ad)
    & card(c7149,int1)
    & etype(c7149,int0)
    & fact(c7149,hypo)
    & gener(c7149,sp)
    & quant(c7149,one)
    & refer(c7149,det)
    & varia(c7149,con)
    & sort(c7203,l)
    & card(c7203,int1)
    & etype(c7203,int0)
    & fact(c7203,real)
    & gener(c7203,sp)
    & quant(c7203,one)
    & refer(c7203,det)
    & varia(c7203,con)
    & sort(aktion_1_1,ad)
    & card(aktion_1_1,int1)
    & etype(aktion_1_1,int0)
    & fact(aktion_1_1,real)
    & gener(aktion_1_1,ge)
    & quant(aktion_1_1,one)
    & refer(aktion_1_1,refer_c)
    & varia(aktion_1_1,varia_c)
    & sort(c7155,d)
    & card(c7155,int1)
    & etype(c7155,int0)
    & fact(c7155,real)
    & gener(c7155,sp)
    & quant(c7155,one)
    & refer(c7155,det)
    & varia(c7155,con)
    & sort(idol_1_1,d)
    & card(idol_1_1,int1)
    & etype(idol_1_1,int0)
    & fact(idol_1_1,real)
    & gener(idol_1_1,ge)
    & quant(idol_1_1,one)
    & refer(idol_1_1,refer_c)
    & varia(idol_1_1,varia_c)
    & sort(c7160,ad)
    & sort(c7160,io)
    & card(c7160,int1)
    & etype(c7160,int0)
    & fact(c7160,real)
    & gener(c7160,sp)
    & quant(c7160,one)
    & refer(c7160,indet)
    & varia(c7160,varia_c)
    & sort(c7166,d)
    & card(c7166,int1)
    & etype(c7166,int0)
    & fact(c7166,real)
    & gener(c7166,sp)
    & quant(c7166,one)
    & refer(c7166,det)
    & varia(c7166,con)
    & sort(para_1_1,rq)
    & sort(hilfeprojekt_1_1,ad)
    & sort(hilfeprojekt_1_1,io)
    & card(hilfeprojekt_1_1,int1)
    & etype(hilfeprojekt_1_1,int0)
    & fact(hilfeprojekt_1_1,real)
    & gener(hilfeprojekt_1_1,ge)
    & quant(hilfeprojekt_1_1,one)
    & refer(hilfeprojekt_1_1,refer_c)
    & varia(hilfeprojekt_1_1,varia_c)
    & sort(c7202,l)
    & card(c7202,int1)
    & etype(c7202,int0)
    & fact(c7202,real)
    & gener(c7202,sp)
    & quant(c7202,one)
    & refer(c7202,det)
    & varia(c7202,con)
    & sort(freiheitsstatue_1_1,d)
    & card(freiheitsstatue_1_1,int1)
    & etype(freiheitsstatue_1_1,int0)
    & fact(freiheitsstatue_1_1,real)
    & gener(freiheitsstatue_1_1,ge)
    & quant(freiheitsstatue_1_1,one)
    & refer(freiheitsstatue_1_1,refer_c)
    & varia(freiheitsstatue_1_1,varia_c)
    & sort(c7172,d)
    & sort(c7172,io)
    & card(c7172,int1)
    & etype(c7172,int0)
    & fact(c7172,real)
    & gener(c7172,sp)
    & quant(c7172,one)
    & refer(c7172,det)
    & varia(c7172,con)
    & sort(c7173,na)
    & card(c7173,int1)
    & etype(c7173,int0)
    & fact(c7173,real)
    & gener(c7173,sp)
    & quant(c7173,one)
    & refer(c7173,indet)
    & varia(c7173,varia_c)
    & sort(new_york_0,fe)
    & sort(c7175,ad)
    & card(c7175,int1)
    & etype(c7175,int0)
    & fact(c7175,real)
    & gener(c7175,sp)
    & quant(c7175,one)
    & refer(c7175,det)
    & varia(c7175,con)
    & sort(leben_1_1,ad)
    & card(leben_1_1,int1)
    & etype(leben_1_1,int0)
    & fact(leben_1_1,real)
    & gener(leben_1_1,ge)
    & quant(leben_1_1,one)
    & refer(leben_1_1,refer_c)
    & varia(leben_1_1,varia_c)
    & sort(c7183,da)
    & fact(c7183,real)
    & gener(c7183,sp)
    & sort(rufen_1_2,da)
    & fact(rufen_1_2,real)
    & gener(rufen_1_2,ge)
    & sort(finanzierung_1_1,ad)
    & card(finanzierung_1_1,int1)
    & etype(finanzierung_1_1,int0)
    & fact(finanzierung_1_1,real)
    & gener(finanzierung_1_1,ge)
    & quant(finanzierung_1_1,one)
    & refer(finanzierung_1_1,refer_c)
    & varia(finanzierung_1_1,varia_c)
    & sort(plan_1_1,ad)
    & sort(plan_1_1,d)
    & sort(plan_1_1,io)
    & card(plan_1_1,int1)
    & etype(plan_1_1,int0)
    & fact(plan_1_1,real)
    & gener(plan_1_1,ge)
    & quant(plan_1_1,one)
    & refer(plan_1_1,refer_c)
    & varia(plan_1_1,varia_c)
    & sort(freiheit_1_1,as)
    & sort(freiheit_1_1,io)
    & card(freiheit_1_1,int1)
    & etype(freiheit_1_1,int0)
    & fact(freiheit_1_1,real)
    & gener(freiheit_1_1,ge)
    & quant(freiheit_1_1,one)
    & refer(freiheit_1_1,refer_c)
    & varia(freiheit_1_1,varia_c)
    & sort(statue_1_1,d)
    & card(statue_1_1,int1)
    & etype(statue_1_1,int0)
    & fact(statue_1_1,real)
    & gener(statue_1_1,ge)
    & quant(statue_1_1,one)
    & refer(statue_1_1,refer_c)
    & varia(statue_1_1,varia_c)
    & sort(hilfe_1_1,ad)
    & sort(hilfe_1_1,io)
    & card(hilfe_1_1,int1)
    & etype(hilfe_1_1,int0)
    & fact(hilfe_1_1,real)
    & gener(hilfe_1_1,ge)
    & quant(hilfe_1_1,one)
    & refer(hilfe_1_1,refer_c)
    & varia(hilfe_1_1,varia_c)
    & sort(ansinnen_1_1,ad)
    & sort(ansinnen_1_1,io)
    & card(ansinnen_1_1,int1)
    & etype(ansinnen_1_1,int0)
    & fact(ansinnen_1_1,real)
    & gener(ansinnen_1_1,ge)
    & quant(ansinnen_1_1,one)
    & refer(ansinnen_1_1,refer_c)
    & varia(ansinnen_1_1,varia_c)
    & sort(spenden_1_1,da)
    & fact(spenden_1_1,real)
    & gener(spenden_1_1,ge)
    & sort(bankkonto_1_1,d)
    & sort(bankkonto_1_1,io)
    & card(bankkonto_1_1,int1)
    & etype(bankkonto_1_1,int0)
    & fact(bankkonto_1_1,real)
    & gener(bankkonto_1_1,ge)
    & quant(bankkonto_1_1,one)
    & refer(bankkonto_1_1,refer_c)
    & varia(bankkonto_1_1,varia_c)
    & sort(vater_1_1,d)
    & card(vater_1_1,int1)
    & etype(vater_1_1,int0)
    & fact(vater_1_1,real)
    & gener(vater_1_1,ge)
    & quant(vater_1_1,one)
    & refer(vater_1_1,refer_c)
    & varia(vater_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
