%------------------------------------------------------------------------------
% File     : CSR113+6 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Where can you find the Statue of Liberty?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_003_mira_news_511_a19713_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.20 v9.0.0, 0.19 v8.2.0, 0.13 v8.1.0, 0.14 v7.5.0, 0.19 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.14 v6.3.0, 0.23 v6.2.0, 0.27 v6.1.0, 0.36 v6.0.0, 0.50 v5.4.0, 0.43 v5.3.0, 0.52 v5.2.0, 0.36 v5.0.0, 0.35 v4.1.0, 0.44 v4.0.1, 0.37 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 11200 (   0 equ)
%            Maximal formula atoms :  498 (   1 avg)
%            Number of connectives : 1011 (   0   ~;  18   |; 867   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  498 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   89 (  89 usr;   0 prp; 2-8 aty)
%            Number of functors    : 16691 (16691 usr;16690 con; 0-2 aty)
%            Number of variables   :  473 ( 405   !;  68   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_003_mira_news_511_a19713,conjecture,
    ? [X0,X1,X2,X3,X4] :
      ( flp(X0,X2)
      & scar(X3,X4)
      & sub(X1,name_1_1)
      & val(X1,new_york_0) ) ).

fof(ave07_era5_synth_qa07_003_mira_news_511_a19713,hypothesis,
    ( obj(c1519,c1522)
    & subs(c1519,skizzensammlung_1_1)
    & sub(c1522,vater_1_1)
    & attch(c1526,c1522)
    & sub(c1526,freiheitsstatue_1_1)
    & attr(c1547,c1548)
    & attr(c1547,c1580)
    & attr(c1547,c25849)
    & sub(c1547,mensch_1_1)
    & sub(c1548,familiename_1_1)
    & val(c1548,colmar_0)
    & subs(c1561,aus_stellung_1_1)
    & sub(c1567,entwicklung_1_2)
    & attch(c1570,c1567)
    & sub(c1570,bildhauer_1_1)
    & pred(c1571,bartholdi_1_1)
    & sub(c1580,familiename_1_1)
    & val(c1580,colmar_0)
    & attr(c1585,c1586)
    & attr(c1585,c1587)
    & sub(c1586,tag_1_1)
    & val(c1586,c1583)
    & sub(c1587,monat_1_1)
    & val(c1587,c1584)
    & attr(c24784,c24785)
    & poss(c24784,c24787)
    & sub(c24784,stadt__1_1)
    & sub(c24785,name_1_1)
    & val(c24785,new_york_0)
    & prop(c24787,ber__374hmt_1_1)
    & sub(c24787,freiheitsstatue_1_1)
    & assoc(c24791,c25851)
    & obj(c24791,c24787)
    & ornt(c24791,c3399)
    & scar(c24791,c24784)
    & subs(c24791,schulden_2_1)
    & attr(c25819,c25820)
    & sub(c25819,mensch_1_1)
    & sub(c25820,eigenname_1_1)
    & val(c25820,freitag_0)
    & sub(c25849,familiename_1_1)
    & val(c25849,colmar_0)
    & dircl(c25851,c25867)
    & origl(c25851,c25868)
    & subs(c25851,sehen_1_6)
    & in(c25867,c1547)
    & flp(c25868,c25819)
    & itms_p4(c25870,c3385,c3388,c3392)
    & tupl_p8(c3371,c1519,c1547,c1561,c1567,c1571,c1547,c1585)
    & pred(c3385,skizze_1_1)
    & pred(c3388,entwurf_1_1)
    & pred(c3392,zeich_nung_1_1)
    & sub(c3399,bartholdi_1_1)
    & attch(c3401,c25870)
    & attr(c3401,c3402)
    & prop(c3401,els__344ssisch_1_1)
    & sub(c3401,bildhauer_1_1)
    & sub(c3402,eigenname_1_1)
    & val(c3402,auguste_0)
    & assoc(freiheitsstatue_1_1,freiheit_1_1)
    & sub(freiheitsstatue_1_1,statue_1_1)
    & assoc(skizzensammlung_1_1,skizze_1_1)
    & subs(skizzensammlung_1_1,sammlung_1_1)
    & sort(c1519,ad)
    & card(c1519,int1)
    & etype(c1519,int0)
    & fact(c1519,real)
    & gener(c1519,sp)
    & quant(c1519,one)
    & refer(c1519,det)
    & varia(c1519,varia_c)
    & sort(c1522,d)
    & card(c1522,int1)
    & etype(c1522,int0)
    & fact(c1522,real)
    & gener(c1522,sp)
    & quant(c1522,one)
    & refer(c1522,det)
    & varia(c1522,con)
    & sort(skizzensammlung_1_1,ad)
    & card(skizzensammlung_1_1,int1)
    & etype(skizzensammlung_1_1,int0)
    & fact(skizzensammlung_1_1,real)
    & gener(skizzensammlung_1_1,ge)
    & quant(skizzensammlung_1_1,one)
    & refer(skizzensammlung_1_1,refer_c)
    & varia(skizzensammlung_1_1,varia_c)
    & sort(vater_1_1,d)
    & card(vater_1_1,int1)
    & etype(vater_1_1,int0)
    & fact(vater_1_1,real)
    & gener(vater_1_1,ge)
    & quant(vater_1_1,one)
    & refer(vater_1_1,refer_c)
    & varia(vater_1_1,varia_c)
    & sort(c1526,d)
    & card(c1526,int1)
    & etype(c1526,int0)
    & fact(c1526,real)
    & gener(c1526,sp)
    & quant(c1526,one)
    & refer(c1526,det)
    & varia(c1526,con)
    & sort(freiheitsstatue_1_1,d)
    & card(freiheitsstatue_1_1,int1)
    & etype(freiheitsstatue_1_1,int0)
    & fact(freiheitsstatue_1_1,real)
    & gener(freiheitsstatue_1_1,ge)
    & quant(freiheitsstatue_1_1,one)
    & refer(freiheitsstatue_1_1,refer_c)
    & varia(freiheitsstatue_1_1,varia_c)
    & sort(c1547,d)
    & card(c1547,int1)
    & etype(c1547,int0)
    & fact(c1547,real)
    & gener(c1547,sp)
    & quant(c1547,one)
    & refer(c1547,det)
    & varia(c1547,con)
    & sort(c1548,na)
    & card(c1548,int1)
    & etype(c1548,int0)
    & fact(c1548,real)
    & gener(c1548,sp)
    & quant(c1548,one)
    & refer(c1548,indet)
    & varia(c1548,varia_c)
    & sort(c1580,na)
    & card(c1580,int1)
    & etype(c1580,int0)
    & fact(c1580,real)
    & gener(c1580,sp)
    & quant(c1580,one)
    & refer(c1580,indet)
    & varia(c1580,varia_c)
    & sort(c25849,na)
    & card(c25849,int1)
    & etype(c25849,int0)
    & fact(c25849,real)
    & gener(c25849,sp)
    & quant(c25849,one)
    & refer(c25849,indet)
    & varia(c25849,varia_c)
    & sort(mensch_1_1,d)
    & card(mensch_1_1,int1)
    & etype(mensch_1_1,int0)
    & fact(mensch_1_1,real)
    & gener(mensch_1_1,ge)
    & quant(mensch_1_1,one)
    & refer(mensch_1_1,refer_c)
    & varia(mensch_1_1,varia_c)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(colmar_0,fe)
    & sort(c1561,ad)
    & card(c1561,int1)
    & etype(c1561,int0)
    & fact(c1561,real)
    & gener(c1561,gener_c)
    & quant(c1561,one)
    & refer(c1561,refer_c)
    & varia(c1561,varia_c)
    & sort(aus_stellung_1_1,ad)
    & card(aus_stellung_1_1,int1)
    & etype(aus_stellung_1_1,int0)
    & fact(aus_stellung_1_1,real)
    & gener(aus_stellung_1_1,ge)
    & quant(aus_stellung_1_1,one)
    & refer(aus_stellung_1_1,refer_c)
    & varia(aus_stellung_1_1,varia_c)
    & sort(c1567,o)
    & card(c1567,int1)
    & etype(c1567,int0)
    & fact(c1567,real)
    & gener(c1567,sp)
    & quant(c1567,one)
    & refer(c1567,det)
    & varia(c1567,varia_c)
    & sort(entwicklung_1_2,o)
    & card(entwicklung_1_2,int1)
    & etype(entwicklung_1_2,int0)
    & fact(entwicklung_1_2,real)
    & gener(entwicklung_1_2,ge)
    & quant(entwicklung_1_2,one)
    & refer(entwicklung_1_2,refer_c)
    & varia(entwicklung_1_2,varia_c)
    & sort(c1570,d)
    & card(c1570,int1)
    & etype(c1570,int0)
    & fact(c1570,real)
    & gener(c1570,sp)
    & quant(c1570,one)
    & refer(c1570,det)
    & varia(c1570,con)
    & sort(bildhauer_1_1,d)
    & card(bildhauer_1_1,int1)
    & etype(bildhauer_1_1,int0)
    & fact(bildhauer_1_1,real)
    & gener(bildhauer_1_1,ge)
    & quant(bildhauer_1_1,one)
    & refer(bildhauer_1_1,refer_c)
    & varia(bildhauer_1_1,varia_c)
    & sort(c1571,o)
    & card(c1571,cons(x_constant,cons(int1,nil)))
    & etype(c1571,int1)
    & fact(c1571,real)
    & gener(c1571,gener_c)
    & quant(c1571,mult)
    & refer(c1571,indet)
    & varia(c1571,varia_c)
    & sort(bartholdi_1_1,o)
    & card(bartholdi_1_1,int1)
    & etype(bartholdi_1_1,int0)
    & fact(bartholdi_1_1,real)
    & gener(bartholdi_1_1,ge)
    & quant(bartholdi_1_1,one)
    & refer(bartholdi_1_1,refer_c)
    & varia(bartholdi_1_1,varia_c)
    & sort(c1585,t)
    & card(c1585,int1)
    & etype(c1585,int0)
    & fact(c1585,real)
    & gener(c1585,sp)
    & quant(c1585,one)
    & refer(c1585,det)
    & varia(c1585,con)
    & sort(c1586,me)
    & sort(c1586,oa)
    & sort(c1586,ta)
    & card(c1586,card_c)
    & etype(c1586,etype_c)
    & fact(c1586,real)
    & gener(c1586,sp)
    & quant(c1586,quant_c)
    & refer(c1586,refer_c)
    & varia(c1586,varia_c)
    & sort(c1587,me)
    & sort(c1587,oa)
    & sort(c1587,ta)
    & card(c1587,card_c)
    & etype(c1587,etype_c)
    & fact(c1587,real)
    & gener(c1587,sp)
    & quant(c1587,quant_c)
    & refer(c1587,refer_c)
    & varia(c1587,varia_c)
    & sort(tag_1_1,me)
    & sort(tag_1_1,oa)
    & sort(tag_1_1,ta)
    & card(tag_1_1,card_c)
    & etype(tag_1_1,etype_c)
    & fact(tag_1_1,real)
    & gener(tag_1_1,ge)
    & quant(tag_1_1,quant_c)
    & refer(tag_1_1,refer_c)
    & varia(tag_1_1,varia_c)
    & sort(c1583,nu)
    & card(c1583,int13)
    & sort(monat_1_1,me)
    & sort(monat_1_1,oa)
    & sort(monat_1_1,ta)
    & card(monat_1_1,card_c)
    & etype(monat_1_1,etype_c)
    & fact(monat_1_1,real)
    & gener(monat_1_1,ge)
    & quant(monat_1_1,quant_c)
    & refer(monat_1_1,refer_c)
    & varia(monat_1_1,varia_c)
    & sort(c1584,nu)
    & card(c1584,int9)
    & sort(c24784,d)
    & sort(c24784,io)
    & card(c24784,int1)
    & etype(c24784,int0)
    & fact(c24784,real)
    & gener(c24784,sp)
    & quant(c24784,one)
    & refer(c24784,det)
    & varia(c24784,con)
    & sort(c24785,na)
    & card(c24785,int1)
    & etype(c24785,int0)
    & fact(c24785,real)
    & gener(c24785,sp)
    & quant(c24785,one)
    & refer(c24785,indet)
    & varia(c24785,varia_c)
    & sort(c24787,d)
    & card(c24787,int1)
    & etype(c24787,int0)
    & fact(c24787,real)
    & gener(c24787,sp)
    & quant(c24787,one)
    & refer(c24787,det)
    & varia(c24787,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(new_york_0,fe)
    & sort(ber__374hmt_1_1,nq)
    & sort(c24791,st)
    & fact(c24791,real)
    & gener(c24791,sp)
    & sort(c25851,da)
    & fact(c25851,real)
    & gener(c25851,sp)
    & sort(c3399,o)
    & card(c3399,int1)
    & etype(c3399,int0)
    & fact(c3399,real)
    & gener(c3399,sp)
    & quant(c3399,one)
    & refer(c3399,refer_c)
    & varia(c3399,varia_c)
    & sort(schulden_2_1,st)
    & fact(schulden_2_1,real)
    & gener(schulden_2_1,ge)
    & sort(c25819,d)
    & card(c25819,int1)
    & etype(c25819,int0)
    & fact(c25819,real)
    & gener(c25819,sp)
    & quant(c25819,one)
    & refer(c25819,det)
    & varia(c25819,con)
    & sort(c25820,na)
    & card(c25820,int1)
    & etype(c25820,int0)
    & fact(c25820,real)
    & gener(c25820,sp)
    & quant(c25820,one)
    & refer(c25820,indet)
    & varia(c25820,varia_c)
    & sort(eigenname_1_1,na)
    & card(eigenname_1_1,int1)
    & etype(eigenname_1_1,int0)
    & fact(eigenname_1_1,real)
    & gener(eigenname_1_1,ge)
    & quant(eigenname_1_1,one)
    & refer(eigenname_1_1,refer_c)
    & varia(eigenname_1_1,varia_c)
    & sort(freitag_0,fe)
    & sort(c25867,l)
    & card(c25867,int1)
    & etype(c25867,int0)
    & fact(c25867,real)
    & gener(c25867,sp)
    & quant(c25867,one)
    & refer(c25867,det)
    & varia(c25867,con)
    & sort(c25868,l)
    & card(c25868,int1)
    & etype(c25868,int0)
    & fact(c25868,real)
    & gener(c25868,sp)
    & quant(c25868,one)
    & refer(c25868,det)
    & varia(c25868,con)
    & sort(sehen_1_6,da)
    & fact(sehen_1_6,real)
    & gener(sehen_1_6,ge)
    & sort(c25870,ad)
    & sort(c25870,d)
    & sort(c25870,io)
    & card(c25870,int3)
    & etype(c25870,int2)
    & fact(c25870,real)
    & gener(c25870,gener_c)
    & quant(c25870,nfquant)
    & refer(c25870,refer_c)
    & varia(c25870,varia_c)
    & sort(c3385,d)
    & sort(c3385,io)
    & card(c3385,int37)
    & etype(c3385,int1)
    & fact(c3385,real)
    & gener(c3385,gener_c)
    & quant(c3385,nfquant)
    & refer(c3385,refer_c)
    & varia(c3385,varia_c)
    & sort(c3388,ad)
    & sort(c3388,d)
    & sort(c3388,io)
    & card(c3388,cons(x_constant,cons(int1,nil)))
    & etype(c3388,int1)
    & fact(c3388,real)
    & gener(c3388,gener_c)
    & quant(c3388,mult)
    & refer(c3388,indet)
    & varia(c3388,varia_c)
    & sort(c3392,d)
    & sort(c3392,io)
    & card(c3392,cons(x_constant,cons(int1,nil)))
    & etype(c3392,int1)
    & fact(c3392,real)
    & gener(c3392,sp)
    & quant(c3392,mult)
    & refer(c3392,indet)
    & varia(c3392,varia_c)
    & sort(c3371,ent)
    & card(c3371,card_c)
    & etype(c3371,etype_c)
    & fact(c3371,real)
    & gener(c3371,gener_c)
    & quant(c3371,quant_c)
    & refer(c3371,refer_c)
    & varia(c3371,varia_c)
    & sort(skizze_1_1,d)
    & sort(skizze_1_1,io)
    & card(skizze_1_1,int1)
    & etype(skizze_1_1,int0)
    & fact(skizze_1_1,real)
    & gener(skizze_1_1,ge)
    & quant(skizze_1_1,one)
    & refer(skizze_1_1,refer_c)
    & varia(skizze_1_1,varia_c)
    & sort(entwurf_1_1,ad)
    & sort(entwurf_1_1,d)
    & sort(entwurf_1_1,io)
    & card(entwurf_1_1,int1)
    & etype(entwurf_1_1,int0)
    & fact(entwurf_1_1,real)
    & gener(entwurf_1_1,ge)
    & quant(entwurf_1_1,one)
    & refer(entwurf_1_1,refer_c)
    & varia(entwurf_1_1,varia_c)
    & sort(zeich_nung_1_1,d)
    & sort(zeich_nung_1_1,io)
    & card(zeich_nung_1_1,int1)
    & etype(zeich_nung_1_1,int0)
    & fact(zeich_nung_1_1,real)
    & gener(zeich_nung_1_1,ge)
    & quant(zeich_nung_1_1,one)
    & refer(zeich_nung_1_1,refer_c)
    & varia(zeich_nung_1_1,varia_c)
    & sort(c3401,d)
    & card(c3401,int1)
    & etype(c3401,int0)
    & fact(c3401,real)
    & gener(c3401,sp)
    & quant(c3401,one)
    & refer(c3401,det)
    & varia(c3401,con)
    & sort(c3402,na)
    & card(c3402,int1)
    & etype(c3402,int0)
    & fact(c3402,real)
    & gener(c3402,sp)
    & quant(c3402,one)
    & refer(c3402,indet)
    & varia(c3402,varia_c)
    & sort(els__344ssisch_1_1,ql)
    & sort(auguste_0,fe)
    & sort(freiheit_1_1,as)
    & sort(freiheit_1_1,io)
    & card(freiheit_1_1,int1)
    & etype(freiheit_1_1,int0)
    & fact(freiheit_1_1,real)
    & gener(freiheit_1_1,ge)
    & quant(freiheit_1_1,one)
    & refer(freiheit_1_1,refer_c)
    & varia(freiheit_1_1,varia_c)
    & sort(statue_1_1,d)
    & card(statue_1_1,int1)
    & etype(statue_1_1,int0)
    & fact(statue_1_1,real)
    & gener(statue_1_1,ge)
    & quant(statue_1_1,one)
    & refer(statue_1_1,refer_c)
    & varia(statue_1_1,varia_c)
    & sort(sammlung_1_1,ad)
    & card(sammlung_1_1,int1)
    & etype(sammlung_1_1,int0)
    & fact(sammlung_1_1,real)
    & gener(sammlung_1_1,ge)
    & quant(sammlung_1_1,one)
    & refer(sammlung_1_1,refer_c)
    & varia(sammlung_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
