%------------------------------------------------------------------------------
% File     : CSR113+4 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Where can you find the Statue of Liberty?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_003_mira_news_499_a270_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.35 v9.1.0, 0.47 v9.0.0, 0.31 v8.2.0, 0.33 v8.1.0, 0.36 v7.5.0, 0.38 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.43 v6.4.0, 0.50 v6.3.0, 0.54 v6.2.0, 0.73 v6.1.0, 0.72 v6.0.0, 0.50 v5.5.0, 0.75 v5.4.0, 0.74 v5.3.0, 0.78 v5.2.0, 0.57 v5.0.0, 0.65 v4.1.0, 0.61 v4.0.1, 0.68 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10894 (   0 equ)
%            Maximal formula atoms :  192 (   1 avg)
%            Number of connectives :  705 (   0   ~;  18   |; 561   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  192 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   88 (  88 usr;   0 prp; 2-7 aty)
%            Number of functors    : 16651 (16651 usr;16650 con; 0-2 aty)
%            Number of variables   :  472 ( 405   !;  67   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_003_mira_news_499_a270,conjecture,
    ? [X0,X1,X2,X3] :
      ( attr(X1,X0)
      & scar(X2,X3)
      & sub(X0,name_1_1)
      & val(X0,usa_0) ) ).

fof(ave07_era5_synth_qa07_003_mira_news_499_a270,hypothesis,
    ( assoc(auftaktveranstaltung_1_1,auftakt_1_1)
    & sub(auftaktveranstaltung_1_1,event_1_1)
    & sub(c103,auftaktveranstaltung_1_1)
    & poss(c108,c103)
    & attr(c113,c114)
    & prop(c113,aktuell_1_1)
    & sub(c113,land_1_1)
    & sub(c114,name_1_1)
    & val(c114,usa_0)
    & sub(c115,regierung_1_1)
    & tupl_p7(c163,c86,c95,c97,c103,c113,c115)
    & sub(c86,freiheitsstatue_1_1)
    & attr(c95,c96)
    & sub(c95,stadt__1_1)
    & sub(c96,name_1_1)
    & val(c96,new_york_0)
    & assoc(freiheitsstatue_1_1,freiheit_1_1)
    & sub(freiheitsstatue_1_1,statue_1_1)
    & sort(auftaktveranstaltung_1_1,ad)
    & sort(auftaktveranstaltung_1_1,io)
    & card(auftaktveranstaltung_1_1,int1)
    & etype(auftaktveranstaltung_1_1,int0)
    & fact(auftaktveranstaltung_1_1,real)
    & gener(auftaktveranstaltung_1_1,ge)
    & quant(auftaktveranstaltung_1_1,one)
    & refer(auftaktveranstaltung_1_1,refer_c)
    & varia(auftaktveranstaltung_1_1,varia_c)
    & sort(auftakt_1_1,ad)
    & sort(auftakt_1_1,io)
    & card(auftakt_1_1,int1)
    & etype(auftakt_1_1,int0)
    & fact(auftakt_1_1,real)
    & gener(auftakt_1_1,ge)
    & quant(auftakt_1_1,one)
    & refer(auftakt_1_1,refer_c)
    & varia(auftakt_1_1,varia_c)
    & sort(event_1_1,ad)
    & sort(event_1_1,io)
    & card(event_1_1,int1)
    & etype(event_1_1,int0)
    & fact(event_1_1,real)
    & gener(event_1_1,ge)
    & quant(event_1_1,one)
    & refer(event_1_1,refer_c)
    & varia(event_1_1,varia_c)
    & sort(c103,ad)
    & sort(c103,io)
    & card(c103,int1)
    & etype(c103,int0)
    & fact(c103,real)
    & gener(c103,sp)
    & quant(c103,one)
    & refer(c103,det)
    & varia(c103,varia_c)
    & sort(c108,o)
    & card(c108,int1)
    & etype(c108,int0)
    & fact(c108,real)
    & gener(c108,sp)
    & quant(c108,one)
    & refer(c108,det)
    & varia(c108,varia_c)
    & sort(c113,d)
    & sort(c113,io)
    & card(c113,int1)
    & etype(c113,int0)
    & fact(c113,real)
    & gener(c113,sp)
    & quant(c113,one)
    & refer(c113,det)
    & varia(c113,con)
    & sort(c114,na)
    & card(c114,int1)
    & etype(c114,int0)
    & fact(c114,real)
    & gener(c114,sp)
    & quant(c114,one)
    & refer(c114,indet)
    & varia(c114,varia_c)
    & sort(aktuell_1_1,nq)
    & sort(land_1_1,d)
    & sort(land_1_1,io)
    & card(land_1_1,int1)
    & etype(land_1_1,int0)
    & fact(land_1_1,real)
    & gener(land_1_1,ge)
    & quant(land_1_1,one)
    & refer(land_1_1,refer_c)
    & varia(land_1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(usa_0,fe)
    & sort(c115,d)
    & sort(c115,io)
    & card(c115,int1)
    & etype(c115,int1)
    & fact(c115,real)
    & gener(c115,gener_c)
    & quant(c115,one)
    & refer(c115,refer_c)
    & varia(c115,varia_c)
    & sort(regierung_1_1,d)
    & sort(regierung_1_1,io)
    & card(regierung_1_1,card_c)
    & etype(regierung_1_1,int1)
    & fact(regierung_1_1,real)
    & gener(regierung_1_1,ge)
    & quant(regierung_1_1,quant_c)
    & refer(regierung_1_1,refer_c)
    & varia(regierung_1_1,varia_c)
    & sort(c163,ent)
    & card(c163,card_c)
    & etype(c163,etype_c)
    & fact(c163,real)
    & gener(c163,gener_c)
    & quant(c163,quant_c)
    & refer(c163,refer_c)
    & varia(c163,varia_c)
    & sort(c86,d)
    & card(c86,int1)
    & etype(c86,int0)
    & fact(c86,real)
    & gener(c86,sp)
    & quant(c86,one)
    & refer(c86,det)
    & varia(c86,con)
    & sort(c95,d)
    & sort(c95,io)
    & card(c95,int1)
    & etype(c95,int0)
    & fact(c95,real)
    & gener(c95,sp)
    & quant(c95,one)
    & refer(c95,det)
    & varia(c95,con)
    & sort(c97,o)
    & card(c97,int1)
    & etype(c97,int0)
    & fact(c97,real)
    & gener(c97,sp)
    & quant(c97,one)
    & refer(c97,det)
    & varia(c97,varia_c)
    & sort(freiheitsstatue_1_1,d)
    & card(freiheitsstatue_1_1,int1)
    & etype(freiheitsstatue_1_1,int0)
    & fact(freiheitsstatue_1_1,real)
    & gener(freiheitsstatue_1_1,ge)
    & quant(freiheitsstatue_1_1,one)
    & refer(freiheitsstatue_1_1,refer_c)
    & varia(freiheitsstatue_1_1,varia_c)
    & sort(c96,na)
    & card(c96,int1)
    & etype(c96,int0)
    & fact(c96,real)
    & gener(c96,sp)
    & quant(c96,one)
    & refer(c96,indet)
    & varia(c96,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(new_york_0,fe)
    & sort(freiheit_1_1,as)
    & sort(freiheit_1_1,io)
    & card(freiheit_1_1,int1)
    & etype(freiheit_1_1,int0)
    & fact(freiheit_1_1,real)
    & gener(freiheit_1_1,ge)
    & quant(freiheit_1_1,one)
    & refer(freiheit_1_1,refer_c)
    & varia(freiheit_1_1,varia_c)
    & sort(statue_1_1,d)
    & card(statue_1_1,int1)
    & etype(statue_1_1,int0)
    & fact(statue_1_1,real)
    & gener(statue_1_1,ge)
    & quant(statue_1_1,one)
    & refer(statue_1_1,refer_c)
    & varia(statue_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
