%------------------------------------------------------------------------------
% File     : CSR113+31 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Where can you find the Statue of Liberty?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_003_qw2_50_a19713_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.35 v9.1.0, 0.40 v9.0.0, 0.25 v8.2.0, 0.27 v8.1.0, 0.29 v7.5.0, 0.38 v7.4.0, 0.31 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.50 v6.3.0, 0.54 v6.2.0, 0.73 v6.1.0, 0.68 v6.0.0, 0.50 v5.5.0, 0.67 v5.4.0, 0.65 v5.3.0, 0.74 v5.2.0, 0.50 v5.0.0, 0.60 v4.1.0, 0.61 v4.0.1, 0.68 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10891 (   0 equ)
%            Maximal formula atoms :  189 (   1 avg)
%            Number of connectives :  702 (   0   ~;  18   |; 558   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  189 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   86 (  86 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16657 (16657 usr;16656 con; 0-2 aty)
%            Number of variables   :  472 ( 405   !;  67   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_003_qw2_50_a19713,conjecture,
    ? [X0,X1,X2,X3] :
      ( attr(X1,X0)
      & scar(X2,X3)
      & sub(X0,name_1_1)
      & val(X0,new_york_0) ) ).

fof(ave07_era5_synth_qa07_003_qw2_50_a19713,hypothesis,
    ( agt(c4,c1)
    & assoc(c4,aufmerksam_1_1)
    & mcont(c4,c74)
    & obj(c4,c74)
    & ornt(c4,c70)
    & subs(c4,hinweisen_1_1)
    & attr(c70,c71)
    & sub(c70,mensch_1_1)
    & sub(c71,familiename_1_1)
    & val(c71,jacob_0)
    & mcont(c74,c97)
    & pred(c74,strophe_1_1)
    & sub(c79,freiheitsstatue_1_1)
    & attch(c84,c79)
    & attr(c84,c85)
    & sub(c84,stadt__1_1)
    & sub(c85,name_1_1)
    & val(c85,new_york_0)
    & attch(c86,c87)
    & sub(c87,verfasserin_1_1)
    & itms(c97,c79,c87)
    & assoc(freiheitsstatue_1_1,freiheit_1_1)
    & sub(freiheitsstatue_1_1,statue_1_1)
    & sort(c4,da)
    & fact(c4,real)
    & gener(c4,sp)
    & sort(c1,o)
    & card(c1,int1)
    & etype(c1,int0)
    & fact(c1,real)
    & gener(c1,sp)
    & quant(c1,one)
    & refer(c1,det)
    & varia(c1,varia_c)
    & sort(aufmerksam_1_1,nq)
    & sort(c74,d)
    & sort(c74,io)
    & card(c74,cons(x_constant,cons(int1,nil)))
    & etype(c74,int1)
    & fact(c74,hypo)
    & gener(c74,sp)
    & quant(c74,mult)
    & refer(c74,det)
    & varia(c74,con)
    & sort(c70,d)
    & card(c70,int1)
    & etype(c70,int0)
    & fact(c70,real)
    & gener(c70,sp)
    & quant(c70,one)
    & refer(c70,det)
    & varia(c70,con)
    & sort(hinweisen_1_1,da)
    & fact(hinweisen_1_1,real)
    & gener(hinweisen_1_1,ge)
    & sort(c71,na)
    & card(c71,int1)
    & etype(c71,int0)
    & fact(c71,real)
    & gener(c71,sp)
    & quant(c71,one)
    & refer(c71,indet)
    & varia(c71,varia_c)
    & sort(mensch_1_1,d)
    & card(mensch_1_1,int1)
    & etype(mensch_1_1,int0)
    & fact(mensch_1_1,real)
    & gener(mensch_1_1,ge)
    & quant(mensch_1_1,one)
    & refer(mensch_1_1,refer_c)
    & varia(mensch_1_1,varia_c)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(jacob_0,fe)
    & sort(c97,d)
    & card(c97,int2)
    & etype(c97,int1)
    & fact(c97,hypo)
    & gener(c97,sp)
    & quant(c97,nfquant)
    & refer(c97,det)
    & varia(c97,con)
    & sort(strophe_1_1,d)
    & sort(strophe_1_1,io)
    & card(strophe_1_1,int1)
    & etype(strophe_1_1,int0)
    & fact(strophe_1_1,real)
    & gener(strophe_1_1,ge)
    & quant(strophe_1_1,one)
    & refer(strophe_1_1,refer_c)
    & varia(strophe_1_1,varia_c)
    & sort(c79,d)
    & card(c79,int1)
    & etype(c79,int0)
    & fact(c79,real)
    & gener(c79,sp)
    & quant(c79,one)
    & refer(c79,det)
    & varia(c79,con)
    & sort(freiheitsstatue_1_1,d)
    & card(freiheitsstatue_1_1,int1)
    & etype(freiheitsstatue_1_1,int0)
    & fact(freiheitsstatue_1_1,real)
    & gener(freiheitsstatue_1_1,ge)
    & quant(freiheitsstatue_1_1,one)
    & refer(freiheitsstatue_1_1,refer_c)
    & varia(freiheitsstatue_1_1,varia_c)
    & sort(c84,d)
    & sort(c84,io)
    & card(c84,int1)
    & etype(c84,int0)
    & fact(c84,real)
    & gener(c84,sp)
    & quant(c84,one)
    & refer(c84,det)
    & varia(c84,con)
    & sort(c85,na)
    & card(c85,int1)
    & etype(c85,int0)
    & fact(c85,real)
    & gener(c85,sp)
    & quant(c85,one)
    & refer(c85,indet)
    & varia(c85,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(new_york_0,fe)
    & sort(c86,o)
    & card(c86,int1)
    & etype(c86,int0)
    & fact(c86,real)
    & gener(c86,sp)
    & quant(c86,one)
    & refer(c86,det)
    & varia(c86,varia_c)
    & sort(c87,d)
    & card(c87,int1)
    & etype(c87,int0)
    & fact(c87,real)
    & gener(c87,sp)
    & quant(c87,one)
    & refer(c87,det)
    & varia(c87,varia_c)
    & sort(verfasserin_1_1,d)
    & card(verfasserin_1_1,int1)
    & etype(verfasserin_1_1,int0)
    & fact(verfasserin_1_1,real)
    & gener(verfasserin_1_1,ge)
    & quant(verfasserin_1_1,one)
    & refer(verfasserin_1_1,refer_c)
    & varia(verfasserin_1_1,varia_c)
    & sort(freiheit_1_1,as)
    & sort(freiheit_1_1,io)
    & card(freiheit_1_1,int1)
    & etype(freiheit_1_1,int0)
    & fact(freiheit_1_1,real)
    & gener(freiheit_1_1,ge)
    & quant(freiheit_1_1,one)
    & refer(freiheit_1_1,refer_c)
    & varia(freiheit_1_1,varia_c)
    & sort(statue_1_1,d)
    & card(statue_1_1,int1)
    & etype(statue_1_1,int0)
    & fact(statue_1_1,real)
    & gener(statue_1_1,ge)
    & quant(statue_1_1,one)
    & refer(statue_1_1,refer_c)
    & varia(statue_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
