%------------------------------------------------------------------------------
% File     : CSR113+28 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Where can you find the Statue of Liberty?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_003_qapn_31_a19713_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.35 v9.1.0, 0.40 v9.0.0, 0.25 v8.2.0, 0.20 v8.1.0, 0.21 v7.5.0, 0.33 v7.4.0, 0.31 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.29 v6.4.0, 0.21 v6.3.0, 0.23 v6.2.0, 0.45 v6.1.0, 0.52 v6.0.0, 0.50 v5.4.0, 0.48 v5.3.0, 0.57 v5.2.0, 0.36 v5.0.0, 0.45 v4.1.0, 0.50 v4.0.1, 0.53 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10853 (   0 equ)
%            Maximal formula atoms :  148 (   1 avg)
%            Number of connectives :  664 (   0   ~;  18   |; 520   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  148 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   88 (  88 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16653 (16653 usr;16652 con; 0-2 aty)
%            Number of variables   :  473 ( 405   !;  68   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_003_qapn_31_a19713,conjecture,
    ? [X0,X1,X2,X3,X4] :
      ( flp(X0,X2)
      & loc(X3,X0)
      & scar(X3,X4)
      & sub(X1,name_1_1)
      & sub(X4,freiheitsstatue_1_1)
      & subs(X3,stehen_1_1)
      & val(X1,new_york_0) ) ).

fof(ave07_era5_synth_qa07_003_qapn_31_a19713,hypothesis,
    ( arg1(c23,c4)
    & arg2(c23,c56)
    & assoc(c23,c39)
    & subr(c23,prop_0)
    & quant_p3(c39,c25,meter_1_1)
    & prop(c4,c56)
    & sub(c4,figur_1_1)
    & loc(c44,c58)
    & sub(c44,freiheitsstatue_1_1)
    & sub(c49,bootshafen_1_1)
    & attch(c54,c49)
    & attr(c54,c55)
    & sub(c54,stadt__1_1)
    & sub(c55,name_1_1)
    & val(c55,new_york_0)
    & comp(c56,klein_1_1,c44)
    & in(c58,c49)
    & assoc(freiheitsstatue_1_1,freiheit_1_1)
    & sub(freiheitsstatue_1_1,statue_1_1)
    & sort(c23,st)
    & fact(c23,real)
    & gener(c23,sp)
    & sort(c4,d)
    & card(c4,int1)
    & etype(c4,int0)
    & fact(c4,real)
    & gener(c4,sp)
    & quant(c4,one)
    & refer(c4,det)
    & varia(c4,con)
    & sort(c56,tq)
    & sort(c39,co)
    & sort(c39,m)
    & card(c39,card_c)
    & etype(c39,etype_c)
    & fact(c39,real)
    & gener(c39,gener_c)
    & quant(c39,quant_c)
    & refer(c39,refer_c)
    & varia(c39,con)
    & sort(prop_0,st)
    & fact(prop_0,real)
    & gener(prop_0,gener_c)
    & sort(c25,nu)
    & card(c25,int5)
    & sort(meter_1_1,me)
    & gener(meter_1_1,ge)
    & sort(figur_1_1,d)
    & card(figur_1_1,int1)
    & etype(figur_1_1,int0)
    & fact(figur_1_1,real)
    & gener(figur_1_1,ge)
    & quant(figur_1_1,one)
    & refer(figur_1_1,refer_c)
    & varia(figur_1_1,varia_c)
    & sort(c44,d)
    & card(c44,int1)
    & etype(c44,int0)
    & fact(c44,real)
    & gener(c44,sp)
    & quant(c44,one)
    & refer(c44,det)
    & varia(c44,con)
    & sort(c58,l)
    & card(c58,int1)
    & etype(c58,int0)
    & fact(c58,real)
    & gener(c58,sp)
    & quant(c58,one)
    & refer(c58,det)
    & varia(c58,con)
    & sort(freiheitsstatue_1_1,d)
    & card(freiheitsstatue_1_1,int1)
    & etype(freiheitsstatue_1_1,int0)
    & fact(freiheitsstatue_1_1,real)
    & gener(freiheitsstatue_1_1,ge)
    & quant(freiheitsstatue_1_1,one)
    & refer(freiheitsstatue_1_1,refer_c)
    & varia(freiheitsstatue_1_1,varia_c)
    & sort(c49,d)
    & card(c49,int1)
    & etype(c49,int0)
    & fact(c49,real)
    & gener(c49,sp)
    & quant(c49,one)
    & refer(c49,det)
    & varia(c49,con)
    & sort(bootshafen_1_1,d)
    & card(bootshafen_1_1,int1)
    & etype(bootshafen_1_1,int0)
    & fact(bootshafen_1_1,real)
    & gener(bootshafen_1_1,ge)
    & quant(bootshafen_1_1,one)
    & refer(bootshafen_1_1,refer_c)
    & varia(bootshafen_1_1,varia_c)
    & sort(c54,d)
    & sort(c54,io)
    & card(c54,int1)
    & etype(c54,int0)
    & fact(c54,real)
    & gener(c54,sp)
    & quant(c54,one)
    & refer(c54,det)
    & varia(c54,con)
    & sort(c55,na)
    & card(c55,int1)
    & etype(c55,int0)
    & fact(c55,real)
    & gener(c55,sp)
    & quant(c55,one)
    & refer(c55,indet)
    & varia(c55,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(new_york_0,fe)
    & sort(klein_1_1,mq)
    & sort(freiheit_1_1,as)
    & sort(freiheit_1_1,io)
    & card(freiheit_1_1,int1)
    & etype(freiheit_1_1,int0)
    & fact(freiheit_1_1,real)
    & gener(freiheit_1_1,ge)
    & quant(freiheit_1_1,one)
    & refer(freiheit_1_1,refer_c)
    & varia(freiheit_1_1,varia_c)
    & sort(statue_1_1,d)
    & card(statue_1_1,int1)
    & etype(statue_1_1,int0)
    & fact(statue_1_1,real)
    & gener(statue_1_1,ge)
    & quant(statue_1_1,one)
    & refer(statue_1_1,refer_c)
    & varia(statue_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
