%------------------------------------------------------------------------------
% File     : CSR113+27 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Where can you find the Statue of Liberty?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_003_qapn_26_a19713_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.35 v9.1.0, 0.47 v9.0.0, 0.31 v8.2.0, 0.33 v8.1.0, 0.36 v7.5.0, 0.38 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.50 v6.3.0, 0.54 v6.2.0, 0.73 v6.1.0, 0.72 v6.0.0, 0.50 v5.5.0, 0.75 v5.4.0, 0.74 v5.3.0, 0.78 v5.2.0, 0.57 v5.0.0, 0.65 v4.1.0, 0.61 v4.0.1, 0.68 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10867 (   0 equ)
%            Maximal formula atoms :  165 (   1 avg)
%            Number of connectives :  678 (   0   ~;  18   |; 534   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  165 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-9 aty)
%            Number of functors    : 16655 (16655 usr;16654 con; 0-2 aty)
%            Number of variables   :  472 ( 405   !;  67   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_003_qapn_26_a19713,conjecture,
    ? [X0,X1,X2,X3] :
      ( attr(X1,X0)
      & scar(X2,X3)
      & sub(X0,name_1_1)
      & val(X0,new_york_0) ) ).

fof(ave07_era5_synth_qa07_003_qapn_26_a19713,hypothesis,
    ( pred(c78483,masse_1_1)
    & sub(c78489,sich_1_1)
    & sub(c78495,freiheit_1_1)
    & prop(c78520,ber__374hmt_1_1)
    & pred(c78522,wort_2_1)
    & sub(c78531,freiheitsstatue_1_1)
    & attr(c78537,c78538)
    & sub(c78537,stadt__1_1)
    & sub(c78538,name_1_1)
    & val(c78538,new_york_0)
    & tupl_p9(c79239,c78466,c78483,c78489,c78495,c78520,c78522,c78531,c78537)
    & assoc(freiheitsstatue_1_1,freiheit_1_1)
    & sub(freiheitsstatue_1_1,statue_1_1)
    & sort(c78483,io)
    & card(c78483,cons(x_constant,cons(int1,nil)))
    & etype(c78483,int2)
    & fact(c78483,real)
    & gener(c78483,gener_c)
    & quant(c78483,mult)
    & refer(c78483,indet)
    & varia(c78483,varia_c)
    & sort(masse_1_1,io)
    & card(masse_1_1,card_c)
    & etype(masse_1_1,int1)
    & fact(masse_1_1,real)
    & gener(masse_1_1,ge)
    & quant(masse_1_1,quant_c)
    & refer(masse_1_1,refer_c)
    & varia(masse_1_1,varia_c)
    & sort(c78489,o)
    & card(c78489,int1)
    & etype(c78489,int0)
    & fact(c78489,real)
    & gener(c78489,gener_c)
    & quant(c78489,one)
    & refer(c78489,refer_c)
    & varia(c78489,varia_c)
    & sort(sich_1_1,o)
    & card(sich_1_1,int1)
    & etype(sich_1_1,int0)
    & fact(sich_1_1,real)
    & gener(sich_1_1,gener_c)
    & quant(sich_1_1,one)
    & refer(sich_1_1,refer_c)
    & varia(sich_1_1,varia_c)
    & sort(c78495,as)
    & sort(c78495,io)
    & card(c78495,int1)
    & etype(c78495,int0)
    & fact(c78495,real)
    & gener(c78495,sp)
    & quant(c78495,one)
    & refer(c78495,det)
    & varia(c78495,con)
    & sort(freiheit_1_1,as)
    & sort(freiheit_1_1,io)
    & card(freiheit_1_1,int1)
    & etype(freiheit_1_1,int0)
    & fact(freiheit_1_1,real)
    & gener(freiheit_1_1,ge)
    & quant(freiheit_1_1,one)
    & refer(freiheit_1_1,refer_c)
    & varia(freiheit_1_1,varia_c)
    & sort(c78520,o)
    & card(c78520,cons(x_constant,cons(int1,nil)))
    & etype(c78520,int1)
    & fact(c78520,real)
    & gener(c78520,sp)
    & quant(c78520,mult)
    & refer(c78520,det)
    & varia(c78520,con)
    & sort(ber__374hmt_1_1,nq)
    & sort(c78522,d)
    & sort(c78522,io)
    & card(c78522,cons(x_constant,cons(int1,nil)))
    & etype(c78522,int1)
    & fact(c78522,real)
    & gener(c78522,gener_c)
    & quant(c78522,mult)
    & refer(c78522,indet)
    & varia(c78522,varia_c)
    & sort(wort_2_1,d)
    & sort(wort_2_1,io)
    & card(wort_2_1,int1)
    & etype(wort_2_1,int0)
    & fact(wort_2_1,real)
    & gener(wort_2_1,ge)
    & quant(wort_2_1,one)
    & refer(wort_2_1,refer_c)
    & varia(wort_2_1,varia_c)
    & sort(c78531,d)
    & card(c78531,int1)
    & etype(c78531,int0)
    & fact(c78531,real)
    & gener(c78531,sp)
    & quant(c78531,one)
    & refer(c78531,det)
    & varia(c78531,con)
    & sort(freiheitsstatue_1_1,d)
    & card(freiheitsstatue_1_1,int1)
    & etype(freiheitsstatue_1_1,int0)
    & fact(freiheitsstatue_1_1,real)
    & gener(freiheitsstatue_1_1,ge)
    & quant(freiheitsstatue_1_1,one)
    & refer(freiheitsstatue_1_1,refer_c)
    & varia(freiheitsstatue_1_1,varia_c)
    & sort(c78537,d)
    & sort(c78537,io)
    & card(c78537,int1)
    & etype(c78537,int0)
    & fact(c78537,real)
    & gener(c78537,sp)
    & quant(c78537,one)
    & refer(c78537,det)
    & varia(c78537,con)
    & sort(c78538,na)
    & card(c78538,int1)
    & etype(c78538,int0)
    & fact(c78538,real)
    & gener(c78538,sp)
    & quant(c78538,one)
    & refer(c78538,indet)
    & varia(c78538,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(new_york_0,fe)
    & sort(c79239,ent)
    & card(c79239,card_c)
    & etype(c79239,etype_c)
    & fact(c79239,real)
    & gener(c79239,gener_c)
    & quant(c79239,quant_c)
    & refer(c79239,refer_c)
    & varia(c79239,varia_c)
    & sort(c78466,d)
    & card(c78466,int1)
    & etype(c78466,int0)
    & fact(c78466,real)
    & gener(c78466,sp)
    & quant(c78466,one)
    & refer(c78466,det)
    & varia(c78466,varia_c)
    & sort(statue_1_1,d)
    & card(statue_1_1,int1)
    & etype(statue_1_1,int0)
    & fact(statue_1_1,real)
    & gener(statue_1_1,ge)
    & quant(statue_1_1,one)
    & refer(statue_1_1,refer_c)
    & varia(statue_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
