%------------------------------------------------------------------------------
% File     : CSR113+26 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Where can you find the Statue of Liberty?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_003_mw3_123_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.30 v9.1.0, 0.33 v9.0.0, 0.19 v8.2.0, 0.20 v8.1.0, 0.21 v7.5.0, 0.29 v7.4.0, 0.25 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.29 v6.4.0, 0.21 v6.3.0, 0.23 v6.2.0, 0.36 v6.1.0, 0.60 v6.0.0, 0.50 v5.5.0, 0.54 v5.4.0, 0.52 v5.3.0, 0.61 v5.2.0, 0.36 v5.0.0, 0.45 v4.1.0, 0.50 v4.0.1, 0.47 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10898 (   0 equ)
%            Maximal formula atoms :  194 (   1 avg)
%            Number of connectives :  709 (   0   ~;  18   |; 565   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  194 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   88 (  88 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16654 (16654 usr;16653 con; 0-2 aty)
%            Number of variables   :  473 ( 405   !;  68   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_003_mw3_123,conjecture,
    ? [X0,X1,X2,X3,X4] :
      ( attr(X2,X1)
      & loc(X3,X0)
      & scar(X3,X4)
      & sub(X1,name_1_1)
      & subs(X3,stehen_1_1)
      & val(X1,usa_0) ) ).

fof(ave07_era5_synth_qa07_003_mw3_123,hypothesis,
    ( prop(c11,aktuell_1_1)
    & sub(c11,uncle_1_1)
    & attr(c17,c18)
    & sub(c17,mensch_1_1)
    & sub(c18,familiename_1_1)
    & val(c18,sam_0)
    & prop(c23,c27)
    & sub(c23,nationalsymbol_1_1)
    & supl(c27,wichtig_1_1,c28)
    & attch(c32,c23)
    & attr(c32,c33)
    & sub(c32,land_1_1)
    & sub(c33,name_1_1)
    & val(c33,usa_0)
    & neben(c35,c4)
    & sub(c4,freiheitsstatue_1_1)
    & arg1(c9,c11)
    & arg2(c9,aktuell_1_1)
    & assoc(c9,c17)
    & assoc(c9,c23)
    & loc(c9,c35)
    & subr(c9,prop_0)
    & assoc(freiheitsstatue_1_1,freiheit_1_1)
    & sub(freiheitsstatue_1_1,statue_1_1)
    & assoc(nationalsymbol_1_1,national__1_1)
    & sub(nationalsymbol_1_1,symbol_1_1)
    & sort(c11,o)
    & card(c11,int1)
    & etype(c11,int0)
    & fact(c11,real)
    & gener(c11,gener_c)
    & quant(c11,one)
    & refer(c11,refer_c)
    & varia(c11,varia_c)
    & sort(aktuell_1_1,tq)
    & sort(uncle_1_1,o)
    & card(uncle_1_1,int1)
    & etype(uncle_1_1,int0)
    & fact(uncle_1_1,real)
    & gener(uncle_1_1,ge)
    & quant(uncle_1_1,one)
    & refer(uncle_1_1,refer_c)
    & varia(uncle_1_1,varia_c)
    & sort(c17,d)
    & card(c17,int1)
    & etype(c17,int0)
    & fact(c17,real)
    & gener(c17,sp)
    & quant(c17,one)
    & refer(c17,det)
    & varia(c17,con)
    & sort(c18,na)
    & card(c18,int1)
    & etype(c18,int0)
    & fact(c18,real)
    & gener(c18,sp)
    & quant(c18,one)
    & refer(c18,indet)
    & varia(c18,varia_c)
    & sort(mensch_1_1,d)
    & card(mensch_1_1,int1)
    & etype(mensch_1_1,int0)
    & fact(mensch_1_1,real)
    & gener(mensch_1_1,ge)
    & quant(mensch_1_1,one)
    & refer(mensch_1_1,refer_c)
    & varia(mensch_1_1,varia_c)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(sam_0,fe)
    & sort(c23,io)
    & card(c23,int1)
    & etype(c23,int0)
    & fact(c23,real)
    & gener(c23,sp)
    & quant(c23,one)
    & refer(c23,det)
    & varia(c23,con)
    & sort(c27,tq)
    & sort(nationalsymbol_1_1,io)
    & card(nationalsymbol_1_1,int1)
    & etype(nationalsymbol_1_1,int0)
    & fact(nationalsymbol_1_1,real)
    & gener(nationalsymbol_1_1,ge)
    & quant(nationalsymbol_1_1,one)
    & refer(nationalsymbol_1_1,refer_c)
    & varia(nationalsymbol_1_1,varia_c)
    & sort(wichtig_1_1,nq)
    & sort(c28,o)
    & card(c28,card_c)
    & etype(c28,int1)
    & etype(c28,int2)
    & fact(c28,real)
    & gener(c28,gener_c)
    & quant(c28,quant_c)
    & refer(c28,refer_c)
    & varia(c28,varia_c)
    & sort(c32,d)
    & sort(c32,io)
    & card(c32,int1)
    & etype(c32,int0)
    & fact(c32,real)
    & gener(c32,sp)
    & quant(c32,one)
    & refer(c32,det)
    & varia(c32,con)
    & sort(c33,na)
    & card(c33,int1)
    & etype(c33,int0)
    & fact(c33,real)
    & gener(c33,sp)
    & quant(c33,one)
    & refer(c33,indet)
    & varia(c33,varia_c)
    & sort(land_1_1,d)
    & sort(land_1_1,io)
    & card(land_1_1,int1)
    & etype(land_1_1,int0)
    & fact(land_1_1,real)
    & gener(land_1_1,ge)
    & quant(land_1_1,one)
    & refer(land_1_1,refer_c)
    & varia(land_1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(usa_0,fe)
    & sort(c35,l)
    & card(c35,int1)
    & etype(c35,int0)
    & fact(c35,real)
    & gener(c35,sp)
    & quant(c35,one)
    & refer(c35,det)
    & varia(c35,con)
    & sort(c4,d)
    & card(c4,int1)
    & etype(c4,int0)
    & fact(c4,real)
    & gener(c4,sp)
    & quant(c4,one)
    & refer(c4,det)
    & varia(c4,con)
    & sort(freiheitsstatue_1_1,d)
    & card(freiheitsstatue_1_1,int1)
    & etype(freiheitsstatue_1_1,int0)
    & fact(freiheitsstatue_1_1,real)
    & gener(freiheitsstatue_1_1,ge)
    & quant(freiheitsstatue_1_1,one)
    & refer(freiheitsstatue_1_1,refer_c)
    & varia(freiheitsstatue_1_1,varia_c)
    & sort(c9,st)
    & fact(c9,real)
    & gener(c9,sp)
    & sort(prop_0,st)
    & fact(prop_0,real)
    & gener(prop_0,gener_c)
    & sort(freiheit_1_1,as)
    & sort(freiheit_1_1,io)
    & card(freiheit_1_1,int1)
    & etype(freiheit_1_1,int0)
    & fact(freiheit_1_1,real)
    & gener(freiheit_1_1,ge)
    & quant(freiheit_1_1,one)
    & refer(freiheit_1_1,refer_c)
    & varia(freiheit_1_1,varia_c)
    & sort(statue_1_1,d)
    & card(statue_1_1,int1)
    & etype(statue_1_1,int0)
    & fact(statue_1_1,real)
    & gener(statue_1_1,ge)
    & quant(statue_1_1,one)
    & refer(statue_1_1,refer_c)
    & varia(statue_1_1,varia_c)
    & sort(national__1_1,nq)
    & sort(symbol_1_1,io)
    & card(symbol_1_1,int1)
    & etype(symbol_1_1,int0)
    & fact(symbol_1_1,real)
    & gener(symbol_1_1,ge)
    & quant(symbol_1_1,one)
    & refer(symbol_1_1,refer_c)
    & varia(symbol_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
