%------------------------------------------------------------------------------
% File     : CSR113+24 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Where can you find the Statue of Liberty?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_003_mira_wp_254_a19713_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.30 v9.1.0, 0.33 v9.0.0, 0.19 v8.2.0, 0.20 v8.1.0, 0.29 v7.5.0, 0.38 v7.4.0, 0.31 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.36 v6.3.0, 0.38 v6.2.0, 0.55 v6.1.0, 0.60 v6.0.0, 0.50 v5.5.0, 0.62 v5.4.0, 0.57 v5.3.0, 0.70 v5.2.0, 0.43 v5.0.0, 0.50 v4.1.0, 0.61 v4.0.1, 0.58 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 11070 (   0 equ)
%            Maximal formula atoms :  368 (   1 avg)
%            Number of connectives :  881 (   0   ~;  18   |; 737   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  368 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-13 aty)
%            Number of functors    : 16675 (16675 usr;16674 con; 0-2 aty)
%            Number of variables   :  472 ( 405   !;  67   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_003_mira_wp_254_a19713,conjecture,
    ? [X0,X1,X2,X3] :
      ( attr(X1,X0)
      & scar(X2,X3)
      & sub(X0,name_1_1)
      & val(X0,new_york_0) ) ).

fof(ave07_era5_synth_qa07_003_mira_wp_254_a19713,hypothesis,
    ( tupl_p13(c1032,c767,c772,c770,c783,c791,c803,c813,c822,c832,c836,c844,c877)
    & sub(c767,the_1_1)
    & pred(c770,colossus_1_1)
    & attr(c772,c773)
    & sub(c772,mensch_1_1)
    & sub(c773,familiename_1_1)
    & val(c773,new_0)
    & sub(c783,gedicht__1_1)
    & attr(c791,c792)
    & attr(c791,c793)
    & sub(c791,mensch_1_1)
    & sub(c792,eigenname_1_1)
    & val(c792,emma_0)
    & sub(c793,familiename_1_1)
    & val(c793,lazarus_0)
    & attr(c803,c808)
    & sub(c808,jahr__1_1)
    & val(c808,c804)
    & sub(c813,beitrag_1_1)
    & subs(c822,kunstsammlung_1_1)
    & sub(c832,ziel_1_1)
    & sub(c836,geld_1_1)
    & sub(c844,bau_1_1)
    & attch(c847,c844)
    & sub(c847,podest_1_1)
    & attch(c851,c847)
    & sub(c851,freiheitsstatue_1_1)
    & attr(c877,c878)
    & sub(c877,stadt__1_1)
    & sub(c878,name_1_1)
    & val(c878,new_york_0)
    & assoc(freiheitsstatue_1_1,freiheit_1_1)
    & sub(freiheitsstatue_1_1,statue_1_1)
    & assoc(kunstsammlung_1_1,kunst_1_1)
    & subs(kunstsammlung_1_1,sammlung_1_1)
    & sort(c1032,ent)
    & card(c1032,card_c)
    & etype(c1032,etype_c)
    & fact(c1032,real)
    & gener(c1032,gener_c)
    & quant(c1032,quant_c)
    & refer(c1032,refer_c)
    & varia(c1032,varia_c)
    & sort(c767,o)
    & card(c767,int1)
    & etype(c767,int0)
    & fact(c767,real)
    & gener(c767,gener_c)
    & quant(c767,one)
    & refer(c767,refer_c)
    & varia(c767,varia_c)
    & sort(c772,d)
    & card(c772,int1)
    & etype(c772,int0)
    & fact(c772,real)
    & gener(c772,sp)
    & quant(c772,one)
    & refer(c772,det)
    & varia(c772,con)
    & sort(c770,o)
    & card(c770,cons(x_constant,cons(int1,nil)))
    & etype(c770,int1)
    & fact(c770,real)
    & gener(c770,gener_c)
    & quant(c770,mult)
    & refer(c770,indet)
    & varia(c770,varia_c)
    & sort(c783,o)
    & card(c783,int1)
    & etype(c783,int0)
    & fact(c783,real)
    & gener(c783,sp)
    & quant(c783,one)
    & refer(c783,indet)
    & varia(c783,varia_c)
    & sort(c791,d)
    & card(c791,int1)
    & etype(c791,int0)
    & fact(c791,real)
    & gener(c791,sp)
    & quant(c791,one)
    & refer(c791,det)
    & varia(c791,con)
    & sort(c803,t)
    & card(c803,int1)
    & etype(c803,int0)
    & fact(c803,real)
    & gener(c803,sp)
    & quant(c803,one)
    & refer(c803,det)
    & varia(c803,con)
    & sort(c813,io)
    & card(c813,int1)
    & etype(c813,int0)
    & fact(c813,real)
    & gener(c813,gener_c)
    & quant(c813,one)
    & refer(c813,refer_c)
    & varia(c813,varia_c)
    & sort(c822,ad)
    & card(c822,int1)
    & etype(c822,int0)
    & fact(c822,real)
    & gener(c822,sp)
    & quant(c822,one)
    & refer(c822,indet)
    & varia(c822,varia_c)
    & sort(c832,io)
    & card(c832,int1)
    & etype(c832,int0)
    & fact(c832,real)
    & gener(c832,sp)
    & quant(c832,one)
    & refer(c832,det)
    & varia(c832,con)
    & sort(c836,d)
    & card(c836,int1)
    & etype(c836,int0)
    & fact(c836,real)
    & gener(c836,gener_c)
    & quant(c836,one)
    & refer(c836,refer_c)
    & varia(c836,varia_c)
    & sort(c844,d)
    & card(c844,int1)
    & etype(c844,int0)
    & fact(c844,real)
    & gener(c844,sp)
    & quant(c844,one)
    & refer(c844,det)
    & varia(c844,con)
    & sort(c877,d)
    & sort(c877,io)
    & card(c877,int1)
    & etype(c877,int0)
    & fact(c877,real)
    & gener(c877,sp)
    & quant(c877,one)
    & refer(c877,det)
    & varia(c877,con)
    & sort(the_1_1,o)
    & card(the_1_1,int1)
    & etype(the_1_1,int0)
    & fact(the_1_1,real)
    & gener(the_1_1,ge)
    & quant(the_1_1,one)
    & refer(the_1_1,refer_c)
    & varia(the_1_1,varia_c)
    & sort(colossus_1_1,o)
    & card(colossus_1_1,int1)
    & etype(colossus_1_1,int0)
    & fact(colossus_1_1,real)
    & gener(colossus_1_1,ge)
    & quant(colossus_1_1,one)
    & refer(colossus_1_1,refer_c)
    & varia(colossus_1_1,varia_c)
    & sort(c773,na)
    & card(c773,int1)
    & etype(c773,int0)
    & fact(c773,real)
    & gener(c773,sp)
    & quant(c773,one)
    & refer(c773,indet)
    & varia(c773,varia_c)
    & sort(mensch_1_1,d)
    & card(mensch_1_1,int1)
    & etype(mensch_1_1,int0)
    & fact(mensch_1_1,real)
    & gener(mensch_1_1,ge)
    & quant(mensch_1_1,one)
    & refer(mensch_1_1,refer_c)
    & varia(mensch_1_1,varia_c)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(new_0,fe)
    & sort(gedicht__1_1,o)
    & card(gedicht__1_1,int1)
    & etype(gedicht__1_1,int0)
    & fact(gedicht__1_1,real)
    & gener(gedicht__1_1,ge)
    & quant(gedicht__1_1,one)
    & refer(gedicht__1_1,refer_c)
    & varia(gedicht__1_1,varia_c)
    & sort(c792,na)
    & card(c792,int1)
    & etype(c792,int0)
    & fact(c792,real)
    & gener(c792,sp)
    & quant(c792,one)
    & refer(c792,indet)
    & varia(c792,varia_c)
    & sort(c793,na)
    & card(c793,int1)
    & etype(c793,int0)
    & fact(c793,real)
    & gener(c793,sp)
    & quant(c793,one)
    & refer(c793,indet)
    & varia(c793,varia_c)
    & sort(eigenname_1_1,na)
    & card(eigenname_1_1,int1)
    & etype(eigenname_1_1,int0)
    & fact(eigenname_1_1,real)
    & gener(eigenname_1_1,ge)
    & quant(eigenname_1_1,one)
    & refer(eigenname_1_1,refer_c)
    & varia(eigenname_1_1,varia_c)
    & sort(emma_0,fe)
    & sort(lazarus_0,fe)
    & sort(c808,me)
    & sort(c808,oa)
    & sort(c808,ta)
    & card(c808,card_c)
    & etype(c808,etype_c)
    & fact(c808,real)
    & gener(c808,sp)
    & quant(c808,quant_c)
    & refer(c808,refer_c)
    & varia(c808,varia_c)
    & sort(jahr__1_1,me)
    & sort(jahr__1_1,oa)
    & sort(jahr__1_1,ta)
    & card(jahr__1_1,card_c)
    & etype(jahr__1_1,etype_c)
    & fact(jahr__1_1,real)
    & gener(jahr__1_1,ge)
    & quant(jahr__1_1,quant_c)
    & refer(jahr__1_1,refer_c)
    & varia(jahr__1_1,varia_c)
    & sort(c804,nu)
    & card(c804,int1883)
    & sort(beitrag_1_1,io)
    & card(beitrag_1_1,int1)
    & etype(beitrag_1_1,int0)
    & fact(beitrag_1_1,real)
    & gener(beitrag_1_1,ge)
    & quant(beitrag_1_1,one)
    & refer(beitrag_1_1,refer_c)
    & varia(beitrag_1_1,varia_c)
    & sort(kunstsammlung_1_1,ad)
    & card(kunstsammlung_1_1,int1)
    & etype(kunstsammlung_1_1,int0)
    & fact(kunstsammlung_1_1,real)
    & gener(kunstsammlung_1_1,ge)
    & quant(kunstsammlung_1_1,one)
    & refer(kunstsammlung_1_1,refer_c)
    & varia(kunstsammlung_1_1,varia_c)
    & sort(ziel_1_1,io)
    & card(ziel_1_1,int1)
    & etype(ziel_1_1,int0)
    & fact(ziel_1_1,real)
    & gener(ziel_1_1,ge)
    & quant(ziel_1_1,one)
    & refer(ziel_1_1,refer_c)
    & varia(ziel_1_1,varia_c)
    & sort(geld_1_1,d)
    & card(geld_1_1,int1)
    & etype(geld_1_1,int0)
    & fact(geld_1_1,real)
    & gener(geld_1_1,ge)
    & quant(geld_1_1,one)
    & refer(geld_1_1,refer_c)
    & varia(geld_1_1,varia_c)
    & sort(bau_1_1,d)
    & card(bau_1_1,int1)
    & etype(bau_1_1,int0)
    & fact(bau_1_1,real)
    & gener(bau_1_1,ge)
    & quant(bau_1_1,one)
    & refer(bau_1_1,refer_c)
    & varia(bau_1_1,varia_c)
    & sort(c847,d)
    & card(c847,int1)
    & etype(c847,int0)
    & fact(c847,real)
    & gener(c847,sp)
    & quant(c847,one)
    & refer(c847,det)
    & varia(c847,con)
    & sort(podest_1_1,d)
    & card(podest_1_1,int1)
    & etype(podest_1_1,int0)
    & fact(podest_1_1,real)
    & gener(podest_1_1,ge)
    & quant(podest_1_1,one)
    & refer(podest_1_1,refer_c)
    & varia(podest_1_1,varia_c)
    & sort(c851,d)
    & card(c851,int1)
    & etype(c851,int0)
    & fact(c851,real)
    & gener(c851,sp)
    & quant(c851,one)
    & refer(c851,det)
    & varia(c851,con)
    & sort(freiheitsstatue_1_1,d)
    & card(freiheitsstatue_1_1,int1)
    & etype(freiheitsstatue_1_1,int0)
    & fact(freiheitsstatue_1_1,real)
    & gener(freiheitsstatue_1_1,ge)
    & quant(freiheitsstatue_1_1,one)
    & refer(freiheitsstatue_1_1,refer_c)
    & varia(freiheitsstatue_1_1,varia_c)
    & sort(c878,na)
    & card(c878,int1)
    & etype(c878,int0)
    & fact(c878,real)
    & gener(c878,sp)
    & quant(c878,one)
    & refer(c878,indet)
    & varia(c878,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(new_york_0,fe)
    & sort(freiheit_1_1,as)
    & sort(freiheit_1_1,io)
    & card(freiheit_1_1,int1)
    & etype(freiheit_1_1,int0)
    & fact(freiheit_1_1,real)
    & gener(freiheit_1_1,ge)
    & quant(freiheit_1_1,one)
    & refer(freiheit_1_1,refer_c)
    & varia(freiheit_1_1,varia_c)
    & sort(statue_1_1,d)
    & card(statue_1_1,int1)
    & etype(statue_1_1,int0)
    & fact(statue_1_1,real)
    & gener(statue_1_1,ge)
    & quant(statue_1_1,one)
    & refer(statue_1_1,refer_c)
    & varia(statue_1_1,varia_c)
    & sort(kunst_1_1,io)
    & card(kunst_1_1,int1)
    & etype(kunst_1_1,int0)
    & fact(kunst_1_1,real)
    & gener(kunst_1_1,ge)
    & quant(kunst_1_1,one)
    & refer(kunst_1_1,refer_c)
    & varia(kunst_1_1,varia_c)
    & sort(sammlung_1_1,ad)
    & card(sammlung_1_1,int1)
    & etype(sammlung_1_1,int0)
    & fact(sammlung_1_1,real)
    & gener(sammlung_1_1,ge)
    & quant(sammlung_1_1,one)
    & refer(sammlung_1_1,refer_c)
    & varia(sammlung_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
