%------------------------------------------------------------------------------
% File     : CSR113+22 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Where can you find the Statue of Liberty?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_003_mira_wp_245_a19713_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.35 v9.1.0, 0.47 v9.0.0, 0.25 v8.2.0, 0.27 v8.1.0, 0.36 v7.5.0, 0.38 v7.4.0, 0.31 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.43 v6.4.0, 0.50 v6.3.0, 0.54 v6.2.0, 0.73 v6.1.0, 0.68 v6.0.0, 0.50 v5.5.0, 0.67 v5.4.0, 0.65 v5.3.0, 0.74 v5.2.0, 0.50 v5.0.0, 0.60 v4.1.0, 0.56 v4.0.1, 0.68 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10964 (   0 equ)
%            Maximal formula atoms :  262 (   1 avg)
%            Number of connectives :  775 (   0   ~;  18   |; 631   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  262 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-9 aty)
%            Number of functors    : 16664 (16664 usr;16663 con; 0-2 aty)
%            Number of variables   :  472 ( 405   !;  67   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_003_mira_wp_245_a19713,conjecture,
    ? [X0,X1,X2,X3] :
      ( attr(X1,X0)
      & scar(X2,X3)
      & sub(X0,name_1_1)
      & val(X0,new_york_0) ) ).

fof(ave07_era5_synth_qa07_003_mira_wp_245_a19713,hypothesis,
    ( tupl_p9(c188,c28,c39,c56,c69,c74,c79,c83,c92)
    & sub(c28,freiheitsinsel_1_1)
    & pred(c39,bedloe_1_1)
    & attr(c56,c57)
    & sub(c56,gebietsinstitution_1_1)
    & sub(c57,name_1_1)
    & val(c57,island_0)
    & prop(c69,klein_1_1)
    & prop(c69,unbesiedelt_1_1)
    & sub(c69,insel__1_1)
    & sub(c74,upper_1_1)
    & attr(c79,c80)
    & sub(c79,stadt__1_1)
    & sub(c80,name_1_1)
    & val(c80,new_york_0)
    & attr(c83,c84)
    & sub(c83,mensch_1_1)
    & sub(c84,familiename_1_1)
    & val(c84,bay_0)
    & sub(c92,standort_1_1)
    & attch(c96,c92)
    & sub(c96,freiheitsstatue_1_1)
    & assoc(freiheitsinsel_1_1,freiheit_1_1)
    & sub(freiheitsinsel_1_1,insel__1_1)
    & assoc(freiheitsstatue_1_1,freiheit_1_1)
    & sub(freiheitsstatue_1_1,statue_1_1)
    & assoc(standort_1_1,stand_1_1)
    & sub(standort_1_1,ort_1_2)
    & sort(c188,ent)
    & card(c188,card_c)
    & etype(c188,etype_c)
    & fact(c188,real)
    & gener(c188,gener_c)
    & quant(c188,quant_c)
    & refer(c188,refer_c)
    & varia(c188,varia_c)
    & sort(c28,d)
    & card(c28,int1)
    & etype(c28,int0)
    & fact(c28,real)
    & gener(c28,gener_c)
    & quant(c28,one)
    & refer(c28,refer_c)
    & varia(c28,varia_c)
    & sort(c39,o)
    & card(c39,cons(x_constant,cons(int1,nil)))
    & etype(c39,int1)
    & fact(c39,real)
    & gener(c39,gener_c)
    & quant(c39,mult)
    & refer(c39,indet)
    & varia(c39,varia_c)
    & sort(c56,d)
    & sort(c56,io)
    & card(c56,int1)
    & etype(c56,int0)
    & fact(c56,real)
    & gener(c56,sp)
    & quant(c56,one)
    & refer(c56,det)
    & varia(c56,con)
    & sort(c69,d)
    & card(c69,int1)
    & etype(c69,int0)
    & fact(c69,real)
    & gener(c69,sp)
    & quant(c69,one)
    & refer(c69,indet)
    & varia(c69,varia_c)
    & sort(c74,o)
    & card(c74,int1)
    & etype(c74,int0)
    & fact(c74,real)
    & gener(c74,sp)
    & quant(c74,one)
    & refer(c74,det)
    & varia(c74,con)
    & sort(c79,d)
    & sort(c79,io)
    & card(c79,int1)
    & etype(c79,int0)
    & fact(c79,real)
    & gener(c79,sp)
    & quant(c79,one)
    & refer(c79,det)
    & varia(c79,con)
    & sort(c83,d)
    & card(c83,int1)
    & etype(c83,int0)
    & fact(c83,real)
    & gener(c83,sp)
    & quant(c83,one)
    & refer(c83,det)
    & varia(c83,con)
    & sort(c92,d)
    & card(c92,int1)
    & etype(c92,int0)
    & fact(c92,real)
    & gener(c92,sp)
    & quant(c92,one)
    & refer(c92,det)
    & varia(c92,varia_c)
    & sort(freiheitsinsel_1_1,d)
    & card(freiheitsinsel_1_1,int1)
    & etype(freiheitsinsel_1_1,int0)
    & fact(freiheitsinsel_1_1,real)
    & gener(freiheitsinsel_1_1,ge)
    & quant(freiheitsinsel_1_1,one)
    & refer(freiheitsinsel_1_1,refer_c)
    & varia(freiheitsinsel_1_1,varia_c)
    & sort(bedloe_1_1,o)
    & card(bedloe_1_1,int1)
    & etype(bedloe_1_1,int0)
    & fact(bedloe_1_1,real)
    & gener(bedloe_1_1,ge)
    & quant(bedloe_1_1,one)
    & refer(bedloe_1_1,refer_c)
    & varia(bedloe_1_1,varia_c)
    & sort(c57,na)
    & card(c57,int1)
    & etype(c57,int0)
    & fact(c57,real)
    & gener(c57,sp)
    & quant(c57,one)
    & refer(c57,indet)
    & varia(c57,varia_c)
    & sort(gebietsinstitution_1_1,d)
    & sort(gebietsinstitution_1_1,io)
    & card(gebietsinstitution_1_1,int1)
    & etype(gebietsinstitution_1_1,int0)
    & fact(gebietsinstitution_1_1,real)
    & gener(gebietsinstitution_1_1,ge)
    & quant(gebietsinstitution_1_1,one)
    & refer(gebietsinstitution_1_1,refer_c)
    & varia(gebietsinstitution_1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(island_0,fe)
    & sort(klein_1_1,mq)
    & sort(unbesiedelt_1_1,ql)
    & sort(insel__1_1,d)
    & card(insel__1_1,int1)
    & etype(insel__1_1,int0)
    & fact(insel__1_1,real)
    & gener(insel__1_1,ge)
    & quant(insel__1_1,one)
    & refer(insel__1_1,refer_c)
    & varia(insel__1_1,varia_c)
    & sort(upper_1_1,o)
    & card(upper_1_1,int1)
    & etype(upper_1_1,int0)
    & fact(upper_1_1,real)
    & gener(upper_1_1,ge)
    & quant(upper_1_1,one)
    & refer(upper_1_1,refer_c)
    & varia(upper_1_1,varia_c)
    & sort(c80,na)
    & card(c80,int1)
    & etype(c80,int0)
    & fact(c80,real)
    & gener(c80,sp)
    & quant(c80,one)
    & refer(c80,indet)
    & varia(c80,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(new_york_0,fe)
    & sort(c84,na)
    & card(c84,int1)
    & etype(c84,int0)
    & fact(c84,real)
    & gener(c84,sp)
    & quant(c84,one)
    & refer(c84,indet)
    & varia(c84,varia_c)
    & sort(mensch_1_1,d)
    & card(mensch_1_1,int1)
    & etype(mensch_1_1,int0)
    & fact(mensch_1_1,real)
    & gener(mensch_1_1,ge)
    & quant(mensch_1_1,one)
    & refer(mensch_1_1,refer_c)
    & varia(mensch_1_1,varia_c)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(bay_0,fe)
    & sort(standort_1_1,d)
    & card(standort_1_1,int1)
    & etype(standort_1_1,int0)
    & fact(standort_1_1,real)
    & gener(standort_1_1,ge)
    & quant(standort_1_1,one)
    & refer(standort_1_1,refer_c)
    & varia(standort_1_1,varia_c)
    & sort(c96,d)
    & card(c96,int1)
    & etype(c96,int0)
    & fact(c96,real)
    & gener(c96,sp)
    & quant(c96,one)
    & refer(c96,det)
    & varia(c96,con)
    & sort(freiheitsstatue_1_1,d)
    & card(freiheitsstatue_1_1,int1)
    & etype(freiheitsstatue_1_1,int0)
    & fact(freiheitsstatue_1_1,real)
    & gener(freiheitsstatue_1_1,ge)
    & quant(freiheitsstatue_1_1,one)
    & refer(freiheitsstatue_1_1,refer_c)
    & varia(freiheitsstatue_1_1,varia_c)
    & sort(freiheit_1_1,as)
    & sort(freiheit_1_1,io)
    & card(freiheit_1_1,int1)
    & etype(freiheit_1_1,int0)
    & fact(freiheit_1_1,real)
    & gener(freiheit_1_1,ge)
    & quant(freiheit_1_1,one)
    & refer(freiheit_1_1,refer_c)
    & varia(freiheit_1_1,varia_c)
    & sort(statue_1_1,d)
    & card(statue_1_1,int1)
    & etype(statue_1_1,int0)
    & fact(statue_1_1,real)
    & gener(statue_1_1,ge)
    & quant(statue_1_1,one)
    & refer(statue_1_1,refer_c)
    & varia(statue_1_1,varia_c)
    & sort(stand_1_1,d)
    & card(stand_1_1,int1)
    & etype(stand_1_1,int0)
    & fact(stand_1_1,real)
    & gener(stand_1_1,ge)
    & quant(stand_1_1,one)
    & refer(stand_1_1,refer_c)
    & varia(stand_1_1,varia_c)
    & sort(ort_1_2,d)
    & card(ort_1_2,int1)
    & etype(ort_1_2,int0)
    & fact(ort_1_2,real)
    & gener(ort_1_2,ge)
    & quant(ort_1_2,one)
    & refer(ort_1_2,refer_c)
    & varia(ort_1_2,varia_c) ) ).

%------------------------------------------------------------------------------
