%------------------------------------------------------------------------------
% File     : CSR113+21 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Where can you find the Statue of Liberty?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_003_mira_wp_232_a19713_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.35 v9.1.0, 0.47 v9.0.0, 0.31 v8.2.0, 0.33 v8.1.0, 0.36 v7.5.0, 0.38 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.50 v6.3.0, 0.54 v6.2.0, 0.73 v6.1.0, 0.72 v6.0.0, 0.50 v5.5.0, 0.75 v5.4.0, 0.74 v5.3.0, 0.78 v5.2.0, 0.57 v5.0.0, 0.65 v4.1.0, 0.61 v4.0.1, 0.68 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10858 (   0 equ)
%            Maximal formula atoms :  156 (   1 avg)
%            Number of connectives :  669 (   0   ~;  18   |; 525   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  156 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   88 (  88 usr;   0 prp; 2-8 aty)
%            Number of functors    : 16649 (16649 usr;16648 con; 0-2 aty)
%            Number of variables   :  472 ( 405   !;  67   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_003_mira_wp_232_a19713,conjecture,
    ? [X0,X1,X2,X3] :
      ( attr(X1,X0)
      & scar(X2,X3)
      & sub(X0,name_1_1)
      & val(X0,new_york_0) ) ).

fof(ave07_era5_synth_qa07_003_mira_wp_232_a19713,hypothesis,
    ( sub(c28049,ironie_1_1)
    & poss(c28053,c28049)
    & sub(c28060,gedanke_1_1)
    & sub(c28066,bootshafen_1_1)
    & attr(c28073,c28074)
    & sub(c28073,stadt__1_1)
    & sub(c28074,name_1_1)
    & val(c28074,new_york_0)
    & sub(c28075,freiheitsstatue_1_1)
    & tupl_p8(c28887,c28013,c28049,c28060,c28066,c28073,c28075,c28013)
    & assoc(freiheitsstatue_1_1,freiheit_1_1)
    & sub(freiheitsstatue_1_1,statue_1_1)
    & sort(c28049,as)
    & sort(c28049,io)
    & card(c28049,int1)
    & etype(c28049,int0)
    & fact(c28049,real)
    & gener(c28049,sp)
    & quant(c28049,one)
    & refer(c28049,det)
    & varia(c28049,varia_c)
    & sort(ironie_1_1,as)
    & sort(ironie_1_1,io)
    & card(ironie_1_1,int1)
    & etype(ironie_1_1,int0)
    & fact(ironie_1_1,real)
    & gener(ironie_1_1,ge)
    & quant(ironie_1_1,one)
    & refer(ironie_1_1,refer_c)
    & varia(ironie_1_1,varia_c)
    & sort(c28053,o)
    & card(c28053,int1)
    & etype(c28053,int0)
    & fact(c28053,real)
    & gener(c28053,sp)
    & quant(c28053,one)
    & refer(c28053,det)
    & varia(c28053,varia_c)
    & sort(c28060,as)
    & sort(c28060,io)
    & card(c28060,int1)
    & etype(c28060,int0)
    & fact(c28060,real)
    & gener(c28060,sp)
    & quant(c28060,one)
    & refer(c28060,det)
    & varia(c28060,con)
    & sort(gedanke_1_1,as)
    & sort(gedanke_1_1,io)
    & card(gedanke_1_1,int1)
    & etype(gedanke_1_1,int0)
    & fact(gedanke_1_1,real)
    & gener(gedanke_1_1,ge)
    & quant(gedanke_1_1,one)
    & refer(gedanke_1_1,refer_c)
    & varia(gedanke_1_1,varia_c)
    & sort(c28066,d)
    & card(c28066,int1)
    & etype(c28066,int0)
    & fact(c28066,real)
    & gener(c28066,sp)
    & quant(c28066,one)
    & refer(c28066,det)
    & varia(c28066,con)
    & sort(bootshafen_1_1,d)
    & card(bootshafen_1_1,int1)
    & etype(bootshafen_1_1,int0)
    & fact(bootshafen_1_1,real)
    & gener(bootshafen_1_1,ge)
    & quant(bootshafen_1_1,one)
    & refer(bootshafen_1_1,refer_c)
    & varia(bootshafen_1_1,varia_c)
    & sort(c28073,d)
    & sort(c28073,io)
    & card(c28073,int1)
    & etype(c28073,int0)
    & fact(c28073,real)
    & gener(c28073,sp)
    & quant(c28073,one)
    & refer(c28073,det)
    & varia(c28073,con)
    & sort(c28074,na)
    & card(c28074,int1)
    & etype(c28074,int0)
    & fact(c28074,real)
    & gener(c28074,sp)
    & quant(c28074,one)
    & refer(c28074,indet)
    & varia(c28074,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(new_york_0,fe)
    & sort(c28075,d)
    & card(c28075,int1)
    & etype(c28075,int0)
    & fact(c28075,real)
    & gener(c28075,sp)
    & quant(c28075,one)
    & refer(c28075,indet)
    & varia(c28075,varia_c)
    & sort(freiheitsstatue_1_1,d)
    & card(freiheitsstatue_1_1,int1)
    & etype(freiheitsstatue_1_1,int0)
    & fact(freiheitsstatue_1_1,real)
    & gener(freiheitsstatue_1_1,ge)
    & quant(freiheitsstatue_1_1,one)
    & refer(freiheitsstatue_1_1,refer_c)
    & varia(freiheitsstatue_1_1,varia_c)
    & sort(c28887,ent)
    & card(c28887,card_c)
    & etype(c28887,etype_c)
    & fact(c28887,real)
    & gener(c28887,gener_c)
    & quant(c28887,quant_c)
    & refer(c28887,refer_c)
    & varia(c28887,varia_c)
    & sort(c28013,d)
    & card(c28013,int1)
    & etype(c28013,int0)
    & fact(c28013,real)
    & gener(c28013,sp)
    & quant(c28013,one)
    & refer(c28013,det)
    & varia(c28013,varia_c)
    & sort(freiheit_1_1,as)
    & sort(freiheit_1_1,io)
    & card(freiheit_1_1,int1)
    & etype(freiheit_1_1,int0)
    & fact(freiheit_1_1,real)
    & gener(freiheit_1_1,ge)
    & quant(freiheit_1_1,one)
    & refer(freiheit_1_1,refer_c)
    & varia(freiheit_1_1,varia_c)
    & sort(statue_1_1,d)
    & card(statue_1_1,int1)
    & etype(statue_1_1,int0)
    & fact(statue_1_1,real)
    & gener(statue_1_1,ge)
    & quant(statue_1_1,one)
    & refer(statue_1_1,refer_c)
    & varia(statue_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
