%------------------------------------------------------------------------------
% File     : CSR113+20 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Where can you find the Statue of Liberty?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_003_mira_wp_231_a19713_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.35 v9.1.0, 0.47 v9.0.0, 0.31 v8.2.0, 0.33 v8.1.0, 0.36 v7.5.0, 0.38 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.50 v6.3.0, 0.54 v6.2.0, 0.73 v6.1.0, 0.72 v6.0.0, 0.50 v5.5.0, 0.71 v5.4.0, 0.70 v5.3.0, 0.74 v5.2.0, 0.50 v5.0.0, 0.60 v4.1.0, 0.56 v4.0.1, 0.68 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10879 (   0 equ)
%            Maximal formula atoms :  177 (   1 avg)
%            Number of connectives :  690 (   0   ~;  18   |; 546   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  177 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   88 (  88 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16654 (16654 usr;16653 con; 0-2 aty)
%            Number of variables   :  473 ( 405   !;  68   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_003_mira_wp_231_a19713,conjecture,
    ? [X0,X1,X2,X3,X4] :
      ( flp(X0,X2)
      & scar(X3,X4)
      & sub(X1,name_1_1)
      & val(X1,new_york_0) ) ).

fof(ave07_era5_synth_qa07_003_mira_wp_231_a19713,hypothesis,
    ( attr(c2595,c2596)
    & sub(c2595,stadt__1_1)
    & sub(c2596,name_1_1)
    & val(c2596,new_york_0)
    & pred(c2599,mauskewitz_1_1)
    & sub(c3439,bord_1_1)
    & mcont(c3446,c3575)
    & mexp(c3446,c2599)
    & obj(c3446,c3558)
    & semrel(c3446,c7)
    & subs(c3446,ansehen_2_3)
    & poss(c3558,c3569)
    & sub(c3558,freiheitsstatue_1_1)
    & sspe(c3563,c3569)
    & subs(c3563,verhei__337ung_1_1)
    & sub(c3569,freiheit_1_1)
    & arg1(c3575,c3558)
    & arg2(c3575,c3563)
    & subr(c3575,rprs_0)
    & flp(c3577,c3439)
    & obj(c7,c2599)
    & origl(c7,c3577)
    & ornt(c7,c2595)
    & subs(c7,gehen_1_2)
    & assoc(freiheitsstatue_1_1,freiheit_1_1)
    & sub(freiheitsstatue_1_1,statue_1_1)
    & sort(c2595,d)
    & sort(c2595,io)
    & card(c2595,int1)
    & etype(c2595,int0)
    & fact(c2595,real)
    & gener(c2595,sp)
    & quant(c2595,one)
    & refer(c2595,det)
    & varia(c2595,con)
    & sort(c2596,na)
    & card(c2596,int1)
    & etype(c2596,int0)
    & fact(c2596,real)
    & gener(c2596,sp)
    & quant(c2596,one)
    & refer(c2596,indet)
    & varia(c2596,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(new_york_0,fe)
    & sort(c2599,o)
    & card(c2599,cons(x_constant,cons(int1,nil)))
    & etype(c2599,int1)
    & fact(c2599,real)
    & gener(c2599,sp)
    & quant(c2599,mult)
    & refer(c2599,det)
    & varia(c2599,con)
    & sort(mauskewitz_1_1,o)
    & card(mauskewitz_1_1,int1)
    & etype(mauskewitz_1_1,int0)
    & fact(mauskewitz_1_1,real)
    & gener(mauskewitz_1_1,ge)
    & quant(mauskewitz_1_1,one)
    & refer(mauskewitz_1_1,refer_c)
    & varia(mauskewitz_1_1,varia_c)
    & sort(c3439,d)
    & card(c3439,int1)
    & etype(c3439,int0)
    & fact(c3439,real)
    & gener(c3439,sp)
    & quant(c3439,one)
    & refer(c3439,refer_c)
    & varia(c3439,varia_c)
    & sort(bord_1_1,d)
    & card(bord_1_1,int1)
    & etype(bord_1_1,int0)
    & fact(bord_1_1,real)
    & gener(bord_1_1,ge)
    & quant(bord_1_1,one)
    & refer(bord_1_1,refer_c)
    & varia(bord_1_1,varia_c)
    & sort(c3446,st)
    & fact(c3446,real)
    & gener(c3446,sp)
    & sort(c3575,st)
    & fact(c3575,hypo)
    & gener(c3575,sp)
    & sort(c3558,d)
    & card(c3558,int1)
    & etype(c3558,int0)
    & fact(c3558,real)
    & gener(c3558,sp)
    & quant(c3558,one)
    & refer(c3558,det)
    & varia(c3558,con)
    & sort(c7,dn)
    & fact(c7,real)
    & gener(c7,sp)
    & sort(ansehen_2_3,st)
    & fact(ansehen_2_3,real)
    & gener(ansehen_2_3,ge)
    & sort(c3569,as)
    & sort(c3569,io)
    & card(c3569,int1)
    & etype(c3569,int0)
    & fact(c3569,real)
    & gener(c3569,sp)
    & quant(c3569,one)
    & refer(c3569,det)
    & varia(c3569,varia_c)
    & sort(freiheitsstatue_1_1,d)
    & card(freiheitsstatue_1_1,int1)
    & etype(freiheitsstatue_1_1,int0)
    & fact(freiheitsstatue_1_1,real)
    & gener(freiheitsstatue_1_1,ge)
    & quant(freiheitsstatue_1_1,one)
    & refer(freiheitsstatue_1_1,refer_c)
    & varia(freiheitsstatue_1_1,varia_c)
    & sort(c3563,as)
    & card(c3563,int1)
    & etype(c3563,int0)
    & fact(c3563,real)
    & gener(c3563,sp)
    & quant(c3563,one)
    & refer(c3563,det)
    & varia(c3563,varia_c)
    & sort(verhei__337ung_1_1,as)
    & card(verhei__337ung_1_1,int1)
    & etype(verhei__337ung_1_1,int0)
    & fact(verhei__337ung_1_1,real)
    & gener(verhei__337ung_1_1,ge)
    & quant(verhei__337ung_1_1,one)
    & refer(verhei__337ung_1_1,refer_c)
    & varia(verhei__337ung_1_1,varia_c)
    & sort(freiheit_1_1,as)
    & sort(freiheit_1_1,io)
    & card(freiheit_1_1,int1)
    & etype(freiheit_1_1,int0)
    & fact(freiheit_1_1,real)
    & gener(freiheit_1_1,ge)
    & quant(freiheit_1_1,one)
    & refer(freiheit_1_1,refer_c)
    & varia(freiheit_1_1,varia_c)
    & sort(rprs_0,st)
    & fact(rprs_0,real)
    & gener(rprs_0,gener_c)
    & sort(c3577,l)
    & card(c3577,int1)
    & etype(c3577,int0)
    & fact(c3577,real)
    & gener(c3577,sp)
    & quant(c3577,one)
    & refer(c3577,refer_c)
    & varia(c3577,varia_c)
    & sort(gehen_1_2,dn)
    & fact(gehen_1_2,real)
    & gener(gehen_1_2,ge)
    & sort(statue_1_1,d)
    & card(statue_1_1,int1)
    & etype(statue_1_1,int0)
    & fact(statue_1_1,real)
    & gener(statue_1_1,ge)
    & quant(statue_1_1,one)
    & refer(statue_1_1,refer_c)
    & varia(statue_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
