%------------------------------------------------------------------------------
% File     : CSR113+2 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Where can you find the Statue of Liberty?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_003_insicht_4_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.30 v9.1.0, 0.33 v9.0.0, 0.25 v8.2.0, 0.20 v8.1.0, 0.21 v7.5.0, 0.29 v7.4.0, 0.31 v7.3.0, 0.43 v7.2.0, 0.33 v7.1.0, 0.25 v7.0.0, 0.36 v6.4.0, 0.29 v6.3.0, 0.23 v6.2.0, 0.45 v6.1.0, 0.56 v6.0.0, 0.50 v5.5.0, 0.54 v5.4.0, 0.48 v5.3.0, 0.52 v5.2.0, 0.36 v5.0.0, 0.45 v4.1.0, 0.56 v4.0.1, 0.53 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 11005 (   0 equ)
%            Maximal formula atoms :  299 (   1 avg)
%            Number of connectives :  816 (   0   ~;  18   |; 672   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  299 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16665 (16665 usr;16664 con; 0-2 aty)
%            Number of variables   :  473 ( 405   !;  68   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_003_insicht_4,conjecture,
    ? [X0,X1,X2,X3,X4] :
      ( flp(X0,X2)
      & attr(X2,X1)
      & loc(X3,X0)
      & scar(X3,X4)
      & sub(X1,name_1_1)
      & sub(X4,freiheitsstatue_1_1)
      & subs(X3,stehen_1_1)
      & val(X1,new_york_0) ) ).

fof(ave07_era5_synth_qa07_003_insicht_4,hypothesis,
    ( pmod(c1,ehemalig_1_1,stadtvater_1_1)
    & attr(c15,c16)
    & attr(c15,c17)
    & sub(c15,c1)
    & sub(c16,eigenname_1_1)
    & val(c16,helmut_0)
    & sub(c17,familiename_1_1)
    & val(c17,zilk_0)
    & dircl(c21,c75)
    & subs(c21,aktion_1_1)
    & sub(c27,idol_1_1)
    & attch(c32,c27)
    & benf(c32,c38)
    & propr(c32,para_1_1)
    & sub(c32,hilfeprojekt_1_1)
    & loc(c38,c74)
    & sub(c38,freiheitsstatue_1_1)
    & attr(c44,c45)
    & sub(c44,stadt__1_1)
    & sub(c45,name_1_1)
    & val(c45,new_york_0)
    & subs(c47,leben_1_1)
    & agt(c55,c15)
    & assoc(c55,c47)
    & mcont(c55,c21)
    & subs(c55,rufen_1_2)
    & in(c74,c44)
    & flp(c75,c27)
    & attch(c8,c15)
    & attr(c8,c9)
    & sub(c8,stadt__1_1)
    & sub(c9,name_1_1)
    & val(c9,vienna_0)
    & assoc(freiheitsstatue_1_1,freiheit_1_1)
    & sub(freiheitsstatue_1_1,statue_1_1)
    & assoc(hilfeprojekt_1_1,hilfe_1_1)
    & sub(hilfeprojekt_1_1,ansinnen_1_1)
    & assoc(stadtvater_1_1,stadt__1_1)
    & sub(stadtvater_1_1,vater_1_1)
    & sort(c1,ent)
    & card(c1,card_c)
    & etype(c1,etype_c)
    & fact(c1,fact_c)
    & gener(c1,gener_c)
    & quant(c1,quant_c)
    & refer(c1,refer_c)
    & varia(c1,varia_c)
    & sort(ehemalig_1_1,tq)
    & sort(stadtvater_1_1,d)
    & card(stadtvater_1_1,int1)
    & etype(stadtvater_1_1,int0)
    & fact(stadtvater_1_1,real)
    & gener(stadtvater_1_1,ge)
    & quant(stadtvater_1_1,one)
    & refer(stadtvater_1_1,refer_c)
    & varia(stadtvater_1_1,varia_c)
    & sort(c15,d)
    & card(c15,int1)
    & etype(c15,int0)
    & fact(c15,real)
    & gener(c15,sp)
    & quant(c15,one)
    & refer(c15,det)
    & varia(c15,varia_c)
    & sort(c16,na)
    & card(c16,int1)
    & etype(c16,int0)
    & fact(c16,real)
    & gener(c16,sp)
    & quant(c16,one)
    & refer(c16,indet)
    & varia(c16,varia_c)
    & sort(c17,na)
    & card(c17,int1)
    & etype(c17,int0)
    & fact(c17,real)
    & gener(c17,sp)
    & quant(c17,one)
    & refer(c17,indet)
    & varia(c17,varia_c)
    & sort(eigenname_1_1,na)
    & card(eigenname_1_1,int1)
    & etype(eigenname_1_1,int0)
    & fact(eigenname_1_1,real)
    & gener(eigenname_1_1,ge)
    & quant(eigenname_1_1,one)
    & refer(eigenname_1_1,refer_c)
    & varia(eigenname_1_1,varia_c)
    & sort(helmut_0,fe)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(zilk_0,fe)
    & sort(c21,ad)
    & card(c21,int1)
    & etype(c21,int0)
    & fact(c21,hypo)
    & gener(c21,sp)
    & quant(c21,one)
    & refer(c21,det)
    & varia(c21,con)
    & sort(c75,l)
    & card(c75,int1)
    & etype(c75,int0)
    & fact(c75,real)
    & gener(c75,sp)
    & quant(c75,one)
    & refer(c75,det)
    & varia(c75,con)
    & sort(aktion_1_1,ad)
    & card(aktion_1_1,int1)
    & etype(aktion_1_1,int0)
    & fact(aktion_1_1,real)
    & gener(aktion_1_1,ge)
    & quant(aktion_1_1,one)
    & refer(aktion_1_1,refer_c)
    & varia(aktion_1_1,varia_c)
    & sort(c27,d)
    & card(c27,int1)
    & etype(c27,int0)
    & fact(c27,real)
    & gener(c27,sp)
    & quant(c27,one)
    & refer(c27,det)
    & varia(c27,con)
    & sort(idol_1_1,d)
    & card(idol_1_1,int1)
    & etype(idol_1_1,int0)
    & fact(idol_1_1,real)
    & gener(idol_1_1,ge)
    & quant(idol_1_1,one)
    & refer(idol_1_1,refer_c)
    & varia(idol_1_1,varia_c)
    & sort(c32,ad)
    & sort(c32,io)
    & card(c32,int1)
    & etype(c32,int0)
    & fact(c32,real)
    & gener(c32,sp)
    & quant(c32,one)
    & refer(c32,indet)
    & varia(c32,varia_c)
    & sort(c38,d)
    & card(c38,int1)
    & etype(c38,int0)
    & fact(c38,real)
    & gener(c38,sp)
    & quant(c38,one)
    & refer(c38,det)
    & varia(c38,con)
    & sort(para_1_1,rq)
    & sort(hilfeprojekt_1_1,ad)
    & sort(hilfeprojekt_1_1,io)
    & card(hilfeprojekt_1_1,int1)
    & etype(hilfeprojekt_1_1,int0)
    & fact(hilfeprojekt_1_1,real)
    & gener(hilfeprojekt_1_1,ge)
    & quant(hilfeprojekt_1_1,one)
    & refer(hilfeprojekt_1_1,refer_c)
    & varia(hilfeprojekt_1_1,varia_c)
    & sort(c74,l)
    & card(c74,int1)
    & etype(c74,int0)
    & fact(c74,real)
    & gener(c74,sp)
    & quant(c74,one)
    & refer(c74,det)
    & varia(c74,con)
    & sort(freiheitsstatue_1_1,d)
    & card(freiheitsstatue_1_1,int1)
    & etype(freiheitsstatue_1_1,int0)
    & fact(freiheitsstatue_1_1,real)
    & gener(freiheitsstatue_1_1,ge)
    & quant(freiheitsstatue_1_1,one)
    & refer(freiheitsstatue_1_1,refer_c)
    & varia(freiheitsstatue_1_1,varia_c)
    & sort(c44,d)
    & sort(c44,io)
    & card(c44,int1)
    & etype(c44,int0)
    & fact(c44,real)
    & gener(c44,sp)
    & quant(c44,one)
    & refer(c44,det)
    & varia(c44,con)
    & sort(c45,na)
    & card(c45,int1)
    & etype(c45,int0)
    & fact(c45,real)
    & gener(c45,sp)
    & quant(c45,one)
    & refer(c45,indet)
    & varia(c45,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(new_york_0,fe)
    & sort(c47,ad)
    & card(c47,int1)
    & etype(c47,int0)
    & fact(c47,real)
    & gener(c47,sp)
    & quant(c47,one)
    & refer(c47,det)
    & varia(c47,con)
    & sort(leben_1_1,ad)
    & card(leben_1_1,int1)
    & etype(leben_1_1,int0)
    & fact(leben_1_1,real)
    & gener(leben_1_1,ge)
    & quant(leben_1_1,one)
    & refer(leben_1_1,refer_c)
    & varia(leben_1_1,varia_c)
    & sort(c55,da)
    & fact(c55,real)
    & gener(c55,sp)
    & sort(rufen_1_2,da)
    & fact(rufen_1_2,real)
    & gener(rufen_1_2,ge)
    & sort(c8,d)
    & sort(c8,io)
    & card(c8,int1)
    & etype(c8,int0)
    & fact(c8,real)
    & gener(c8,sp)
    & quant(c8,one)
    & refer(c8,det)
    & varia(c8,con)
    & sort(c9,na)
    & card(c9,int1)
    & etype(c9,int0)
    & fact(c9,real)
    & gener(c9,sp)
    & quant(c9,one)
    & refer(c9,indet)
    & varia(c9,varia_c)
    & sort(vienna_0,fe)
    & sort(freiheit_1_1,as)
    & sort(freiheit_1_1,io)
    & card(freiheit_1_1,int1)
    & etype(freiheit_1_1,int0)
    & fact(freiheit_1_1,real)
    & gener(freiheit_1_1,ge)
    & quant(freiheit_1_1,one)
    & refer(freiheit_1_1,refer_c)
    & varia(freiheit_1_1,varia_c)
    & sort(statue_1_1,d)
    & card(statue_1_1,int1)
    & etype(statue_1_1,int0)
    & fact(statue_1_1,real)
    & gener(statue_1_1,ge)
    & quant(statue_1_1,one)
    & refer(statue_1_1,refer_c)
    & varia(statue_1_1,varia_c)
    & sort(hilfe_1_1,ad)
    & sort(hilfe_1_1,io)
    & card(hilfe_1_1,int1)
    & etype(hilfe_1_1,int0)
    & fact(hilfe_1_1,real)
    & gener(hilfe_1_1,ge)
    & quant(hilfe_1_1,one)
    & refer(hilfe_1_1,refer_c)
    & varia(hilfe_1_1,varia_c)
    & sort(ansinnen_1_1,ad)
    & sort(ansinnen_1_1,io)
    & card(ansinnen_1_1,int1)
    & etype(ansinnen_1_1,int0)
    & fact(ansinnen_1_1,real)
    & gener(ansinnen_1_1,ge)
    & quant(ansinnen_1_1,one)
    & refer(ansinnen_1_1,refer_c)
    & varia(ansinnen_1_1,varia_c)
    & sort(vater_1_1,d)
    & card(vater_1_1,int1)
    & etype(vater_1_1,int0)
    & fact(vater_1_1,real)
    & gener(vater_1_1,ge)
    & quant(vater_1_1,one)
    & refer(vater_1_1,refer_c)
    & varia(vater_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
